# System.Text

``` diff
 namespace System.Text {
+    public static class Ascii {
+        public static bool Equals(ReadOnlySpan<byte> left, ReadOnlySpan<byte> right);
+        public static bool Equals(ReadOnlySpan<byte> left, ReadOnlySpan<char> right);
+        public static bool Equals(ReadOnlySpan<char> left, ReadOnlySpan<byte> right);
+        public static bool Equals(ReadOnlySpan<char> left, ReadOnlySpan<char> right);
+        public static bool EqualsIgnoreCase(ReadOnlySpan<byte> left, ReadOnlySpan<byte> right);
+        public static bool EqualsIgnoreCase(ReadOnlySpan<byte> left, ReadOnlySpan<char> right);
+        public static bool EqualsIgnoreCase(ReadOnlySpan<char> left, ReadOnlySpan<byte> right);
+        public static bool EqualsIgnoreCase(ReadOnlySpan<char> left, ReadOnlySpan<char> right);
+        public static OperationStatus FromUtf16(ReadOnlySpan<char> source, Span<byte> destination, out int bytesWritten);
+        public static bool IsValid(byte value);
+        public static bool IsValid(char value);
+        public static bool IsValid(ReadOnlySpan<byte> value);
+        public static bool IsValid(ReadOnlySpan<char> value);
+        public static OperationStatus ToLower(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        public static OperationStatus ToLower(ReadOnlySpan<byte> source, Span<char> destination, out int charsWritten);
+        public static OperationStatus ToLower(ReadOnlySpan<char> source, Span<byte> destination, out int bytesWritten);
+        public static OperationStatus ToLower(ReadOnlySpan<char> source, Span<char> destination, out int charsWritten);
+        public static OperationStatus ToLowerInPlace(Span<byte> value, out int bytesWritten);
+        public static OperationStatus ToLowerInPlace(Span<char> value, out int charsWritten);
+        public static OperationStatus ToUpper(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        public static OperationStatus ToUpper(ReadOnlySpan<byte> source, Span<char> destination, out int charsWritten);
+        public static OperationStatus ToUpper(ReadOnlySpan<char> source, Span<byte> destination, out int bytesWritten);
+        public static OperationStatus ToUpper(ReadOnlySpan<char> source, Span<char> destination, out int charsWritten);
+        public static OperationStatus ToUpperInPlace(Span<byte> value, out int bytesWritten);
+        public static OperationStatus ToUpperInPlace(Span<char> value, out int charsWritten);
+        public static OperationStatus ToUtf16(ReadOnlySpan<byte> source, Span<char> destination, out int charsWritten);
+        public static Range Trim(ReadOnlySpan<byte> value);
+        public static Range Trim(ReadOnlySpan<char> value);
+        public static Range TrimEnd(ReadOnlySpan<byte> value);
+        public static Range TrimEnd(ReadOnlySpan<char> value);
+        public static Range TrimStart(ReadOnlySpan<byte> value);
+        public static Range TrimStart(ReadOnlySpan<char> value);
+    }
     public class ASCIIEncoding : Encoding {
+        public override bool TryGetBytes(ReadOnlySpan<char> chars, Span<byte> bytes, out int bytesWritten);
+        public override bool TryGetChars(ReadOnlySpan<byte> bytes, Span<char> chars, out int charsWritten);
     }
+    public sealed class CompositeFormat {
+        public string Format { get; }
+        public int MinimumArgumentCount { get; }
+        public static CompositeFormat Parse([StringSyntaxAttribute("CompositeFormat")] string format);
+    }
     public abstract class Encoding : ICloneable {
+        public virtual bool TryGetBytes(ReadOnlySpan<char> chars, Span<byte> bytes, out int bytesWritten);
+        public virtual bool TryGetChars(ReadOnlySpan<byte> bytes, Span<char> chars, out int charsWritten);
     }
-    public readonly struct Rune : IComparable, IComparable<Rune>, IEquatable<Rune>, IFormattable, ISpanFormattable {
+    public readonly struct Rune : IComparable, IComparable<Rune>, IEquatable<Rune>, IFormattable, ISpanFormattable, IUtf8SpanFormattable {
+        bool IUtf8SpanFormattable.TryFormat(Span<byte> utf8Destination, out int bytesWritten, ReadOnlySpan<char> format, IFormatProvider provider);
     }
     public sealed class StringBuilder : ISerializable {
+        public StringBuilder AppendFormat(IFormatProvider? provider, CompositeFormat format, params object?[] args);
+        public StringBuilder AppendFormat(IFormatProvider? provider, CompositeFormat format, ReadOnlySpan<object?> args);
+        public StringBuilder AppendFormat<TArg0, TArg1, TArg2>(IFormatProvider? provider, CompositeFormat format, TArg0 arg0, TArg1 arg1, TArg2 arg2);
+        public StringBuilder AppendFormat<TArg0, TArg1>(IFormatProvider? provider, CompositeFormat format, TArg0 arg0, TArg1 arg1);
+        public StringBuilder AppendFormat<TArg0>(IFormatProvider? provider, CompositeFormat format, TArg0 arg0);
     }
     public class UTF8Encoding : Encoding {
+        public override bool TryGetBytes(ReadOnlySpan<char> chars, Span<byte> bytes, out int bytesWritten);
+        public override bool TryGetChars(ReadOnlySpan<byte> bytes, Span<char> chars, out int charsWritten);
     }
 }
```

