# System.Threading

``` diff
 namespace System.Threading {
     public class AbandonedMutexException : SystemException {
-        protected AbandonedMutexException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected AbandonedMutexException(SerializationInfo info, StreamingContext context);
     }
     public class BarrierPostPhaseException : Exception {
-        protected BarrierPostPhaseException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected BarrierPostPhaseException(SerializationInfo info, StreamingContext context);
     }
     public class CancellationTokenSource : IDisposable {
+        public CancellationTokenSource(TimeSpan delay, TimeProvider timeProvider);
+        public Task CancelAsync();
     }
     public sealed class CompressedStack : ISerializable {
-        public void GetObjectData(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     public sealed class ExecutionContext : IDisposable, ISerializable {
-        public void GetObjectData(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     public static class Interlocked {
-        public static long Read(ref long location);
+        public static long Read([RequiresLocationAttribute] ref long location);
-        [CLSCompliantAttribute(false)]
-        public static ulong Read(ref ulong location);
+        [CLSCompliantAttribute(false)]
+        public static ulong Read([RequiresLocationAttribute] ref ulong location);
     }
+    public interface ITimer : IAsyncDisposable, IDisposable {
+        bool Change(TimeSpan dueTime, TimeSpan period);
+    }
     public class LockRecursionException : Exception {
-        protected LockRecursionException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected LockRecursionException(SerializationInfo info, StreamingContext context);
     }
     public sealed class PeriodicTimer : IDisposable {
+        public PeriodicTimer(TimeSpan period, TimeProvider timeProvider);
+        public TimeSpan Period { get; set; }
     }
     public class SemaphoreFullException : SystemException {
-        protected SemaphoreFullException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected SemaphoreFullException(SerializationInfo info, StreamingContext context);
     }
     public class SynchronizationLockException : SystemException {
-        protected SynchronizationLockException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected SynchronizationLockException(SerializationInfo info, StreamingContext context);
     }
     public class ThreadInterruptedException : SystemException {
-        protected ThreadInterruptedException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected ThreadInterruptedException(SerializationInfo info, StreamingContext context);
     }
     public class ThreadStateException : SystemException {
-        protected ThreadStateException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected ThreadStateException(SerializationInfo info, StreamingContext context);
     }
-    public sealed class Timer : MarshalByRefObject, IAsyncDisposable, IDisposable
+    public sealed class Timer : MarshalByRefObject, IAsyncDisposable, IDisposable, ITimer
     public static class Volatile {
-        public static bool Read(ref bool location);
+        public static bool Read([RequiresLocationAttribute] ref bool location);
-        public static byte Read(ref byte location);
+        public static byte Read([RequiresLocationAttribute] ref byte location);
-        public static double Read(ref double location);
+        public static double Read([RequiresLocationAttribute] ref double location);
-        public static short Read(ref short location);
+        public static short Read([RequiresLocationAttribute] ref short location);
-        public static int Read(ref int location);
+        public static int Read([RequiresLocationAttribute] ref int location);
-        public static long Read(ref long location);
+        public static long Read([RequiresLocationAttribute] ref long location);
-        public static IntPtr Read(ref IntPtr location);
+        public static IntPtr Read([RequiresLocationAttribute] ref IntPtr location);
-        [CLSCompliantAttribute(false)]
-        public static sbyte Read(ref sbyte location);
+        [CLSCompliantAttribute(false)]
+        public static sbyte Read([RequiresLocationAttribute] ref sbyte location);
-        public static float Read(ref float location);
+        public static float Read([RequiresLocationAttribute] ref float location);
-        [CLSCompliantAttribute(false)]
-        public static ushort Read(ref ushort location);
+        [CLSCompliantAttribute(false)]
+        public static ushort Read([RequiresLocationAttribute] ref ushort location);
-        [CLSCompliantAttribute(false)]
-        public static uint Read(ref uint location);
+        [CLSCompliantAttribute(false)]
+        public static uint Read([RequiresLocationAttribute] ref uint location);
-        [CLSCompliantAttribute(false)]
-        public static ulong Read(ref ulong location);
+        [CLSCompliantAttribute(false)]
+        public static ulong Read([RequiresLocationAttribute] ref ulong location);
-        [CLSCompliantAttribute(false)]
-        public static UIntPtr Read(ref UIntPtr location);
+        [CLSCompliantAttribute(false)]
+        public static UIntPtr Read([RequiresLocationAttribute] ref UIntPtr location);
-        [return: NotNullIfNotNullAttribute("location")]
-        public static T Read<T>([NotNullIfNotNullAttribute("location")] ref T location) where T : class?;
+        [return: NotNullIfNotNullAttribute("location")]
+        public static T Read<T>([NotNullIfNotNullAttribute("location"), RequiresLocationAttribute] ref T location) where T : class?;
     }
     public class WaitHandleCannotBeOpenedException : ApplicationException {
-        protected WaitHandleCannotBeOpenedException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected WaitHandleCannotBeOpenedException(SerializationInfo info, StreamingContext context);
     }
 }
```

