# System.ComponentModel.Design.Serialization

``` diff
 namespace System.ComponentModel.Design.Serialization {
     [DefaultSerializationProviderAttribute(typeof(CodeDomSerializationProvider))]
     public class CodeDomSerializer : CodeDomSerializerBase {
-        public virtual object Deserialize(IDesignerSerializationManager manager, object codeObject);
+        public virtual object? Deserialize(IDesignerSerializationManager manager, object codeObject);
-        protected object DeserializeStatementToInstance(IDesignerSerializationManager manager, CodeStatement statement);
+        protected object? DeserializeStatementToInstance(IDesignerSerializationManager manager, CodeStatement statement);
-        public virtual string GetTargetComponentName(CodeStatement statement, CodeExpression expression, Type targetType);
+        public virtual string? GetTargetComponentName(CodeStatement? statement, CodeExpression? expression, Type? targetType);
-        public virtual object Serialize(IDesignerSerializationManager manager, object value);
+        public virtual object? Serialize(IDesignerSerializationManager manager, object value);
-        public virtual object SerializeAbsolute(IDesignerSerializationManager manager, object value);
+        public virtual object? SerializeAbsolute(IDesignerSerializationManager manager, object value);
-        [ObsoleteAttribute("This method has been deprecated. Use SerializeToExpression or GetExpression instead.  https://go.microsoft.com/fwlink/?linkid=14202")]
-        protected CodeExpression SerializeToReferenceExpression(IDesignerSerializationManager manager, object value);
+        [ObsoleteAttribute("This method has been deprecated. Use SerializeToExpression or GetExpression instead.  https://go.microsoft.com/fwlink/?linkid=14202")]
+        protected CodeExpression? SerializeToReferenceExpression(IDesignerSerializationManager manager, object value);
     }
     [EditorBrowsableAttribute(1)]
     public abstract class CodeDomSerializerBase {
-        protected object DeserializeExpression(IDesignerSerializationManager manager, string name, CodeExpression expression);
+        protected object? DeserializeExpression(IDesignerSerializationManager manager, string? name, CodeExpression? expression);
-        protected virtual object DeserializeInstance(IDesignerSerializationManager manager, Type type, object[] parameters, string name, bool addToContainer);
+        protected virtual object DeserializeInstance(IDesignerSerializationManager manager, Type type, object?[]? parameters, string? name, bool addToContainer);
-        protected void DeserializePropertiesFromResources(IDesignerSerializationManager manager, object value, Attribute[] filter);
+        protected void DeserializePropertiesFromResources(IDesignerSerializationManager manager, object value, Attribute[]? filter);
-        protected static EventDescriptorCollection GetEventsHelper(IDesignerSerializationManager manager, object instance, Attribute[] attributes);
+        protected static EventDescriptorCollection GetEventsHelper(IDesignerSerializationManager manager, object instance, Attribute[]? attributes);
-        protected CodeExpression GetExpression(IDesignerSerializationManager manager, object value);
+        protected CodeExpression? GetExpression(IDesignerSerializationManager manager, object value);
-        protected static PropertyDescriptorCollection GetPropertiesHelper(IDesignerSerializationManager manager, object instance, Attribute[] attributes);
+        protected static PropertyDescriptorCollection GetPropertiesHelper(IDesignerSerializationManager manager, object instance, Attribute[]? attributes);
-        protected CodeDomSerializer GetSerializer(IDesignerSerializationManager manager, object value);
+        protected CodeDomSerializer? GetSerializer(IDesignerSerializationManager manager, object? value);
-        protected CodeDomSerializer GetSerializer(IDesignerSerializationManager manager, Type valueType);
+        protected CodeDomSerializer? GetSerializer(IDesignerSerializationManager manager, Type valueType);
-        protected static TypeDescriptionProvider GetTargetFrameworkProvider(IServiceProvider provider, object instance);
+        protected static TypeDescriptionProvider? GetTargetFrameworkProvider(IServiceProvider provider, object instance);
-        protected CodeExpression SerializeCreationExpression(IDesignerSerializationManager manager, object value, out bool isComplete);
+        protected CodeExpression? SerializeCreationExpression(IDesignerSerializationManager manager, object value, out bool isComplete);
-        protected void SerializeEvents(IDesignerSerializationManager manager, CodeStatementCollection statements, object value, params Attribute[] filter);
+        protected void SerializeEvents(IDesignerSerializationManager manager, CodeStatementCollection statements, object value, params Attribute[]? filter);
-        protected void SerializeProperties(IDesignerSerializationManager manager, CodeStatementCollection statements, object value, Attribute[] filter);
+        protected void SerializeProperties(IDesignerSerializationManager manager, CodeStatementCollection statements, object value, Attribute[]? filter);
-        protected void SerializePropertiesToResources(IDesignerSerializationManager manager, CodeStatementCollection statements, object value, Attribute[] filter);
+        protected void SerializePropertiesToResources(IDesignerSerializationManager manager, CodeStatementCollection statements, object value, Attribute[]? filter);
-        protected void SerializeResource(IDesignerSerializationManager manager, string resourceName, object value);
+        protected void SerializeResource(IDesignerSerializationManager manager, string resourceName, object? value);
-        protected void SerializeResourceInvariant(IDesignerSerializationManager manager, string resourceName, object value);
+        protected void SerializeResourceInvariant(IDesignerSerializationManager manager, string resourceName, object? value);
-        protected CodeExpression SerializeToExpression(IDesignerSerializationManager manager, object value);
+        protected CodeExpression? SerializeToExpression(IDesignerSerializationManager manager, object? value);
-        protected CodeExpression SerializeToResourceExpression(IDesignerSerializationManager manager, object value);
+        protected CodeExpression? SerializeToResourceExpression(IDesignerSerializationManager manager, object? value);
-        protected CodeExpression SerializeToResourceExpression(IDesignerSerializationManager manager, object value, bool ensureInvariant);
+        protected CodeExpression? SerializeToResourceExpression(IDesignerSerializationManager manager, object? value, bool ensureInvariant);
     }
     public class CodeDomSerializerException : SystemException {
-        public CodeDomSerializerException(Exception ex, IDesignerSerializationManager manager);
+        public CodeDomSerializerException(Exception? ex, IDesignerSerializationManager manager);
-        public CodeDomSerializerException(string message, IDesignerSerializationManager manager);
+        public CodeDomSerializerException(string? message, IDesignerSerializationManager manager);
-        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+        [ObsoleteAttribute(DiagnosticId="SYSLIB0051")]
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     public class DesignerSerializationManager : IDesignerSerializationManager, IServiceProvider {
-        public DesignerSerializationManager(IServiceProvider provider);
+        public DesignerSerializationManager(IServiceProvider? provider);
-        public IContainer Container { get; set; }
+        public IContainer? Container { get; set; }
-        public object PropertyProvider { get; set; }
+        public object? PropertyProvider { get; set; }
-        ContextStack System.ComponentModel.Design.Serialization.IDesignerSerializationManager.Context { get; }
+        ContextStack IDesignerSerializationManager.Context { get; }
-        PropertyDescriptorCollection System.ComponentModel.Design.Serialization.IDesignerSerializationManager.Properties { get; }
+        PropertyDescriptorCollection IDesignerSerializationManager.Properties { get; }
-        public event EventHandler SessionCreated;
+        public event EventHandler? SessionCreated;
-        public event EventHandler SessionDisposed;
+        public event EventHandler? SessionDisposed;
-        protected virtual object CreateInstance(Type type, ICollection arguments, string name, bool addToContainer);
+        protected virtual object CreateInstance(Type type, ICollection? arguments, string? name, bool addToContainer);
-        public Type GetRuntimeType(string typeName);
+        public Type? GetRuntimeType(string? typeName);
-        public object GetSerializer(Type objectType, Type serializerType);
+        public object? GetSerializer(Type? objectType, Type serializerType);
-        protected virtual object GetService(Type serviceType);
+        protected virtual object? GetService(Type serviceType);
-        protected virtual Type GetType(string typeName);
+        protected virtual Type? GetType(string? typeName);
-        object IDesignerSerializationManager.CreateInstance(Type type, ICollection arguments, string name, bool addToContainer);
+        object IDesignerSerializationManager.CreateInstance(Type type, ICollection? arguments, string? name, bool addToContainer);
-        object IDesignerSerializationManager.GetInstance(string name);
+        object? IDesignerSerializationManager.GetInstance(string name);
-        string IDesignerSerializationManager.GetName(object value);
+        string? IDesignerSerializationManager.GetName(object value);
-        object IDesignerSerializationManager.GetSerializer(Type objectType, Type serializerType);
+        object? IDesignerSerializationManager.GetSerializer(Type? objectType, Type serializerType);
-        Type IDesignerSerializationManager.GetType(string typeName);
+        Type? IDesignerSerializationManager.GetType(string typeName);
-        object IServiceProvider.GetService(Type serviceType);
+        object? IServiceProvider.GetService(Type serviceType);
     }
     public sealed class ExpressionContext {
-        public ExpressionContext(CodeExpression expression, Type expressionType, object owner, object presetValue);
+        public ExpressionContext(CodeExpression expression, Type expressionType, object owner, object? presetValue);
-        public object PresetValue { get; }
+        public object? PresetValue { get; }
     }
     public sealed class ObjectStatementCollection : IEnumerable {
-        public CodeStatementCollection this[object statementOwner] { get; }
+        public CodeStatementCollection? this[object statementOwner] { get; }
     }
 }
```

