# System.ComponentModel.Design

``` diff
 namespace System.ComponentModel.Design {
     public class CollectionEditor : UITypeEditor {
         protected abstract class CollectionForm : Form {
-            public object EditValue { get; set; }
+            public object? EditValue { get; set; }
         }
     }
     public class DesignerActionList {
-        public DesignerActionList(IComponent component);
+        public DesignerActionList(IComponent? component);
-        public IComponent Component { get; }
+        public IComponent? Component { get; }
-        public object GetService(Type serviceType);
+        public object? GetService(Type serviceType);
     }
     public class DesignerActionListCollection : CollectionBase {
-        public DesignerActionListCollection(DesignerActionList[] value);
+        public DesignerActionListCollection(DesignerActionList?[] value);
-        public void AddRange(DesignerActionList[] value);
+        public void AddRange(DesignerActionList?[] value);
-        public void CopyTo(DesignerActionList[] array, int index);
+        public void CopyTo(DesignerActionList?[] array, int index);
     }
     public sealed class DesignerActionPropertyItem : DesignerActionItem {
-        public DesignerActionPropertyItem(string memberName, string displayName);
+        public DesignerActionPropertyItem(string memberName, string? displayName);
     }
     public class DesignerActionTextItem : DesignerActionItem {
-        public DesignerActionTextItem(string displayName, string category);
+        public DesignerActionTextItem(string? displayName, string? category);
     }
     public class DesignerCommandSet {
-        public virtual ICollection GetCommands(string name);
+        public virtual ICollection? GetCommands(string name);
     }
     public class DesignSurface : IDisposable, IServiceProvider {
-        public DesignSurface(IServiceProvider parentProvider);
+        public DesignSurface(IServiceProvider? parentProvider);
-        public DesignSurface(IServiceProvider parentProvider, Type rootComponentType);
+        public DesignSurface(IServiceProvider? parentProvider, Type rootComponentType);
-        public event EventHandler Disposed;
+        public event EventHandler? Disposed;
-        public event EventHandler Flushed;
+        public event EventHandler? Flushed;
-        public event LoadedEventHandler Loaded;
+        public event LoadedEventHandler? Loaded;
-        public event EventHandler Loading;
+        public event EventHandler? Loading;
-        public event EventHandler Unloaded;
+        public event EventHandler? Unloaded;
-        public event EventHandler Unloading;
+        public event EventHandler? Unloading;
-        public event EventHandler ViewActivated;
+        public event EventHandler? ViewActivated;
-        [ObsoleteAttribute("CreateComponent has been replaced by CreateInstance and will be removed after Beta2")]
-        protected internal virtual IComponent CreateComponent(Type componentType);
+        [ObsoleteAttribute("CreateComponent has been replaced by CreateInstance and will be removed after Beta2")]
+        protected internal virtual IComponent? CreateComponent(Type componentType);
-        protected internal virtual IDesigner CreateDesigner(IComponent component, bool rootDesigner);
+        protected internal virtual IDesigner? CreateDesigner(IComponent component, bool rootDesigner);
-        protected internal virtual object CreateInstance(Type type);
+        protected internal virtual object? CreateInstance(Type type);
-        public INestedContainer CreateNestedContainer(IComponent owningComponent, string containerName);
+        public INestedContainer CreateNestedContainer(IComponent owningComponent, string? containerName);
-        public object GetService(Type serviceType);
+        public object? GetService(Type serviceType);
     }
     public sealed class DesignSurfaceCollection : ICollection, IEnumerable {
-        int System.Collections.ICollection.Count { get; }
+        int ICollection.Count { get; }
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
     }
     public class DesignSurfaceManager : IDisposable, IServiceProvider {
-        public object GetService(Type serviceType);
+        public object? GetService(Type serviceType);
     }
     public sealed class ExceptionCollection : Exception {
-        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+        [ObsoleteAttribute(DiagnosticId="SYSLIB0051")]
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     public class InheritanceService : IDisposable, IInheritanceService {
-        protected virtual void AddInheritedComponents(Type type, IComponent component, IContainer container);
+        protected virtual void AddInheritedComponents(Type? type, IComponent component, IContainer container);
-        protected virtual bool IgnoreInheritedMember(MemberInfo member, IComponent component);
+        protected virtual bool IgnoreInheritedMember(MemberInfo member, IComponent? component);
     }
     public sealed class LoadedEventArgs : EventArgs {
-        public LoadedEventArgs(bool succeeded, ICollection errors);
+        public LoadedEventArgs(bool succeeded, ICollection? errors);
     }
     public abstract class ObjectSelectorEditor : UITypeEditor {
-        protected virtual void FillTreeWithData(ObjectSelectorEditor.Selector selector, ITypeDescriptorContext context, IServiceProvider provider);
+        protected virtual void FillTreeWithData(ObjectSelectorEditor.Selector selector, ITypeDescriptorContext? context, IServiceProvider provider);
         public class Selector : TreeView {
-            public ObjectSelectorEditor.SelectorNode AddNode(string label, object value, ObjectSelectorEditor.SelectorNode parent);
+            public ObjectSelectorEditor.SelectorNode AddNode(string? label, object? value, ObjectSelectorEditor.SelectorNode? parent);
-            protected void OnAfterSelect(object sender, TreeViewEventArgs e);
+            protected void OnAfterSelect(object? sender, TreeViewEventArgs e);
-            public bool SetSelection(object value, TreeNodeCollection nodes);
+            public bool SetSelection(object? value, TreeNodeCollection? nodes);
-            public void Start(IWindowsFormsEditorService edSvc, object value);
+            public void Start(IWindowsFormsEditorService edSvc, object? value);
         }
     }
     public abstract class UndoEngine : IDisposable {
-        public event EventHandler Undoing;
+        public event EventHandler? Undoing;
-        public event EventHandler Undone;
+        public event EventHandler? Undone;
-        protected virtual UndoEngine.UndoUnit CreateUndoUnit(string name, bool primary);
+        protected virtual UndoEngine.UndoUnit CreateUndoUnit(string? name, bool primary);
-        protected object GetService(Type serviceType);
+        protected object? GetService(Type serviceType);
         protected class UndoUnit {
-            public UndoUnit(UndoEngine engine, string name);
+            public UndoUnit(UndoEngine engine, string? name);
-            protected object GetService(Type serviceType);
+            protected object? GetService(Type serviceType);
         }
     }
 }
```

