# System.Drawing

``` diff
 namespace System.Drawing {
-    [EditorAttribute("System.Drawing.Design.BitmapEditor, System.Drawing.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.Drawing.Design.UITypeEditor, System.Drawing, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
-    public sealed class Bitmap : Image
+    [EditorAttribute("System.Drawing.Design.BitmapEditor, System.Drawing.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.Drawing.Design.UITypeEditor, System.Drawing, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    [TypeForwardedFromAttribute("System.Drawing, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    public sealed class Bitmap : Image
-    [EditorAttribute("System.Drawing.Design.ContentAlignmentEditor, System.Drawing.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.Drawing.Design.UITypeEditor, System.Drawing, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
-    public enum ContentAlignment
+    [EditorAttribute("System.Drawing.Design.ContentAlignmentEditor, System.Drawing.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.Drawing.Design.UITypeEditor, System.Drawing, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    [TypeForwardedFromAttribute("System.Drawing, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    public enum ContentAlignment
-    [EditorAttribute("System.Drawing.Design.FontEditor, System.Drawing.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.Drawing.Design.UITypeEditor, System.Drawing, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
-    [TypeConverterAttribute(typeof(FontConverter))]
-    public sealed class Font : MarshalByRefObject, ICloneable, IDisposable, ISerializable {
+    [EditorAttribute("System.Drawing.Design.FontEditor, System.Drawing.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.Drawing.Design.UITypeEditor, System.Drawing, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    [TypeConverterAttribute(typeof(FontConverter))]
+    [TypeForwardedFromAttribute("System.Drawing, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    public sealed class Font : MarshalByRefObject, ICloneable, IDisposable, ISerializable {
+        public static Font FromLogFont(in LOGFONT logFont);
+        public static Font FromLogFont(in LOGFONT logFont, IntPtr hdc);
+        public void ToLogFont(out LOGFONT logFont);
+        public void ToLogFont(out LOGFONT logFont, Graphics graphics);
     }
     public class FontConverter : TypeConverter {
-        public override bool CanConvertTo(ITypeDescriptorContext context, [NotNullWhenAttribute(true)] Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext? context, [NotNullWhenAttribute(true)] Type? destinationType);
-        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object? ConvertFrom(ITypeDescriptorContext? context, CultureInfo? culture, object value);
-        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public override object? ConvertTo(ITypeDescriptorContext? context, CultureInfo? culture, object? value, Type destinationType);
-        public override bool GetCreateInstanceSupported(ITypeDescriptorContext context);
+        public override bool GetCreateInstanceSupported(ITypeDescriptorContext? context);
-        [RequiresUnreferencedCodeAttribute("The Type of value cannot be statically discovered. The public parameterless constructor or the 'Default' static field may be trimmed from the Attribute's Type.")]
-        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[]? attributes);
+        [RequiresUnreferencedCodeAttribute("The Type of value cannot be statically discovered. The public parameterless constructor or the 'Default' static field may be trimmed from the Attribute's Type.")]
+        public override PropertyDescriptorCollection? GetProperties(ITypeDescriptorContext? context, object value, Attribute[]? attributes);
-        public override bool GetPropertiesSupported(ITypeDescriptorContext context);
+        public override bool GetPropertiesSupported(ITypeDescriptorContext? context);
         public sealed class FontNameConverter : TypeConverter, IDisposable {
-            public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+            public override object? ConvertFrom(ITypeDescriptorContext? context, CultureInfo? culture, object value);
-            public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
+            public override bool GetStandardValuesExclusive(ITypeDescriptorContext? context);
-            public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
+            public override bool GetStandardValuesSupported(ITypeDescriptorContext? context);
         }
     }
-    [FlagsAttribute]
-    public enum FontStyle
+    [FlagsAttribute]
+    [TypeForwardedFromAttribute("System.Drawing, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    public enum FontStyle
     public sealed class Graphics : MarshalByRefObject, IDeviceContext, IDisposable {
+        public void DrawCachedBitmap(CachedBitmap cachedBitmap, int x, int y);
+        public void DrawString(ReadOnlySpan<char> s, Font font, Brush brush, PointF point);
+        public void DrawString(ReadOnlySpan<char> s, Font font, Brush brush, PointF point, StringFormat? format);
+        public void DrawString(ReadOnlySpan<char> s, Font font, Brush brush, RectangleF layoutRectangle);
+        public void DrawString(ReadOnlySpan<char> s, Font font, Brush brush, RectangleF layoutRectangle, StringFormat? format);
+        public void DrawString(ReadOnlySpan<char> s, Font font, Brush brush, float x, float y);
+        public void DrawString(ReadOnlySpan<char> s, Font font, Brush brush, float x, float y, StringFormat? format);
+        public Region[] MeasureCharacterRanges(ReadOnlySpan<char> text, Font font, RectangleF layoutRect, StringFormat? stringFormat);
+        public SizeF MeasureString(ReadOnlySpan<char> text, Font font);
+        public SizeF MeasureString(ReadOnlySpan<char> text, Font font, PointF origin, StringFormat? stringFormat);
+        public SizeF MeasureString(ReadOnlySpan<char> text, Font font, SizeF layoutArea);
+        public SizeF MeasureString(ReadOnlySpan<char> text, Font font, SizeF layoutArea, StringFormat? stringFormat);
+        public SizeF MeasureString(ReadOnlySpan<char> text, Font font, SizeF layoutArea, StringFormat? stringFormat, out int charactersFitted, out int linesFilled);
+        public SizeF MeasureString(ReadOnlySpan<char> text, Font font, int width);
+        public SizeF MeasureString(ReadOnlySpan<char> text, Font font, int width, StringFormat? format);
     }
-    public enum GraphicsUnit
+    [TypeForwardedFromAttribute("System.Drawing, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    public enum GraphicsUnit
-    [EditorAttribute("System.Drawing.Design.IconEditor, System.Drawing.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.Drawing.Design.UITypeEditor, System.Drawing, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
-    [TypeConverterAttribute(typeof(IconConverter))]
-    public sealed class Icon : MarshalByRefObject, ICloneable, IDisposable, ISerializable {
+    [EditorAttribute("System.Drawing.Design.IconEditor, System.Drawing.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.Drawing.Design.UITypeEditor, System.Drawing, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    [TypeConverterAttribute(typeof(IconConverter))]
+    [TypeForwardedFromAttribute("System.Drawing, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    public sealed class Icon : MarshalByRefObject, ICloneable, IDisposable, ISerializable {
+        public static Icon? ExtractIcon(string filePath, int id, bool smallIcon = false);
+        public static Icon? ExtractIcon(string filePath, int id, int size);
     }
-    [EditorAttribute("System.Drawing.Design.ImageEditor, System.Drawing.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.Drawing.Design.UITypeEditor, System.Drawing, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
-    [ImmutableObjectAttribute(true)]
-    [TypeConverterAttribute(typeof(ImageConverter))]
-    public abstract class Image : MarshalByRefObject, ICloneable, IDisposable, ISerializable
+    [EditorAttribute("System.Drawing.Design.ImageEditor, System.Drawing.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.Drawing.Design.UITypeEditor, System.Drawing, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    [ImmutableObjectAttribute(true)]
+    [TypeConverterAttribute(typeof(ImageConverter))]
+    [TypeForwardedFromAttribute("System.Drawing, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    public abstract class Image : MarshalByRefObject, ICloneable, IDisposable, ISerializable
     public class ImageConverter : TypeConverter {
-        public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
+        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
     }
     public class ImageFormatConverter : TypeConverter {
-        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
     }
+    public enum StockIconId {
+        Application = 2,
+        AudioFiles = 71,
+        AutoList = 49,
+        ClusteredDrive = 140,
+        Delete = 84,
+        DesktopPC = 94,
+        DeviceAudioPlayer = 102,
+        DeviceCamera = 100,
+        DeviceCellPhone = 99,
+        DeviceVideoCamera = 101,
+        DocumentNoAssociation = 0,
+        DocumentWithAssociation = 1,
+        Drive35 = 6,
+        Drive525 = 5,
+        DriveBD = 133,
+        DriveCD = 11,
+        DriveDVD = 59,
+        DriveFixed = 8,
+        DriveHDDVD = 132,
+        DriveNet = 9,
+        DriveNetDisabled = 10,
+        DriveRam = 12,
+        DriveRemovable = 7,
+        DriveUnknown = 58,
+        Error = 80,
+        Find = 22,
+        Folder = 3,
+        FolderBack = 75,
+        FolderFront = 76,
+        FolderOpen = 4,
+        Help = 23,
+        ImageFiles = 72,
+        Info = 79,
+        Internet = 104,
+        Key = 81,
+        Link = 29,
+        Lock = 47,
+        MediaAudioDVD = 85,
+        MediaBDR = 138,
+        MediaBDRE = 139,
+        MediaBDROM = 137,
+        MediaBlankCD = 69,
+        MediaBluRay = 90,
+        MediaCDAudio = 40,
+        MediaCDAudioPlus = 65,
+        MediaCDBurn = 68,
+        MediaCDR = 67,
+        MediaCDROM = 70,
+        MediaCDRW = 66,
+        MediaCompactFlash = 98,
+        MediaDVD = 60,
+        MediaDVDPlusR = 92,
+        MediaDVDPlusRW = 93,
+        MediaDVDR = 63,
+        MediaDVDRAM = 61,
+        MediaDVDROM = 64,
+        MediaDVDRW = 62,
+        MediaEnhancedCD = 87,
+        MediaEnhancedDVD = 88,
+        MediaHDDVD = 89,
+        MediaHDDVDR = 135,
+        MediaHDDVDRAM = 136,
+        MediaHDDVDROM = 134,
+        MediaMovieDVD = 86,
+        MediaSmartMedia = 97,
+        MediaSVCD = 56,
+        MediaVCD = 91,
+        MixedFiles = 74,
+        MobilePC = 95,
+        MyNetwork = 17,
+        NetworkConnect = 103,
+        Printer = 16,
+        PrinterFax = 52,
+        PrinterFaxNet = 53,
+        PrinterFile = 54,
+        PrinterNet = 50,
+        Recycler = 31,
+        RecyclerFull = 32,
+        Rename = 83,
+        Server = 15,
+        ServerShare = 51,
+        Settings = 106,
+        Share = 28,
+        Shield = 77,
+        SlowFile = 30,
+        Software = 82,
+        Stack = 55,
+        StuffedFolder = 57,
+        Users = 96,
+        VideoFiles = 73,
+        Warning = 78,
+        World = 13,
+        ZipFile = 105,
+    }
+    [FlagsAttribute]
+    public enum StockIconOptions {
+        Default = 0,
+        LinkOverlay = 32768,
+        Selected = 65536,
+        ShellIconSize = 4,
+        SmallIcon = 1,
+    }
     public static class SystemIcons {
+        public static Icon GetStockIcon(StockIconId stockIcon, StockIconOptions options = StockIconOptions.Default);
+        public static Icon GetStockIcon(StockIconId stockIcon, int size);
     }
     [AttributeUsageAttribute(4)]
     public class ToolboxBitmapAttribute : Attribute {
-        public override bool Equals([NotNullWhenAttribute(true)] object? value);
+        public override bool Equals([NotNullWhenAttribute(true)] object value);
-        public Image? GetImage(object? component);
+        public Image GetImage(object component);
-        public Image? GetImage(object? component, bool large);
+        public Image GetImage(object component, bool large);
-        public Image? GetImage(Type type, string? imgName, bool large);
+        public Image GetImage(Type type, string imgName, bool large);
-        public static Image? GetImageFromResource(Type t, string? imageName, bool large);
+        public static Image GetImageFromResource(Type t, string imageName, bool large);
     }
 }
```

