# System.Windows.Forms

``` diff
 namespace System.Windows.Forms {
-    public class AccessibleObject : StandardOleMarshalObject, IAccessible, Interop.Ole32.IOleWindow, Interop.Ole32.IServiceProvider, Interop.Oleaut32.IEnumVariant, Interop.UiaCore.IAccessibleEx, Interop.UiaCore.IExpandCollapseProvider, Interop.UiaCore.IGridItemProvider, Interop.UiaCore.IGridProvider, Interop.UiaCore.IInvokeProvider, Interop.UiaCore.ILegacyIAccessibleProvider, Interop.UiaCore.IMultipleViewProvider, Interop.UiaCore.IRangeValueProvider, Interop.UiaCore.IRawElementProviderFragment, Interop.UiaCore.IRawElementProviderFragmentRoot, Interop.UiaCore.IRawElementProviderHwndOverride, Interop.UiaCore.IRawElementProviderSimple, Interop.UiaCore.IScrollItemProvider, Interop.UiaCore.ISelectionItemProvider, Interop.UiaCore.ISelectionProvider, Interop.UiaCore.ITableItemProvider, Interop.UiaCore.ITableProvider, Interop.UiaCore.ITextProvider, Interop.UiaCore.ITextProvider2, Interop.UiaCore.IToggleProvider, Interop.UiaCore.IValueProvider, IReflect
+    public class AccessibleObject : StandardOleMarshalObject, IAccessible, IEnumVARIANT.Interface, Interop.UiaCore.IAccessibleEx, Interop.UiaCore.IExpandCollapseProvider, Interop.UiaCore.IGridItemProvider, Interop.UiaCore.IGridProvider, Interop.UiaCore.IInvokeProvider, Interop.UiaCore.ILegacyIAccessibleProvider, Interop.UiaCore.IMultipleViewProvider, Interop.UiaCore.IRangeValueProvider, Interop.UiaCore.IRawElementProviderFragment, Interop.UiaCore.IRawElementProviderFragmentRoot, Interop.UiaCore.IRawElementProviderHwndOverride, Interop.UiaCore.IRawElementProviderSimple, Interop.UiaCore.IScrollItemProvider, Interop.UiaCore.ISelectionItemProvider, Interop.UiaCore.ISelectionProvider, Interop.UiaCore.ITableItemProvider, Interop.UiaCore.ITableProvider, Interop.UiaCore.ITextProvider, Interop.UiaCore.ITextProvider2, Interop.UiaCore.IToggleProvider, Interop.UiaCore.IValueProvider, IOleWindow.Interface, IReflect, IServiceProvider.Interface
     public sealed class Application {
-        public static string CompanyName { get; }
+        public static string? CompanyName { get; }
-        public static string ProductName { get; }
+        public static string? ProductName { get; }
-        public static event EventHandler ApplicationExit;
+        public static event EventHandler? ApplicationExit;
-        [EditorBrowsableAttribute(2)]
-        public static event EventHandler EnterThreadModal;
+        [EditorBrowsableAttribute(2)]
+        public static event EventHandler? EnterThreadModal;
-        public static event EventHandler Idle;
+        public static event EventHandler? Idle;
-        [EditorBrowsableAttribute(2)]
-        public static event EventHandler LeaveThreadModal;
+        [EditorBrowsableAttribute(2)]
+        public static event EventHandler? LeaveThreadModal;
-        public static event ThreadExceptionEventHandler ThreadException;
+        public static event ThreadExceptionEventHandler? ThreadException;
-        public static event EventHandler ThreadExit;
+        public static event EventHandler? ThreadExit;
-        public static void AddMessageFilter(IMessageFilter value);
+        public static void AddMessageFilter(IMessageFilter? value);
-        [EditorBrowsableAttribute(2)]
-        public static void Exit(CancelEventArgs e);
+        [EditorBrowsableAttribute(2)]
+        public static void Exit(CancelEventArgs? e);
-        [EditorBrowsableAttribute(2)]
-        public static void RegisterMessageLoop(Application.MessageLoopCallback callback);
+        [EditorBrowsableAttribute(2)]
+        public static void RegisterMessageLoop(Application.MessageLoopCallback? callback);
     }
     public class AutoCompleteStringCollection : ICollection, IEnumerable, IList {
-        bool System.Collections.IList.IsFixedSize { get; }
+        bool IList.IsFixedSize { get; }
-        bool System.Collections.IList.IsReadOnly { get; }
+        bool IList.IsReadOnly { get; }
-        object System.Collections.IList.this[int index] { get; set; }
+        object? IList.this[int index] { get; set; }
-        public event CollectionChangeEventHandler CollectionChanged;
+        public event CollectionChangeEventHandler? CollectionChanged;
-        int IList.Add(object value);
+        int IList.Add(object? value);
-        bool IList.Contains(object value);
+        bool IList.Contains(object? value);
-        int IList.IndexOf(object value);
+        int IList.IndexOf(object? value);
-        void IList.Insert(int index, object value);
+        void IList.Insert(int index, object? value);
-        void IList.Remove(object value);
+        void IList.Remove(object? value);
     }
     [DefaultEventAttribute("Enter")]
     [DesignTimeVisibleAttribute(false)]
     [DesignerAttribute("System.Windows.Forms.Design.AxHostDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [ToolboxItemAttribute(false)]
     public abstract class AxHost : Control, ICustomTypeDescriptor, ISupportInitialize {
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override Cursor Cursor { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override Cursor Cursor { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override Font Font { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override Font Font { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [TypeConverterAttribute(typeof(TypeConverter))]
-        public class State : ISerializable {
+        [TypeConverterAttribute(typeof(TypeConverter))]
+        public class State : IDisposable, ISerializable {
+            public void Dispose();
+            protected virtual void Dispose(bool disposing);
-            void ISerializable.GetObjectData(SerializationInfo si, StreamingContext context);
+            void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
         }
     }
     public class BaseCollection : MarshalByRefObject, ICollection, IEnumerable {
-        protected virtual ArrayList List { get; }
+        protected virtual ArrayList? List { get; }
     }
-    [RequiresPreviewFeaturesAttribute]
-    public abstract class BindableComponent : Component, IBindableComponent, IComponent, IDisposable
+    public abstract class BindableComponent : Component, IBindableComponent, IComponent, IDisposable
     [DefaultEventAttribute("CollectionChanged")]
     public class BindingContext : ICollection, IEnumerable {
-        int System.Collections.ICollection.Count { get; }
+        int ICollection.Count { get; }
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
-        public BindingManagerBase this[object dataSource, string dataMember] { get; }
+        public BindingManagerBase this[object dataSource, string? dataMember] { get; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        [SRDescriptionAttribute("collectionChangedEventDescr")]
-        public event CollectionChangeEventHandler CollectionChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [SRDescriptionAttribute("collectionChangedEventDescr")]
+        public event CollectionChangeEventHandler? CollectionChanged;
-        public bool Contains(object dataSource, string dataMember);
+        public bool Contains(object dataSource, string? dataMember);
-        public static void UpdateBinding(BindingContext newBindingContext, Binding binding);
+        public static void UpdateBinding(BindingContext? newBindingContext, Binding binding);
     }
     public abstract class BindingManagerBase {
-        public abstract object Current { get; }
+        public abstract object? Current { get; }
     }
-    public struct BindingMemberInfo : IEquatable<BindingMemberInfo> {
+    public readonly struct BindingMemberInfo : IEquatable<BindingMemberInfo> {
-        public BindingMemberInfo(string dataMember);
+        public BindingMemberInfo(string? dataMember);
-        public override bool Equals(object otherObject);
+        public override bool Equals(object? otherObject);
     }
     [DefaultEventAttribute("CollectionChanged")]
     public class BindingsCollection : BaseCollection {
-        [SRDescriptionAttribute("collectionChangedEventDescr")]
-        public event CollectionChangeEventHandler CollectionChanged;
+        [SRDescriptionAttribute("collectionChangedEventDescr")]
+        public event CollectionChangeEventHandler? CollectionChanged;
-        [SRDescriptionAttribute("collectionChangingEventDescr")]
-        public event CollectionChangeEventHandler CollectionChanging;
+        [SRDescriptionAttribute("collectionChangingEventDescr")]
+        public event CollectionChangeEventHandler? CollectionChanging;
     }
     [DesignerAttribute("System.Windows.Forms.Design.ButtonBaseDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public abstract class ButtonBase : Control, ICommandBindingTargetProvider {
-        [BindableAttribute(true)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [RequiresPreviewFeaturesAttribute]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandComponentCommandDescr")]
-        public ICommand? Command { get; set; }
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandComponentCommandDescr")]
+        public ICommand? Command { get; set; }
-        [BindableAttribute(true)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandComponentCommandParameterDescr")]
-        public object? CommandParameter { [RequiresPreviewFeaturesAttribute] get; [RequiresPreviewFeaturesAttribute] set; }
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandComponentCommandParameterDescr")]
+        public object? CommandParameter { get; set; }
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandCanExecuteChangedEventDescr")]
-        public event EventHandler? CommandCanExecuteChanged;
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandCanExecuteChangedEventDescr")]
+        public event EventHandler? CommandCanExecuteChanged;
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandChangedEventDescr")]
-        public event EventHandler? CommandChanged;
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandChangedEventDescr")]
+        public event EventHandler? CommandChanged;
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandParameterChangedEventDescr")]
-        public event EventHandler? CommandParameterChanged;
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandParameterChangedEventDescr")]
+        public event EventHandler? CommandParameterChanged;
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        protected virtual void OnCommandCanExecuteChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnCommandCanExecuteChanged(EventArgs e);
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        protected virtual void OnCommandChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnCommandChanged(EventArgs e);
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        protected virtual void OnCommandParameterChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnCommandParameterChanged(EventArgs e);
-        [RequiresPreviewFeaturesAttribute]
-        protected virtual void OnRequestCommandExecute(EventArgs e);
+        protected virtual void OnRequestCommandExecute(EventArgs e);
         public class ButtonBaseAccessibleObject : Control.ControlAccessibleObject {
+            public override string KeyboardShortcut { get; }
+            public override string Name { get; }
         }
     }
     [LookupBindingPropertiesAttribute]
     [SRDescriptionAttribute("DescriptionCheckedListBox")]
     public class CheckedListBox : ListBox {
-        [DesignerSerializationVisibilityAttribute(2)]
-        [EditorAttribute("System.Windows.Forms.Design.ListControlStringCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ListBoxItemsDescr")]
-        public new CheckedListBox.ObjectCollection Items { get; }
+        [DesignerSerializationVisibilityAttribute(2)]
+        [EditorAttribute("System.Windows.Forms.Design.ListControlStringCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [LocalizableAttribute(true)]
+        [MergablePropertyAttribute(false)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ListBoxItemsDescr")]
+        public new CheckedListBox.ObjectCollection Items { get; }
     }
     [DefaultBindingPropertyAttribute("Text")]
     [DefaultEventAttribute("SelectedIndexChanged")]
     [DefaultPropertyAttribute("Items")]
     [DesignerAttribute("System.Windows.Forms.Design.ComboBoxDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionComboBox")]
     public class ComboBox : ListControl {
-        [BrowsableAttribute(true)]
-        [DesignerSerializationVisibilityAttribute(2)]
-        [EditorAttribute("System.Windows.Forms.Design.ListControlStringCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [EditorBrowsableAttribute(0)]
-        [LocalizableAttribute(true)]
-        [SRDescriptionAttribute("ComboBoxAutoCompleteCustomSourceDescr")]
-        public AutoCompleteStringCollection AutoCompleteCustomSource { get; set; }
+        [BrowsableAttribute(true)]
+        [DesignerSerializationVisibilityAttribute(2)]
+        [EditorAttribute("System.Windows.Forms.Design.ListControlStringCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [EditorBrowsableAttribute(0)]
+        [LocalizableAttribute(true)]
+        [SRDescriptionAttribute("ComboBoxAutoCompleteCustomSourceDescr")]
+        [AllowNullAttribute]
+        public AutoCompleteStringCollection AutoCompleteCustomSource { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override Image BackgroundImage { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public override Image? BackgroundImage { get; set; }
-        [AttributeProviderAttribute(typeof(IListSource))]
-        [DefaultValueAttribute(null)]
-        [RefreshPropertiesAttribute(2)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ListControlDataSourceDescr")]
-        public new object DataSource { get; set; }
+        [AttributeProviderAttribute(typeof(IListSource))]
+        [DefaultValueAttribute(null)]
+        [RefreshPropertiesAttribute(2)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ListControlDataSourceDescr")]
+        public new object? DataSource { get; set; }
-        [BindableAttribute(true)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRDescriptionAttribute("ComboBoxSelectedItemDescr")]
-        public object SelectedItem { get; set; }
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRDescriptionAttribute("ComboBoxSelectedItemDescr")]
+        public object? SelectedItem { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRDescriptionAttribute("ComboBoxSelectedTextDescr")]
-        public string SelectedText { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRDescriptionAttribute("ComboBoxSelectedTextDescr")]
+        [AllowNullAttribute]
+        public string SelectedText { get; set; }
-        [BindableAttribute(true)]
-        [LocalizableAttribute(true)]
-        public override string Text { get; set; }
+        [BindableAttribute(true)]
+        [LocalizableAttribute(true)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackgroundImageChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackgroundImageChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackgroundImageLayoutChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackgroundImageLayoutChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler DoubleClick;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? DoubleClick;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("drawItemEventDescr")]
-        public event DrawItemEventHandler DrawItem;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("drawItemEventDescr")]
+        public event DrawItemEventHandler? DrawItem;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ComboBoxOnDropDownDescr")]
-        public event EventHandler DropDown;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ComboBoxOnDropDownDescr")]
+        public event EventHandler? DropDown;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ComboBoxOnDropDownClosedDescr")]
-        public event EventHandler DropDownClosed;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ComboBoxOnDropDownClosedDescr")]
+        public event EventHandler? DropDownClosed;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ComboBoxDropDownStyleChangedDescr")]
-        public event EventHandler DropDownStyleChanged;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ComboBoxDropDownStyleChangedDescr")]
+        public event EventHandler? DropDownStyleChanged;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("measureItemEventDescr")]
-        public event MeasureItemEventHandler MeasureItem;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("measureItemEventDescr")]
+        public event MeasureItemEventHandler? MeasureItem;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler PaddingChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? PaddingChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event PaintEventHandler Paint;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event PaintEventHandler? Paint;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("selectedIndexChangedEventDescr")]
-        public event EventHandler SelectedIndexChanged;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("selectedIndexChangedEventDescr")]
+        public event EventHandler? SelectedIndexChanged;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("selectionChangeCommittedEventDescr")]
-        public event EventHandler SelectionChangeCommitted;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("selectionChangeCommittedEventDescr")]
+        public event EventHandler? SelectionChangeCommitted;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ComboBoxOnTextUpdateDescr")]
-        public event EventHandler TextUpdate;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ComboBoxOnTextUpdateDescr")]
+        public event EventHandler? TextUpdate;
-        [ObsoleteAttribute("This method has been deprecated.  There is no replacement.  https://go.microsoft.com/fwlink/?linkid=14202")]
-        protected virtual void AddItemsCore(object[] value);
+        [ObsoleteAttribute("This method has been deprecated.  There is no replacement.  https://go.microsoft.com/fwlink/?linkid=14202")]
+        protected virtual void AddItemsCore(object[]? value);
-        public int FindString(string s);
+        public int FindString(string? s);
-        public int FindString(string s, int startIndex);
+        public int FindString(string? s, int startIndex);
-        public int FindStringExact(string s);
+        public int FindStringExact(string? s);
-        public int FindStringExact(string s, int startIndex);
+        public int FindStringExact(string? s, int startIndex);
         [ListBindableAttribute(false)]
         public class ObjectCollection : ICollection, IComparer<ComboBox.ObjectCollection.Entry>, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            [BrowsableAttribute(false)]
-            [DesignerSerializationVisibilityAttribute(0)]
-            public virtual object this[int index] { get; set; }
+            [BrowsableAttribute(false)]
+            [DesignerSerializationVisibilityAttribute(0)]
+            public virtual object? this[int index] { get; set; }
-            public bool Contains(object value);
+            public bool Contains(object? value);
-            public int IndexOf(object value);
+            public int IndexOf(object? value);
-            public void Insert(int index, object item);
+            public void Insert(int index, object? item);
-            public void Remove(object value);
+            public void Remove(object? value);
-            int IComparer<ComboBox.ObjectCollection.Entry>.Compare(ComboBox.ObjectCollection.Entry entry1, ComboBox.ObjectCollection.Entry entry2);
+            int IComparer<ComboBox.ObjectCollection.Entry>.Compare(ComboBox.ObjectCollection.Entry? entry1, ComboBox.ObjectCollection.Entry? entry2);
-            int IList.Add(object item);
+            int IList.Add(object? item);
         }
     }
     [DefaultEventAttribute("Opening")]
     [SRDescriptionAttribute("DescriptionContextMenuStrip")]
     public class ContextMenuStrip : ToolStripDropDownMenu {
+        protected override void OnClosed(ToolStripDropDownClosedEventArgs e);
+        protected override void OnOpened(EventArgs e);
     }
-    [DefaultEventAttribute("Click")]
-    [DefaultPropertyAttribute("Text")]
-    [DesignerAttribute("System.Windows.Forms.Design.ControlDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
-    [DesignerSerializerAttribute("System.Windows.Forms.Design.ControlCodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.ComponentModel.Design.Serialization.CodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
-    [ToolboxItemFilterAttribute("System.Windows.Forms")]
-    public class Control : Component, IArrangedElement, IBindableComponent, IComponent, IDisposable, IDropTarget, IHandle, IKeyboardToolTip, Interop.Ole32.IOleControl, Interop.Ole32.IOleInPlaceActiveObject, Interop.Ole32.IOleInPlaceObject, Interop.Ole32.IOleObject, Interop.Ole32.IOleWindow, Interop.Ole32.IPersist, Interop.Ole32.IPersistStorage, Interop.Ole32.IPersistStreamInit, Interop.Ole32.IQuickActivate, Interop.Ole32.IViewObject, Interop.Ole32.IViewObject2, Interop.Oleaut32.IPersistPropertyBag, ISupportOleDropSource, ISynchronizeInvoke, IWin32Window {
+    [DefaultEventAttribute("Click")]
+    [DefaultPropertyAttribute("Text")]
+    [DesignerAttribute("System.Windows.Forms.Design.ControlDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    [DesignerSerializerAttribute("System.Windows.Forms.Design.ControlCodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.ComponentModel.Design.Serialization.CodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    [ToolboxItemFilterAttribute("System.Windows.Forms")]
+    public class Control : Component, IArrangedElement, IBindableComponent, IComponent, IDisposable, IDropTarget, IHandle<HWND>, IKeyboardToolTip, IOleControl.Interface, IOleInPlaceActiveObject.Interface, IOleInPlaceObject.Interface, IOleObject.Interface, IOleWindow.Interface, IPersist.Interface, IPersistPropertyBag.Interface, IPersistStorage.Interface, IPersistStreamInit.Interface, IQuickActivate.Interface, ISupportOleDropSource, ISynchronizeInvoke, IViewObject.Interface, IViewObject2.Interface, IWin32Window {
-        [EditorBrowsableAttribute(2)]
-        protected void InvokeGotFocus(Control toInvoke, EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected void InvokeGotFocus(Control? toInvoke, EventArgs e);
-        [EditorBrowsableAttribute(2)]
-        protected void InvokeLostFocus(Control toInvoke, EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected void InvokeLostFocus(Control? toInvoke, EventArgs e);
-        [EditorBrowsableAttribute(2)]
-        protected void InvokeOnClick(Control toInvoke, EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected void InvokeOnClick(Control? toInvoke, EventArgs e);
     }
     [ComplexBindingPropertiesAttribute("DataSource", "DataMember")]
     [DefaultEventAttribute("CellContentClick")]
     [DesignerAttribute("System.Windows.Forms.Design.DataGridViewDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DockingAttribute(DockingBehavior.Ask)]
     [EditorAttribute("System.Windows.Forms.Design.DataGridViewComponentEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(ComponentEditor))]
     [SRDescriptionAttribute("DescriptionDataGridView")]
     public class DataGridView : Control, ISupportInitialize {
         public class DataGridViewControlCollection : Control.ControlCollection {
-            public override void Remove(Control value);
+            public override void Remove(Control? value);
         }
         public sealed class HitTestInfo {
-            public override bool Equals(object value);
+            public override bool Equals(object? value);
         }
     }
     public class DataGridViewButtonCell : DataGridViewCell {
-        public override Type EditType { get; }
+        public override Type? EditType { get; }
-        protected override object GetValue(int rowIndex);
+        protected override object? GetValue(int rowIndex);
-        protected override void Paint(Graphics graphics, Rectangle clipBounds, Rectangle cellBounds, int rowIndex, DataGridViewElementStates elementState, object value, object formattedValue, string errorText, DataGridViewCellStyle cellStyle, DataGridViewAdvancedBorderStyle advancedBorderStyle, DataGridViewPaintParts paintParts);
+        protected override void Paint(Graphics graphics, Rectangle clipBounds, Rectangle cellBounds, int rowIndex, DataGridViewElementStates elementState, object? value, object? formattedValue, string? errorText, DataGridViewCellStyle cellStyle, DataGridViewAdvancedBorderStyle advancedBorderStyle, DataGridViewPaintParts paintParts);
     }
     [AttributeUsageAttribute(4)]
     public sealed class DataGridViewColumnDesignTimeVisibleAttribute : Attribute {
-        public override bool Equals(object obj);
+        public override bool Equals(object? obj);
     }
     public class DataGridViewComboBoxEditingControl : ComboBox, IDataGridViewEditingControl {
-        public virtual DataGridView EditingControlDataGridView { get; set; }
+        public virtual DataGridView? EditingControlDataGridView { get; set; }
     }
     [TypeConverterAttribute(typeof(DataGridViewRowConverter))]
     public class DataGridViewRow : DataGridViewBand {
-        [DefaultValueAttribute(22)]
-        [NotifyParentPropertyAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("DataGridView_RowHeightDescr")]
-        public int Height { get; set; }
+        [NotifyParentPropertyAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("DataGridView_RowHeightDescr")]
+        public int Height { get; set; }
     }
     [ListBindableAttribute(false)]
     public class DataGridViewSelectedCellCollection : BaseCollection, ICollection, IEnumerable, IList {
-        int System.Collections.ICollection.Count { get; }
+        int ICollection.Count { get; }
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
-        bool System.Collections.IList.IsFixedSize { get; }
+        bool IList.IsFixedSize { get; }
-        bool System.Collections.IList.IsReadOnly { get; }
+        bool IList.IsReadOnly { get; }
-        object System.Collections.IList.this[int index] { get; set; }
+        object? IList.this[int index] { get; set; }
-        int IList.Add(object value);
+        int IList.Add(object? value);
-        bool IList.Contains(object value);
+        bool IList.Contains(object? value);
-        int IList.IndexOf(object value);
+        int IList.IndexOf(object? value);
-        void IList.Insert(int index, object value);
+        void IList.Insert(int index, object? value);
-        void IList.Remove(object value);
+        void IList.Remove(object? value);
     }
     [ListBindableAttribute(false)]
     public class DataGridViewSelectedColumnCollection : BaseCollection, ICollection, IEnumerable, IList {
-        int System.Collections.ICollection.Count { get; }
+        int ICollection.Count { get; }
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
-        bool System.Collections.IList.IsFixedSize { get; }
+        bool IList.IsFixedSize { get; }
-        bool System.Collections.IList.IsReadOnly { get; }
+        bool IList.IsReadOnly { get; }
-        object System.Collections.IList.this[int index] { get; set; }
+        object? IList.this[int index] { get; set; }
-        int IList.Add(object value);
+        int IList.Add(object? value);
-        bool IList.Contains(object value);
+        bool IList.Contains(object? value);
-        int IList.IndexOf(object value);
+        int IList.IndexOf(object? value);
-        void IList.Insert(int index, object value);
+        void IList.Insert(int index, object? value);
-        void IList.Remove(object value);
+        void IList.Remove(object? value);
     }
     [ListBindableAttribute(false)]
     public class DataGridViewSelectedRowCollection : BaseCollection, ICollection, IEnumerable, IList {
-        int System.Collections.ICollection.Count { get; }
+        int ICollection.Count { get; }
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
-        bool System.Collections.IList.IsFixedSize { get; }
+        bool IList.IsFixedSize { get; }
-        bool System.Collections.IList.IsReadOnly { get; }
+        bool IList.IsReadOnly { get; }
-        object System.Collections.IList.this[int index] { get; set; }
+        object? IList.this[int index] { get; set; }
-        int IList.Add(object value);
+        int IList.Add(object? value);
-        bool IList.Contains(object value);
+        bool IList.Contains(object? value);
-        int IList.IndexOf(object value);
+        int IList.IndexOf(object? value);
-        void IList.Insert(int index, object value);
+        void IList.Insert(int index, object? value);
-        void IList.Remove(object value);
+        void IList.Remove(object? value);
     }
     public class DataGridViewTextBoxEditingControl : TextBox, IDataGridViewEditingControl {
-        protected override void OnGotFocus(EventArgs e);
     }
     public class DataGridViewTopLeftHeaderCell : DataGridViewColumnHeaderCell {
-        protected override void Paint(Graphics graphics, Rectangle clipBounds, Rectangle cellBounds, int rowIndex, DataGridViewElementStates cellState, object value, object formattedValue, string errorText, DataGridViewCellStyle cellStyle, DataGridViewAdvancedBorderStyle advancedBorderStyle, DataGridViewPaintParts paintParts);
+        protected override void Paint(Graphics graphics, Rectangle clipBounds, Rectangle cellBounds, int rowIndex, DataGridViewElementStates cellState, object? value, object? formattedValue, string? errorText, DataGridViewCellStyle cellStyle, DataGridViewAdvancedBorderStyle advancedBorderStyle, DataGridViewPaintParts paintParts);
     }
     [DefaultBindingPropertyAttribute("SelectedItem")]
     [DefaultEventAttribute("SelectedItemChanged")]
     [DefaultPropertyAttribute("Items")]
     [SRDescriptionAttribute("DescriptionDomainUpDown")]
     public class DomainUpDown : UpDownBase {
-        protected override AccessibleObject CreateAccessibilityInstance();
-        [EditorBrowsableAttribute(1)]
-        [ObsoleteAttribute("DomainUpDownAccessibleObject is no longer used to provide accessible support for DomainUpDown controls.", false, DiagnosticId="WFDEV002", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
-        public class DomainUpDownAccessibleObject : Control.ControlAccessibleObject
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("DomainUpDownAccessibleObject is no longer used to provide accessible support for DomainUpDown controls. Use ControlAccessibleObject instead.", true, DiagnosticId="WFDEV002", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        public class DomainUpDownAccessibleObject : Control.ControlAccessibleObject
     }
     public class DragEventArgs : EventArgs {
-        public DragEventArgs(IDataObject? data, int keyState, int x, int y, DragDropEffects allowedEffect, DragDropEffects effect, DropImageType dropImageType, string message, string messageReplacementToken);
+        public DragEventArgs(IDataObject data, int keyState, int x, int y, DragDropEffects allowedEffect, DragDropEffects effect, DropImageType dropImageType, string message, string messageReplacementToken);
     }
     [ComplexBindingPropertiesAttribute("DataSource", "DataMember")]
     [ProvidePropertyAttribute("Error", typeof(Control))]
     [ProvidePropertyAttribute("IconAlignment", typeof(Control))]
     [ProvidePropertyAttribute("IconPadding", typeof(Control))]
     [SRDescriptionAttribute("DescriptionErrorProvider")]
     [ToolboxItemFilterAttribute("System.Windows.Forms")]
     public class ErrorProvider : Component, IExtenderProvider, ISupportInitialize {
-        [DefaultValueAttribute(null)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ErrorProviderContainerControlDescr")]
-        public ContainerControl ContainerControl { get; set; }
+        [DefaultValueAttribute(null)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ErrorProviderContainerControlDescr")]
+        public ContainerControl? ContainerControl { get; set; }
-        [DefaultValueAttribute(null)]
-        [EditorAttribute("System.Windows.Forms.Design.DataMemberListEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ErrorProviderDataMemberDescr")]
-        public string DataMember { get; set; }
+        [DefaultValueAttribute(null)]
+        [EditorAttribute("System.Windows.Forms.Design.DataMemberListEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ErrorProviderDataMemberDescr")]
+        public string? DataMember { get; set; }
-        [AttributeProviderAttribute(typeof(IListSource))]
-        [DefaultValueAttribute(null)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ErrorProviderDataSourceDescr")]
-        public object DataSource { get; set; }
+        [AttributeProviderAttribute(typeof(IListSource))]
+        [DefaultValueAttribute(null)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ErrorProviderDataSourceDescr")]
+        public object? DataSource { get; set; }
-        public override ISite Site { set; }
+        public override ISite? Site { set; }
-        [BindableAttribute(true)]
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(false)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ControlTagDescr")]
-        [TypeConverterAttribute(typeof(StringConverter))]
-        public object Tag { get; set; }
+        [BindableAttribute(true)]
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(false)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ControlTagDescr")]
+        [TypeConverterAttribute(typeof(StringConverter))]
+        public object? Tag { get; set; }
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("ControlOnRightToLeftChangedDescr")]
-        public event EventHandler RightToLeftChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("ControlOnRightToLeftChangedDescr")]
+        public event EventHandler? RightToLeftChanged;
-        public void BindToDataAndErrors(object newDataSource, string newDataMember);
+        public void BindToDataAndErrors(object? newDataSource, string? newDataMember);
-        public bool CanExtend(object extendee);
+        public bool CanExtend(object? extendee);
-        public void SetError(Control control, string value);
+        public void SetError(Control control, string? value);
     }
     [DefaultEventAttribute("HelpRequest")]
     [DefaultPropertyAttribute("SelectedPath")]
     [DesignerAttribute("System.Windows.Forms.Design.FolderBrowserDialogDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionFolderBrowserDialog")]
     public sealed class FolderBrowserDialog : CommonDialog {
         protected override bool RunDialog(IntPtr hWndOwner);
     }
     public static class Help {
-        public static void ShowPopup(Control parent, string caption, Point location);
+        public static void ShowPopup(Control? parent, string caption, Point location);
     }
     [ProvidePropertyAttribute("HelpKeyword", typeof(Control))]
     [ProvidePropertyAttribute("HelpNavigator", typeof(Control))]
     [ProvidePropertyAttribute("HelpString", typeof(Control))]
     [ProvidePropertyAttribute("ShowHelp", typeof(Control))]
     [SRDescriptionAttribute("DescriptionHelpProvider")]
     [ToolboxItemFilterAttribute("System.Windows.Forms")]
     public class HelpProvider : Component, IExtenderProvider {
-        [DefaultValueAttribute(null)]
-        [EditorAttribute("System.Windows.Forms.Design.HelpNamespaceEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [LocalizableAttribute(true)]
-        [SRDescriptionAttribute("HelpProviderHelpNamespaceDescr")]
-        public virtual string HelpNamespace { get; set; }
+        [DefaultValueAttribute(null)]
+        [EditorAttribute("System.Windows.Forms.Design.HelpNamespaceEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [LocalizableAttribute(true)]
+        [SRDescriptionAttribute("HelpProviderHelpNamespaceDescr")]
+        public virtual string? HelpNamespace { get; set; }
-        [BindableAttribute(true)]
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(false)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ControlTagDescr")]
-        [TypeConverterAttribute(typeof(StringConverter))]
-        public object Tag { get; set; }
+        [BindableAttribute(true)]
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(false)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ControlTagDescr")]
+        [TypeConverterAttribute(typeof(StringConverter))]
+        public object? Tag { get; set; }
-        public virtual bool CanExtend(object target);
+        public virtual bool CanExtend(object? target);
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(true)]
-        [SRDescriptionAttribute("HelpProviderHelpKeywordDescr")]
-        public virtual string GetHelpKeyword(Control ctl);
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(true)]
+        [SRDescriptionAttribute("HelpProviderHelpKeywordDescr")]
+        public virtual string? GetHelpKeyword(Control ctl);
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(true)]
-        [SRDescriptionAttribute("HelpProviderHelpStringDescr")]
-        public virtual string GetHelpString(Control ctl);
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(true)]
+        [SRDescriptionAttribute("HelpProviderHelpStringDescr")]
+        public virtual string? GetHelpString(Control ctl);
-        public virtual void SetHelpKeyword(Control ctl, string keyword);
+        public virtual void SetHelpKeyword(Control ctl, string? keyword);
-        public virtual void SetHelpString(Control ctl, string helpString);
+        public virtual void SetHelpString(Control ctl, string? helpString);
     }
     public sealed class HtmlDocument {
-        public HtmlElement ActiveElement { get; }
+        public HtmlElement? ActiveElement { get; }
-        public HtmlElement Body { get; }
+        public HtmlElement? Body { get; }
-        public Uri Url { get; }
+        public Uri? Url { get; }
-        public HtmlWindow Window { get; }
+        public HtmlWindow? Window { get; }
-        public event HtmlElementEventHandler Click;
+        public event HtmlElementEventHandler? Click;
-        public event HtmlElementEventHandler ContextMenuShowing;
+        public event HtmlElementEventHandler? ContextMenuShowing;
-        public event HtmlElementEventHandler Focusing;
+        public event HtmlElementEventHandler? Focusing;
-        public event HtmlElementEventHandler LosingFocus;
+        public event HtmlElementEventHandler? LosingFocus;
-        public event HtmlElementEventHandler MouseDown;
+        public event HtmlElementEventHandler? MouseDown;
-        public event HtmlElementEventHandler MouseLeave;
+        public event HtmlElementEventHandler? MouseLeave;
-        public event HtmlElementEventHandler MouseMove;
+        public event HtmlElementEventHandler? MouseMove;
-        public event HtmlElementEventHandler MouseOver;
+        public event HtmlElementEventHandler? MouseOver;
-        public event HtmlElementEventHandler MouseUp;
+        public event HtmlElementEventHandler? MouseUp;
-        public event HtmlElementEventHandler Stop;
+        public event HtmlElementEventHandler? Stop;
-        public HtmlElement CreateElement(string elementTag);
+        public HtmlElement? CreateElement(string elementTag);
-        public override bool Equals(object obj);
+        public override bool Equals(object? obj);
-        public HtmlElement GetElementById(string id);
+        public HtmlElement? GetElementById(string id);
-        public HtmlElement GetElementFromPoint(Point point);
+        public HtmlElement? GetElementFromPoint(Point point);
-        public object InvokeScript(string scriptName);
+        public object? InvokeScript(string scriptName);
-        public object InvokeScript(string scriptName, object[] args);
+        public object? InvokeScript(string scriptName, object[]? args);
-        public HtmlDocument OpenNew(bool replaceInHistory);
+        public HtmlDocument? OpenNew(bool replaceInHistory);
-        public static bool operator ==(HtmlDocument left, HtmlDocument right);
+        public static bool operator ==(HtmlDocument? left, HtmlDocument? right);
-        public static bool operator !=(HtmlDocument left, HtmlDocument right);
+        public static bool operator !=(HtmlDocument? left, HtmlDocument? right);
     }
     public sealed class HtmlElementCollection : ICollection, IEnumerable {
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
-        public HtmlElement this[int index] { get; }
+        public HtmlElement? this[int index] { get; }
-        public HtmlElement this[string elementId] { get; }
+        public HtmlElement? this[string elementId] { get; }
     }
     public sealed class HtmlElementEventArgs : EventArgs {
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(2)]
-        public HtmlElement FromElement { get; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(2)]
+        public HtmlElement? FromElement { get; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(2)]
-        public HtmlElement ToElement { get; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(2)]
+        public HtmlElement? ToElement { get; }
     }
     public class HtmlWindowCollection : ICollection, IEnumerable {
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
-        public HtmlWindow this[int index] { get; }
+        public HtmlWindow? this[int index] { get; }
-        public HtmlWindow this[string windowId] { get; }
+        public HtmlWindow? this[string windowId] { get; }
     }
-    public struct ImeModeConversion
+    public readonly struct ImeModeConversion
     public class KeysConverter : TypeConverter, IComparer {
-        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
+        public override bool CanConvertTo(ITypeDescriptorContext? context, Type? destinationType);
-        public int Compare(object a, object b);
+        public int Compare(object? a, object? b);
-        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object? ConvertFrom(ITypeDescriptorContext? context, CultureInfo? culture, object value);
-        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public override object? ConvertTo(ITypeDescriptorContext? context, CultureInfo? culture, object? value, Type destinationType);
-        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
+        public override bool GetStandardValuesExclusive(ITypeDescriptorContext? context);
-        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
+        public override bool GetStandardValuesSupported(ITypeDescriptorContext? context);
     }
     [DefaultEventAttribute("LinkClicked")]
     [SRDescriptionAttribute("DescriptionLinkLabel")]
     [ToolboxItemAttribute("System.Windows.Forms.Design.AutoSizeToolboxItem,System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public class LinkLabel : Label, IButtonControl {
-        protected Cursor OverrideCursor { get; set; }
+        protected Cursor? OverrideCursor { get; set; }
-        DialogResult System.Windows.Forms.IButtonControl.DialogResult { get; set; }
+        DialogResult IButtonControl.DialogResult { get; set; }
-        [RefreshPropertiesAttribute(2)]
-        public override string Text { get; set; }
+        [RefreshPropertiesAttribute(2)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [SRDescriptionAttribute("LinkLabelLinkClickedDescr")]
-        [WinCategoryAttribute("Action")]
-        public event LinkLabelLinkClickedEventHandler LinkClicked;
+        [SRDescriptionAttribute("LinkLabelLinkClickedDescr")]
+        [WinCategoryAttribute("Action")]
+        public event LinkLabelLinkClickedEventHandler? LinkClicked;
-        [BrowsableAttribute(true)]
-        [EditorBrowsableAttribute(0)]
-        public new event EventHandler TabStopChanged;
+        [BrowsableAttribute(true)]
+        [EditorBrowsableAttribute(0)]
+        public new event EventHandler? TabStopChanged;
-        protected LinkLabel.Link PointInLink(int x, int y);
+        protected LinkLabel.Link? PointInLink(int x, int y);
         [TypeConverterAttribute(typeof(LinkConverter))]
         public class Link {
-            [DefaultValueAttribute("")]
-            [SRCategoryAttribute("CatAppearance")]
-            [SRDescriptionAttribute("TreeNodeNodeNameDescr")]
-            public string Name { get; set; }
+            [DefaultValueAttribute("")]
+            [SRCategoryAttribute("CatAppearance")]
+            [SRDescriptionAttribute("TreeNodeNodeNameDescr")]
+            [AllowNullAttribute]
+            public string Name { get; set; }
         }
         public class LinkCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object? IList.this[int index] { get; set; }
-            public virtual LinkLabel.Link this[string key] { get; }
+            public virtual LinkLabel.Link? this[string key] { get; }
-            public LinkLabel.Link Add(int start, int length, object linkData);
+            public LinkLabel.Link Add(int start, int length, object? linkData);
-            public virtual bool ContainsKey(string key);
+            public virtual bool ContainsKey(string? key);
-            public virtual int IndexOfKey(string key);
+            public virtual int IndexOfKey(string? key);
-            public virtual void RemoveByKey(string key);
+            public virtual void RemoveByKey(string? key);
-            int IList.Add(object value);
+            int IList.Add(object? value);
-            bool IList.Contains(object link);
+            bool IList.Contains(object? value);
-            int IList.IndexOf(object link);
+            int IList.IndexOf(object? value);
-            void IList.Insert(int index, object value);
+            void IList.Insert(int index, object? value);
-            void IList.Remove(object value);
+            void IList.Remove(object? value);
         }
     }
     public static class ListBindingHelper {
-        public static object GetList(object list);
+        public static object? GetList(object? list);
-        public static object GetList(object dataSource, string dataMember);
+        public static object? GetList(object? dataSource, string? dataMember);
-        public static PropertyDescriptorCollection GetListItemProperties(object list);
+        public static PropertyDescriptorCollection GetListItemProperties(object? list);
-        public static PropertyDescriptorCollection GetListItemProperties(object list, PropertyDescriptor[] listAccessors);
+        public static PropertyDescriptorCollection GetListItemProperties(object? list, PropertyDescriptor[]? listAccessors);
-        public static PropertyDescriptorCollection GetListItemProperties(object dataSource, string dataMember, PropertyDescriptor[] listAccessors);
+        public static PropertyDescriptorCollection GetListItemProperties(object? dataSource, string? dataMember, PropertyDescriptor[]? listAccessors);
-        public static Type GetListItemType(object list);
+        public static Type? GetListItemType(object? list);
-        public static Type GetListItemType(object dataSource, string dataMember);
+        public static Type? GetListItemType(object? dataSource, string? dataMember);
-        public static string GetListName(object list, PropertyDescriptor[] listAccessors);
+        public static string GetListName(object? list, PropertyDescriptor[]? listAccessors);
     }
     [DefaultBindingPropertyAttribute("SelectedValue")]
     [DefaultEventAttribute("SelectedIndexChanged")]
     [DefaultPropertyAttribute("Items")]
     [DesignerAttribute("System.Windows.Forms.Design.ListBoxDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionListBox")]
     public class ListBox : ListControl {
-        [DefaultValueAttribute(13)]
-        [LocalizableAttribute(true)]
-        [RefreshPropertiesAttribute(2)]
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ListBoxItemHeightDescr")]
-        public virtual int ItemHeight { get; set; }
+        [LocalizableAttribute(true)]
+        [RefreshPropertiesAttribute(2)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ListBoxItemHeightDescr")]
+        public virtual int ItemHeight { get; set; }
     }
     [DefaultEventAttribute("SelectedIndexChanged")]
     [DefaultPropertyAttribute("Items")]
     [DesignerAttribute("System.Windows.Forms.Design.ListViewDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DockingAttribute(DockingBehavior.Ask)]
     [SRDescriptionAttribute("DescriptionListView")]
     public class ListView : Control {
         [ListBindableAttribute(false)]
         public class ListViewItemCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object? IList.this[int index] { get; set; }
-            public virtual ListViewItem this[string key] { get; }
+            public virtual ListViewItem? this[string key] { get; }
-            public virtual ListViewItem Add(string text);
+            public virtual ListViewItem Add(string? text);
-            public virtual ListViewItem Add(string text, int imageIndex);
+            public virtual ListViewItem Add(string? text, int imageIndex);
-            public virtual ListViewItem Add(string text, string imageKey);
+            public virtual ListViewItem Add(string? text, string? imageKey);
-            public virtual ListViewItem Add(string key, string text, int imageIndex);
+            public virtual ListViewItem Add(string? key, string? text, int imageIndex);
-            public virtual ListViewItem Add(string key, string text, string imageKey);
+            public virtual ListViewItem Add(string? key, string? text, string? imageKey);
-            public virtual bool ContainsKey(string key);
+            public virtual bool ContainsKey(string? key);
-            public virtual int IndexOfKey(string key);
+            public virtual int IndexOfKey(string? key);
-            public ListViewItem Insert(int index, string text);
+            public ListViewItem Insert(int index, string? text);
-            public ListViewItem Insert(int index, string text, int imageIndex);
+            public ListViewItem Insert(int index, string? text, int imageIndex);
-            public ListViewItem Insert(int index, string text, string imageKey);
+            public ListViewItem Insert(int index, string? text, string? imageKey);
-            public virtual ListViewItem Insert(int index, string key, string text, int imageIndex);
+            public virtual ListViewItem Insert(int index, string? key, string? text, int imageIndex);
-            public virtual ListViewItem Insert(int index, string key, string text, string imageKey);
+            public virtual ListViewItem Insert(int index, string? key, string? text, string? imageKey);
-            int IList.Add(object item);
+            int IList.Add(object? item);
-            bool IList.Contains(object item);
+            bool IList.Contains(object? item);
-            int IList.IndexOf(object item);
+            int IList.IndexOf(object? item);
-            void IList.Insert(int index, object item);
+            void IList.Insert(int index, object? item);
-            void IList.Remove(object item);
+            void IList.Remove(object? item);
         }
     }
     [DefaultPropertyAttribute("Text")]
     [DesignTimeVisibleAttribute(false)]
     [ToolboxItemAttribute(false)]
     [TypeConverterAttribute(typeof(ListViewItemConverter))]
     public class ListViewItem : ICloneable, IKeyboardToolTip, ISerializable {
-        public ListViewItem(ListViewItem.ListViewSubItem[] subItems, int imageIndex, ListViewGroup group);
+        public ListViewItem(ListViewItem.ListViewSubItem[] subItems, int imageIndex, ListViewGroup? group);
-        public ListViewItem(ListViewItem.ListViewSubItem[] subItems, string imageKey);
+        public ListViewItem(ListViewItem.ListViewSubItem[] subItems, string? imageKey);
-        public ListViewItem(ListViewItem.ListViewSubItem[] subItems, string imageKey, ListViewGroup group);
+        public ListViewItem(ListViewItem.ListViewSubItem[] subItems, string? imageKey, ListViewGroup? group);
-        public ListViewItem(string text);
+        public ListViewItem(string? text);
-        public ListViewItem(string text, int imageIndex);
+        public ListViewItem(string? text, int imageIndex);
-        public ListViewItem(string text, int imageIndex, ListViewGroup group);
+        public ListViewItem(string? text, int imageIndex, ListViewGroup? group);
-        public ListViewItem(string text, string imageKey);
+        public ListViewItem(string? text, string? imageKey);
-        public ListViewItem(string text, string imageKey, ListViewGroup group);
+        public ListViewItem(string? text, string? imageKey, ListViewGroup? group);
-        public ListViewItem(string text, ListViewGroup group);
+        public ListViewItem(string? text, ListViewGroup? group);
-        public ListViewItem(string[] items);
+        public ListViewItem(string[]? items);
-        public ListViewItem(string[] items, int imageIndex);
+        public ListViewItem(string[]? items, int imageIndex);
-        public ListViewItem(string[] items, int imageIndex, Color foreColor, Color backColor, Font font);
+        public ListViewItem(string[]? items, int imageIndex, Color foreColor, Color backColor, Font? font);
-        public ListViewItem(string[] items, int imageIndex, Color foreColor, Color backColor, Font font, ListViewGroup group);
+        public ListViewItem(string[]? items, int imageIndex, Color foreColor, Color backColor, Font? font, ListViewGroup? group);
-        public ListViewItem(string[] items, int imageIndex, ListViewGroup group);
+        public ListViewItem(string[]? items, int imageIndex, ListViewGroup? group);
-        public ListViewItem(string[] items, string imageKey);
+        public ListViewItem(string[]? items, string? imageKey);
-        public ListViewItem(string[] items, string imageKey, Color foreColor, Color backColor, Font font);
+        public ListViewItem(string[]? items, string? imageKey, Color foreColor, Color backColor, Font? font);
-        public ListViewItem(string[] items, string imageKey, Color foreColor, Color backColor, Font font, ListViewGroup group);
+        public ListViewItem(string[]? items, string? imageKey, Color foreColor, Color backColor, Font? font, ListViewGroup? group);
-        public ListViewItem(string[] items, string imageKey, ListViewGroup group);
+        public ListViewItem(string[]? items, string? imageKey, ListViewGroup? group);
-        public ListViewItem(string[] items, ListViewGroup group);
+        public ListViewItem(string[]? items, ListViewGroup? group);
-        public ListViewItem(ListViewGroup group);
+        public ListViewItem(ListViewGroup? group);
-        [DesignerSerializationVisibilityAttribute(0)]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        public Font Font { get; set; }
+        [DesignerSerializationVisibilityAttribute(0)]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [AllowNullAttribute]
+        public Font Font { get; set; }
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatBehavior")]
-        public ListViewGroup Group { get; set; }
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatBehavior")]
+        public ListViewGroup? Group { get; set; }
-        [BrowsableAttribute(false)]
-        public ImageList ImageList { get; }
+        [BrowsableAttribute(false)]
+        public ImageList? ImageList { get; }
-        [BrowsableAttribute(false)]
-        public ListView ListView { get; }
+        [BrowsableAttribute(false)]
+        public ListView? ListView { get; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [LocalizableAttribute(true)]
-        public string Name { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [LocalizableAttribute(true)]
+        [AllowNullAttribute]
+        public string Name { get; set; }
-        [BindableAttribute(true)]
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(false)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ControlTagDescr")]
-        [TypeConverterAttribute(typeof(StringConverter))]
-        public object Tag { get; set; }
+        [BindableAttribute(true)]
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(false)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ControlTagDescr")]
+        [TypeConverterAttribute(typeof(StringConverter))]
+        public object? Tag { get; set; }
-        [DesignerSerializationVisibilityAttribute(0)]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        public string Text { get; set; }
+        [DesignerSerializationVisibilityAttribute(0)]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [AllowNullAttribute]
+        public string Text { get; set; }
-        [DefaultValueAttribute("")]
-        [SRCategoryAttribute("CatAppearance")]
-        public string ToolTipText { get; set; }
+        [DefaultValueAttribute("")]
+        [SRCategoryAttribute("CatAppearance")]
+        [AllowNullAttribute]
+        public string ToolTipText { get; set; }
-        public ListViewItem FindNearestItem(SearchDirectionHint searchDirection);
+        public ListViewItem? FindNearestItem(SearchDirectionHint searchDirection);
-        public ListViewItem.ListViewSubItem GetSubItemAt(int x, int y);
+        public ListViewItem.ListViewSubItem? GetSubItemAt(int x, int y);
         [DefaultPropertyAttribute("Text")]
         [DesignTimeVisibleAttribute(false)]
         [ToolboxItemAttribute(false)]
         [TypeConverterAttribute(typeof(ListViewSubItemConverter))]
         public class ListViewSubItem {
-            public ListViewSubItem(ListViewItem owner, string? text);
+            public ListViewSubItem(ListViewItem owner, string text);
-            public ListViewSubItem(ListViewItem owner, string? text, Color foreColor, Color backColor, Font font);
+            public ListViewSubItem(ListViewItem owner, string text, Color foreColor, Color backColor, Font font);
-            [LocalizableAttribute(true)]
-            public Font Font { get; set; }
+            [LocalizableAttribute(true)]
+            [AllowNullAttribute]
+            public Font Font { get; set; }
-            [BindableAttribute(true)]
-            [DefaultValueAttribute(null)]
-            [LocalizableAttribute(false)]
-            [SRCategoryAttribute("CatData")]
-            [SRDescriptionAttribute("ControlTagDescr")]
-            [TypeConverterAttribute(typeof(StringConverter))]
-            public object? Tag { get; set; }
+            [BindableAttribute(true)]
+            [DefaultValueAttribute(null)]
+            [LocalizableAttribute(false)]
+            [SRCategoryAttribute("CatData")]
+            [SRDescriptionAttribute("ControlTagDescr")]
+            [TypeConverterAttribute(typeof(StringConverter))]
+            public object Tag { get; set; }
         }
     }
     [DefaultBindingPropertyAttribute("Text")]
     [DefaultEventAttribute("MaskInputRejected")]
     [DefaultPropertyAttribute("Mask")]
     [DesignerAttribute("System.Windows.Forms.Design.MaskedTextBoxDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionMaskedTextBox")]
     public class MaskedTextBox : TextBoxBase {
+        protected override AccessibleObject CreateAccessibilityInstance();
+        protected override void OnGotFocus(EventArgs e);
+        protected override void OnMouseDown(MouseEventArgs e);
     }
     [DesignTimeVisibleAttribute(false)]
     [ToolboxItemAttribute(false)]
     public sealed class MdiClient : Control {
         public new class ControlCollection : Control.ControlCollection {
-            public override void Add(Control value);
+            public override void Add(Control? value);
-            public override void Remove(Control value);
+            public override void Remove(Control? value);
         }
     }
     public class MessageBox {
-        public static DialogResult Show(string text, string caption, MessageBoxButtons buttons, MessageBoxIcon icon, MessageBoxDefaultButton defaultButton, MessageBoxOptions options, string helpFilePath, string keyword);
+        public static DialogResult Show(string? text, string? caption, MessageBoxButtons buttons, MessageBoxIcon icon, MessageBoxDefaultButton defaultButton, MessageBoxOptions options, string helpFilePath, string keyword);
     }
     [DefaultBindingPropertyAttribute("SelectionRange")]
     [DefaultEventAttribute("DateChanged")]
     [DefaultPropertyAttribute("SelectionRange")]
     [DesignerAttribute("System.Windows.Forms.Design.MonthCalendarDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionMonthCalendar")]
     public class MonthCalendar : Control {
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override Image BackgroundImage { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public override Image? BackgroundImage { get; set; }
-        [BindableAttribute(false)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BindableAttribute(false)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackgroundImageChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackgroundImageChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackgroundImageLayoutChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackgroundImageLayoutChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler Click;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? Click;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("MonthCalendarOnDateChangedDescr")]
-        public event DateRangeEventHandler DateChanged;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("MonthCalendarOnDateChangedDescr")]
+        public event DateRangeEventHandler? DateChanged;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("MonthCalendarOnDateSelectedDescr")]
-        public event DateRangeEventHandler DateSelected;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("MonthCalendarOnDateSelectedDescr")]
+        public event DateRangeEventHandler? DateSelected;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler DoubleClick;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? DoubleClick;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler ImeModeChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? ImeModeChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event MouseEventHandler MouseClick;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event MouseEventHandler? MouseClick;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event MouseEventHandler MouseDoubleClick;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event MouseEventHandler? MouseDoubleClick;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler PaddingChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? PaddingChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event PaintEventHandler Paint;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event PaintEventHandler? Paint;
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("ControlOnRightToLeftLayoutChangedDescr")]
-        public event EventHandler RightToLeftLayoutChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("ControlOnRightToLeftLayoutChangedDescr")]
+        public event EventHandler? RightToLeftLayoutChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler TextChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? TextChanged;
     }
     public class NativeWindow : MarshalByRefObject, IHandle, IWin32Window {
+        protected virtual void WmDpiChangedAfterParent(ref Message m);
+        protected virtual void WmDpiChangedBeforeParent(ref Message m);
     }
     [DefaultPropertyAttribute("Document")]
     [SRDescriptionAttribute("DescriptionPrintPreviewControl")]
     public class PrintPreviewControl : Control {
-        protected override CreateParams CreateParams { get; }
+        [DefaultValueAttribute(false)]
+        [DispIdAttribute(-516)]
+        public new bool TabStop { get; set; }
+        protected override void OnGotFocus(EventArgs e);
+        protected override void OnLostFocus(EventArgs e);
+        protected override void OnMouseDown(MouseEventArgs e);
+        protected override void OnPaintBackground(PaintEventArgs e);
     }
-    [DesignerAttribute("System.Windows.Forms.Design.PropertyGridDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
-    [SRDescriptionAttribute("DescriptionPropertyGrid")]
-    public class PropertyGrid : ContainerControl, IComPropertyBrowser, Interop.Ole32.IPropertyNotifySink {
+    [DesignerAttribute("System.Windows.Forms.Design.PropertyGridDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    [SRDescriptionAttribute("DescriptionPropertyGrid")]
+    public class PropertyGrid : ContainerControl, IComPropertyBrowser, IPropertyNotifySink.Interface {
         public class PropertyTabCollection : ICollection, IEnumerable {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
         }
     }
     public class PropertyManager : BindingManagerBase {
-        public override object Current { get; }
+        public override object? Current { get; }
-        protected internal override string GetListName(ArrayList listAccessors);
+        protected internal override string GetListName(ArrayList? listAccessors);
     }
     [DefaultBindingPropertyAttribute("Checked")]
     [DefaultEventAttribute("CheckedChanged")]
     [DefaultPropertyAttribute("Checked")]
     [DesignerAttribute("System.Windows.Forms.Design.RadioButtonDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionRadioButton")]
     [ToolboxItemAttribute("System.Windows.Forms.Design.AutoSizeToolboxItem,System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public class RadioButton : ButtonBase {
         public class RadioButtonAccessibleObject : Control.ControlAccessibleObject {
+            public override string KeyboardShortcut { get; }
+            public override string Name { get; }
         }
     }
     [DesignerAttribute("System.Windows.Forms.Design.RichTextBoxDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DockingAttribute(DockingBehavior.Ask)]
     [SRDescriptionAttribute("DescriptionRichTextBox")]
     public class RichTextBox : TextBoxBase {
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override Image BackgroundImage { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public override Image? BackgroundImage { get; set; }
-        public override Font Font { get; set; }
+        [AllowNullAttribute]
+        public override Font Font { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [RefreshPropertiesAttribute(1)]
-        [SRDescriptionAttribute("RichTextBoxRTF")]
-        public string Rtf { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [RefreshPropertiesAttribute(1)]
+        [SRDescriptionAttribute("RichTextBoxRTF")]
+        public string? Rtf { get; set; }
-        [BrowsableAttribute(false)]
-        [DefaultValueAttribute("")]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRDescriptionAttribute("RichTextBoxSelRTF")]
-        public string SelectedRtf { get; set; }
+        [BrowsableAttribute(false)]
+        [DefaultValueAttribute("")]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRDescriptionAttribute("RichTextBoxSelRTF")]
+        [AllowNullAttribute]
+        public string SelectedRtf { get; set; }
-        [BrowsableAttribute(false)]
-        [DefaultValueAttribute("")]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRDescriptionAttribute("RichTextBoxSelText")]
-        public override string SelectedText { get; set; }
+        [BrowsableAttribute(false)]
+        [DefaultValueAttribute("")]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRDescriptionAttribute("RichTextBoxSelText")]
+        [AllowNullAttribute]
+        public override string SelectedText { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRDescriptionAttribute("RichTextBoxSelFont")]
-        public Font SelectionFont { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRDescriptionAttribute("RichTextBoxSelFont")]
+        [DisallowNullAttribute]
+        public Font? SelectionFont { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRDescriptionAttribute("RichTextBoxSelTabs")]
-        public int[] SelectionTabs { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRDescriptionAttribute("RichTextBoxSelTabs")]
+        [AllowNullAttribute]
+        public int[] SelectionTabs { get; set; }
-        [LocalizableAttribute(true)]
-        [RefreshPropertiesAttribute(1)]
-        public override string Text { get; set; }
+        [LocalizableAttribute(true)]
+        [RefreshPropertiesAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackgroundImageChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackgroundImageChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackgroundImageLayoutChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackgroundImageLayoutChanged;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("RichTextBoxContentsResized")]
-        public event ContentsResizedEventHandler ContentsResized;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("RichTextBoxContentsResized")]
+        public event ContentsResizedEventHandler? ContentsResized;
-        [BrowsableAttribute(false)]
-        public new event DragEventHandler DragDrop;
+        [BrowsableAttribute(false)]
+        public new event DragEventHandler? DragDrop;
-        [BrowsableAttribute(false)]
-        public new event DragEventHandler DragEnter;
+        [BrowsableAttribute(false)]
+        public new event DragEventHandler? DragEnter;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler DragLeave;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? DragLeave;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event DragEventHandler DragOver;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event DragEventHandler? DragOver;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event GiveFeedbackEventHandler GiveFeedback;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event GiveFeedbackEventHandler? GiveFeedback;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("RichTextBoxHScroll")]
-        public event EventHandler HScroll;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("RichTextBoxHScroll")]
+        public event EventHandler? HScroll;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("RichTextBoxIMEChange")]
-        public event EventHandler ImeChange;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("RichTextBoxIMEChange")]
+        public event EventHandler? ImeChange;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("RichTextBoxLinkClick")]
-        public event LinkClickedEventHandler LinkClicked;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("RichTextBoxLinkClick")]
+        public event LinkClickedEventHandler? LinkClicked;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("RichTextBoxProtected")]
-        public event EventHandler Protected;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("RichTextBoxProtected")]
+        public event EventHandler? Protected;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event QueryContinueDragEventHandler QueryContinueDrag;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event QueryContinueDragEventHandler? QueryContinueDrag;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("RichTextBoxSelChange")]
-        public event EventHandler SelectionChanged;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("RichTextBoxSelChange")]
+        public event EventHandler? SelectionChanged;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("RichTextBoxVScroll")]
-        public event EventHandler VScroll;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("RichTextBoxVScroll")]
+        public event EventHandler? VScroll;
     }
     [DefaultEventAttribute("Scroll")]
     [DefaultPropertyAttribute("Value")]
     public abstract class ScrollBar : Control {
-        protected override void RescaleConstantsForDpi(int deviceDpiOld, int deviceDpiNew);
+        protected override void ScaleControl(SizeF factor, BoundsSpecified specified);
     }
     [SRDescriptionAttribute("DescriptionStatusStrip")]
     public class StatusStrip : ToolStrip {
-        [BrowsableAttribute(false)]
-        public new event EventHandler PaddingChanged;
+        [BrowsableAttribute(false)]
+        public new event EventHandler? PaddingChanged;
-        protected internal override ToolStripItem CreateDefaultItem(string text, Image image, EventHandler onClick);
+        protected internal override ToolStripItem CreateDefaultItem(string? text, Image? image, EventHandler? onClick);
     }
     [DefaultEventAttribute("SelectedIndexChanged")]
     [DefaultPropertyAttribute("TabPages")]
     [DesignerAttribute("System.Windows.Forms.Design.TabControlDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionTabControl")]
     public class TabControl : Control {
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override Image BackgroundImage { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public override Image? BackgroundImage { get; set; }
-        [DefaultValueAttribute(null)]
-        [RefreshPropertiesAttribute(2)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("TabBaseImageListDescr")]
-        public ImageList ImageList { get; set; }
+        [DefaultValueAttribute(null)]
+        [RefreshPropertiesAttribute(2)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("TabBaseImageListDescr")]
+        public ImageList? ImageList { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("TabControlSelectedTabDescr")]
-        public TabPage SelectedTab { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("TabControlSelectedTabDescr")]
+        public TabPage? SelectedTab { get; set; }
-        [BindableAttribute(false)]
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BindableAttribute(false)]
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackColorChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackColorChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackgroundImageChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackgroundImageChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackgroundImageLayoutChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackgroundImageLayoutChanged;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("TabControlDeselectedEventDescr")]
-        public event TabControlEventHandler Deselected;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("TabControlDeselectedEventDescr")]
+        public event TabControlEventHandler? Deselected;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("TabControlDeselectingEventDescr")]
-        public event TabControlCancelEventHandler Deselecting;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("TabControlDeselectingEventDescr")]
+        public event TabControlCancelEventHandler? Deselecting;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("drawItemEventDescr")]
-        public event DrawItemEventHandler DrawItem;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("drawItemEventDescr")]
+        public event DrawItemEventHandler? DrawItem;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler ForeColorChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? ForeColorChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event PaintEventHandler Paint;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event PaintEventHandler? Paint;
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("ControlOnRightToLeftLayoutChangedDescr")]
-        public event EventHandler RightToLeftLayoutChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("ControlOnRightToLeftLayoutChangedDescr")]
+        public event EventHandler? RightToLeftLayoutChanged;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("TabControlSelectedEventDescr")]
-        public event TabControlEventHandler Selected;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("TabControlSelectedEventDescr")]
+        public event TabControlEventHandler? Selected;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("selectedIndexChangedEventDescr")]
-        public event EventHandler SelectedIndexChanged;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("selectedIndexChangedEventDescr")]
+        public event EventHandler? SelectedIndexChanged;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("TabControlSelectingEventDescr")]
-        public event TabControlCancelEventHandler Selecting;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("TabControlSelectingEventDescr")]
+        public event TabControlCancelEventHandler? Selecting;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler TextChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? TextChanged;
         public new class ControlCollection : Control.ControlCollection {
-            public override void Add(Control value);
+            public override void Add(Control? value);
-            public override void Remove(Control value);
+            public override void Remove(Control? value);
         }
     }
     [TypeConverterAttribute(typeof(TableLayoutPanelCellPositionTypeConverter))]
     public struct TableLayoutPanelCellPosition : IEquatable<TableLayoutPanelCellPosition> {
-        public override bool Equals(object other);
+        public override bool Equals(object? other);
     }
     [EditorAttribute("System.Windows.Forms.Design.StyleCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
     public abstract class TableLayoutStyleCollection : ICollection, IEnumerable, IList {
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
-        bool System.Collections.IList.IsFixedSize { get; }
+        bool IList.IsFixedSize { get; }
-        bool System.Collections.IList.IsReadOnly { get; }
+        bool IList.IsReadOnly { get; }
-        object System.Collections.IList.this[int index] { get; set; }
+        object IList.this[int index] { get; set; }
     }
+    public class TaskDialogLinkClickedEventArgs : EventArgs {
+        public TaskDialogLinkClickedEventArgs(string linkHref);
+        public string LinkHref { get; }
+    }
     public class TaskDialogPage {
+        public bool EnableLinks { get; set; }
+        public event EventHandler<TaskDialogLinkClickedEventArgs>? LinkClicked;
+        protected internal void OnLinkClicked(TaskDialogLinkClickedEventArgs e);
     }
     [DesignerAttribute("System.Windows.Forms.Design.TextBoxDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionTextBox")]
     public class TextBox : TextBoxBase {
+        protected override AccessibleObject CreateAccessibilityInstance();
     }
     [DefaultBindingPropertyAttribute("Text")]
     [DefaultEventAttribute("TextChanged")]
     [DesignerAttribute("System.Windows.Forms.Design.TextBoxBaseDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public abstract class TextBoxBase : Control {
+        protected bool ContainsNavigationKeyCode(Keys keyCode);
     }
     [DefaultEventAttribute("ItemClicked")]
     [DefaultPropertyAttribute("Items")]
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DesignerSerializerAttribute("System.Windows.Forms.Design.ToolStripCodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.ComponentModel.Design.Serialization.CodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionToolStrip")]
     public class ToolStrip : ScrollableControl, IArrangedElement, IComponent, IDisposable, ISupportToolStripPanel {
-        public override BindingContext BindingContext { get; set; }
+        public override BindingContext? BindingContext { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        public override Cursor Cursor { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [AllowNullAttribute]
+        public override Cursor Cursor { get; set; }
-        public override Font Font { get; set; }
+        [AllowNullAttribute]
+        public override Font Font { get; set; }
-        [BrowsableAttribute(false)]
-        [DefaultValueAttribute(null)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripImageListDescr")]
-        public ImageList ImageList { get; set; }
+        [BrowsableAttribute(false)]
+        [DefaultValueAttribute(null)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripImageListDescr")]
+        public ImageList? ImageList { get; set; }
-        [BrowsableAttribute(false)]
-        [DefaultValueAttribute(null)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        public LayoutSettings LayoutSettings { get; set; }
+        [BrowsableAttribute(false)]
+        [DefaultValueAttribute(null)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        public LayoutSettings? LayoutSettings { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        public ToolStripRenderer Renderer { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [AllowNullAttribute]
+        public ToolStripRenderer Renderer { get; set; }
-        [BrowsableAttribute(true)]
-        [EditorBrowsableAttribute(0)]
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("ControlOnAutoSizeChangedDescr")]
-        public new event EventHandler AutoSizeChanged;
+        [BrowsableAttribute(true)]
+        [EditorBrowsableAttribute(0)]
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("ControlOnAutoSizeChangedDescr")]
+        public new event EventHandler? AutoSizeChanged;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ToolStripOnBeginDrag")]
-        public event EventHandler BeginDrag;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ToolStripOnBeginDrag")]
+        public event EventHandler? BeginDrag;
-        [BrowsableAttribute(false)]
-        public new event EventHandler CausesValidationChanged;
+        [BrowsableAttribute(false)]
+        public new event EventHandler? CausesValidationChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event ControlEventHandler ControlAdded;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event ControlEventHandler? ControlAdded;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event ControlEventHandler ControlRemoved;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event ControlEventHandler? ControlRemoved;
-        [BrowsableAttribute(false)]
-        public new event EventHandler CursorChanged;
+        [BrowsableAttribute(false)]
+        public new event EventHandler? CursorChanged;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ToolStripOnEndDrag")]
-        public event EventHandler EndDrag;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ToolStripOnEndDrag")]
+        public event EventHandler? EndDrag;
-        [BrowsableAttribute(false)]
-        public new event EventHandler ForeColorChanged;
+        [BrowsableAttribute(false)]
+        public new event EventHandler? ForeColorChanged;
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripItemAddedDescr")]
-        public event ToolStripItemEventHandler ItemAdded;
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripItemAddedDescr")]
+        public event ToolStripItemEventHandler? ItemAdded;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("ToolStripItemOnClickDescr")]
-        public event ToolStripItemClickedEventHandler ItemClicked;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("ToolStripItemOnClickDescr")]
+        public event ToolStripItemClickedEventHandler? ItemClicked;
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripItemRemovedDescr")]
-        public event ToolStripItemEventHandler ItemRemoved;
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripItemRemovedDescr")]
+        public event ToolStripItemEventHandler? ItemRemoved;
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripLayoutCompleteDescr")]
-        public event EventHandler LayoutCompleted;
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripLayoutCompleteDescr")]
+        public event EventHandler? LayoutCompleted;
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripLayoutStyleChangedDescr")]
-        public event EventHandler LayoutStyleChanged;
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripLayoutStyleChangedDescr")]
+        public event EventHandler? LayoutStyleChanged;
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripPaintGripDescr")]
-        public event PaintEventHandler PaintGrip;
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripPaintGripDescr")]
+        public event PaintEventHandler? PaintGrip;
-        public event EventHandler RendererChanged;
+        public event EventHandler? RendererChanged;
-        protected internal virtual ToolStripItem CreateDefaultItem(string text, Image image, EventHandler onClick);
+        protected internal virtual ToolStripItem CreateDefaultItem(string? text, Image? image, EventHandler? onClick);
-        protected virtual LayoutSettings CreateLayoutSettings(ToolStripLayoutStyle layoutStyle);
+        protected virtual LayoutSettings? CreateLayoutSettings(ToolStripLayoutStyle layoutStyle);
-        [EditorBrowsableAttribute(1)]
-        public new Control GetChildAtPoint(Point point);
+        [EditorBrowsableAttribute(1)]
+        public new Control? GetChildAtPoint(Point point);
-        [EditorBrowsableAttribute(1)]
-        public new Control GetChildAtPoint(Point pt, GetChildAtPointSkip skipValue);
+        [EditorBrowsableAttribute(1)]
+        public new Control? GetChildAtPoint(Point pt, GetChildAtPointSkip skipValue);
-        public ToolStripItem GetItemAt(Point point);
+        public ToolStripItem? GetItemAt(Point point);
-        public ToolStripItem GetItemAt(int x, int y);
+        public ToolStripItem? GetItemAt(int x, int y);
-        public virtual ToolStripItem GetNextItem(ToolStripItem start, ArrowDirection direction);
+        public virtual ToolStripItem? GetNextItem(ToolStripItem? start, ArrowDirection direction);
     }
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.ToolStrip)]
     public class ToolStripButton : ToolStripItem {
-        public override bool CanSelect { get; }
+        protected internal override bool ProcessDialogKey(Keys keyData);
     }
     [DefaultPropertyAttribute("Items")]
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.ContextMenuStrip | ToolStripItemDesignerAvailability.MenuStrip | ToolStripItemDesignerAvailability.ToolStrip)]
     public class ToolStripComboBox : ToolStripControlHost {
-        public ToolStripComboBox(string name);
+        public ToolStripComboBox(string? name);
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override Image BackgroundImage { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        public override Image? BackgroundImage { get; set; }
-        [BindableAttribute(true)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRDescriptionAttribute("ComboBoxSelectedItemDescr")]
-        public object SelectedItem { get; set; }
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRDescriptionAttribute("ComboBoxSelectedItemDescr")]
+        public object? SelectedItem { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler DoubleClick;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? DoubleClick;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ComboBoxOnDropDownDescr")]
-        public event EventHandler DropDown;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ComboBoxOnDropDownDescr")]
+        public event EventHandler? DropDown;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ComboBoxOnDropDownClosedDescr")]
-        public event EventHandler DropDownClosed;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ComboBoxOnDropDownClosedDescr")]
+        public event EventHandler? DropDownClosed;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ComboBoxDropDownStyleChangedDescr")]
-        public event EventHandler DropDownStyleChanged;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ComboBoxDropDownStyleChangedDescr")]
+        public event EventHandler? DropDownStyleChanged;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("selectedIndexChangedEventDescr")]
-        public event EventHandler SelectedIndexChanged;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("selectedIndexChangedEventDescr")]
+        public event EventHandler? SelectedIndexChanged;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ComboBoxOnTextUpdateDescr")]
-        public event EventHandler TextUpdate;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ComboBoxOnTextUpdateDescr")]
+        public event EventHandler? TextUpdate;
-        public int FindString(string s);
+        public int FindString(string? s);
-        public int FindString(string s, int startIndex);
+        public int FindString(string? s, int startIndex);
-        public int FindStringExact(string s);
+        public int FindStringExact(string? s);
-        public int FindStringExact(string s, int startIndex);
+        public int FindStringExact(string? s, int startIndex);
-        protected override void OnSubscribeControlEvents(Control control);
+        protected override void OnSubscribeControlEvents(Control? control);
-        protected override void OnUnsubscribeControlEvents(Control control);
+        protected override void OnUnsubscribeControlEvents(Control? control);
     }
     public class ToolStripControlHost : ToolStripItem {
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripItemImageDescr")]
-        public override Image BackgroundImage { get; set; }
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripItemImageDescr")]
+        public override Image? BackgroundImage { get; set; }
-        public override Font Font { get; set; }
+        [AllowNullAttribute]
+        public override Font Font { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override Image Image { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        public override Image? Image { get; set; }
-        [EditorBrowsableAttribute(2)]
-        public override ISite Site { get; set; }
+        [EditorBrowsableAttribute(2)]
+        public override ISite? Site { get; set; }
-        [DefaultValueAttribute("")]
-        public override string Text { get; set; }
+        [DefaultValueAttribute("")]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler DisplayStyleChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? DisplayStyleChanged;
-        [SRCategoryAttribute("CatFocus")]
-        [SRDescriptionAttribute("ControlOnEnterDescr")]
-        public event EventHandler Enter;
+        [SRCategoryAttribute("CatFocus")]
+        [SRDescriptionAttribute("ControlOnEnterDescr")]
+        public event EventHandler? Enter;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(2)]
-        [SRCategoryAttribute("CatFocus")]
-        [SRDescriptionAttribute("ToolStripItemOnGotFocusDescr")]
-        public event EventHandler GotFocus;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatFocus")]
+        [SRDescriptionAttribute("ToolStripItemOnGotFocusDescr")]
+        public event EventHandler? GotFocus;
-        [SRCategoryAttribute("CatKey")]
-        [SRDescriptionAttribute("ControlOnKeyDownDescr")]
-        public event KeyEventHandler KeyDown;
+        [SRCategoryAttribute("CatKey")]
+        [SRDescriptionAttribute("ControlOnKeyDownDescr")]
+        public event KeyEventHandler? KeyDown;
-        [SRCategoryAttribute("CatKey")]
-        [SRDescriptionAttribute("ControlOnKeyPressDescr")]
-        public event KeyPressEventHandler KeyPress;
+        [SRCategoryAttribute("CatKey")]
+        [SRDescriptionAttribute("ControlOnKeyPressDescr")]
+        public event KeyPressEventHandler? KeyPress;
-        [SRCategoryAttribute("CatKey")]
-        [SRDescriptionAttribute("ControlOnKeyUpDescr")]
-        public event KeyEventHandler KeyUp;
+        [SRCategoryAttribute("CatKey")]
+        [SRDescriptionAttribute("ControlOnKeyUpDescr")]
+        public event KeyEventHandler? KeyUp;
-        [SRCategoryAttribute("CatFocus")]
-        [SRDescriptionAttribute("ControlOnLeaveDescr")]
-        public event EventHandler Leave;
+        [SRCategoryAttribute("CatFocus")]
+        [SRDescriptionAttribute("ControlOnLeaveDescr")]
+        public event EventHandler? Leave;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(2)]
-        [SRCategoryAttribute("CatFocus")]
-        [SRDescriptionAttribute("ToolStripItemOnLostFocusDescr")]
-        public event EventHandler LostFocus;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatFocus")]
+        [SRDescriptionAttribute("ToolStripItemOnLostFocusDescr")]
+        public event EventHandler? LostFocus;
-        [SRCategoryAttribute("CatFocus")]
-        [SRDescriptionAttribute("ControlOnValidatedDescr")]
-        public event EventHandler Validated;
+        [SRCategoryAttribute("CatFocus")]
+        [SRDescriptionAttribute("ControlOnValidatedDescr")]
+        public event EventHandler? Validated;
-        [SRCategoryAttribute("CatFocus")]
-        [SRDescriptionAttribute("ControlOnValidatingDescr")]
-        public event CancelEventHandler Validating;
+        [SRCategoryAttribute("CatFocus")]
+        [SRDescriptionAttribute("ControlOnValidatingDescr")]
+        public event CancelEventHandler? Validating;
-        protected override void OnParentChanged(ToolStrip oldParent, ToolStrip newParent);
+        protected override void OnParentChanged(ToolStrip? oldParent, ToolStrip? newParent);
-        protected virtual void OnSubscribeControlEvents(Control control);
+        protected virtual void OnSubscribeControlEvents(Control? control);
-        protected virtual void OnUnsubscribeControlEvents(Control control);
+        protected virtual void OnUnsubscribeControlEvents(Control? control);
     }
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripDropDownDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public class ToolStripDropDown : ToolStrip {
-        public override Font Font { get; set; }
+        [AllowNullAttribute]
+        public override Font Font { get; set; }
     }
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.StatusStrip | ToolStripItemDesignerAvailability.ToolStrip)]
     public class ToolStripDropDownButton : ToolStripDropDownItem {
-        public ToolStripDropDownButton(Image image);
+        public ToolStripDropDownButton(Image? image);
-        public ToolStripDropDownButton(string text);
+        public ToolStripDropDownButton(string? text);
-        public ToolStripDropDownButton(string text, Image image);
+        public ToolStripDropDownButton(string? text, Image? image);
-        public ToolStripDropDownButton(string text, Image image, EventHandler onClick);
+        public ToolStripDropDownButton(string? text, Image? image, EventHandler? onClick);
-        public ToolStripDropDownButton(string text, Image image, EventHandler onClick, string name);
+        public ToolStripDropDownButton(string? text, Image? image, EventHandler? onClick, string? name);
-        public ToolStripDropDownButton(string text, Image image, params ToolStripItem[] dropDownItems);
+        public ToolStripDropDownButton(string? text, Image? image, params ToolStripItem[]? dropDownItems);
     }
     [DefaultPropertyAttribute("DropDownItems")]
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripMenuItemDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public abstract class ToolStripDropDownItem : ToolStripItem {
-        protected ToolStripDropDownItem(string text, Image image, EventHandler onClick);
+        protected ToolStripDropDownItem(string? text, Image? image, EventHandler? onClick);
-        protected ToolStripDropDownItem(string text, Image image, EventHandler onClick, string name);
+        protected ToolStripDropDownItem(string? text, Image? image, EventHandler? onClick, string? name);
-        protected ToolStripDropDownItem(string text, Image image, params ToolStripItem[] dropDownItems);
+        protected ToolStripDropDownItem(string? text, Image? image, params ToolStripItem[]? dropDownItems);
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ToolStripDropDownDescr")]
-        [TypeConverterAttribute(typeof(ReferenceConverter))]
-        public ToolStripDropDown DropDown { get; set; }
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ToolStripDropDownDescr")]
+        [TypeConverterAttribute(typeof(ReferenceConverter))]
+        [AllowNullAttribute]
+        public ToolStripDropDown DropDown { get; set; }
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("ToolStripDropDownClosedDecr")]
-        public event EventHandler DropDownClosed;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("ToolStripDropDownClosedDecr")]
+        public event EventHandler? DropDownClosed;
-        [SRCategoryAttribute("CatAction")]
-        public event ToolStripItemClickedEventHandler DropDownItemClicked;
+        [SRCategoryAttribute("CatAction")]
+        public event ToolStripItemClickedEventHandler? DropDownItemClicked;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("ToolStripDropDownOpenedDescr")]
-        public event EventHandler DropDownOpened;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("ToolStripDropDownOpenedDescr")]
+        public event EventHandler? DropDownOpened;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("ToolStripDropDownOpeningDescr")]
-        public event EventHandler DropDownOpening;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("ToolStripDropDownOpeningDescr")]
+        public event EventHandler? DropDownOpening;
     }
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripDropDownDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public class ToolStripDropDownMenu : ToolStripDropDown {
-        protected internal override ToolStripItem CreateDefaultItem(string text, Image image, EventHandler onClick);
+        protected internal override ToolStripItem CreateDefaultItem(string? text, Image? image, EventHandler? onClick);
     }
     [DefaultEventAttribute("Click")]
     [DefaultPropertyAttribute("Text")]
     [DesignTimeVisibleAttribute(false)]
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripItemDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [ToolboxItemAttribute(false)]
     public abstract class ToolStripItem : BindableComponent, IArrangedElement, ICommandBindingTargetProvider, IComponent, IDisposable, IDropTarget, IKeyboardToolTip, ISupportOleDropSource {
-        [BindableAttribute(true)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [RequiresPreviewFeaturesAttribute]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandComponentCommandDescr")]
-        public ICommand Command { get; set; }
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandComponentCommandDescr")]
+        public ICommand Command { get; set; }
-        [BindableAttribute(true)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandComponentCommandParameterDescr")]
-        public object CommandParameter { [RequiresPreviewFeaturesAttribute] get; [RequiresPreviewFeaturesAttribute] set; }
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandComponentCommandParameterDescr")]
+        public object CommandParameter { get; set; }
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripItemFontDescr")]
-        public virtual Font Font { get; set; }
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripItemFontDescr")]
+        [AllowNullAttribute]
+        public virtual Font Font { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorAttribute("System.Windows.Forms.Design.ToolStripImageIndexEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [LocalizableAttribute(true)]
-        [RefreshPropertiesAttribute(2)]
-        [RelatedImageListAttribute("Owner.ImageList")]
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ToolStripItemImageKeyDescr")]
-        [TypeConverterAttribute(typeof(ImageKeyConverter))]
-        public string ImageKey { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorAttribute("System.Windows.Forms.Design.ToolStripImageIndexEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [LocalizableAttribute(true)]
+        [RefreshPropertiesAttribute(2)]
+        [RelatedImageListAttribute("Owner.ImageList")]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ToolStripItemImageKeyDescr")]
+        [TypeConverterAttribute(typeof(ImageKeyConverter))]
+        [AllowNullAttribute]
+        public string ImageKey { get; set; }
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandCanExecuteChangedEventDescr")]
-        public event EventHandler CommandCanExecuteChanged;
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandCanExecuteChangedEventDescr")]
+        public event EventHandler CommandCanExecuteChanged;
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandChangedEventDescr")]
-        public event EventHandler CommandChanged;
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandChangedEventDescr")]
+        public event EventHandler CommandChanged;
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("CommandParameterChangedEventDescr")]
-        public event EventHandler CommandParameterChanged;
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("CommandParameterChangedEventDescr")]
+        public event EventHandler CommandParameterChanged;
-        [EditorBrowsableAttribute(2)]
-        public DragDropEffects DoDragDrop(object data, DragDropEffects allowedEffects, Bitmap dragImage, Point cursorOffset, bool useDefaultDragImage);
+        [EditorBrowsableAttribute(2)]
+        public DragDropEffects DoDragDrop(object data, DragDropEffects allowedEffects, Bitmap? dragImage, Point cursorOffset, bool useDefaultDragImage);
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        protected virtual void OnCommandCanExecuteChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnCommandCanExecuteChanged(EventArgs e);
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        protected virtual void OnCommandChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnCommandChanged(EventArgs e);
-        [EditorBrowsableAttribute(2)]
-        [RequiresPreviewFeaturesAttribute]
-        protected virtual void OnCommandParameterChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnCommandParameterChanged(EventArgs e);
-        [RequiresPreviewFeaturesAttribute]
-        protected virtual void OnRequestCommandExecute(EventArgs e);
+        protected virtual void OnRequestCommandExecute(EventArgs e);
     }
     [EditorAttribute("System.Windows.Forms.Design.ToolStripCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
     [ListBindableAttribute(false)]
     public class ToolStripItemCollection : ArrangedElementCollection, ICollection, IEnumerable, IList {
-        bool System.Collections.IList.IsFixedSize { get; }
+        bool IList.IsFixedSize { get; }
-        object System.Collections.IList.this[int index] { get; set; }
+        object? IList.this[int index] { get; set; }
-        public virtual ToolStripItem this[string key] { get; }
+        public virtual ToolStripItem? this[string? key] { get; }
-        public ToolStripItem Add(Image image);
+        public ToolStripItem Add(Image? image);
-        public ToolStripItem Add(string text);
+        public ToolStripItem Add(string? text);
-        public ToolStripItem Add(string text, Image image);
+        public ToolStripItem Add(string? text, Image? image);
-        public ToolStripItem Add(string text, Image image, EventHandler onClick);
+        public ToolStripItem Add(string? text, Image? image, EventHandler? onClick);
-        public virtual bool ContainsKey(string key);
+        public virtual bool ContainsKey(string? key);
-        public virtual int IndexOfKey(string key);
+        public virtual int IndexOfKey(string? key);
-        public virtual void RemoveByKey(string key);
+        public virtual void RemoveByKey(string? key);
-        int IList.Add(object value);
+        int IList.Add(object? value);
-        bool IList.Contains(object value);
+        bool IList.Contains(object? value);
-        int IList.IndexOf(object value);
+        int IList.IndexOf(object? value);
-        void IList.Insert(int index, object value);
+        void IList.Insert(int index, object? value);
-        void IList.Remove(object value);
+        void IList.Remove(object? value);
     }
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.ToolStrip)]
     public class ToolStripLabel : ToolStripItem {
-        public ToolStripLabel(Image image);
+        public ToolStripLabel(Image? image);
-        public ToolStripLabel(string text);
+        public ToolStripLabel(string? text);
-        public ToolStripLabel(string text, Image image);
+        public ToolStripLabel(string? text, Image? image);
-        public ToolStripLabel(string text, Image image, bool isLink);
+        public ToolStripLabel(string? text, Image? image, bool isLink);
-        public ToolStripLabel(string text, Image image, bool isLink, EventHandler onClick);
+        public ToolStripLabel(string? text, Image? image, bool isLink, EventHandler? onClick);
-        public ToolStripLabel(string text, Image image, bool isLink, EventHandler onClick, string name);
+        public ToolStripLabel(string? text, Image? image, bool isLink, EventHandler? onClick, string? name);
     }
     public static class ToolStripManager {
-        public static ToolStripRenderer Renderer { get; set; }
+        [AllowNullAttribute]
+        public static ToolStripRenderer Renderer { get; set; }
-        public static event EventHandler RendererChanged;
+        public static event EventHandler? RendererChanged;
-        public static ToolStrip FindToolStrip(string toolStripName);
+        public static ToolStrip? FindToolStrip(string toolStripName);
     }
     [DesignerSerializerAttribute("System.Windows.Forms.Design.ToolStripMenuItemCodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.ComponentModel.Design.Serialization.CodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.ContextMenuStrip | ToolStripItemDesignerAvailability.MenuStrip)]
     public class ToolStripMenuItem : ToolStripDropDownItem {
-        public ToolStripMenuItem(Image image);
+        public ToolStripMenuItem(Image? image);
-        public ToolStripMenuItem(string text);
+        public ToolStripMenuItem(string? text);
-        public ToolStripMenuItem(string text, Image image);
+        public ToolStripMenuItem(string? text, Image? image);
-        public ToolStripMenuItem(string text, Image image, EventHandler onClick);
+        public ToolStripMenuItem(string? text, Image? image, EventHandler? onClick);
-        public ToolStripMenuItem(string text, Image image, EventHandler onClick, string name);
+        public ToolStripMenuItem(string? text, Image? image, EventHandler? onClick, string? name);
-        public ToolStripMenuItem(string text, Image image, EventHandler onClick, Keys shortcutKeys);
+        public ToolStripMenuItem(string? text, Image? image, EventHandler? onClick, Keys shortcutKeys);
-        public ToolStripMenuItem(string text, Image image, params ToolStripItem[] dropDownItems);
+        public ToolStripMenuItem(string? text, Image? image, params ToolStripItem[]? dropDownItems);
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripMenuItemShortcutKeyDisplayStringDescr")]
-        public string ShortcutKeyDisplayString { get; set; }
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripMenuItemShortcutKeyDisplayStringDescr")]
+        public string? ShortcutKeyDisplayString { get; set; }
-        [SRDescriptionAttribute("CheckBoxOnCheckedChangedDescr")]
-        public event EventHandler CheckedChanged;
+        [SRDescriptionAttribute("CheckBoxOnCheckedChangedDescr")]
+        public event EventHandler? CheckedChanged;
-        [SRDescriptionAttribute("CheckBoxOnCheckStateChangedDescr")]
-        public event EventHandler CheckStateChanged;
+        [SRDescriptionAttribute("CheckBoxOnCheckStateChangedDescr")]
+        public event EventHandler? CheckStateChanged;
     }
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripPanelDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [ToolboxBitmapAttribute(typeof(ToolStripPanel), "ToolStripPanel_standalone")]
     public class ToolStripPanel : ContainerControl, IArrangedElement, IComponent, IDisposable {
         [ListBindableAttribute(false)]
         public class ToolStripPanelRowCollection : ArrangedElementCollection, ICollection, IEnumerable, IList {
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            bool System.Collections.IList.IsReadOnly { get; }
+            bool IList.IsReadOnly { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object? IList.this[int index] { get; set; }
-            int IList.Add(object value);
+            int IList.Add(object? value);
-            bool IList.Contains(object value);
+            bool IList.Contains(object? value);
-            int IList.IndexOf(object value);
+            int IList.IndexOf(object? value);
-            void IList.Insert(int index, object value);
+            void IList.Insert(int index, object? value);
-            void IList.Remove(object value);
+            void IList.Remove(object? value);
         }
     }
     [DefaultPropertyAttribute("Value")]
     public class ToolStripProgressBar : ToolStripControlHost {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
     }
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.ContextMenuStrip | ToolStripItemDesignerAvailability.ToolStrip)]
     public class ToolStripSeparator : ToolStripItem {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override Font Font { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override Font Font { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public new string ImageKey { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public new string ImageKey { get; set; }
     }
     [DefaultEventAttribute("ButtonClick")]
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.StatusStrip | ToolStripItemDesignerAvailability.ToolStrip)]
     public class ToolStripSplitButton : ToolStripDropDownItem {
-        public ToolStripSplitButton(Image image);
+        public ToolStripSplitButton(Image? image);
-        public ToolStripSplitButton(string text);
+        public ToolStripSplitButton(string? text);
-        public ToolStripSplitButton(string text, Image image);
+        public ToolStripSplitButton(string? text, Image? image);
-        public ToolStripSplitButton(string text, Image image, EventHandler onClick);
+        public ToolStripSplitButton(string? text, Image? image, EventHandler? onClick);
-        public ToolStripSplitButton(string text, Image image, EventHandler onClick, string name);
+        public ToolStripSplitButton(string? text, Image? image, EventHandler? onClick, string? name);
-        public ToolStripSplitButton(string text, Image image, params ToolStripItem[] dropDownItems);
+        public ToolStripSplitButton(string? text, Image? image, params ToolStripItem[]? dropDownItems);
-        [BrowsableAttribute(false)]
-        [DefaultValueAttribute(null)]
-        public ToolStripItem DefaultItem { get; set; }
+        [BrowsableAttribute(false)]
+        [DefaultValueAttribute(null)]
+        public ToolStripItem? DefaultItem { get; set; }
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("ToolStripSplitButtonOnButtonClickDescr")]
-        public event EventHandler ButtonClick;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("ToolStripSplitButtonOnButtonClickDescr")]
+        public event EventHandler? ButtonClick;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("ToolStripSplitButtonOnButtonDoubleClickDescr")]
-        public event EventHandler ButtonDoubleClick;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("ToolStripSplitButtonOnButtonDoubleClickDescr")]
+        public event EventHandler? ButtonDoubleClick;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("ToolStripSplitButtonOnDefaultItemChangedDescr")]
-        public event EventHandler DefaultItemChanged;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("ToolStripSplitButtonOnDefaultItemChangedDescr")]
+        public event EventHandler? DefaultItemChanged;
     }
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.StatusStrip)]
     public class ToolStripStatusLabel : ToolStripLabel, IAutomationLiveRegion {
-        public ToolStripStatusLabel(Image image);
+        public ToolStripStatusLabel(Image? image);
-        public ToolStripStatusLabel(string text);
+        public ToolStripStatusLabel(string? text);
-        public ToolStripStatusLabel(string text, Image image);
+        public ToolStripStatusLabel(string? text, Image? image);
-        public ToolStripStatusLabel(string text, Image image, EventHandler onClick);
+        public ToolStripStatusLabel(string? text, Image? image, EventHandler? onClick);
-        public ToolStripStatusLabel(string text, Image image, EventHandler onClick, string name);
+        public ToolStripStatusLabel(string? text, Image? image, EventHandler? onClick, string? name);
     }
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.ContextMenuStrip | ToolStripItemDesignerAvailability.MenuStrip | ToolStripItemDesignerAvailability.ToolStrip)]
     public class ToolStripTextBox : ToolStripControlHost {
-        public ToolStripTextBox(string name);
+        public ToolStripTextBox(string? name);
-        [BrowsableAttribute(true)]
-        [DesignerSerializationVisibilityAttribute(2)]
-        [EditorAttribute("System.Windows.Forms.Design.ListControlStringCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [EditorBrowsableAttribute(0)]
-        [LocalizableAttribute(true)]
-        [SRDescriptionAttribute("TextBoxAutoCompleteCustomSourceDescr")]
-        public AutoCompleteStringCollection AutoCompleteCustomSource { get; set; }
+        [BrowsableAttribute(true)]
+        [DesignerSerializationVisibilityAttribute(2)]
+        [EditorAttribute("System.Windows.Forms.Design.ListControlStringCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [EditorBrowsableAttribute(0)]
+        [LocalizableAttribute(true)]
+        [SRDescriptionAttribute("TextBoxAutoCompleteCustomSourceDescr")]
+        [AllowNullAttribute]
+        public AutoCompleteStringCollection AutoCompleteCustomSource { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override Image BackgroundImage { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        public override Image? BackgroundImage { get; set; }
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorAttribute("System.Windows.Forms.Design.StringArrayEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("TextBoxLinesDescr")]
-        public string[] Lines { get; set; }
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorAttribute("System.Windows.Forms.Design.StringArrayEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("TextBoxLinesDescr")]
+        [AllowNullAttribute]
+        public string[] Lines { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("TextBoxSelectedTextDescr")]
-        public string SelectedText { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("TextBoxSelectedTextDescr")]
+        [AllowNullAttribute]
+        public string SelectedText { get; set; }
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("TextBoxBaseOnAcceptsTabChangedDescr")]
-        public event EventHandler AcceptsTabChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("TextBoxBaseOnAcceptsTabChangedDescr")]
+        public event EventHandler? AcceptsTabChanged;
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("TextBoxBaseOnBorderStyleChangedDescr")]
-        public event EventHandler BorderStyleChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("TextBoxBaseOnBorderStyleChangedDescr")]
+        public event EventHandler? BorderStyleChanged;
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("TextBoxBaseOnHideSelectionChangedDescr")]
-        public event EventHandler HideSelectionChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("TextBoxBaseOnHideSelectionChangedDescr")]
+        public event EventHandler? HideSelectionChanged;
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("TextBoxBaseOnModifiedChangedDescr")]
-        public event EventHandler ModifiedChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("TextBoxBaseOnModifiedChangedDescr")]
+        public event EventHandler? ModifiedChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("TextBoxBaseOnMultilineChangedDescr")]
-        public event EventHandler MultilineChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("TextBoxBaseOnMultilineChangedDescr")]
+        public event EventHandler? MultilineChanged;
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("TextBoxBaseOnReadOnlyChangedDescr")]
-        public event EventHandler ReadOnlyChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("TextBoxBaseOnReadOnlyChangedDescr")]
+        public event EventHandler? ReadOnlyChanged;
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("ToolStripTextBoxTextBoxTextAlignChangedDescr")]
-        public event EventHandler TextBoxTextAlignChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("ToolStripTextBoxTextBoxTextAlignChangedDescr")]
+        public event EventHandler? TextBoxTextAlignChanged;
-        public void AppendText(string text);
+        public void AppendText(string? text);
-        protected override void OnSubscribeControlEvents(Control control);
+        protected override void OnSubscribeControlEvents(Control? control);
-        protected override void OnUnsubscribeControlEvents(Control control);
+        protected override void OnUnsubscribeControlEvents(Control? control);
     }
     [DefaultEventAttribute("Popup")]
     [ProvidePropertyAttribute("ToolTip", typeof(Control))]
     [SRDescriptionAttribute("DescriptionToolTip")]
     [ToolboxItemFilterAttribute("System.Windows.Forms")]
     public class ToolTip : Component, IExtenderProvider, IHandle {
-        [BindableAttribute(true)]
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(false)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ControlTagDescr")]
-        [TypeConverterAttribute(typeof(StringConverter))]
-        public object Tag { get; set; }
+        [BindableAttribute(true)]
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(false)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ControlTagDescr")]
+        [TypeConverterAttribute(typeof(StringConverter))]
+        public object? Tag { get; set; }
-        [DefaultValueAttribute("")]
-        [SRDescriptionAttribute("ToolTipTitleDescr")]
-        public string ToolTipTitle { get; set; }
+        [DefaultValueAttribute("")]
+        [SRDescriptionAttribute("ToolTipTitleDescr")]
+        [AllowNullAttribute]
+        public string ToolTipTitle { get; set; }
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ToolTipDrawEventDescr")]
-        public event DrawToolTipEventHandler Draw;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ToolTipDrawEventDescr")]
+        public event DrawToolTipEventHandler? Draw;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ToolTipPopupEventDescr")]
-        public event PopupEventHandler Popup;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ToolTipPopupEventDescr")]
+        public event PopupEventHandler? Popup;
-        [DefaultValueAttribute("")]
-        [EditorAttribute("System.ComponentModel.Design.MultilineStringEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [LocalizableAttribute(true)]
-        [SRDescriptionAttribute("ToolTipToolTipDescr")]
-        public string GetToolTip(Control control);
+        [DefaultValueAttribute("")]
+        [EditorAttribute("System.ComponentModel.Design.MultilineStringEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [LocalizableAttribute(true)]
+        [SRDescriptionAttribute("ToolTipToolTipDescr")]
+        public string? GetToolTip(Control? control);
-        public void SetToolTip(Control control, string caption);
+        public void SetToolTip(Control control, string? caption);
-        public void Show(string text, IWin32Window window);
+        public void Show(string? text, IWin32Window window);
-        public void Show(string text, IWin32Window window, Point point);
+        public void Show(string? text, IWin32Window window, Point point);
-        public void Show(string text, IWin32Window window, Point point, int duration);
+        public void Show(string? text, IWin32Window window, Point point, int duration);
-        public void Show(string text, IWin32Window window, int duration);
+        public void Show(string? text, IWin32Window window, int duration);
-        public void Show(string text, IWin32Window window, int x, int y);
+        public void Show(string? text, IWin32Window window, int x, int y);
-        public void Show(string text, IWin32Window window, int x, int y, int duration);
+        public void Show(string? text, IWin32Window window, int x, int y, int duration);
     }
     [EditorAttribute("System.Windows.Forms.Design.TreeNodeCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
     public class TreeNodeCollection : ICollection, IEnumerable, IList {
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
-        bool System.Collections.IList.IsFixedSize { get; }
+        bool IList.IsFixedSize { get; }
-        object System.Collections.IList.this[int index] { get; set; }
+        object IList.this[int index] { get; set; }
-        public virtual TreeNode Add(string text);
+        public virtual TreeNode Add(string? text);
-        public virtual TreeNode Insert(int index, string text);
+        public virtual TreeNode Insert(int index, string? text);
     }
     [DefaultEventAttribute("DocumentCompleted")]
     [DefaultPropertyAttribute("Url")]
     [DesignerAttribute("System.Windows.Forms.Design.WebBrowserDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DockingAttribute(DockingBehavior.AutoDock)]
     [SRDescriptionAttribute("DescriptionWebBrowser")]
     public class WebBrowser : WebBrowserBase {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        public string DocumentText { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [AllowNullAttribute]
+        public string DocumentText { get; set; }
-        public void Navigate(string urlString, string targetFrameName);
+        public void Navigate(string urlString, string? targetFrameName);
     }
     [DefaultEventAttribute("Enter")]
     [DefaultPropertyAttribute("Name")]
     [DesignerAttribute("System.Windows.Forms.Design.AxDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public class WebBrowserBase : Control {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override Cursor Cursor { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override Cursor Cursor { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override Font Font { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override Font Font { get; set; }
-        [BindableAttribute(false)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BindableAttribute(false)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
     }
-    public class WebBrowserSiteBase : IDisposable, Interop.Ole32.IOleClientSite, Interop.Ole32.IOleControlSite, Interop.Ole32.IOleInPlaceSite, Interop.Ole32.IPropertyNotifySink, Interop.Ole32.ISimpleFrameSite
+    public class WebBrowserSiteBase : IDisposable, IOleClientSite.Interface, IOleControlSite.Interface, IOleInPlaceSite.Interface, IOleWindow.Interface, IPropertyNotifySink.Interface, ISimpleFrameSite.Interface
     public sealed class WindowsFormsSynchronizationContext : SynchronizationContext, IDisposable {
-        public override void Post(SendOrPostCallback d, object state);
+        public override void Post(SendOrPostCallback d, object? state);
-        public override void Send(SendOrPostCallback d, object state);
+        public override void Send(SendOrPostCallback d, object? state);
     }
 }
```

