# .NET 8.0.1  - January 09, 2024

The .NET 8.0.1 and .NET SDK 8.0.101 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.101
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/monitor/base](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor-base.md): .NET Monitor Base
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 8.0 Blog][dotnet-blog]

.NET 8.0.1 release carries security and non-security fixes.

[CVE-2024-0056 - Microsoft.Data.SqlClient and System.Data.SqlClient SQL Data provider Information Disclosure Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-0056)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET's System.Data.SqlClient and Microsoft.Data.SqlClient NuGet Packages. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A vulnerability exists in the Microsoft.Data.SqlClient and System.Data.SqlClient SQL Data provider where an attackercan perform an AiTM (adversary-in-the-middle) attack between the SQL client and the SQL server. This may allow the attacker to steal authentication credentials intended for the database server, even if the connection is established over an encrypted channel like TLS.

[CVE-2024-0057- .NET Security Feature bypass Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36049)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 7.0 and .NET 8.0 . This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A security feature bypass vulnerability exists when Microsoft .NET Framework-based applications use X.509 chain building APIs but do not completely validate the X.509 certificate due to a logic flaw. An attacker could present an arbitrary untrusted certificate with malformed signatures, triggering a bug in the framework. The framework will correctly report that X.509 chain building failed, but it will return an incorrect reason code for the failure. Applications which utilize this reason code to make their own chain building trust decisions may inadvertently treat this scenario as a successful chain build. This could allow an adversary to subvert the app's typical authentication logic.

[CVE-2024-21319 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-21319)

Microsoft is releasing this security advisory to provide information about a vulnerability in the ASP.NET Core project templates. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A Denial of Service vulnerability exists in ASP.NET Core project templates which utilize JWT-based authentication tokens. This vulnerability allows an unauthenticated client to consume arbitrarily large amounts of server memory, potentially triggering an out-of-memory condition on the server and making the server no longer able to respond to legitimate requests.

## Visual Studio Compatibility

You need [Visual Studio 17.8](https://visualstudio.microsoft.com) or later to use .NET 8.0 on Windows. While not officially supported, we’ve also enabled rudimentary support for .NET 8 in Visual Studio for Mac. Users have to enable a preview feature in Preferences to enable the IDE to discover and use the .NET 8 SDK for creating, loading, building, and debugging projects. The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 8.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9052](https://github.com/dotnet/core/issues/9052) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.1.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.1-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.1-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-8/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-dotnet-8/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.1+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.1+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.1+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.1+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.1xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 8.0.1
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 8.0.1
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 8.0.1
Microsoft.Windows.Compatibility | 8.0.1
Microsoft.WindowsDesktop.App.Ref | 8.0.1
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 8.0.1
Microsoft.NET.Runtime.Android.Sample.Mono | 8.0.1
Microsoft.NET.Runtime.iOS.Sample.Mono | 8.0.1
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 8.0.1
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 8.0.1
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 8.0.1
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 8.0.1
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x64 | 8.0.1
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Crossgen2.win-arm64 | 8.0.1
Microsoft.NETCore.App.Crossgen2.osx-x64 | 8.0.1
Microsoft.NETCore.App.Host.linux-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.linux-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.linux-musl-arm | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 8.0.1
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.linux-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 8.0.1
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.win-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.win-x86 | 8.0.1
Microsoft.NETCore.DotNetAppHost | 8.0.1
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 8.0.1
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.1
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.1
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 8.0.1
Microsoft.Extensions.Configuration.Binder | 8.0.1
Microsoft.Bcl.TimeProvider | 8.0.1
Microsoft.Extensions.Options | 8.0.1
Microsoft.NET.Runtime.MonoTargets.Sdk | 8.0.1
Microsoft.NET.Runtime.wasm.Sample.Mono | 8.0.1
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 8.0.1
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 8.0.1
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 8.0.1
Microsoft.NET.Runtime.WebAssembly.Templates | 8.0.1
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 8.0.1
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 8.0.1
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.arm64 | 8.0.1
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 8.0.1
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Host.linux-musl-arm | 8.0.1
Microsoft.NETCore.App.Host.linux-x64 | 8.0.1
Microsoft.NETCore.App.Host.osx-x64 | 8.0.1
Microsoft.NETCore.App.Host.win-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm | 8.0.1
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 8.0.1
Microsoft.NETCore.DotNetHost | 8.0.1
Microsoft.NETCore.DotNetHostResolver | 8.0.1
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 8.0.1
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 8.0.1
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.1
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 8.0.1
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.1
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 8.0.1
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 8.0.1
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.1
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.1
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 8.0.1
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.1
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.1
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 8.0.1
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 8.0.1
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.1
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 8.0.1
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 8.0.1
System.Text.Json | 8.0.1
Microsoft.NET.Runtime.LibraryBuilder.Sdk | 8.0.1
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 8.0.1
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 8.0.1
Microsoft.NET.Sdk.WebAssembly.Pack | 8.0.1
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x86 | 8.0.1
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100 | 8.0.1
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100 | 8.0.1
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 8.0.1
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 8.0.1
Microsoft.NETCore.App.Host.linux-arm | 8.0.1
Microsoft.NETCore.App.Host.win-x86 | 8.0.1
Microsoft.NETCore.App.Ref | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x86 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-arm | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.NativeAOT.ios-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.NativeAOT.osx-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.osx-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 8.0.1
Microsoft.NETCore.DotNetHostPolicy | 8.0.1
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.1
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 8.0.1
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.1
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 8.0.1
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.1
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.1
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.1
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 8.0.1
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 8.0.1
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 8.0.1
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.1
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.1
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.1
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x64 | 8.0.1
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100 | 8.0.1
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.arm64 | 8.0.1
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Crossgen2.win-x64 | 8.0.1
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 8.0.1
Microsoft.NETCore.App.Host.linux-bionic-x64 | 8.0.1
Microsoft.NETCore.App.Host.linux-musl-arm64 | 8.0.1
Microsoft.NETCore.App.Host.linux-musl-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm64 | 8.0.1
Microsoft.NETCore.App.Host.win-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.browser-wasm | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x86 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.browser-wasm | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.linux-arm | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.NativeAOT.osx-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.win-arm64 | 8.0.1
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.1
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvos-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Runtime.NativeAOT.tvos-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.osx-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 8.0.1
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.1
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 8.0.1
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.1
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.1
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 8.0.1
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.1
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.1
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 8.0.1
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 8.0.1
runtime.osx-arm64.Microsoft.DotNet.ILCompiler | 8.0.1
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.1
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 8.0.1
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 8.0.1
runtime.win-x86.Microsoft.NETCore.DotNetHost | 8.0.1
Microsoft.DotNet.ILCompiler | 8.0.1
Microsoft.NET.ILLink.Tasks | 8.0.1
Microsoft.NET.Runtime.WebAssembly.Sdk | 8.0.1
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Crossgen2.linux-arm | 8.0.1
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk | 8.0.1
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x64 | 8.0.1
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x64 | 8.0.1
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.arm64 | 8.0.1
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Crossgen2.win-x86 | 8.0.1
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 8.0.1
Microsoft.NETCore.App.Crossgen2.linux-x64 | 8.0.1
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 8.0.1
Microsoft.NETCore.App.Host.osx-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.ios-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 8.0.1
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 8.0.1
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 8.0.1
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 8.0.1
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 8.0.1
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.1
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 8.0.1
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 8.0.1
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.1
runtime.win-x64.Microsoft.DotNet.ILCompiler | 8.0.1
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.1
runtime.win-x64.Microsoft.NETCore.DotNetHost | 8.0.1
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.1
Microsoft.AspNetCore.Authentication.Certificate | 8.0.1
Microsoft.AspNetCore.Authentication.Facebook | 8.0.1
Microsoft.AspNetCore.Authentication.Google | 8.0.1
Microsoft.AspNetCore.Connections.Abstractions | 8.0.1
Microsoft.AspNetCore.DataProtection | 8.0.1
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 8.0.1
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 8.0.1
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 8.0.1
Microsoft.AspNetCore.SignalR.Client.Core | 8.0.1
Microsoft.AspNetCore.SignalR.Client | 8.0.1
Microsoft.AspNetCore.SignalR.Protocols.Json | 8.0.1
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 8.0.1
Microsoft.Extensions.Caching.SqlServer | 8.0.1
Microsoft.Extensions.Caching.StackExchangeRedis | 8.0.1
Microsoft.Extensions.Diagnostics.HealthChecks | 8.0.1
Microsoft.Extensions.Configuration.KeyPerFile | 8.0.1
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 8.0.1
Microsoft.Extensions.Identity.Stores | 8.0.1
Microsoft.Extensions.Localization | 8.0.1
Microsoft.Extensions.Localization.Abstractions | 8.0.1
Microsoft.AspNetCore.App.Runtime.linux-arm | 8.0.1
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 8.0.1
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 8.0.1
Microsoft.AspNetCore.App.Runtime.win-x86 | 8.0.1
Microsoft.AspNetCore.App.Runtime.win-x64 | 8.0.1
Microsoft.AspNetCore.Authentication.JwtBearer | 8.0.1
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 8.0.1
Microsoft.AspNetCore.Authentication.OpenIdConnect | 8.0.1
Microsoft.AspNetCore.Authentication.Negotiate | 8.0.1
Microsoft.AspNetCore.Authentication.Twitter | 8.0.1
Microsoft.AspNetCore.Authorization | 8.0.1
Microsoft.AspNetCore.Authentication.WsFederation | 8.0.1
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 8.0.1
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 8.0.1
Microsoft.AspNetCore.Components | 8.0.1
Microsoft.AspNetCore.Components.WebView | 8.0.1
Microsoft.AspNetCore.Http.Connections.Common | 8.0.1
Microsoft.AspNetCore.JsonPatch | 8.0.1
Microsoft.AspNetCore.Metadata | 8.0.1
Microsoft.AspNetCore.SignalR.Common | 8.0.1
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 8.0.1
Microsoft.AspNetCore.SpaProxy | 8.0.1
Microsoft.DotNet.Web.ItemTemplates.8.0 | 8.0.1
Microsoft.Extensions.ApiDescription.Server | 8.0.1
Microsoft.Extensions.ApiDescription.Client | 8.0.1
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 8.0.1
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 8.0.1
Microsoft.AspNetCore.App.Runtime.linux-x64 | 8.0.1
dotnet-sql-cache | 8.0.1
Microsoft.AspNetCore.Components.WebAssembly.Server | 8.0.1
Microsoft.AspNetCore.Grpc.Swagger | 0.8.1
Microsoft.AspNetCore.Hosting.WindowsServices | 8.0.1
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 8.0.1
AspNetCoreRuntime.8.0.x64 | 8.0.1
Microsoft.AspNetCore.App.Runtime.win-arm64 | 8.0.1
Microsoft.AspNetCore.App.Ref | 8.0.1
Microsoft.AspNetCore.Components.Analyzers | 8.0.1
Microsoft.AspNetCore.Components.Authorization | 8.0.1
Microsoft.AspNetCore.Components.CustomElements | 8.0.1
Microsoft.AspNetCore.Components.QuickGrid | 8.0.1
Microsoft.AspNetCore.Components.Forms | 8.0.1
Microsoft.AspNetCore.Components.QuickGrid.EntityFrameworkAdapter | 8.0.1
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 8.0.1
Microsoft.AspNetCore.Components.Web | 8.0.1
Microsoft.AspNetCore.Components.WebAssembly | 8.0.1
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 8.0.1
Microsoft.AspNetCore.Cryptography.Internal | 8.0.1
Microsoft.AspNetCore.ConcurrencyLimiter | 8.0.1
Microsoft.AspNetCore.Cryptography.KeyDerivation | 8.0.1
Microsoft.AspNetCore.DataProtection.Abstractions | 8.0.1
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 8.0.1
Microsoft.AspNetCore.DataProtection.Extensions | 8.0.1
Microsoft.AspNetCore.Grpc.JsonTranscoding | 8.0.1
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 8.0.1
Microsoft.AspNetCore.Http.Connections.Client | 8.0.1
Microsoft.AspNetCore.Identity.UI | 8.0.1
Microsoft.AspNetCore.HeaderPropagation | 8.0.1
Microsoft.AspNetCore.MiddlewareAnalysis | 8.0.1
Microsoft.AspNetCore.Mvc.Testing | 8.0.1
Microsoft.AspNetCore.OpenApi | 8.0.1
Microsoft.AspNetCore.OutputCaching.StackExchangeRedis | 8.0.1
Microsoft.AspNetCore.Owin | 8.0.1
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 8.0.1
Microsoft.AspNetCore.SignalR.Specification.Tests | 8.0.1
Microsoft.AspNetCore.SpaServices.Extensions | 8.0.1
Microsoft.AspNetCore.TestHost | 8.0.1
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 8.0.1
Microsoft.Extensions.Features | 8.0.1
Microsoft.Extensions.Http.Polly | 8.0.1
Microsoft.Extensions.Identity.Core | 8.0.1
Microsoft.Extensions.ObjectPool | 8.0.1
Microsoft.Extensions.WebEncoders | 8.0.1
Microsoft.JSInterop.WebAssembly | 8.0.1
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 8.0.1
Microsoft.Extensions.FileProviders.Embedded | 8.0.1
Microsoft.Extensions.Logging.AzureAppServices | 8.0.1
Microsoft.JSInterop | 8.0.1
Microsoft.Net.Http.Headers | 8.0.1
Microsoft.AspNetCore.App.Runtime.osx-x64 | 8.0.1
AspNetCoreRuntime.8.0.x86 | 8.0.1
Microsoft.AspNetCore.AzureAppServicesIntegration | 8.0.1
Microsoft.AspNetCore.WebUtilities | 8.0.1
Microsoft.Authentication.WebAssembly.Msal | 8.0.1
Microsoft.dotnet-openapi | 8.0.1
Microsoft.DotNet.Web.Client.ItemTemplates | 8.0.1
Microsoft.DotNet.Web.ProjectTemplates.8.0 | 8.0.1
FSharp.Core | 8.0.101
Microsoft.DotNet.ApiCompat.Tool | 8.0.101
Microsoft.DotNet.ApiCompat.Task | 8.0.101
Microsoft.DotNet.Common.ItemTemplates | 8.0.101
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.101
Microsoft.NET.Build.Containers | 8.0.101
FSharp.Compiler.Service | 43.8.101
System.Drawing.Common | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-x64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64.Msi.x64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64.Msi.arm64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64.Msi.arm64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64.Msi.x64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64.Msi.arm64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64.Msi.x64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-x64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-arm64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64.Msi.x64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-x64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-x64 | 8.0.1
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x64 | 8.0.1
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.arm64 | 8.0.1
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-arm64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-arm64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-arm64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-x64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-arm64 | 8.0.1
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x86 | 8.0.1
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.arm64 | 8.0.1
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x64 | 8.0.1
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.arm64 | 8.0.1
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x86 | 8.0.1
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x86 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-arm64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-arm64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-x64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-x64 | 8.0.1
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64.Msi.arm64 | 8.0.1
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100 | 8.0.1
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100 | 8.0.1
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100 | 8.0.1
Microsoft.EntityFrameworkCore.InMemory | 8.0.1
Microsoft.EntityFrameworkCore.Specification.Tests | 8.0.1
Microsoft.EntityFrameworkCore.Sqlite.Core | 8.0.1
dotnet-ef | 8.0.1
Microsoft.Data.Sqlite | 8.0.1
Microsoft.EntityFrameworkCore.Abstractions | 8.0.1
Microsoft.EntityFrameworkCore.Analyzers | 8.0.1
Microsoft.EntityFrameworkCore.Relational | 8.0.1
Microsoft.EntityFrameworkCore.Sqlite | 8.0.1
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 8.0.1
Microsoft.EntityFrameworkCore.SqlServer.Abstractions | 8.0.1
Microsoft.EntityFrameworkCore.Proxies | 8.0.1
Microsoft.EntityFrameworkCore.SqlServer | 8.0.1
Microsoft.EntityFrameworkCore | 8.0.1
Microsoft.Data.Sqlite.Core | 8.0.1
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 8.0.1
Microsoft.EntityFrameworkCore.Design | 8.0.1
Microsoft.EntityFrameworkCore.Cosmos | 8.0.1
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 8.0.1
Microsoft.EntityFrameworkCore.SqlServer.HierarchyId | 8.0.1
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 8.0.1
Microsoft.EntityFrameworkCore.Templates | 8.0.1
Microsoft.EntityFrameworkCore.Tools | 8.0.1
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.101
Microsoft.TemplateEngine.Edge | 8.0.101
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.101
Microsoft.TemplateEngine.Abstractions | 8.0.101
Microsoft.TemplateEngine.Authoring.CLI | 8.0.101
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.101
Microsoft.TemplateEngine.Authoring.Templates | 8.0.101
Microsoft.TemplateEngine.Core | 8.0.101
Microsoft.TemplateEngine.Core.Contracts | 8.0.101
Microsoft.TemplateEngine.IDE | 8.0.101
Microsoft.TemplateEngine.Utils | 8.0.101
Microsoft.TemplateSearch.Common | 8.0.101
Microsoft.TemplateEngine.Samples | 8.0.101
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.101

[//]: # ( Runtime 8.0.1)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/809134e8-66fa-4f0c-a84a-9e981e9bd2f9/efb33d1a4075101410c82a617f4f7c42/dotnet-runtime-8.0.1-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/39e79317-94d1-4e57-bb90-d5e004f4f3d4/cdcf3c0d8dc2560dcfcb160acb193785/dotnet-runtime-8.0.1-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fd50b40d-20ba-4fde-8100-eb5dd4c5d47d/1c801abf25f2166037b772f14252ac9f/dotnet-runtime-8.0.1-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/788ff867-ada8-484b-aadb-cfe85e846a07/cdb07410754e7e42de1f02dc2f238be1/dotnet-runtime-8.0.1-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/96967996-531c-4ff1-8848-dd981aedc49e/8e70800721e5dc182075e8bd2ef86451/dotnet-runtime-8.0.1-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4d5166de-c1ac-45c5-bb8a-d47f8ee93ad9/ffab59440a3eb74359dd3009e4da5a81/dotnet-runtime-8.0.1-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a7984b93-92dc-41e1-996c-fd059c17afb4/c44ed6a09d648e289e49002c0d7297c2/dotnet-runtime-8.0.1-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/43ed6ef8-5265-462e-bbc4-2055a0f473e8/28d78788aeca160f615dcbd63c79b621/dotnet-runtime-8.0.1-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2dc0cd09-9e3d-4329-b01b-12b417e610de/38a37e5f8b93ef55e6630f216265293a/dotnet-runtime-8.0.1-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/220d43f7-eb7f-470d-a80b-b30210adbbf2/dbfa691328557ee9888a1f38a29f72bd/dotnet-runtime-8.0.1-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/cc502ccd-70f6-4714-b1d0-60585e24bbed/7ca46f9ea9958f8a4455990641418a92/dotnet-runtime-8.0.1-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/219a8418-3f0b-45f9-b733-df9094b15a68/aa98f0d154b3ef8d01f679c579f30d00/dotnet-runtime-8.0.1-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/cede7e69-dbd4-4908-9bfb-12fa4660e2b9/d9ed17179d0275abee5afd29d5460b48/dotnet-runtime-8.0.1-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/eac51dde-7bac-4bdb-aacd-e8c870f29aa4/d6c945e85adab9af2446856f90f6d326/dotnet-runtime-8.0.1-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8c884ea1-2ae5-4359-82a4-8ce8fb309b0e/53a67e660c7b331577c95b02f87935fe/dotnet-runtime-8.0.1-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/edd19f6e-419b-4ce6-8c58-eced8309bda3/98ae2907a522f3bdf8ee700c2e0daf50/dotnet-runtime-8.0.1-win-x86.zip

[//]: # ( WindowsDesktop 8.0.1)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/627d7473-7de1-4285-ab75-16e89f861f0e/54e8a293cfc12144c111155b65a6a41b/windowsdesktop-runtime-8.0.1-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/55e981c7-adb4-45ae-9f21-ede2c4016290/c250573c1d02c1f37632b202e78c1eb9/windowsdesktop-runtime-8.0.1-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f18288f6-1732-415b-b577-7fb46510479a/a98239f751a7aed31bc4aa12f348a9bf/windowsdesktop-runtime-8.0.1-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0a1e339f-cfa3-4d99-93d6-1ef32a1e42c6/89a0f5a9cd7ae0fdede93ce3c931d109/windowsdesktop-runtime-8.0.1-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ca725693-6de7-4a4d-b8a4-4390b0387c66/ce13f2f016152d9b5f2d3c6537cc415b/windowsdesktop-runtime-8.0.1-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1f19390e-a6eb-4dad-bf62-2f30e03e910e/a9f6a26833b41c796ff40f2b217dc445/windowsdesktop-runtime-8.0.1-win-x86.zip

[//]: # ( ASP 8.0.1)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6d73b0dc-fd8a-4f4a-9b16-bf075c2985e0/345ca37b7db49d9528406707aa97ff6c/aspnetcore-runtime-8.0.1-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0688a08e-fdaf-489b-90e4-033cc19cfffc/c9a9c648862b0b18c9aca77d3be0ef9f/aspnetcore-runtime-8.0.1-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9996eb25-90b1-4fbe-b02d-2cc84a4facf4/b31e737c1372e0d3642fd5578612e914/aspnetcore-runtime-8.0.1-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/276629d4-54be-47ec-a34d-24c0aeb7bf71/1cf737f170cdc6a15dd70ae8e294b336/aspnetcore-runtime-8.0.1-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3d20e634-d5b8-4822-992f-801cf11b3fa6/76313771ec5cc707999190afe2ea40da/aspnetcore-runtime-8.0.1-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8e19b03a-93be-43ae-8cd6-95b89a849572/facbb896d726a2496dd23bcecb28c9e9/aspnetcore-runtime-8.0.1-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/73548990-4198-4c80-ac97-29ff5064cb11/da52a05fbc9a0cc6b997c14284753589/aspnetcore-runtime-8.0.1-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6032140f-ed94-431d-94b3-afa360230225/eabd66a040f8a926694f78bf0f4a417e/aspnetcore-runtime-8.0.1-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/c3ef1610-6e16-4763-8770-ad9847865ce2/798fd19c3570257a14c552813aff564d/aspnetcore-runtime-8.0.1-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4b805b84-302c-42e3-b57e-665d0bb7b1f0/3a0965017f98303c7fe1ab1291728e07/aspnetcore-runtime-8.0.1-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4fe2aae0-2d64-47b6-ab89-7af36e696bf7/1327a3ad7c6797951ae0017dfd0efbd5/aspnetcore-runtime-8.0.1-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/054695b5-a7fd-43e9-8e7f-c8422e9766c4/78ff5d8a3ea0f03af996456dd260351e/aspnetcore-runtime-8.0.1-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/bd8879cf-4cca-4f2c-aee0-8aca9b382614/5e0357446e4c988e9805adf99dbf2b22/aspnetcore-runtime-8.0.1-win-x86.zip
[aspnetcore-runtime-composite-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a2db90be-db6c-446a-9851-87a7cc1b0c77/e186785ae5b67a280c585711a0cb2e82/aspnetcore-runtime-composite-8.0.1-linux-arm.tar.gz
[aspnetcore-runtime-composite-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2503a66c-c2ba-4e25-913e-d54a5f89375d/d8d06505e674cd235bfca177cb90cdea/aspnetcore-runtime-composite-8.0.1-linux-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4feba7fe-f35e-4129-8548-6e8de76d0d52/0ee6b0e3849d17beb00c5b15e63e5634/aspnetcore-runtime-composite-8.0.1-linux-musl-arm.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e7bf1bb8-5e79-4eeb-8a8d-b1427c9d9820/0d5abd9842f2e2cf8cca75d808b2bf19/aspnetcore-runtime-composite-8.0.1-linux-musl-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c6fc9b8b-ba8e-418f-9429-ae0c7790d367/d85fc973f0fef00128fc6922274f73ba/aspnetcore-runtime-composite-8.0.1-linux-musl-x64.tar.gz
[aspnetcore-runtime-composite-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d9dfa873-f3a9-42a4-bf76-9b8d1c0d4462/cf3dfae1fd46c5fdf9684dc9132cd8ed/aspnetcore-runtime-composite-8.0.1-linux-x64.tar.gz
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/016c6447-764a-4210-a260-bf7a2880d5c0/a5746437a3862d7803284ae8c2290200/dotnet-hosting-8.0.1-win.exe

[//]: # ( SDK 8.0.101)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/28bc9d47-631c-4e28-9e8c-3e8d025cc999/c4302b73c98da0dc26bcb36ed1e148d2/dotnet-sdk-8.0.101-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/092bec24-9cad-421d-9b43-458b3a7549aa/84280dbd1eef750f9ed1625339235c22/dotnet-sdk-8.0.101-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c2a7a9a1-69e7-40ab-9130-30d0ab771564/3a5280c98c262c576d6cd6025d868419/dotnet-sdk-8.0.101-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e024f0c4-88f2-4d8d-a7ee-d98536bc7aac/53b09f1040e29b65d90bc78a10c1cf09/dotnet-sdk-8.0.101-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f75f8192-785e-4199-8643-6ee8a87dca34/6bd0c5e0da66cc807be5b76e18092750/dotnet-sdk-8.0.101-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9454f7dc-b98e-4a64-a96d-4eb08c7b6e66/da76f9c6bc4276332b587b771243ae34/dotnet-sdk-8.0.101-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4d6fe60e-611f-4db0-8b03-fc15ee03ca7a/e24b834bd82a75fb2a50a59b8a27aed3/dotnet-sdk-8.0.101-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ef083c06-7aee-4a4f-b18b-50c9a8990753/e206864e7910e81bbd9cb7e674ff1b4c/dotnet-sdk-8.0.101-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3b11b408-68e1-4a8f-a0ad-55b21456c4f6/03819d38c79a9aa4fd806f8c7b64130d/dotnet-sdk-8.0.101-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7f806d2-1483-4a52-893a-4de1054b0bff/a6f52ed50876c45f859192b6576a14d5/dotnet-sdk-8.0.101-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/0047e089-cf40-49c3-a8a1-8d1daa9d5a75/67300bbb26dab5d0a33b7401f6aa52ef/dotnet-sdk-8.0.101-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/bfcfe7c7-d722-45b0-80df-663516a401ce/d7b91a51df647c710c96cde20aa8b100/dotnet-sdk-8.0.101-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/cb56b18a-e2a6-4f24-be1d-fc4f023c9cc8/be3822e20b990cf180bb94ea8fbc42fe/dotnet-sdk-8.0.101-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6902745c-34bd-4d66-8e84-d5b61a17dfb7/e61732b00f7e144e162d7e6914291f16/dotnet-sdk-8.0.101-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/88238db3-d71e-4431-bba5-1f6d16f7a415/d1e7b4c6302c51f1e968d07391cac7e1/dotnet-sdk-8.0.101-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/059613f3-d3e9-4585-b8a9-3814e675b6d0/01150dbaaa7f392f103137bd325786b6/dotnet-sdk-8.0.101-win-x86.zip
