# .NET 8.0.10 - October 08, 2024

The .NET 8.0.10 and .NET SDK 8.0.403 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.403
```
## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/monitor/base](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor-base.md): .NET Monitor Base
* [dotnet/aspire-dashboard](https://github.com/dotnet/dotnet-docker/blob/main/README.aspire-dashboard.md): .NET Aspire Dashboard
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 8.0 Blog][dotnet-blog]

 .NET 8.0.10 release carries the security fixes and non-security fixes.

### Microsoft Security Advisory CVE-2024-38229 | .NET Remote Code Execution Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in  .NET 8.0 and .NET 9.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in ASP.NET when closing an HTTP/3 stream while application code is writing to the response body, a race condition may lead to use-after-free.

Note: HTTP/3 is experimental in .NET 6.0. If you are on .NET 6.0 and using HTTP/3, please upgrade to .NET 8.0.10. .NET 6.0 will not receive a security patch for this vulnerability.

### Microsoft Security Advisory CVE-2024-43483 | .NET Denial of Service Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in  System.Security.Cryptography.Cose, System.IO.Packaging, System.Runtime.Caching. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

System.Security.Cryptography.Cose, System.IO.Packaging, System.Runtime.Caching may be exposed to a hostile input which may lead them to be susceptible to hash flooding attacks resulting in denial of service.

### Microsoft Security Advisory CVE-2024-43484 | .NET Denial of Service Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in System.IO.Packaging. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

The System.IO.Packaging library may allow untrusted inputs to influence algorithmically complex operations, leading to denial of service.

### Microsoft Security Advisory CVE-2024-43485 | .NET Denial of Service Vulnerability

Microsoft is releasing this security advisory to provide information about a vulnerability in System.Text.Json 6.0.x and 8.0.x. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

In System.Text.Json 6.0.x and 8.0.x, applications which deserialize input to a model with an `[ExtensionData]` property can be vulnerable to an algorithmic complexity attack resulting in Denial of Service.

## Visual Studio Compatibility

You need [Visual Studio 17.11](https://visualstudio.microsoft.com) or later to use .NET 8.0 on Windows. While not officially supported, we’ve also enabled rudimentary support for .NET 8 in Visual Studio for Mac. Users have to enable a preview feature in Preferences to enable the IDE to discover and use the .NET 8 SDK for creating, loading, building, and debugging projects. The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 8.0 and C# 12.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9532](https://github.com/dotnet/core/issues/9532) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.10.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.10-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.10-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/dotnet-and-dotnet-framework-october-2024-servicing-updates/#net-october-2024-updates
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-dotnet-8/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.10+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.10+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.10+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.10+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.10xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Ref | 8.0.10
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 8.0.10
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 8.0.10
Microsoft.Windows.Compatibility | 8.0.10
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 8.0.10
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 8.0.10
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.arm64 | 8.0.10
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Crossgen2.linux-arm | 8.0.10
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100 | 8.0.10
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x86 | 8.0.10
Microsoft.NETCore.App.Crossgen2.osx-x64 | 8.0.10
Microsoft.NETCore.App.Crossgen2.win-x64 | 8.0.10
Microsoft.NETCore.App.Host.linux-bionic-x64 | 8.0.10
Microsoft.NETCore.App.Host.linux-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 8.0.10
Microsoft.NETCore.App.Runtime.osx-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 8.0.10
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 8.0.10
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.10
runtime.osx-arm64.Microsoft.DotNet.ILCompiler | 8.0.10
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.10
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.10
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 8.0.10
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.10
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.10
System.Data.OleDb | 8.0.1
System.ServiceProcess.ServiceController | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 8.0.10
Microsoft.NETCore.App.Crossgen2.linux-x64 | 8.0.10
Microsoft.NETCore.App.Host.linux-arm | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.linux-arm | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 8.0.10
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm | 8.0.10
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 8.0.10
Microsoft.NETCore.DotNetHostResolver | 8.0.10
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.10
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 8.0.10
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.10
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.10
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 8.0.10
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 8.0.10
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 8.0.10
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 8.0.10
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.10
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 8.0.10
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 8.0.10
System.Data.Odbc | 8.0.1
System.Runtime.Caching | 8.0.1
System.Security.Cryptography.Pkcs | 8.0.1
Microsoft.Extensions.DependencyInjection.Abstractions | 8.0.2
Microsoft.Extensions.DependencyModel | 8.0.2
Microsoft.Extensions.Logging.Debug | 8.0.1
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 8.0.10
Microsoft.NET.Sdk.WebAssembly.Pack | 8.0.10
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100 | 8.0.10
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Host.linux-musl-arm64 | 8.0.10
Microsoft.NETCore.App.Host.osx-arm64 | 8.0.10
Microsoft.NETCore.App.Host.osx-x64 | 8.0.10
Microsoft.NETCore.App.Host.win-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x86 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.ios-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.browser-wasm | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.linux-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-x64 | 8.0.10
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 8.0.10
System.Diagnostics.PerformanceCounter | 8.0.1
System.IO.Packaging | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.linux-arm64 | 8.0.10
Microsoft.NET.Runtime.wasm.Sample.Mono | 8.0.10
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 8.0.10
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 8.0.10
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 8.0.10
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x86 | 8.0.10
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x64 | 8.0.10
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 8.0.10
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.NativeAOT.tvos-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.win-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 8.0.10
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 8.0.10
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.10
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.10
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 8.0.10
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 8.0.10
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 8.0.10
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.10
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.10
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.10
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.10
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 8.0.10
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.10
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.10
runtime.win-x64.Microsoft.NETCore.DotNetHost | 8.0.10
System.Configuration.ConfigurationManager | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 8.0.10
System.Diagnostics.EventLog | 8.0.1
System.Reflection.Metadata | 8.0.1
Microsoft.Extensions.Hosting.Abstractions | 8.0.1
Microsoft.Extensions.Hosting.Systemd | 8.0.1
Microsoft.Extensions.Hosting.WindowsServices | 8.0.1
Microsoft.Extensions.Http | 8.0.1
Microsoft.Extensions.Logging | 8.0.1
Microsoft.NET.Runtime.Android.Sample.Mono | 8.0.10
Microsoft.NET.ILLink.Tasks | 8.0.10
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 8.0.10
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 8.0.10
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 8.0.10
Microsoft.NET.Runtime.MonoTargets.Sdk | 8.0.10
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 8.0.10
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 8.0.10
Microsoft.NET.Runtime.WebAssembly.Sdk | 8.0.10
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 8.0.10
Microsoft.NET.Runtime.WebAssembly.Templates | 8.0.10
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 8.0.10
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 8.0.10
Microsoft.NETCore.App.Host.linux-arm64 | 8.0.10
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 8.0.10
Microsoft.NETCore.App.Host.linux-musl-arm | 8.0.10
Microsoft.NETCore.App.Host.win-x86 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x86 | 8.0.10
Microsoft.NETCore.App.Runtime.NativeAOT.osx-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.NativeAOT.osx-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.win-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 8.0.10
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.win-x86 | 8.0.10
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 8.0.10
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 8.0.10
Microsoft.NETCore.DotNetHostPolicy | 8.0.10
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 8.0.10
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 8.0.10
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 8.0.10
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.10
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 8.0.10
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.10
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 8.0.10
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.10
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 8.0.10
runtime.win-x86.Microsoft.NETCore.DotNetHost | 8.0.10
System.DirectoryServices.AccountManagement | 8.0.1
System.Reflection.MetadataLoadContext | 8.0.1
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 8.0.10
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.10
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.10
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.10
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 8.0.10
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 8.0.10
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 8.0.10
runtime.win-x64.Microsoft.DotNet.ILCompiler | 8.0.10
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 8.0.10
System.Net.Http.Json | 8.0.1
System.Security.Cryptography.Cose | 8.0.1
System.Memory.Data | 8.0.1
System.Security.Cryptography.Xml | 8.0.2
System.Text.Json | 8.0.5
Microsoft.DotNet.ILCompiler | 8.0.10
Microsoft.Extensions.Logging.Configuration | 8.0.1
Microsoft.Extensions.Logging.Console | 8.0.1
Microsoft.Extensions.Logging.EventLog | 8.0.1
Microsoft.Extensions.Logging.EventSource | 8.0.1
Microsoft.Extensions.Logging.TraceSource | 8.0.1
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 8.0.10
Microsoft.NETCore.App.Crossgen2.win-x86 | 8.0.10
Microsoft.NETCore.App.Crossgen2.win-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm | 8.0.10
Microsoft.NETCore.App.Host.linux-musl-x64 | 8.0.10
Microsoft.NETCore.App.Host.win-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x86 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.browser-wasm | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvos-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.NativeAOT.ios-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.osx-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 8.0.10
Microsoft.NETCore.DotNetAppHost | 8.0.10
Microsoft.NETCore.DotNetHost | 8.0.10
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.10
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.10
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.10
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.10
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 8.0.10
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.10
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.10
Microsoft.Extensions.Caching.Memory | 8.0.1
Microsoft.Extensions.Configuration.Json | 8.0.1
Microsoft.Extensions.Configuration.UserSecrets | 8.0.1
Microsoft.Extensions.Configuration.Xml | 8.0.1
Microsoft.Extensions.DependencyInjection | 8.0.1
Microsoft.Extensions.Diagnostics | 8.0.1
Microsoft.Extensions.Diagnostics.Abstractions | 8.0.1
Microsoft.Extensions.Hosting | 8.0.1
Microsoft.Extensions.Logging.Abstractions | 8.0.2
Microsoft.NET.Runtime.iOS.Sample.Mono | 8.0.10
Microsoft.NET.Runtime.LibraryBuilder.Sdk | 8.0.10
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 8.0.10
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk | 8.0.10
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x86 | 8.0.10
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x64 | 8.0.10
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100 | 8.0.10
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.arm64 | 8.0.10
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x86 | 8.0.10
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 8.0.10
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 8.0.10
Microsoft.NETCore.App.Ref | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 8.0.10
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.linux-musl-arm | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 8.0.10
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 8.0.10
Microsoft.AspNetCore.App.Runtime.win-arm64 | 8.0.10
Microsoft.AspNetCore.Authentication.Certificate | 8.0.10
Microsoft.AspNetCore.AzureAppServicesIntegration | 8.0.10
Microsoft.AspNetCore.Components.Authorization | 8.0.10
Microsoft.AspNetCore.Components.CustomElements | 8.0.10
Microsoft.AspNetCore.Components.QuickGrid.EntityFrameworkAdapter | 8.0.10
Microsoft.AspNetCore.DataProtection | 8.0.10
Microsoft.AspNetCore.Components.Web | 8.0.10
Microsoft.AspNetCore.Components.WebAssembly | 8.0.10
Microsoft.AspNetCore.Metadata | 8.0.10
Microsoft.AspNetCore.MiddlewareAnalysis | 8.0.10
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 8.0.10
Microsoft.Extensions.ApiDescription.Client | 8.0.10
Microsoft.Extensions.Http.Polly | 8.0.10
Microsoft.Extensions.Diagnostics.HealthChecks | 8.0.10
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 8.0.10
Microsoft.Extensions.FileProviders.Embedded | 8.0.10
Microsoft.Extensions.Identity.Stores | 8.0.10
Microsoft.Extensions.Logging.AzureAppServices | 8.0.10
Microsoft.Extensions.Localization.Abstractions | 8.0.10
Microsoft.AspNetCore.App.Runtime.linux-x64 | 8.0.10
Microsoft.AspNetCore.Authentication.JwtBearer | 8.0.10
Microsoft.AspNetCore.Authentication.Google | 8.0.10
Microsoft.AspNetCore.Authentication.Negotiate | 8.0.10
Microsoft.AspNetCore.Authentication.OpenIdConnect | 8.0.10
Microsoft.AspNetCore.Authentication.WsFederation | 8.0.10
Microsoft.AspNetCore.Authorization | 8.0.10
Microsoft.AspNetCore.ConcurrencyLimiter | 8.0.10
Microsoft.AspNetCore.Connections.Abstractions | 8.0.10
Microsoft.AspNetCore.DataProtection.Extensions | 8.0.10
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 8.0.10
Microsoft.AspNetCore.Grpc.JsonTranscoding | 8.0.10
Microsoft.AspNetCore.Hosting.WindowsServices | 8.0.10
Microsoft.AspNetCore.Http.Connections.Common | 8.0.10
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 8.0.10
Microsoft.Extensions.WebEncoders | 8.0.10
Microsoft.JSInterop.WebAssembly | 8.0.10
Microsoft.AspNetCore.Components.Analyzers | 8.0.10
Microsoft.AspNetCore.Components | 8.0.10
Microsoft.AspNetCore.Components.QuickGrid | 8.0.10
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 8.0.10
Microsoft.AspNetCore.Components.WebAssembly.Server | 8.0.10
Microsoft.AspNetCore.Cryptography.KeyDerivation | 8.0.10
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 8.0.10
Microsoft.AspNetCore.DataProtection.Abstractions | 8.0.10
Microsoft.AspNetCore.WebUtilities | 8.0.10
Microsoft.Extensions.Caching.SqlServer | 8.0.10
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 8.0.10
Microsoft.AspNetCore.App.Runtime.linux-arm | 8.0.10
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 8.0.10
dotnet-sql-cache | 8.0.10
Microsoft.AspNetCore.App.Ref | 8.0.10
Microsoft.AspNetCore.App.Runtime.win-x86 | 8.0.10
Microsoft.AspNetCore.Authentication.Twitter | 8.0.10
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 8.0.10
Microsoft.AspNetCore.JsonPatch | 8.0.10
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 8.0.10
Microsoft.AspNetCore.Mvc.Testing | 8.0.10
Microsoft.AspNetCore.OpenApi | 8.0.10
Microsoft.AspNetCore.OutputCaching.StackExchangeRedis | 8.0.10
Microsoft.AspNetCore.Owin | 8.0.10
Microsoft.AspNetCore.SignalR.Protocols.Json | 8.0.10
Microsoft.AspNetCore.SignalR.Common | 8.0.10
Microsoft.Extensions.ObjectPool | 8.0.10
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 8.0.10
AspNetCoreRuntime.8.0.x64 | 8.0.10
AspNetCoreRuntime.8.0.x86 | 8.0.10
Microsoft.AspNetCore.Components.WebView | 8.0.10
Microsoft.AspNetCore.Cryptography.Internal | 8.0.10
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 8.0.10
Microsoft.AspNetCore.HeaderPropagation | 8.0.10
Microsoft.AspNetCore.Grpc.Swagger | 0.8.10
Microsoft.AspNetCore.Http.Connections.Client | 8.0.10
Microsoft.AspNetCore.App.Runtime.osx-x64 | 8.0.10
Microsoft.AspNetCore.Authentication.Facebook | 8.0.10
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 8.0.10
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 8.0.10
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 8.0.10
Microsoft.AspNetCore.Components.Forms | 8.0.10
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 8.0.10
Microsoft.AspNetCore.SignalR.Client | 8.0.10
Microsoft.AspNetCore.SignalR.Client.Core | 8.0.10
Microsoft.AspNetCore.SignalR.Specification.Tests | 8.0.10
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 8.0.10
Microsoft.dotnet-openapi | 8.0.10
Microsoft.AspNetCore.SpaProxy | 8.0.10
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 8.0.10
Microsoft.AspNetCore.TestHost | 8.0.10
Microsoft.AspNetCore.SpaServices.Extensions | 8.0.10
Microsoft.DotNet.Web.ProjectTemplates.8.0 | 8.0.10
Microsoft.DotNet.Web.Client.ItemTemplates | 8.0.10
Microsoft.DotNet.Web.ItemTemplates.8.0 | 8.0.10
Microsoft.Extensions.ApiDescription.Server | 8.0.10
Microsoft.Extensions.Caching.StackExchangeRedis | 8.0.10
Microsoft.Extensions.Configuration.KeyPerFile | 8.0.10
Microsoft.Extensions.Features | 8.0.10
Microsoft.Extensions.Identity.Core | 8.0.10
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 8.0.10
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 8.0.10
Microsoft.AspNetCore.Identity.UI | 8.0.10
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 8.0.10
Microsoft.Authentication.WebAssembly.Msal | 8.0.10
Microsoft.JSInterop | 8.0.10
Microsoft.AspNetCore.App.Runtime.win-x64 | 8.0.10
Microsoft.Extensions.Localization | 8.0.10
Microsoft.Net.Http.Headers | 8.0.10
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.110
Microsoft.DotNet.Common.ItemTemplates | 8.0.110
FSharp.Core | 8.0.102
Microsoft.DotNet.ApiCompat.Tool | 8.0.110
FSharp.Compiler.Service | 43.8.102
Microsoft.NET.Build.Containers | 8.0.110
Microsoft.DotNet.ApiCompat.Task | 8.0.110
System.Drawing.Common | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-arm64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-x64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-x64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-x64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-x64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-x64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-x64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-arm64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-arm64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-x64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-arm64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64.Msi.x64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64.Msi.x64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64.Msi.x64 | 8.0.10
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.arm64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-arm64 | 8.0.10
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64 | 8.0.10
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x64 | 8.0.10
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x86 | 8.0.10
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-arm64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64.Msi.arm64 | 8.0.10
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x64 | 8.0.10
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.arm64 | 8.0.10
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.arm64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-arm64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64.Msi.x64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64.Msi.arm64 | 8.0.10
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x86 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64 | 8.0.10
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100 | 8.0.10
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64.Msi.arm64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64.Msi.arm64 | 8.0.10
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64 | 8.0.10
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x86 | 8.0.10
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 8.0.10
Microsoft.EntityFrameworkCore.Analyzers | 8.0.10
Microsoft.EntityFrameworkCore.Design | 8.0.10
Microsoft.EntityFrameworkCore.InMemory | 8.0.10
Microsoft.EntityFrameworkCore.Sqlite.Core | 8.0.10
Microsoft.EntityFrameworkCore.SqlServer.Abstractions | 8.0.10
Microsoft.EntityFrameworkCore.Abstractions | 8.0.10
Microsoft.EntityFrameworkCore | 8.0.10
Microsoft.EntityFrameworkCore.Cosmos | 8.0.10
Microsoft.EntityFrameworkCore.Specification.Tests | 8.0.10
Microsoft.EntityFrameworkCore.SqlServer.HierarchyId | 8.0.10
Microsoft.EntityFrameworkCore.Templates | 8.0.10
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 8.0.10
dotnet-ef | 8.0.10
Microsoft.Data.Sqlite | 8.0.10
Microsoft.Data.Sqlite.Core | 8.0.10
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 8.0.10
Microsoft.EntityFrameworkCore.Relational | 8.0.10
Microsoft.EntityFrameworkCore.Proxies | 8.0.10
Microsoft.EntityFrameworkCore.Sqlite | 8.0.10
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 8.0.10
Microsoft.EntityFrameworkCore.SqlServer | 8.0.10
Microsoft.EntityFrameworkCore.Tools | 8.0.10
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.109
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.109
Microsoft.TemplateEngine.Utils | 8.0.109
Microsoft.TemplateSearch.Common | 8.0.109
Microsoft.TemplateEngine.Authoring.CLI | 8.0.109
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.109
Microsoft.TemplateEngine.Edge | 8.0.109
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.109
Microsoft.TemplateEngine.Abstractions | 8.0.109
Microsoft.TemplateEngine.Core | 8.0.109
Microsoft.TemplateEngine.Authoring.Templates | 8.0.109
Microsoft.TemplateEngine.Core.Contracts | 8.0.109
Microsoft.TemplateEngine.IDE | 8.0.109
Microsoft.TemplateEngine.Samples | 8.0.109
Microsoft.DotNet.ApiCompat.Tool | 8.0.306
FSharp.Compiler.Service | 43.8.301
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.306
Microsoft.DotNet.ApiCompat.Task | 8.0.306
Microsoft.NET.Build.Containers | 8.0.306
FSharp.Core | 8.0.301
Microsoft.DotNet.Common.ItemTemplates | 8.0.306
Microsoft.TemplateEngine.Authoring.CLI | 8.0.306
Microsoft.TemplateEngine.Utils | 8.0.306
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.306
Microsoft.TemplateEngine.Abstractions | 8.0.306
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.306
Microsoft.TemplateEngine.Authoring.Templates | 8.0.306
Microsoft.TemplateEngine.Core | 8.0.306
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.306
Microsoft.TemplateEngine.Core.Contracts | 8.0.306
Microsoft.TemplateEngine.Edge | 8.0.306
Microsoft.TemplateEngine.IDE | 8.0.306
Microsoft.TemplateEngine.Samples | 8.0.306
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.306
Microsoft.TemplateSearch.Common | 8.0.306
FSharp.Compiler.Service | 43.8.401
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.403
Microsoft.DotNet.ApiCompat.Tool | 8.0.403
FSharp.Core | 8.0.401
Microsoft.NET.Build.Containers | 8.0.403
Microsoft.DotNet.Common.ItemTemplates | 8.0.403
Microsoft.DotNet.ApiCompat.Task | 8.0.403
Microsoft.TemplateEngine.Authoring.CLI | 8.0.403
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.403
Microsoft.TemplateEngine.Abstractions | 8.0.403
Microsoft.TemplateEngine.Core.Contracts | 8.0.403
Microsoft.TemplateEngine.IDE | 8.0.403
Microsoft.TemplateEngine.Edge | 8.0.403
Microsoft.TemplateEngine.Utils | 8.0.403
Microsoft.TemplateSearch.Common | 8.0.403
Microsoft.TemplateEngine.Authoring.Templates | 8.0.403
Microsoft.TemplateEngine.Core | 8.0.403
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.403
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.403
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.403
Microsoft.TemplateEngine.Samples | 8.0.403

[//]: # ( Runtime 8.0.10)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3f8dea7e-13bf-4931-b11e-77fcc6de7ca9/37531adc6a054037c064c47dae4e7f77/dotnet-runtime-8.0.10-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6c71a005-d902-4df5-8cbb-f1fd53cf14f7/658dd2a2a839c14173e3804befec6a7e/dotnet-runtime-8.0.10-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a254fc53-e78b-4039-91ca-38fb3e42535e/be0d765e74b082a5919248c97866c7cd/dotnet-runtime-8.0.10-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aa047a4f-73b1-4a00-bb94-1fdf28bdf606/533876a5403795f02d8071d6fc9be4d6/dotnet-runtime-8.0.10-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/abd532e1-6dae-443d-a35c-fdbd5053e239/1ab2cb2acddcbd435cb6970721f0f85a/dotnet-runtime-8.0.10-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ebc433c4-8f01-43c8-a1e2-bbe1291ba857/e073f3f679d7a4067a56e8f5d12fc0e5/dotnet-runtime-8.0.10-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/fd2985f3-9c48-48f5-aa1f-b44048867c07/3900dd411441277fe4c01515ec099a50/dotnet-runtime-8.0.10-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5fcb418a-d290-4fd9-bba3-d0ebe56eab58/e20afef70b5f56e36daf054ee3e09d82/dotnet-runtime-8.0.10-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/39438218-9735-41f4-ae9d-12cde5faf85e/9c8ceefa41c57929ae626d5ff64d7b56/dotnet-runtime-8.0.10-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c71dbec0-22de-4f32-aa1f-8e7112fa380a/54b3ec6159d2f72c813d913afaebcf2f/dotnet-runtime-8.0.10-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/09b9c42b-8189-40e7-9033-45ac95e311b6/d30b6ee196576e7007aff16f3b2697a2/dotnet-runtime-8.0.10-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/b3f13f65-b535-4551-8809-18abe906f750/09d2b79ad619b15c15071533afa52d0d/dotnet-runtime-8.0.10-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f55ed80e-ba58-4ac8-a2b3-f2227cd628de/6fabf1c613cf9386d14ddbaaca1a5eb8/dotnet-runtime-8.0.10-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/697fe02d-5f59-4fd3-ba15-b0ee74bec5d9/4fb434c648aaf10f18682ccbe6d59bc6/dotnet-runtime-8.0.10-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3f9cf5a6-d4d6-4fe0-a02b-cd700df1899b/75c95e00aab7258aed5f4ffe80526803/dotnet-runtime-8.0.10-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/81bc2b8a-98ca-4872-84c8-62314b60c043/b808aee68300ac6eb2a19d2f85ae728d/dotnet-runtime-8.0.10-win-x86.zip

[//]: # ( WindowsDesktop 8.0.10)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c1387fab-1960-4cdc-8653-1e0333f6385a/3bd819d5f2aecff94803006a9e2c945a/windowsdesktop-runtime-8.0.10-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/35d88685-f28b-4c3f-8740-c75f39aa5e1d/d6d679d63f67a0360e614f7d3e68008f/windowsdesktop-runtime-8.0.10-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f398d462-9d4e-4b9c-abd3-86c54262869a/4a8e3a10ca0a9903a989578140ef0499/windowsdesktop-runtime-8.0.10-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/627c352a-dc9e-4d04-acf6-6bc00baedf0e/c27a050c89482c01930127fe34efc954/windowsdesktop-runtime-8.0.10-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9836a475-66af-47eb-a726-8046c47ce6d5/ccb7d60db407a6d022a856852ef9e763/windowsdesktop-runtime-8.0.10-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/20f2a207-3496-4a94-a284-a494008e668e/6cca616d16e78522af9113ef66da1815/windowsdesktop-runtime-8.0.10-win-x86.zip

[//]: # ( ASP 8.0.10)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/50a67fd4-a5dd-42f1-a3ac-e008c3115dcc/816972da008ae5cee7612cad9b6808f0/aspnetcore-runtime-8.0.10-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f93af34d-cde3-4231-a54f-119c328bd876/663b3c2dbf1ed2a3e08ac8e614060571/aspnetcore-runtime-8.0.10-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ccbec918-1f15-4f1e-ad7e-b4d1a679fa91/f8fc5b5f2fccf1fbdf164132da8fbda6/aspnetcore-runtime-8.0.10-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c150b15d-79f6-4343-8aad-7748ad4765de/0e0768e8874957a8b37415919d77a9e1/aspnetcore-runtime-8.0.10-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fd29b6fd-e351-4758-8c61-0d9c0a6813d9/8be59cf5b2537298eb59d44e472c6b4b/aspnetcore-runtime-8.0.10-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6d143cf6-e215-428e-bcde-9fd50ea0e1be/99652e31b3e0161a3f1f933e0bedf223/aspnetcore-runtime-8.0.10-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/05bfc51d-d738-4796-ad78-6f16dadd2382/9a64a66f30708e38b6470a480ecc850c/aspnetcore-runtime-8.0.10-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/135424ff-12b7-4b4b-83e0-1d04b053ef5e/9274109d1ec702677474c148ad2af1ff/aspnetcore-runtime-8.0.10-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/e12443bf-603e-4a02-a5c1-2f04cc889a9d/2bdd33336b7ed813d099120e397dc0bf/aspnetcore-runtime-8.0.10-win-arm64.exe
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/16b46ac1-089c-4d5b-9f2d-96be946ce5cf/14b2e3953b86e520353ba1f14e0a0b6a/aspnetcore-runtime-8.0.10-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a17b907f-8457-45a8-90db-53f2665ee49e/49bccd33593ebceb2847674fe5fd768e/aspnetcore-runtime-8.0.10-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5dd09f82-5d3a-43cd-ba51-110ecb995d4d/530878ac59026edeedf6d6a9f02a768e/aspnetcore-runtime-8.0.10-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/175256c9-8d8d-4f9a-a873-ff7b36161506/1b91f2b288e6077e30714485ebe8acb5/aspnetcore-runtime-8.0.10-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1f8b9d89-a426-458f-b542-540e873c1dfd/15b8fc9c972761ff46ff5b9b9ac4a0a6/aspnetcore-runtime-8.0.10-win-x86.zip
[aspnetcore-runtime-composite-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57894b5d-9b1d-4e16-a3be-7b96b742e1d2/8e76f03de1083d3f9a3467e76e591f77/aspnetcore-runtime-composite-8.0.10-linux-arm.tar.gz
[aspnetcore-runtime-composite-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/83366e0a-9f80-4cee-b55c-9698c369d1b6/4b83e2bf0133f477f2ad4e12941a6e5e/aspnetcore-runtime-composite-8.0.10-linux-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/deaaa50c-60ed-49f5-9a32-5931117963c2/6f7d05c0517e33b01f3ef20c3f204f5b/aspnetcore-runtime-composite-8.0.10-linux-musl-arm.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/73a83ec4-fd70-4adc-98bd-013bcf9ca465/a925ebc3d1939d63d733a4d6b2675634/aspnetcore-runtime-composite-8.0.10-linux-musl-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c58c7d90-45b1-4464-a66e-0f54cd6e647d/270934170a03fc4072c0b430ceefea96/aspnetcore-runtime-composite-8.0.10-linux-musl-x64.tar.gz
[aspnetcore-runtime-composite-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2da8b6b0-4c56-49b3-8906-65e1cd522226/af52474f70c98ccfa72ab85077318518/aspnetcore-runtime-composite-8.0.10-linux-x64.tar.gz
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/dfbcd81d-e383-4c92-a174-5079bde0a180/b05bcf7656d1ea900bd23c4f1939a642/dotnet-hosting-8.0.10-win.exe

[//]: # ( SDK 8.0.403)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/382e3bc7-f055-48b9-965b-89b070c15713/54b2af6b1ef970f852c29a850661728b/dotnet-sdk-8.0.403-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/853490db-6fd3-4c17-ad8e-9dbb61261252/3d36d7d5b861bbb219aa1a66af6e6fd2/dotnet-sdk-8.0.403-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8c87dbf9-f000-41f4-bb78-3aea9eceb73c/d75a2445ca5e49bb07243f047c602013/dotnet-sdk-8.0.403-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/18e32a84-60ec-4d82-8ab1-84511be4172b/4a1e6bdd4f15e0d55e0d9bb20c67631e/dotnet-sdk-8.0.403-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/662d63c4-fb9e-494f-96a6-e5d564dbb488/b39e35ac3115e6c8b0c1333d8327d7c8/dotnet-sdk-8.0.403-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ca6cd525-677e-4d3a-b66c-11348a6f920a/ec395f498f89d0ca4d67d903892af82d/dotnet-sdk-8.0.403-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/35b0fb29-cadc-4083-aa26-6cecd2e7ffa1/1a9972a435b73ffdd0b462f979ea5b23/dotnet-sdk-8.0.403-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0f1c8c1a-a14d-451e-8a14-4088b0d29cf0/37d7a2637468a506214ce484985fe040/dotnet-sdk-8.0.403-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d6b3fe61-3c0e-45da-9e37-cef64d4fd3eb/28d536e0ecfbb330ab49454a5e3962f6/dotnet-sdk-8.0.403-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8d0cf513-65cf-4691-a436-7363a5c10af7/ea63a46f9c1f901cec977f2c88538146/dotnet-sdk-8.0.403-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/12351b08-d150-4bac-928e-b9f83d8ad3de/9a7c21d0eca1578b8a9ed63b317a37f9/dotnet-sdk-8.0.403-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d8d7232f-2b0d-4dd8-a4dd-a11df8927aea/289c03f1ac6ad6fe4d6b396480ca4de2/dotnet-sdk-8.0.403-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6224f00f-08da-4e7f-85b1-00d42c2bb3d3/b775de636b91e023574a0bbc291f705a/dotnet-sdk-8.0.403-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/fe458265-87fe-4cc8-baed-7ebf467aab39/2f62c4e56c20f867d28057d7fee9502e/dotnet-sdk-8.0.403-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/959afa1a-8afa-4d6f-982a-f09b9bb7392d/447a25613488738dbcf565e674db0669/dotnet-sdk-8.0.403-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e3bac783-b5d2-4f85-a392-50a9a5a193cc/019f98c74f89f3353798b048de36855f/dotnet-sdk-8.0.403-win-x86.zip
