# .NET 8.0.2 - February 13, 2024

The .NET 8.0.2 and .NET SDK 8.0.200 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.200
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/monitor/base](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor-base.md): .NET Monitor Base
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 8.0 Blog][dotnet-blog]

.NET 8.0.2 release carries security and non-security fixes.

[CVE-2024-21386 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-21386)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET 6.0, ASP.NET 7.0 and, ASP.NET 8.0. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A vulnerability exists in ASP.NET applications using SignalR where a malicious client can result in a denial-of-service.

[CVE-2024-21404 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-21404)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 7.0 and .NET 8.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial-of-service vulnerability exists in .NET with OpenSSL support when parsing X509 certificates.

## Visual Studio Compatibility

You need [Visual Studio 17.8](https://visualstudio.microsoft.com) or later to use .NET 8.0 on Windows. While not officially supported, we’ve also enabled rudimentary support for .NET 8 in Visual Studio for Mac. Users have to enable a preview feature in Preferences to enable the IDE to discover and use the .NET 8 SDK for creating, loading, building, and debugging projects. The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 8.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9163](https://github.com/dotnet/core/issues/9163) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.2.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.2-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/february-2024-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-dotnet-8/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.2+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.2+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.2+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.2+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.2xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Ref | 8.0.2
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 8.0.2
Microsoft.Windows.Compatibility | 8.0.2
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 8.0.2
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 8.0.2
Microsoft.NETCore.App.Host.linux-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 8.0.2
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x86 | 8.0.2
Microsoft.NET.Sdk.WebAssembly.Pack | 8.0.2
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Crossgen2.win-arm64 | 8.0.2
Microsoft.NETCore.App.Host.osx-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.browser-wasm | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.linux-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Runtime.NativeAOT.ios-arm64 | 8.0.2
Microsoft.NET.Runtime.LibraryBuilder.Sdk | 8.0.2
Microsoft.NET.Runtime.Android.Sample.Mono | 8.0.2
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 8.0.2
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 8.0.2
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 8.0.2
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.arm64 | 8.0.2
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x64 | 8.0.2
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100 | 8.0.2
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.arm64 | 8.0.2
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x64 | 8.0.2
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x86 | 8.0.2
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100 | 8.0.2
Microsoft.NETCore.App.Crossgen2.win-x86 | 8.0.2
Microsoft.NETCore.App.Host.win-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvos-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.linux-arm | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.android-arm | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 8.0.2
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.NativeAOT.tvos-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.osx-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.win-arm64 | 8.0.2
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.2
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.2
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.2
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.2
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.2
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.2
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 8.0.2
Microsoft.NETCore.DotNetHostResolver | 8.0.2
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.2
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.2
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.2
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 8.0.2
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 8.0.2
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 8.0.2
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 8.0.2
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 8.0.2
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 8.0.2
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 8.0.2
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.2
runtime.win-x86.Microsoft.NETCore.DotNetHost | 8.0.2
Microsoft.NETCore.App.Host.linux-bionic-x64 | 8.0.2
Microsoft.NETCore.App.Host.win-x86 | 8.0.2
Microsoft.NETCore.App.Host.linux-musl-arm | 8.0.2
Microsoft.NETCore.App.Host.linux-musl-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x86 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.linux-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x86 | 8.0.2
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 8.0.2
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.2
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 8.0.2
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.2
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.2
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 8.0.2
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 8.0.2
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 8.0.2
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.2
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.2
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.2
System.Text.Json | 8.0.2
Microsoft.NET.ILLink.Tasks | 8.0.2
Microsoft.NET.Runtime.iOS.Sample.Mono | 8.0.2
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 8.0.2
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 8.0.2
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Crossgen2.linux-arm | 8.0.2
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 8.0.2
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 8.0.2
Microsoft.NET.Runtime.WebAssembly.Templates | 8.0.2
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 8.0.2
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk | 8.0.2
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.arm64 | 8.0.2
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x64 | 8.0.2
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x86 | 8.0.2
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 8.0.2
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 8.0.2
Microsoft.NETCore.App.Crossgen2.osx-x64 | 8.0.2
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 8.0.2
Microsoft.NETCore.App.Host.osx-x64 | 8.0.2
Microsoft.NETCore.App.Host.win-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x64 | 8.0.2
Microsoft.NETCore.App.Ref | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x86 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.linux-musl-arm | 8.0.2
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.NativeAOT.osx-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 8.0.2
Microsoft.NETCore.DotNetHostPolicy | 8.0.2
Microsoft.NETCore.DotNetHost | 8.0.2
Microsoft.NETCore.DotNetAppHost | 8.0.2
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 8.0.2
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 8.0.2
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.2
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.2
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.2
Microsoft.NET.Runtime.MonoTargets.Sdk | 8.0.2
Microsoft.NET.Runtime.WebAssembly.Sdk | 8.0.2
Microsoft.NET.Runtime.wasm.Sample.Mono | 8.0.2
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 8.0.2
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100 | 8.0.2
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 8.0.2
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 8.0.2
Microsoft.NETCore.App.Crossgen2.linux-x64 | 8.0.2
Microsoft.NETCore.App.Crossgen2.win-x64 | 8.0.2
Microsoft.NETCore.App.Host.linux-arm | 8.0.2
Microsoft.NETCore.App.Host.linux-arm64 | 8.0.2
Microsoft.NETCore.App.Host.linux-musl-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.browser-wasm | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.ios-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm | 8.0.2
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.win-x64 | 8.0.2
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 8.0.2
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 8.0.2
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 8.0.2
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.2
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.2
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 8.0.2
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.2
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 8.0.2
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 8.0.2
runtime.osx-arm64.Microsoft.DotNet.ILCompiler | 8.0.2
runtime.win-x64.Microsoft.DotNet.ILCompiler | 8.0.2
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 8.0.2
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.2
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 8.0.2
Microsoft.DotNet.ILCompiler | 8.0.2
Microsoft.Extensions.Options | 8.0.2
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 8.0.2
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 8.0.2
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 8.0.2
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x64 | 8.0.2
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.NativeAOT.osx-x64 | 8.0.2
Microsoft.NETCore.App.Runtime.osx-arm64 | 8.0.2
Microsoft.NETCore.App.Runtime.win-x86 | 8.0.2
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 8.0.2
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 8.0.2
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.2
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.2
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.2
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.2
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 8.0.2
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.2
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 8.0.2
runtime.win-x64.Microsoft.NETCore.DotNetHost | 8.0.2
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 8.0.2
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 8.0.2
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 8.0.2
Microsoft.AspNetCore.App.Runtime.linux-x64 | 8.0.2
AspNetCoreRuntime.8.0.x64 | 8.0.2
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 8.0.2
Microsoft.AspNetCore.Authentication.Negotiate | 8.0.2
Microsoft.AspNetCore.Authentication.OpenIdConnect | 8.0.2
Microsoft.AspNetCore.Authentication.WsFederation | 8.0.2
Microsoft.AspNetCore.Components.Analyzers | 8.0.2
Microsoft.AspNetCore.Components.QuickGrid | 8.0.2
Microsoft.AspNetCore.Components.Forms | 8.0.2
Microsoft.AspNetCore.Components.WebAssembly | 8.0.2
Microsoft.AspNetCore.Components.WebView | 8.0.2
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 8.0.2
Microsoft.AspNetCore.Http.Connections.Client | 8.0.2
Microsoft.AspNetCore.HeaderPropagation | 8.0.2
Microsoft.AspNetCore.Identity.UI | 8.0.2
Microsoft.AspNetCore.Hosting.WindowsServices | 8.0.2
Microsoft.AspNetCore.Http.Connections.Common | 8.0.2
Microsoft.AspNetCore.JsonPatch | 8.0.2
Microsoft.AspNetCore.SignalR.Client.Core | 8.0.2
Microsoft.AspNetCore.SignalR.Client | 8.0.2
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 8.0.2
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 8.0.2
Microsoft.AspNetCore.SpaProxy | 8.0.2
Microsoft.AspNetCore.TestHost | 8.0.2
Microsoft.AspNetCore.SpaServices.Extensions | 8.0.2
Microsoft.Authentication.WebAssembly.Msal | 8.0.2
Microsoft.dotnet-openapi | 8.0.2
Microsoft.Extensions.ApiDescription.Server | 8.0.2
Microsoft.DotNet.Web.Client.ItemTemplates | 8.0.2
Microsoft.DotNet.Web.ProjectTemplates.8.0 | 8.0.2
Microsoft.Extensions.Diagnostics.HealthChecks | 8.0.2
Microsoft.Extensions.Configuration.KeyPerFile | 8.0.2
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 8.0.2
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 8.0.2
Microsoft.Extensions.FileProviders.Embedded | 8.0.2
Microsoft.Extensions.Features | 8.0.2
Microsoft.Extensions.Identity.Core | 8.0.2
Microsoft.JSInterop.WebAssembly | 8.0.2
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 8.0.2
Microsoft.AspNetCore.App.Runtime.win-x64 | 8.0.2
Microsoft.AspNetCore.Authentication.Certificate | 8.0.2
Microsoft.AspNetCore.Authentication.Twitter | 8.0.2
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 8.0.2
Microsoft.AspNetCore.Authorization | 8.0.2
Microsoft.AspNetCore.AzureAppServicesIntegration | 8.0.2
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 8.0.2
Microsoft.Extensions.Caching.StackExchangeRedis | 8.0.2
Microsoft.Extensions.Caching.SqlServer | 8.0.2
Microsoft.Extensions.Http.Polly | 8.0.2
Microsoft.Extensions.Identity.Stores | 8.0.2
Microsoft.Extensions.WebEncoders | 8.0.2
Microsoft.JSInterop | 8.0.2
Microsoft.Extensions.Logging.AzureAppServices | 8.0.2
Microsoft.Net.Http.Headers | 8.0.2
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 8.0.2
AspNetCoreRuntime.8.0.x86 | 8.0.2
Microsoft.AspNetCore.App.Ref | 8.0.2
Microsoft.AspNetCore.Authentication.Facebook | 8.0.2
Microsoft.AspNetCore.Authentication.Google | 8.0.2
Microsoft.AspNetCore.Authentication.JwtBearer | 8.0.2
Microsoft.AspNetCore.Components | 8.0.2
Microsoft.AspNetCore.Components.Authorization | 8.0.2
Microsoft.AspNetCore.Components.CustomElements | 8.0.2
Microsoft.AspNetCore.Components.QuickGrid.EntityFrameworkAdapter | 8.0.2
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 8.0.2
Microsoft.AspNetCore.Components.Web | 8.0.2
Microsoft.AspNetCore.Components.WebAssembly.Server | 8.0.2
Microsoft.AspNetCore.ConcurrencyLimiter | 8.0.2
Microsoft.AspNetCore.DataProtection.Extensions | 8.0.2
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 8.0.2
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 8.0.2
Microsoft.AspNetCore.Grpc.Swagger | 0.8.2
Microsoft.AspNetCore.Grpc.JsonTranscoding | 8.0.2
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 8.0.2
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 8.0.2
Microsoft.AspNetCore.OpenApi | 8.0.2
Microsoft.AspNetCore.Owin | 8.0.2
Microsoft.Extensions.Localization.Abstractions | 8.0.2
Microsoft.Extensions.Localization | 8.0.2
Microsoft.Extensions.ObjectPool | 8.0.2
dotnet-sql-cache | 8.0.2
Microsoft.AspNetCore.App.Runtime.win-x86 | 8.0.2
Microsoft.AspNetCore.App.Runtime.win-arm64 | 8.0.2
Microsoft.AspNetCore.Cryptography.Internal | 8.0.2
Microsoft.AspNetCore.Connections.Abstractions | 8.0.2
Microsoft.AspNetCore.Cryptography.KeyDerivation | 8.0.2
Microsoft.AspNetCore.DataProtection | 8.0.2
Microsoft.AspNetCore.DataProtection.Abstractions | 8.0.2
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 8.0.2
Microsoft.AspNetCore.Metadata | 8.0.2
Microsoft.AspNetCore.MiddlewareAnalysis | 8.0.2
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 8.0.2
Microsoft.AspNetCore.Mvc.Testing | 8.0.2
Microsoft.AspNetCore.OutputCaching.StackExchangeRedis | 8.0.2
Microsoft.AspNetCore.SignalR.Common | 8.0.2
Microsoft.AspNetCore.SignalR.Protocols.Json | 8.0.2
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 8.0.2
Microsoft.AspNetCore.SignalR.Specification.Tests | 8.0.2
Microsoft.AspNetCore.WebUtilities | 8.0.2
Microsoft.Extensions.ApiDescription.Client | 8.0.2
Microsoft.AspNetCore.App.Runtime.linux-arm | 8.0.2
Microsoft.AspNetCore.App.Runtime.osx-x64 | 8.0.2
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 8.0.2
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 8.0.2
Microsoft.DotNet.Web.ItemTemplates.8.0 | 8.0.2
Microsoft.DotNet.Common.ItemTemplates | 8.0.102
FSharp.Compiler.Service | 43.8.101
Microsoft.DotNet.ApiCompat.Task | 8.0.102
Microsoft.NET.Build.Containers | 8.0.102
FSharp.Core | 8.0.101
Microsoft.DotNet.ApiCompat.Tool | 8.0.102
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.102
System.Drawing.Common | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-x64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-x64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-arm64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-arm64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-arm64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-x64 | 8.0.2
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x64 | 8.0.2
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-arm64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-arm64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-x64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64.Msi.x64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64.Msi.arm64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64.Msi.x64 | 8.0.2
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.arm64 | 8.0.2
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x86 | 8.0.2
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-arm64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-x64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64.Msi.x64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64.Msi.x64 | 8.0.2
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.arm64 | 8.0.2
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x86 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64 | 8.0.2
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-arm64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-x64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64.Msi.arm64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64.Msi.arm64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64 | 8.0.2
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x86 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64 | 8.0.2
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64.Msi.arm64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64 | 8.0.2
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-x64 | 8.0.2
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.arm64 | 8.0.2
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100 | 8.0.2
Microsoft.EntityFrameworkCore | 8.0.2
Microsoft.Data.Sqlite | 8.0.2
Microsoft.Data.Sqlite.Core | 8.0.2
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 8.0.2
Microsoft.EntityFrameworkCore.Design | 8.0.2
Microsoft.EntityFrameworkCore.Cosmos | 8.0.2
Microsoft.EntityFrameworkCore.InMemory | 8.0.2
Microsoft.EntityFrameworkCore.Proxies | 8.0.2
Microsoft.EntityFrameworkCore.Relational | 8.0.2
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 8.0.2
Microsoft.EntityFrameworkCore.Specification.Tests | 8.0.2
dotnet-ef | 8.0.2
Microsoft.EntityFrameworkCore.Abstractions | 8.0.2
Microsoft.EntityFrameworkCore.Analyzers | 8.0.2
Microsoft.EntityFrameworkCore.Sqlite.Core | 8.0.2
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 8.0.2
Microsoft.EntityFrameworkCore.SqlServer.Abstractions | 8.0.2
Microsoft.EntityFrameworkCore.SqlServer.HierarchyId | 8.0.2
Microsoft.EntityFrameworkCore.SqlServer | 8.0.2
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 8.0.2
Microsoft.EntityFrameworkCore.Tools | 8.0.2
Microsoft.EntityFrameworkCore.Templates | 8.0.2
Microsoft.EntityFrameworkCore.Sqlite | 8.0.2
Microsoft.TemplateEngine.Abstractions | 8.0.102
Microsoft.TemplateEngine.Authoring.CLI | 8.0.102
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.102
Microsoft.TemplateEngine.Authoring.Templates | 8.0.102
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.102
Microsoft.TemplateEngine.Core.Contracts | 8.0.102
Microsoft.TemplateEngine.Edge | 8.0.102
Microsoft.TemplateEngine.IDE | 8.0.102
Microsoft.TemplateEngine.Core | 8.0.102
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.102
Microsoft.TemplateEngine.Samples | 8.0.102
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.102
Microsoft.TemplateEngine.Utils | 8.0.102
Microsoft.TemplateSearch.Common | 8.0.102
FSharp.Compiler.Service | 43.8.200
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.200
Microsoft.DotNet.ApiCompat.Task | 8.0.200
Microsoft.DotNet.Common.ItemTemplates | 8.0.200
Microsoft.NET.Build.Containers | 8.0.200
FSharp.Core | 8.0.200
Microsoft.DotNet.ApiCompat.Tool | 8.0.200
Microsoft.TemplateEngine.Core.Contracts | 8.0.200-preview.24060.12
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.200-preview.24060.12
Microsoft.TemplateEngine.Authoring.CLI | 8.0.200-preview.24060.12
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.200-preview.24060.12
Microsoft.TemplateEngine.IDE | 8.0.200-preview.24060.12
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.200-preview.24060.12
Microsoft.TemplateSearch.Common | 8.0.200-preview.24060.12
Microsoft.TemplateEngine.Core | 8.0.200-preview.24060.12
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.200-preview.24060.12
Microsoft.TemplateEngine.Authoring.Templates | 8.0.200-preview.24060.12
Microsoft.TemplateEngine.Abstractions | 8.0.200-preview.24060.12
Microsoft.TemplateEngine.Edge | 8.0.200-preview.24060.12
Microsoft.TemplateEngine.Samples | 8.0.200-preview.24060.12
Microsoft.TemplateEngine.Utils | 8.0.200-preview.24060.12
Microsoft.CodeAnalysis.Analyzers | 3.11.0-beta1.23614.1
Microsoft.CodeAnalysis.BannedApiAnalyzers | 3.11.0-beta1.23614.1
Text.Analyzers | 3.11.0-beta1.23614.1
Microsoft.CodeAnalysis.ResxSourceGenerator | 3.11.0-beta1.23614.1
Microsoft.CodeAnalysis.Metrics | 4.0.0-beta1.23614.1
Microsoft.CodeAnalysis.RulesetToEditorconfigConverter | 3.11.0-beta1.23614.1
Microsoft.CodeAnalysis.NetAnalyzers | 8.0.0-preview.23614.1
Microsoft.CodeAnalysis.PublicApiAnalyzers | 3.11.0-beta1.23614.1
Microsoft.CodeAnalysis.AnalyzerUtilities | 3.11.0-beta1.23614.1
Microsoft.CodeAnalysis.PerformanceSensitiveAnalyzers | 3.11.0-beta1.23614.1
Roslyn.Diagnostics.Analyzers | 3.11.0-beta1.23614.1

[//]: # ( Runtime 8.0.2)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/738dd855-9340-4dda-93b8-e11444113a66/9516b9e2023e158cc2439ac5dd7dbee2/dotnet-runtime-8.0.2-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9de452db-acbe-48eb-b3f0-305a4e48e32a/515bbe7e3e1deef5ab9a4b8123b901ca/dotnet-runtime-8.0.2-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4f9331fe-31a9-49a8-bd70-8a55a3318936/54c8b154eb5a78355b013af0cf78bad8/dotnet-runtime-8.0.2-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5e13608d-2f8e-44bb-ab1e-f4d804100074/3cdb710d3949c31a4648552f3b1d3184/dotnet-runtime-8.0.2-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e57d7fe5-06c8-44ad-861b-e6b598adf5d3/d682ed25fe5bd0cedd8676d95603072d/dotnet-runtime-8.0.2-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/307e4bf7-53c1-4b03-a2e5-379151ab3a04/140e7502609d45dfd83e4750b4bb5178/dotnet-runtime-8.0.2-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4e5292ef-8f26-4ead-9632-03243fd4f907/761efaa7a63c52d69e6ef085b338ff41/dotnet-runtime-8.0.2-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7b73f69-39ca-4d2a-bd02-a72abb3a4fc5/6d68aa25f4576b70fff4925fb4e69c4b/dotnet-runtime-8.0.2-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d9899395-7f5a-45b4-acd0-8f0ad2d3dad8/008391ac2859dc0fca2eed8ff6bdd3f6/dotnet-runtime-8.0.2-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/414af43f-fdc6-4e8e-bbff-8b544a6627a8/0719a2eafa1d0d5f73ee0a7aae4ce670/dotnet-runtime-8.0.2-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/f6128726-3c33-4cc3-a3c7-69855be7a734/cd59b37c259abbbcb1e8f6dc263a5d29/dotnet-runtime-8.0.2-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/5e795f0e-2907-4b42-946f-c863c6505edf/128bad1a73f85294017255ea71a71866/dotnet-runtime-8.0.2-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a4bc7333-6e30-4e2d-b300-0b4f23537e5b/4b81af6d46a02fba5d9ce030af438c67/dotnet-runtime-8.0.2-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8abf4502-4a22-4a2e-bea0-9fe73379d62e/88146c1d41e53e08f9dbc92a217143de/dotnet-runtime-8.0.2-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e4987764-bda2-4a72-8820-52605f30e899/f5b412fec80d7f4b20fc4ac7740f7279/dotnet-runtime-8.0.2-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/265b103c-39a1-4f44-b85a-1d90373d26b1/7fc1a69ab29cd2705933ec761c18fe7f/dotnet-runtime-8.0.2-win-x86.zip

[//]: # ( WindowsDesktop 8.0.2)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/851642d5-5a3f-48f5-b608-a8bc8251591f/1e5beaba1586f70cf882323d91fa7be1/windowsdesktop-runtime-8.0.2-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/5d6235b4-17d3-462a-84e9-0646edb28d80/f2234e0e4c09c2a362287d97a39ffcb2/windowsdesktop-runtime-8.0.2-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/84ba33d4-4407-4572-9bfa-414d26e7c67c/bb81f8c9e6c9ee1ca547396f6e71b65f/windowsdesktop-runtime-8.0.2-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d8d5df9e-52a3-413b-9db3-fe4740e308eb/d9be81be4541911ed2be53cec3f460e0/windowsdesktop-runtime-8.0.2-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9b77b480-7e32-4321-b417-a41e0f8ea952/3922bbf5538277b1d41e9b49ee443673/windowsdesktop-runtime-8.0.2-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/bb0b6ab8-649b-4c1e-98d1-8c175a355d88/5a44e15273d8b7063e6da2365c7ba3c9/windowsdesktop-runtime-8.0.2-win-x86.zip

[//]: # ( ASP 8.0.2)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/272dbea2-057e-4032-9857-7e00b476ceec/3c472df94b1c3f5e0d009cbccc9256a6/aspnetcore-runtime-8.0.2-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bdfd0216-539e-4dfd-81ea-1b7a77dda929/59a62884bdb8684ef0e4f434eaea0ca3/aspnetcore-runtime-8.0.2-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d0a94580-5249-41d5-be77-5500507a4336/eabf58603de2533792aafc0a35f668c2/aspnetcore-runtime-8.0.2-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3de102d9-40b6-42a4-b3bb-6e58a210ef3d/6379916327625a9e9166e66a02e66d15/aspnetcore-runtime-8.0.2-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/563ce630-fc25-480c-bff8-5c087e6dc8bd/403acb7bc6825deab9bc426740cd4cd8/aspnetcore-runtime-8.0.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d6d79cc3-df2f-4680-96ff-a7198f461139/df025000eaf5beb85d9137274a8c53ea/aspnetcore-runtime-8.0.2-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a5692569-6092-4db1-9d5c-4862265a7b5b/7173de926da466e21ab9c7666a31dee3/aspnetcore-runtime-8.0.2-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a44da2c3-cb74-4ffe-af5a-34286598a885/263f113228e88df3f654510c9092f68b/aspnetcore-runtime-8.0.2-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/6a412067-1e24-474c-92c1-fe14cc33eb14/6289222047347ca3d5b388463614bd83/aspnetcore-runtime-8.0.2-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/34d3e426-9f3c-45a6-8496-f21b3adbbf5f/475aec17378cc8ab0fcfe535e84698f9/aspnetcore-runtime-8.0.2-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f2b824c4-d65c-406a-9d3c-3fc4c45f402b/54a17e458c67caf84e4117783e1d2c40/aspnetcore-runtime-8.0.2-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2a1c05bf-8147-4bb9-abf2-ef886871eb73/fec274762cdf5935369116a4f38d43ad/aspnetcore-runtime-8.0.2-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e2585d65-56c9-4e68-b117-674764461a7e/dd5fe9ed35d2d2584aab61278429f53d/aspnetcore-runtime-8.0.2-win-x86.zip
[aspnetcore-runtime-composite-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/208558f7-99d0-46e5-8ee0-49c0aea0bd98/bf08ddbb231ec89e7dc6a86935358e43/aspnetcore-runtime-composite-8.0.2-linux-arm.tar.gz
[aspnetcore-runtime-composite-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9637484d-7b26-4b24-b1f7-d36a8014f822/beaadc6e41f89cb1e9603ebc52e32b63/aspnetcore-runtime-composite-8.0.2-linux-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ac829988-bbd8-44be-ae46-4b0aecbbe3f9/981efee9eab033fdc679d023d9689a08/aspnetcore-runtime-composite-8.0.2-linux-musl-arm.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e2ea6875-805c-43f7-9caa-cb767d3b643b/8296236168dfdf269a569bbc1d685896/aspnetcore-runtime-composite-8.0.2-linux-musl-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d409796e-4c01-4722-b1f4-7ad09f51083c/d369363bb63759f0a958e3c57ca1e3a1/aspnetcore-runtime-composite-8.0.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-composite-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bfd1bc98-e950-4e26-bbc6-309d1256f056/b1e9268c8d44bbe3c1b8a8104925e20b/aspnetcore-runtime-composite-8.0.2-linux-x64.tar.gz
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/98ff0a08-a283-428f-8e54-19841d97154c/8c7d5f9600eadf264f04c82c813b7aab/dotnet-hosting-8.0.2-win.exe

[//]: # ( SDK 8.0.200)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c8caa3f2-2b14-4aae-8829-1e5229f8f547/f3f059cc07aa6c23156670f71cf8dbb5/dotnet-sdk-8.0.200-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cb9d4eda-118d-4db0-823e-77486a94b1c3/f12cc8c101479f59cb18700b4433de15/dotnet-sdk-8.0.200-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/54b8d299-2657-4816-90ff-2deac10770a0/11b5552623a49d71be22d59f43dea313/dotnet-sdk-8.0.200-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1db2e933-d512-4cb2-bed1-c97abee06dd0/bab7a156742d296c2bf0c9fcbf3a8798/dotnet-sdk-8.0.200-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4501f260-dcda-4e91-bf47-e0c0aa7cf0da/8cc97d74df5c140b1d5c1f85e31bffc9/dotnet-sdk-8.0.200-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7a1bac6e-364e-4de4-b76d-a1e3af5af8d2/292c64839df2435b4289766af556e144/dotnet-sdk-8.0.200-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/87f99dbc-f7aa-4247-b40b-b1206093c33f/86625a11ac2b702bbc5aa49f529ea8da/dotnet-sdk-8.0.200-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/86934007-0cb8-4cab-9ea3-393654979909/07d71dfe0110f4b89c17af9c87e88948/dotnet-sdk-8.0.200-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f1e3adeb-edfd-4429-a9bf-e4c790788e2f/1d57d12283ee0086d5652f9ccc2218c7/dotnet-sdk-8.0.200-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4aa51c1b-65de-4f5e-baaf-d9eb5aec2cd0/5613f60425a4ab151b299ec4ecde39ea/dotnet-sdk-8.0.200-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/3730a321-327e-4576-b1c9-3784c7622767/11c56f7342a6f0e1242684a0c1234f58/dotnet-sdk-8.0.200-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/acbf59c4-c194-4ff7-88e5-1dbd12b3a158/5a2ebb1e32be3704f67f48aa2b3a7da2/dotnet-sdk-8.0.200-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9f9ad302-a698-4fab-9765-e313f7e14151/8ad751b6cfc11276b4e2adef4e319db7/dotnet-sdk-8.0.200-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4061a59e-63ff-4c53-8070-e6fd6825eb6b/86d97324d285174d4110b0fd7b3a9808/dotnet-sdk-8.0.200-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/82d826cc-3aaa-4d8c-98af-889bd40fe50b/32ae8125fb5b475864ee91f9a618a2ae/dotnet-sdk-8.0.200-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0a25c416-3109-46f2-99ab-c776b549e39d/43f477139ece7d8e937ea05210e35b3b/dotnet-sdk-8.0.200-win-x86.zip
