# .NET 8.0.3 - March 12, 2024

The .NET 8.0.3 and .NET SDK 8.0.202 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.202
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/monitor/base](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor-base.md): .NET Monitor Base
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 8.0 Blog][dotnet-blog]

.NET 8.0.3 release carries security and non-security fixes.

[CVE-2024-21392 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-21392)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 8.0 . This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A vulnerability exists in .NET where specially crafted requests may cause a resource leak, leading to a Denial of Service


[CVE-2024-26190 |  Microsoft QUIC Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-26190)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 8.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A Vulnerability exist in MsQuic.dll which might result in a peer to allocate small chunks of memory as long as connection stays alive.

## Visual Studio Compatibility

You need [Visual Studio 17.8](https://visualstudio.microsoft.com) or later to use .NET 8.0 on Windows. While not officially supported, we’ve also enabled rudimentary support for .NET 8 in Visual Studio for Mac. Users have to enable a preview feature in Preferences to enable the IDE to discover and use the .NET 8 SDK for creating, loading, building, and debugging projects. The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 8.0 and C# 12.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9214](https://github.com/dotnet/core/issues/9214) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.3.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.3-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.3-sha.txt

[linux-install]: ../install-linux.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/march-2024-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-dotnet-8/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.3+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.3+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.3+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.3+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.2xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 8.0.3
Microsoft.Windows.Compatibility | 8.0.3
Microsoft.WindowsDesktop.App.Ref | 8.0.3
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 8.0.3
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 8.0.3
Microsoft.NET.ILLink.Tasks | 8.0.3
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x86 | 8.0.3
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.arm64 | 8.0.3
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 8.0.3
Microsoft.NETCore.App.Host.linux-musl-x64 | 8.0.3
Microsoft.NETCore.App.Host.linux-arm | 8.0.3
Microsoft.NETCore.App.Host.osx-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x86 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.browser-wasm | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Runtime.NativeAOT.osx-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.win-arm64 | 8.0.3
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.3
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.3
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.3
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.3
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 8.0.3
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 8.0.3
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 8.0.3
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.3
runtime.osx-arm64.Microsoft.DotNet.ILCompiler | 8.0.3
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.3
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 8.0.3
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.3
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 8.0.3
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 8.0.3
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 8.0.3
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 8.0.3
Microsoft.NET.Runtime.WebAssembly.Sdk | 8.0.3
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 8.0.3
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 8.0.3
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk | 8.0.3
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x64 | 8.0.3
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x64 | 8.0.3
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x86 | 8.0.3
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Crossgen2.linux-arm | 8.0.3
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x64 | 8.0.3
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100 | 8.0.3
Microsoft.NETCore.App.Crossgen2.win-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.browser-wasm | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 8.0.3
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.NativeAOT.ios-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 8.0.3
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 8.0.3
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.3
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 8.0.3
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.3
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.3
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 8.0.3
runtime.win-x64.Microsoft.NETCore.DotNetHost | 8.0.3
runtime.win-x86.Microsoft.NETCore.DotNetHost | 8.0.3
Microsoft.NETCore.App.Ref | 8.0.3
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-x64 | 8.0.3
Microsoft.DotNet.ILCompiler | 8.0.3
Microsoft.Extensions.DependencyInjection.Abstractions | 8.0.1
Microsoft.NET.Runtime.Android.Sample.Mono | 8.0.3
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 8.0.3
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 8.0.3
Microsoft.NET.Runtime.wasm.Sample.Mono | 8.0.3
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 8.0.3
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.arm64 | 8.0.3
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100 | 8.0.3
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100 | 8.0.3
Microsoft.NETCore.App.Crossgen2.osx-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 8.0.3
Microsoft.NETCore.App.Runtime.osx-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.win-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Runtime.win-x86 | 8.0.3
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 8.0.3
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 8.0.3
Microsoft.Extensions.Logging.Abstractions | 8.0.1
Microsoft.NET.Runtime.MonoTargets.Sdk | 8.0.3
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 8.0.3
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 8.0.3
Microsoft.NETCore.App.Crossgen2.linux-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.ios-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 8.0.3
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.NativeAOT.osx-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 8.0.3
Microsoft.NETCore.DotNetAppHost | 8.0.3
Microsoft.NETCore.DotNetHostResolver | 8.0.3
Microsoft.NETCore.DotNetHost | 8.0.3
Microsoft.NETCore.DotNetHostPolicy | 8.0.3
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 8.0.3
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 8.0.3
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.3
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.3
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 8.0.3
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.3
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.3
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.3
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.3
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 8.0.3
System.Text.Json | 8.0.3
Microsoft.Extensions.Options | 8.0.2
Microsoft.NET.Runtime.iOS.Sample.Mono | 8.0.3
Microsoft.NET.Runtime.LibraryBuilder.Sdk | 8.0.3
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 8.0.3
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 8.0.3
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 8.0.3
Microsoft.NET.Runtime.WebAssembly.Templates | 8.0.3
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 8.0.3
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 8.0.3
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x64 | 8.0.3
Microsoft.NET.Sdk.WebAssembly.Pack | 8.0.3
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.arm64 | 8.0.3
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 8.0.3
Microsoft.NETCore.App.Host.linux-arm64 | 8.0.3
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 8.0.3
Microsoft.NETCore.App.Host.linux-musl-arm64 | 8.0.3
Microsoft.NETCore.App.Host.win-arm64 | 8.0.3
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 8.0.3
Microsoft.NETCore.App.Host.linux-bionic-x64 | 8.0.3
Microsoft.NETCore.App.Host.win-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x86 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.NativeAOT.tvos-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 8.0.3
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.3
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 8.0.3
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.3
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.3
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.3
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.3
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.3
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 8.0.3
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.linux-musl-arm | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 8.0.3
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 8.0.3
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 8.0.3
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.3
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 8.0.3
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.3
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 8.0.3
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.3
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 8.0.3
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 8.0.3
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.3
runtime.win-x64.Microsoft.DotNet.ILCompiler | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.linux-arm | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.linux-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 8.0.3
Microsoft.NETCore.App.Crossgen2.win-x86 | 8.0.3
Microsoft.NETCore.App.Crossgen2.win-arm64 | 8.0.3
Microsoft.NETCore.App.Host.linux-musl-arm | 8.0.3
Microsoft.NETCore.App.Host.win-x86 | 8.0.3
Microsoft.NETCore.App.Host.linux-x64 | 8.0.3
Microsoft.NETCore.App.Host.osx-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvos-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.android-arm | 8.0.3
Microsoft.NETCore.App.Runtime.linux-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm | 8.0.3
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-x64 | 8.0.3
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 8.0.3
Microsoft.NETCore.App.Runtime.osx-arm64 | 8.0.3
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 8.0.3
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.3
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.3
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 8.0.3
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 8.0.3
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 8.0.3
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 8.0.3
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.3
Microsoft.AspNetCore.App.Runtime.linux-arm | 8.0.3
Microsoft.AspNetCore.App.Runtime.win-x64 | 8.0.3
Microsoft.DotNet.Web.ItemTemplates.8.0 | 8.0.3
Microsoft.Extensions.Caching.StackExchangeRedis | 8.0.3
Microsoft.Extensions.Caching.SqlServer | 8.0.3
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 8.0.3
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 8.0.3
Microsoft.Extensions.Identity.Core | 8.0.3
Microsoft.Extensions.Identity.Stores | 8.0.3
Microsoft.Extensions.Localization | 8.0.3
Microsoft.Extensions.Localization.Abstractions | 8.0.3
Microsoft.Extensions.Logging.AzureAppServices | 8.0.3
Microsoft.Extensions.WebEncoders | 8.0.3
Microsoft.Net.Http.Headers | 8.0.3
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 8.0.3
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 8.0.3
Microsoft.AspNetCore.Components.Authorization | 8.0.3
Microsoft.AspNetCore.Components.CustomElements | 8.0.3
Microsoft.AspNetCore.Components | 8.0.3
Microsoft.AspNetCore.Components.Analyzers | 8.0.3
Microsoft.AspNetCore.Components.QuickGrid | 8.0.3
Microsoft.AspNetCore.Components.WebAssembly.Server | 8.0.3
Microsoft.AspNetCore.Components.Forms | 8.0.3
Microsoft.AspNetCore.Components.QuickGrid.EntityFrameworkAdapter | 8.0.3
Microsoft.AspNetCore.Grpc.Swagger | 0.8.3
Microsoft.AspNetCore.Identity.UI | 8.0.3
Microsoft.AspNetCore.Http.Connections.Client | 8.0.3
Microsoft.AspNetCore.Hosting.WindowsServices | 8.0.3
Microsoft.AspNetCore.SignalR.Common | 8.0.3
Microsoft.AspNetCore.SignalR.Protocols.Json | 8.0.3
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 8.0.3
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 8.0.3
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 8.0.3
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 8.0.3
dotnet-sql-cache | 8.0.3
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 8.0.3
Microsoft.AspNetCore.Grpc.JsonTranscoding | 8.0.3
Microsoft.AspNetCore.SignalR.Specification.Tests | 8.0.3
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 8.0.3
Microsoft.AspNetCore.SpaProxy | 8.0.3
Microsoft.AspNetCore.SpaServices.Extensions | 8.0.3
Microsoft.DotNet.Web.Client.ItemTemplates | 8.0.3
Microsoft.DotNet.Web.ProjectTemplates.8.0 | 8.0.3
Microsoft.Extensions.ApiDescription.Client | 8.0.3
Microsoft.Extensions.Configuration.KeyPerFile | 8.0.3
Microsoft.Extensions.Diagnostics.HealthChecks | 8.0.3
Microsoft.Extensions.Features | 8.0.3
Microsoft.Extensions.FileProviders.Embedded | 8.0.3
Microsoft.Extensions.Http.Polly | 8.0.3
Microsoft.Extensions.ObjectPool | 8.0.3
AspNetCoreRuntime.8.0.x64 | 8.0.3
Microsoft.JSInterop.WebAssembly | 8.0.3
Microsoft.AspNetCore.App.Runtime.osx-x64 | 8.0.3
Microsoft.AspNetCore.App.Runtime.linux-x64 | 8.0.3
Microsoft.AspNetCore.App.Runtime.win-arm64 | 8.0.3
Microsoft.JSInterop | 8.0.3
AspNetCoreRuntime.8.0.x86 | 8.0.3
Microsoft.AspNetCore.App.Ref | 8.0.3
Microsoft.AspNetCore.Authentication.Facebook | 8.0.3
Microsoft.AspNetCore.Authentication.Certificate | 8.0.3
Microsoft.AspNetCore.Authentication.Google | 8.0.3
Microsoft.AspNetCore.Authentication.JwtBearer | 8.0.3
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 8.0.3
Microsoft.AspNetCore.Components.Web | 8.0.3
Microsoft.AspNetCore.Components.WebAssembly | 8.0.3
Microsoft.AspNetCore.Components.WebView | 8.0.3
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 8.0.3
Microsoft.AspNetCore.DataProtection | 8.0.3
Microsoft.AspNetCore.ConcurrencyLimiter | 8.0.3
Microsoft.AspNetCore.Cryptography.Internal | 8.0.3
Microsoft.AspNetCore.Cryptography.KeyDerivation | 8.0.3
Microsoft.AspNetCore.DataProtection.Abstractions | 8.0.3
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 8.0.3
Microsoft.AspNetCore.DataProtection.Extensions | 8.0.3
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 8.0.3
Microsoft.AspNetCore.HeaderPropagation | 8.0.3
Microsoft.AspNetCore.Http.Connections.Common | 8.0.3
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 8.0.3
Microsoft.AspNetCore.MiddlewareAnalysis | 8.0.3
Microsoft.AspNetCore.JsonPatch | 8.0.3
Microsoft.AspNetCore.Metadata | 8.0.3
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 8.0.3
Microsoft.AspNetCore.Mvc.Testing | 8.0.3
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 8.0.3
Microsoft.AspNetCore.Owin | 8.0.3
Microsoft.AspNetCore.OutputCaching.StackExchangeRedis | 8.0.3
Microsoft.AspNetCore.OpenApi | 8.0.3
Microsoft.AspNetCore.SignalR.Client.Core | 8.0.3
Microsoft.AspNetCore.SignalR.Client | 8.0.3
Microsoft.Authentication.WebAssembly.Msal | 8.0.3
Microsoft.AspNetCore.WebUtilities | 8.0.3
Microsoft.AspNetCore.TestHost | 8.0.3
Microsoft.dotnet-openapi | 8.0.3
Microsoft.Extensions.ApiDescription.Server | 8.0.3
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 8.0.3
Microsoft.AspNetCore.App.Runtime.win-x86 | 8.0.3
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 8.0.3
Microsoft.AspNetCore.Authentication.Negotiate | 8.0.3
Microsoft.AspNetCore.Authentication.OpenIdConnect | 8.0.3
Microsoft.AspNetCore.Authentication.WsFederation | 8.0.3
Microsoft.AspNetCore.Authentication.Twitter | 8.0.3
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 8.0.3
Microsoft.AspNetCore.AzureAppServicesIntegration | 8.0.3
Microsoft.AspNetCore.Authorization | 8.0.3
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 8.0.3
Microsoft.AspNetCore.Connections.Abstractions | 8.0.3
Microsoft.DotNet.ApiCompat.Task | 8.0.202
FSharp.Compiler.Service | 43.8.200
FSharp.Core | 8.0.200
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.202
Microsoft.DotNet.Common.ItemTemplates | 8.0.202
Microsoft.NET.Build.Containers | 8.0.202
Microsoft.DotNet.ApiCompat.Tool | 8.0.202
System.Drawing.Common | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-x64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-x64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-arm64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-arm64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64.Msi.arm64 | 8.0.3
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-arm64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-arm64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64.Msi.x64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64.Msi.x64 | 8.0.3
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x64 | 8.0.3
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.arm64 | 8.0.3
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.arm64 | 8.0.3
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-arm64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-x64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-x64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64.Msi.arm64 | 8.0.3
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.arm64 | 8.0.3
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x86 | 8.0.3
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x86 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-arm64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-x64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-arm64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64.Msi.x64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-x64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-x64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64.Msi.x64 | 8.0.3
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x86 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64 | 8.0.3
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100 | 8.0.3
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64.Msi.arm64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64.Msi.arm64 | 8.0.3
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64 | 8.0.3
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100 | 8.0.3
Microsoft.EntityFrameworkCore.SqlServer.Abstractions | 8.0.3
Microsoft.EntityFrameworkCore.Specification.Tests | 8.0.3
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 8.0.3
Microsoft.EntityFrameworkCore.Analyzers | 8.0.3
Microsoft.EntityFrameworkCore.Design | 8.0.3
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 8.0.3
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 8.0.3
Microsoft.Data.Sqlite.Core | 8.0.3
dotnet-ef | 8.0.3
Microsoft.Data.Sqlite | 8.0.3
Microsoft.EntityFrameworkCore | 8.0.3
Microsoft.EntityFrameworkCore.Abstractions | 8.0.3
Microsoft.EntityFrameworkCore.Cosmos | 8.0.3
Microsoft.EntityFrameworkCore.Sqlite | 8.0.3
Microsoft.EntityFrameworkCore.InMemory | 8.0.3
Microsoft.EntityFrameworkCore.Proxies | 8.0.3
Microsoft.EntityFrameworkCore.Relational | 8.0.3
Microsoft.EntityFrameworkCore.SqlServer.HierarchyId | 8.0.3
Microsoft.EntityFrameworkCore.Sqlite.Core | 8.0.3
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 8.0.3
Microsoft.EntityFrameworkCore.SqlServer | 8.0.3
Microsoft.EntityFrameworkCore.Templates | 8.0.3
Microsoft.EntityFrameworkCore.Tools | 8.0.3
Microsoft.TemplateEngine.Authoring.CLI | 8.0.202
Microsoft.TemplateEngine.Abstractions | 8.0.202
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.202
Microsoft.TemplateEngine.Authoring.Templates | 8.0.202
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.202
Microsoft.TemplateEngine.Core | 8.0.202
Microsoft.TemplateEngine.IDE | 8.0.202
Microsoft.TemplateEngine.Core.Contracts | 8.0.202
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.202
Microsoft.TemplateEngine.Samples | 8.0.202
Microsoft.TemplateEngine.Utils | 8.0.202
Microsoft.TemplateSearch.Common | 8.0.202
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.202
Microsoft.TemplateEngine.Edge | 8.0.202
Microsoft.DotNet.ApiCompat.Task | 8.0.103
FSharp.Compiler.Service | 43.8.102
Microsoft.DotNet.ApiCompat.Tool | 8.0.103
Microsoft.DotNet.Common.ItemTemplates | 8.0.103
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.103
Microsoft.NET.Build.Containers | 8.0.103
FSharp.Core | 8.0.102
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.103
Microsoft.TemplateEngine.Core | 8.0.103
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.103
Microsoft.TemplateEngine.Authoring.CLI | 8.0.103
Microsoft.TemplateEngine.Authoring.Templates | 8.0.103
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.103
Microsoft.TemplateEngine.Abstractions | 8.0.103
Microsoft.TemplateEngine.Core.Contracts | 8.0.103
Microsoft.TemplateEngine.Edge | 8.0.103
Microsoft.TemplateEngine.Utils | 8.0.103
Microsoft.TemplateEngine.Samples | 8.0.103
Microsoft.TemplateSearch.Common | 8.0.103
Microsoft.TemplateEngine.IDE | 8.0.103
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.103

[//]: # ( Runtime 8.0.3)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a3caf5aa-a29a-41a2-b3db-7d68b606dc1a/478f27b65c19dafd3c3120fbdeb99295/dotnet-runtime-8.0.3-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/988a1d6e-6bfb-406c-90ba-682f5c11a7fc/28208806b0a6151c4e5d9e1441b01a6f/dotnet-runtime-8.0.3-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/da52a443-fcc6-4922-b21a-613400853807/823cf334f9915cca2a9782d8aa6394a5/dotnet-runtime-8.0.3-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f4adb123-7b54-4b22-8984-559154ed94e2/88a4fcb21274d9a6118dd99994e724d1/dotnet-runtime-8.0.3-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf4826c7-86b2-4811-b474-7e9052ce4de9/6cc534eb1530c8c28745af317c3b35d5/dotnet-runtime-8.0.3-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ed0c9129-950a-48db-80be-e770daf2db41/53879e5802bc6e76bac55c1b8154ed06/dotnet-runtime-8.0.3-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ce5fba93-9d2f-4f16-b091-76ad1be06f05/ea39bddf82f228c7ec293ef1a34ce944/dotnet-runtime-8.0.3-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/08f11d3e-84de-440c-8982-0c8c62273548/d8a497c6cae9b84456d0b90cc7635231/dotnet-runtime-8.0.3-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/02be54d9-bf36-4a01-8a68-cd0cc05e93f2/ab893ef01800b28b66a99c61c4dabdc4/dotnet-runtime-8.0.3-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/564a929b-4f15-490b-895e-5260338cbae1/1db7fd97d0907d3911ac3e4dda32fbb2/dotnet-runtime-8.0.3-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/4b679ae1-8e5d-4e91-a949-94bada37356a/662cd1bc6d6c058c94df4113268da17c/dotnet-runtime-8.0.3-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/bec390b1-bfea-401b-a6cf-9f47a84f45cc/710adc347accf08a2ece2ccfe98abf1d/dotnet-runtime-8.0.3-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/961dfc84-ea72-48a2-b3f4-b82cefc34580/6ac50b6bf244a2c5481ad705a92cf843/dotnet-runtime-8.0.3-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/420ca01f-4528-43c0-893b-321ed0f9087a/c340930ab3e48da2abe868244415c846/dotnet-runtime-8.0.3-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c8d7a77c-5647-4e38-9ed8-edf82328497d/56130e071ac13c3660b0f3a0d60914c7/dotnet-runtime-8.0.3-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/de7b59bd-9b75-4cc3-9fa9-e0226a491a6d/66a8866da41f8ca1485455778b0d8279/dotnet-runtime-8.0.3-win-x86.zip

[//]: # ( WindowsDesktop 8.0.3)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/bd4bf739-106e-44af-9f0d-a6a777976512/e9f077b8cb33b574df2f5cf986acddd8/windowsdesktop-runtime-8.0.3-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/8952a411-3d5a-48ee-bd24-6c8da21ad889/87a87f3a8f0ecaaa1c4c875e77b66a17/windowsdesktop-runtime-8.0.3-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/51bc18ac-0594-412d-bd63-18ece4c91ac4/90b47b97c3bfe40a833791b166697e67/windowsdesktop-runtime-8.0.3-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7b548de8-aa07-498f-8fa0-0cd0e6c1f114/b6b66ec9ba495b71332bebe337905174/windowsdesktop-runtime-8.0.3-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c629f243-5125-4751-a5ff-e78fa45646b1/85777e3e3f58f863d884fd4b8a1453f2/windowsdesktop-runtime-8.0.3-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6d278466-4714-4aef-b809-3f084c40640c/f593db8727573a64e19e843a8e33dab4/windowsdesktop-runtime-8.0.3-win-x86.zip

[//]: # ( ASP 8.0.3)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/16463b95-fb59-4769-86ed-d57012b2da25/d7f5df1e4b840ebc8d001d01b8cfdad5/aspnetcore-runtime-8.0.3-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9feb7c60-3821-433f-994d-c6861b341d3b/5b90405a9978455b10ce6f1fc058fc1a/aspnetcore-runtime-8.0.3-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9ac25bad-92be-493e-b21c-95210d6db3ce/ce350da31037d6adda3836fe01881200/aspnetcore-runtime-8.0.3-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a4b5054e-8f86-4e8e-9651-c08218204718/7db506957e22a45007491efe607f8bb2/aspnetcore-runtime-8.0.3-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2db04bdc-48e6-42e7-a002-392742513cba/9b62b6516f8908f918c5de57732bcea3/aspnetcore-runtime-8.0.3-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1371dc2-eed2-47be-9af3-ae060dbe3c7d/bd509e0a87629764ed47608466d183e6/aspnetcore-runtime-8.0.3-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/794f6ac7-83e4-4af7-9150-7722bf51b5ed/fb380221e5933bc50e5266ddae54e083/aspnetcore-runtime-8.0.3-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bb76b58a-59e9-4652-b457-ca7ce7f124d4/1afc9b4da60ab79bd103caa9516b8259/aspnetcore-runtime-8.0.3-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a5cc1bef-f350-4935-964d-7646f6b6a1ec/1a628279b86db34d77d94c76b0b2edad/aspnetcore-runtime-8.0.3-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e91876a9-1760-42cb-a6f4-97c57e9cca52/b433fcf4768929539f17e1908cb315bf/aspnetcore-runtime-8.0.3-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/086d1dd6-57a5-437a-a1ef-549cf702fb48/dd4a8fe6c53a1016a414d6f2925c1323/aspnetcore-runtime-8.0.3-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6e92e2d6-32bb-4ff7-9424-78cd278076e8/7b23ff0e6bb04586ad90a0289b31d8d5/aspnetcore-runtime-8.0.3-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e1efd12b-9598-4b70-ad83-496563ae3f7c/da67696e4232886f52d50bb8ecda5ab1/aspnetcore-runtime-8.0.3-win-x86.zip
[aspnetcore-runtime-composite-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d051a9af-a43d-40ca-9215-7ef492d0b0b1/c4723cb6e5e24b40b5b8f70ab04d2ae3/aspnetcore-runtime-composite-8.0.3-linux-arm.tar.gz
[aspnetcore-runtime-composite-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c05b3de1-d870-4278-847f-9fa0137876af/2f4f5a83ffafed78ce15aa1a3ffeef8c/aspnetcore-runtime-composite-8.0.3-linux-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/31c7c16a-cd4a-414e-96bb-6d3adcd111ce/3167aafc5a23e700cf51424cb070bee6/aspnetcore-runtime-composite-8.0.3-linux-musl-arm.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d798189f-6d2a-479e-9708-54a3f8de331e/8bdb69c35c8de95de0bf740f18e224a2/aspnetcore-runtime-composite-8.0.3-linux-musl-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/899fa9d0-6101-4501-9370-5747d89429e1/d547ff7de190cb1cb966607c142a2432/aspnetcore-runtime-composite-8.0.3-linux-musl-x64.tar.gz
[aspnetcore-runtime-composite-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c6a46d32-ccef-4c2b-aa3e-333402eb9a07/99f0e14e6170923d519117e625fa7ba8/aspnetcore-runtime-composite-8.0.3-linux-x64.tar.gz
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/20598243-c38f-4538-b2aa-af33bc232f80/ea9b2ca232f59a6fdc84b7a31da88464/dotnet-hosting-8.0.3-win.exe

[//]: # ( SDK 8.0.202)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ff14287d-75cb-44cd-a581-d6132204848b/2a124effe81c79bd9e116be96ce33b23/dotnet-sdk-8.0.202-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d0a8cedc-978a-408c-a9d2-07d22b45b5dd/1b985478744a545465c0af18cff40a92/dotnet-sdk-8.0.202-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6e4e49ac-d1de-409c-a1be-12713b1c0df4/cc1d9b80d2c7a8d742ceba69beffe623/dotnet-sdk-8.0.202-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7b3a5036-3c38-40af-ad38-e1936051ae32/069ce2295a75cc698b6475ba21396e38/dotnet-sdk-8.0.202-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/50073b70-82d3-4929-8d85-db176b930953/fe3ea3464258e296778cf27cbd520ce9/dotnet-sdk-8.0.202-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/14e4bb95-1b59-441e-87b9-58e9feb93426/b61087ddece464f4dc1a3d4e0f31aab3/dotnet-sdk-8.0.202-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4f1f4135-d42a-4ede-9838-85672f82f08c/fffd37265287676bb7b745f4531d8607/dotnet-sdk-8.0.202-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0b9cbb0b-0db0-4c8a-997d-aa85b883da5e/40699a42290e517061d38529c3e17359/dotnet-sdk-8.0.202-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/15530a86-8714-4828-a934-8058c3673e1a/738ed9cd4f6eaf7367c9bda26999652e/dotnet-sdk-8.0.202-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b04586c5-24bf-40cf-ab29-60f508b9bc24/9f34421826fcfc9b7d4e785b1efdb99b/dotnet-sdk-8.0.202-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b9338ab2-1488-4770-a952-0d5a65c5def8/5c7249d5431d4cf3d91e9ca9b57c5e48/dotnet-sdk-8.0.202-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/90ada9cb-1200-4fe7-9679-1ca78139017c/6608ba3bd280fc84e9f9e3c7f18a9c33/dotnet-sdk-8.0.202-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f71e824f-ceab-444f-bd41-7a3852cb9d8a/f9227b2b0c3111777f349d9200592fbd/dotnet-sdk-8.0.202-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5eaf9f28-b8a9-4fa4-a8cd-8feeb6d35b39/65c5410d191c9e7f561b94744c15e70d/dotnet-sdk-8.0.202-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e619b4bf-5f5a-4e95-8f98-f46962592c88/f5538efb5bca899cda6718c237dd0988/dotnet-sdk-8.0.202-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d1cc5284-31ef-4aa8-adae-8a696eb57a09/d9a171bd3d227be64c6dd7d07d548a59/dotnet-sdk-8.0.202-win-x86.zip
