# .NET 8.0.4 - April 09, 2024

The .NET 8.0.4 and .NET SDK 8.0.204 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.204
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/monitor/base](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor-base.md): .NET Monitor Base
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples


## Notable Changes

 [.NET 8.0 Blog][dotnet-blog]

.NET 8.0.4 release carries security and non-security fixes.

[CVE-2024-21409 | .NET Elevation of Privilege Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-21409)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 7.0 ,and .NET 8.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability. This is a Windows only vulnerability.

A use-after-free vulnerability exists in WPF which may result in Elevation of Privilege when viewing untrusted documents.

## Visual Studio Compatibility

You need [Visual Studio 17.9](https://visualstudio.microsoft.com) or later to use .NET 8.0 on Windows. While not officially supported, we’ve also enabled rudimentary support for .NET 8 in Visual Studio for Mac. Users have to enable a preview feature in Preferences to enable the IDE to discover and use the .NET 8 SDK for creating, loading, building, and debugging projects. The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 8.0 and C# 12.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9263](https://github.com/dotnet/core/issues/9263) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.4.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.4-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.4-sha.txt

[linux-install]: ../install-linux.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/april-2024-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-dotnet-8/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.4+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.4+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.4+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.4+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.2xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 8.0.4
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 8.0.4
Microsoft.Windows.Compatibility | 8.0.4
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 8.0.4
Microsoft.WindowsDesktop.App.Ref | 8.0.4
Microsoft.NETCore.App.Host.linux-arm | 8.0.4
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 8.0.4
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 8.0.4
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Crossgen2.linux-arm | 8.0.4
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100 | 8.0.4
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.arm64 | 8.0.4
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x64 | 8.0.4
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Crossgen2.osx-x64 | 8.0.4
Microsoft.NETCore.App.Crossgen2.win-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.browser-wasm | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x86 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 8.0.4
Microsoft.NET.ILLink.Tasks | 8.0.4
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100 | 8.0.4
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.arm64 | 8.0.4
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x64 | 8.0.4
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Host.linux-musl-x64 | 8.0.4
Microsoft.NETCore.App.Host.linux-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm | 8.0.4
Microsoft.NETCore.App.Host.win-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.browser-wasm | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvos-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 8.0.4
Microsoft.DotNet.ILCompiler | 8.0.4
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 8.0.4
Microsoft.NETCore.App.Runtime.linux-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.NativeAOT.osx-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.NativeAOT.tvos-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.win-arm64 | 8.0.4
Microsoft.NETCore.DotNetHost | 8.0.4
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 8.0.4
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 8.0.4
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.4
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.4
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 8.0.4
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.4
System.Diagnostics.DiagnosticSource | 8.0.1
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 8.0.4
Microsoft.NET.Runtime.wasm.Sample.Mono | 8.0.4
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x86 | 8.0.4
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100 | 8.0.4
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 8.0.4
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 8.0.4
Microsoft.NETCore.App.Host.linux-bionic-x64 | 8.0.4
Microsoft.NETCore.App.Host.win-x86 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.osx-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 8.0.4
Microsoft.NETCore.DotNetAppHost | 8.0.4
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 8.0.4
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 8.0.4
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.4
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 8.0.4
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 8.0.4
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 8.0.4
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 8.0.4
Microsoft.NETCore.DotNetHostPolicy | 8.0.4
Microsoft.NETCore.DotNetHostResolver | 8.0.4
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 8.0.4
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 8.0.4
runtime.win-x64.Microsoft.DotNet.ILCompiler | 8.0.4
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 8.0.4
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 8.0.4
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 8.0.4
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 8.0.4
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 8.0.4
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 8.0.4
Microsoft.NET.Sdk.WebAssembly.Pack | 8.0.4
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 8.0.4
Microsoft.NETCore.App.Crossgen2.linux-x64 | 8.0.4
Microsoft.NETCore.App.Host.linux-musl-arm | 8.0.4
Microsoft.NETCore.App.Host.linux-musl-arm64 | 8.0.4
Microsoft.NETCore.App.Host.osx-x64 | 8.0.4
Microsoft.NETCore.App.Ref | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x86 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.android-arm | 8.0.4
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.NativeAOT.osx-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.osx-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.win-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 8.0.4
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 8.0.4
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 8.0.4
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.4
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.4
runtime.osx-arm64.Microsoft.DotNet.ILCompiler | 8.0.4
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.4
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.4
runtime.win-x64.Microsoft.NETCore.DotNetHost | 8.0.4
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 8.0.4
Microsoft.NETCore.App.Runtime.linux-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.linux-musl-arm | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.win-x86 | 8.0.4
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 8.0.4
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.4
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 8.0.4
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 8.0.4
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.4
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.4
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 8.0.4
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.4
runtime.win-x86.Microsoft.NETCore.DotNetHost | 8.0.4
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 8.0.4
Microsoft.NETCore.App.Runtime.linux-arm | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm | 8.0.4
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 8.0.4
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 8.0.4
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.4
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 8.0.4
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.4
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.4
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 8.0.4
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.4
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 8.0.4
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.4
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.4
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.4
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.4
Microsoft.NET.Runtime.LibraryBuilder.Sdk | 8.0.4
Microsoft.NET.Runtime.Android.Sample.Mono | 8.0.4
Microsoft.NET.Runtime.iOS.Sample.Mono | 8.0.4
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 8.0.4
Microsoft.NET.Runtime.MonoTargets.Sdk | 8.0.4
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 8.0.4
Microsoft.NET.Runtime.WebAssembly.Sdk | 8.0.4
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 8.0.4
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 8.0.4
Microsoft.NET.Runtime.WebAssembly.Templates | 8.0.4
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk | 8.0.4
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 8.0.4
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x64 | 8.0.4
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.arm64 | 8.0.4
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Crossgen2.win-x86 | 8.0.4
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 8.0.4
Microsoft.NETCore.App.Crossgen2.win-x64 | 8.0.4
Microsoft.NETCore.App.Host.linux-arm64 | 8.0.4
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 8.0.4
Microsoft.NETCore.App.Host.osx-arm64 | 8.0.4
Microsoft.NETCore.App.Host.win-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.ios-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 8.0.4
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 8.0.4
Microsoft.NETCore.App.Runtime.NativeAOT.ios-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-x64 | 8.0.4
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-arm64 | 8.0.4
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 8.0.4
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.4
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.4
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.4
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.4
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.4
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 8.0.4
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.4
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.4
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.4
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 8.0.4
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 8.0.4
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.4
Microsoft.AspNetCore.App.Runtime.osx-x64 | 8.0.4
Microsoft.AspNetCore.App.Runtime.win-x64 | 8.0.4
Microsoft.AspNetCore.App.Runtime.linux-x64 | 8.0.4
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 8.0.4
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 8.0.4
Microsoft.AspNetCore.Grpc.JsonTranscoding | 8.0.4
Microsoft.AspNetCore.Grpc.Swagger | 0.8.4
Microsoft.AspNetCore.Identity.UI | 8.0.4
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 8.0.4
Microsoft.AspNetCore.MiddlewareAnalysis | 8.0.4
Microsoft.AspNetCore.OpenApi | 8.0.4
Microsoft.AspNetCore.OutputCaching.StackExchangeRedis | 8.0.4
Microsoft.AspNetCore.Owin | 8.0.4
Microsoft.JSInterop | 8.0.4
Microsoft.Net.Http.Headers | 8.0.4
Microsoft.JSInterop.WebAssembly | 8.0.4
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 8.0.4
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 8.0.4
Microsoft.Extensions.Localization | 8.0.4
Microsoft.Extensions.Localization.Abstractions | 8.0.4
Microsoft.AspNetCore.App.Runtime.linux-arm | 8.0.4
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 8.0.4
AspNetCoreRuntime.8.0.x64 | 8.0.4
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 8.0.4
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 8.0.4
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 8.0.4
dotnet-sql-cache | 8.0.4
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 8.0.4
Microsoft.AspNetCore.Components.WebAssembly | 8.0.4
Microsoft.AspNetCore.Connections.Abstractions | 8.0.4
Microsoft.AspNetCore.Http.Connections.Common | 8.0.4
Microsoft.AspNetCore.JsonPatch | 8.0.4
Microsoft.AspNetCore.Metadata | 8.0.4
Microsoft.AspNetCore.WebUtilities | 8.0.4
Microsoft.dotnet-openapi | 8.0.4
Microsoft.Authentication.WebAssembly.Msal | 8.0.4
Microsoft.Extensions.ApiDescription.Server | 8.0.4
Microsoft.DotNet.Web.Client.ItemTemplates | 8.0.4
Microsoft.DotNet.Web.ProjectTemplates.8.0 | 8.0.4
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 8.0.4
Microsoft.Extensions.Features | 8.0.4
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 8.0.4
Microsoft.Extensions.Http.Polly | 8.0.4
Microsoft.Extensions.ObjectPool | 8.0.4
AspNetCoreRuntime.8.0.x86 | 8.0.4
Microsoft.AspNetCore.App.Runtime.win-x86 | 8.0.4
Microsoft.AspNetCore.App.Runtime.win-arm64 | 8.0.4
Microsoft.AspNetCore.Authentication.Certificate | 8.0.4
Microsoft.AspNetCore.Authentication.Facebook | 8.0.4
Microsoft.AspNetCore.Authentication.Google | 8.0.4
Microsoft.AspNetCore.Authentication.JwtBearer | 8.0.4
Microsoft.AspNetCore.Components.Web | 8.0.4
Microsoft.AspNetCore.Components.WebView | 8.0.4
Microsoft.AspNetCore.Cryptography.KeyDerivation | 8.0.4
Microsoft.AspNetCore.ConcurrencyLimiter | 8.0.4
Microsoft.AspNetCore.Cryptography.Internal | 8.0.4
Microsoft.AspNetCore.DataProtection.Abstractions | 8.0.4
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 8.0.4
Microsoft.AspNetCore.DataProtection.Extensions | 8.0.4
Microsoft.AspNetCore.DataProtection | 8.0.4
Microsoft.AspNetCore.Hosting.WindowsServices | 8.0.4
Microsoft.AspNetCore.HeaderPropagation | 8.0.4
Microsoft.Extensions.ApiDescription.Client | 8.0.4
Microsoft.DotNet.Web.ItemTemplates.8.0 | 8.0.4
Microsoft.Extensions.Caching.StackExchangeRedis | 8.0.4
Microsoft.Extensions.Caching.SqlServer | 8.0.4
Microsoft.Extensions.Configuration.KeyPerFile | 8.0.4
Microsoft.Extensions.Diagnostics.HealthChecks | 8.0.4
Microsoft.Extensions.FileProviders.Embedded | 8.0.4
Microsoft.Extensions.Identity.Stores | 8.0.4
Microsoft.Extensions.Identity.Core | 8.0.4
Microsoft.Extensions.Logging.AzureAppServices | 8.0.4
Microsoft.Extensions.WebEncoders | 8.0.4
Microsoft.AspNetCore.Authentication.Negotiate | 8.0.4
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 8.0.4
Microsoft.AspNetCore.Authentication.OpenIdConnect | 8.0.4
Microsoft.AspNetCore.Authentication.Twitter | 8.0.4
Microsoft.AspNetCore.Components | 8.0.4
Microsoft.AspNetCore.Components.WebAssembly.Server | 8.0.4
Microsoft.AspNetCore.App.Ref | 8.0.4
Microsoft.AspNetCore.Authentication.WsFederation | 8.0.4
Microsoft.AspNetCore.Authorization | 8.0.4
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 8.0.4
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 8.0.4
Microsoft.AspNetCore.AzureAppServicesIntegration | 8.0.4
Microsoft.AspNetCore.Components.Analyzers | 8.0.4
Microsoft.AspNetCore.Components.Authorization | 8.0.4
Microsoft.AspNetCore.Components.CustomElements | 8.0.4
Microsoft.AspNetCore.Components.QuickGrid | 8.0.4
Microsoft.AspNetCore.Components.Forms | 8.0.4
Microsoft.AspNetCore.Components.QuickGrid.EntityFrameworkAdapter | 8.0.4
Microsoft.AspNetCore.Http.Connections.Client | 8.0.4
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 8.0.4
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 8.0.4
Microsoft.AspNetCore.Mvc.Testing | 8.0.4
Microsoft.AspNetCore.SignalR.Client.Core | 8.0.4
Microsoft.AspNetCore.SignalR.Client | 8.0.4
Microsoft.AspNetCore.SignalR.Common | 8.0.4
Microsoft.AspNetCore.SignalR.Protocols.Json | 8.0.4
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 8.0.4
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 8.0.4
Microsoft.AspNetCore.SignalR.Specification.Tests | 8.0.4
Microsoft.AspNetCore.SpaProxy | 8.0.4
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 8.0.4
Microsoft.AspNetCore.SpaServices.Extensions | 8.0.4
Microsoft.AspNetCore.TestHost | 8.0.4
FSharp.Core | 8.0.200
Microsoft.DotNet.ApiCompat.Tool | 8.0.204
FSharp.Compiler.Service | 43.8.200
Microsoft.DotNet.Common.ItemTemplates | 8.0.204
Microsoft.DotNet.ApiCompat.Task | 8.0.204
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.204
Microsoft.NET.Build.Containers | 8.0.204
System.Drawing.Common | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-arm64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-x64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-arm64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64.Msi.arm64 | 8.0.4
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-arm64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64 | 8.0.4
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x64 | 8.0.4
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x86 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-arm64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-arm64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-arm64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-arm64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64.Msi.x64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64.Msi.arm64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64.Msi.arm64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-x64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-x64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-x64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64.Msi.x64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64.Msi.x64 | 8.0.4
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x64 | 8.0.4
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-x64 | 8.0.4
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.arm64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64.Msi.arm64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64.Msi.x64 | 8.0.4
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.arm64 | 8.0.4
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.arm64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-x64 | 8.0.4
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-x64 | 8.0.4
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x86 | 8.0.4
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x86 | 8.0.4
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100 | 8.0.4
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100 | 8.0.4
Microsoft.EntityFrameworkCore.SqlServer.Abstractions | 8.0.4
Microsoft.Data.Sqlite | 8.0.4
Microsoft.EntityFrameworkCore.SqlServer | 8.0.4
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 8.0.4
Microsoft.EntityFrameworkCore.SqlServer.HierarchyId | 8.0.4
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 8.0.4
Microsoft.EntityFrameworkCore | 8.0.4
Microsoft.Data.Sqlite.Core | 8.0.4
Microsoft.EntityFrameworkCore.Abstractions | 8.0.4
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 8.0.4
Microsoft.EntityFrameworkCore.Cosmos | 8.0.4
Microsoft.EntityFrameworkCore.Analyzers | 8.0.4
Microsoft.EntityFrameworkCore.Design | 8.0.4
Microsoft.EntityFrameworkCore.Proxies | 8.0.4
Microsoft.EntityFrameworkCore.Specification.Tests | 8.0.4
Microsoft.EntityFrameworkCore.Sqlite | 8.0.4
Microsoft.EntityFrameworkCore.Sqlite.Core | 8.0.4
Microsoft.EntityFrameworkCore.Templates | 8.0.4
Microsoft.EntityFrameworkCore.Tools | 8.0.4
Microsoft.EntityFrameworkCore.Relational | 8.0.4
Microsoft.EntityFrameworkCore.InMemory | 8.0.4
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 8.0.4
dotnet-ef | 8.0.4
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.204
Microsoft.TemplateEngine.Authoring.Templates | 8.0.204
Microsoft.TemplateEngine.Authoring.CLI | 8.0.204
Microsoft.TemplateEngine.Core.Contracts | 8.0.204
Microsoft.TemplateEngine.Core | 8.0.204
Microsoft.TemplateEngine.IDE | 8.0.204
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.204
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.204
Microsoft.TemplateEngine.Edge | 8.0.204
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.204
Microsoft.TemplateEngine.Utils | 8.0.204
Microsoft.TemplateSearch.Common | 8.0.204
Microsoft.TemplateEngine.Abstractions | 8.0.204
Microsoft.TemplateEngine.Samples | 8.0.204
Microsoft.DotNet.ApiCompat.Tool | 8.0.104
Microsoft.DotNet.ApiCompat.Task | 8.0.104
FSharp.Compiler.Service | 43.8.102
Microsoft.NET.Build.Containers | 8.0.104
FSharp.Core | 8.0.102
Microsoft.DotNet.Common.ItemTemplates | 8.0.104
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.104
Microsoft.TemplateEngine.Authoring.Templates | 8.0.104
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.104
Microsoft.TemplateEngine.Edge | 8.0.104
Microsoft.TemplateEngine.Utils | 8.0.104
Microsoft.TemplateSearch.Common | 8.0.104
Microsoft.TemplateEngine.Authoring.CLI | 8.0.104
Microsoft.TemplateEngine.Abstractions | 8.0.104
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.104
Microsoft.TemplateEngine.Core | 8.0.104
Microsoft.TemplateEngine.IDE | 8.0.104
Microsoft.TemplateEngine.Core.Contracts | 8.0.104
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.104
Microsoft.TemplateEngine.Samples | 8.0.104
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.104

[//]: # ( Runtime 8.0.4)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a299eeb3-a9c8-42d4-a0ff-61713365c715/0f4d4139df6c700efd4c0d172c2c28eb/dotnet-runtime-8.0.4-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/761b252b-a0d9-41cd-b1ec-2dc33159c11c/b8285cf82db4ef340a191bfba9a9a73e/dotnet-runtime-8.0.4-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1183b580-9664-4b23-924a-2db7cf57bdf2/70ae3e474bd338de7175d4c547f800ed/dotnet-runtime-8.0.4-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c3f8aecf-493f-4a7f-a1b4-a1cd5ac961ba/fd2efde18a0e0049d89a421b10912bf2/dotnet-runtime-8.0.4-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8e6b2e18-2bd6-46f0-a1b2-6b8ce1ec8a2d/17bedef454de7096b9d9d562a161813b/dotnet-runtime-8.0.4-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a3ca3d31-f45b-4e53-ab4d-0f2f221cbc5b/47382078b4b72a66387d0fd6ed9ff963/dotnet-runtime-8.0.4-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/8d8977c0-499c-405a-b687-00e7bca8c783/66057685d4fbdfe80b7b9dd96a47b45a/dotnet-runtime-8.0.4-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d2cd56cc-5a78-460d-a45d-3893b020949d/8cf9653a23c91ac2b10c70f58edae60e/dotnet-runtime-8.0.4-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4f3f1c85-67aa-4b3e-b4d2-951b9f8468ad/d6b7b5f7c5cea4f72417a4738da3d941/dotnet-runtime-8.0.4-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c999e42b-38c9-4d9a-9816-9a0ebece8afe/8e4471db5aa0756d812af23817b14259/dotnet-runtime-8.0.4-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/d9986b68-9a34-4499-a0b7-845819d6889d/2c62b88fcebbbf7b58339cc0e73b55a5/dotnet-runtime-8.0.4-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/4d1eb519-88ac-434c-9fe4-59a189472c36/f8e3720e44fa35d9ce50f6f0db76b5fd/dotnet-runtime-8.0.4-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4e4fef83-93d2-4bff-bc74-2c1b0623fbfb/f40b7f2752c23bd0a1046a2a8ed887c5/dotnet-runtime-8.0.4-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1ed8f8a2-7bb8-41cd-b256-63e0e7102742/d0c4851d34ddd0abf041188553a3acae/dotnet-runtime-8.0.4-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f846c59a-2d35-4609-aabf-eee9b1ea6758/2ccf71babeb0853c9de947dc57aec29f/dotnet-runtime-8.0.4-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2f00ad36-c625-4e11-b6e1-d91eef43488e/b6ec44780ed852fa498d4c4b7a43cf73/dotnet-runtime-8.0.4-win-x86.zip

[//]: # ( WindowsDesktop 8.0.4)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/01520b8c-dbf8-4818-89c6-128d5d6d2140/efbc62901cd9543f57b697d2a72eb1a0/windowsdesktop-runtime-8.0.4-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/aae0a632-e442-4341-8143-7817df88afea/e1fcb8a968848820d815075d7ec177a1/windowsdesktop-runtime-8.0.4-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c1d08a81-6e65-4065-b606-ed1127a954d3/14fe55b8a73ebba2b05432b162ab3aa8/windowsdesktop-runtime-8.0.4-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7a74986d-61bf-41b5-8e94-4be88688b56a/371136c10ff4a8838d81e7910cdbad4f/windowsdesktop-runtime-8.0.4-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1fbf5c5f-9770-402d-8971-83da662d8cf9/4e37b3c24bcb6004875b9f8b08024303/windowsdesktop-runtime-8.0.4-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/454f117c-637f-4509-946f-250a99e07008/1db9424f1c44c1cf6bc20f3129cb1e51/windowsdesktop-runtime-8.0.4-win-x86.zip

[//]: # ( ASP 8.0.4)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f12a9449-04ba-454c-bc35-4cdb426accf6/2729a371b61d59794845eb309a46fba2/aspnetcore-runtime-8.0.4-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/80ec12e5-b26f-466c-a20c-f96772ea709d/606e7203912400b44cb35d6fcecf60bf/aspnetcore-runtime-8.0.4-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d8e22573-ac17-4c4e-a35c-a9ca66777d91/bada3ddd0479a64045bf60988e8c7121/aspnetcore-runtime-8.0.4-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/06714f53-d614-4a83-91e6-322f664796cb/5204a9f835636e9a08100ac3ec2e2f4e/aspnetcore-runtime-8.0.4-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a588c4ae-771c-43ba-aede-1526a871a653/e2c5d22a837be58c2190547924768db3/aspnetcore-runtime-8.0.4-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0b0bc7f4-c6e5-4cec-a7ed-45c2fac0da4b/ae2090564274152b5a4be9f1e66c5d30/aspnetcore-runtime-8.0.4-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/172cfd62-a126-4375-9a48-84cfbcf1b718/959ce27a010020f0e5d393578574bca9/aspnetcore-runtime-8.0.4-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8edd447c-bd4a-4677-ba33-8bdac6088dc8/a17a23a5d47642eb050288dea0322350/aspnetcore-runtime-8.0.4-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/3d040214-d952-4261-add3-d83badf84a05/dc1c628b30226f5bc89d9784f581f571/aspnetcore-runtime-8.0.4-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/eb04a61f-75c3-43dd-93d9-b6a7248116c7/f884863125730a39d7fa4139a00c0f99/aspnetcore-runtime-8.0.4-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e9a37988-8a48-4b17-8392-0ee82ab325e4/3939e85b1668f2861d15ff098841349b/aspnetcore-runtime-8.0.4-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b53d938e-3ae2-4c22-8341-689a1c80fb95/84c2b40ac532dc2f9e6d8d1a680d3aaf/aspnetcore-runtime-8.0.4-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/98b91803-42ed-4f3c-893b-11f4f8e7de1f/2b5738505423f855472e0f1838a6956f/aspnetcore-runtime-8.0.4-win-x86.zip
[aspnetcore-runtime-composite-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2f33b8a2-8ea0-456d-8733-26b36348e6ad/739d0e7e5079ac7e7b6b3a62373a12bf/aspnetcore-runtime-composite-8.0.4-linux-arm.tar.gz
[aspnetcore-runtime-composite-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5aacfdfb-c4f0-4ebe-8459-7e2ab6ffb302/3a16c6ebd0d83d2346eedb3c77f6fcf1/aspnetcore-runtime-composite-8.0.4-linux-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d6f9f3c6-3e7b-431d-97ee-d30bf79d82ad/954d0497b602433bcf78d5ca0c733dd3/aspnetcore-runtime-composite-8.0.4-linux-musl-arm.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fae3b6d1-8fc0-40d1-9751-bdaba52621a5/8d6622b0fea76911e4b891f8737a787e/aspnetcore-runtime-composite-8.0.4-linux-musl-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ae505a55-142f-4462-bda2-3d3aa16379c3/daac7bf1dcab2e0ea83a3cbf9dd113ec/aspnetcore-runtime-composite-8.0.4-linux-musl-x64.tar.gz
[aspnetcore-runtime-composite-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2ac9532d-ff0b-4323-84eb-ee9e39d37d0b/2903d6caf4b7002c4a715cea231e19ca/aspnetcore-runtime-composite-8.0.4-linux-x64.tar.gz
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/00397fee-1bd9-44ef-899b-4504b26e6e96/ab9c73409659f3238d33faee304a8b7c/dotnet-hosting-8.0.4-win.exe

[//]: # ( SDK 8.0.204)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ac99d114-0422-475c-b75b-8279ff9f9a68/19efacb0358aaf945f0a8ad62a8ca718/dotnet-sdk-8.0.204-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1e449990-2934-47ee-97fb-b78f0e587c98/1c92c33593932f7a86efa5aff18960ed/dotnet-sdk-8.0.204-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/67254d85-fcab-415e-be63-15d3a3b26f4b/a593418de05aedaf8278c6c5b9371682/dotnet-sdk-8.0.204-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/71f8cf17-ced9-4800-8653-7c6df11cec74/e79328b80df0976e4bb28a23e8ebc7c6/dotnet-sdk-8.0.204-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/890ae69d-17fc-4679-9101-dca1b58a06ff/33d81629d3f650b6b04eb2af137699ca/dotnet-sdk-8.0.204-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0a1b3cbd-b4af-4d0d-9ed7-0054f0e200b4/4bcc533c66379caaa91770236667aacb/dotnet-sdk-8.0.204-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a1b04e7e-464d-45f6-ac93-f8901c46c247/7acd4fa3f321aaec4598a1492cc745c6/dotnet-sdk-8.0.204-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8746698c-596d-406e-b672-49a53d77eea7/74c28673e54213d058eec2c9151714cc/dotnet-sdk-8.0.204-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7bcf1329-6691-45e9-8fdd-96c65bcabd1f/cb618d2620974fc029e4f758eb267452/dotnet-sdk-8.0.204-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9548c95b-8495-4b69-b6f0-1fdebdbbf9ff/30827786409718c5a9604711661da3b5/dotnet-sdk-8.0.204-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/89f6f8f5-c353-4436-aa33-47450e4938df/065cbcf0b8a2df03f2d6487d31cc365c/dotnet-sdk-8.0.204-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d9e0eb19-33ac-42b2-a4e7-e6e0be232e9e/50a3f2722ca4e5e571a1d3843670abc1/dotnet-sdk-8.0.204-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1e9f5038-d1c3-4219-94e9-62d6f810e589/c28bb8c8a1a3d01c72f3db1646a983c5/dotnet-sdk-8.0.204-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/bf435b42-3f28-45db-a666-6e95c4faefe7/23e0b703124347b51f53faf64c829287/dotnet-sdk-8.0.204-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7ec1e77e-07d3-43b6-a688-847507046206/d83ec453d53a308d9f614de81b152594/dotnet-sdk-8.0.204-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/149f911f-3448-438a-9d2f-8a18ad46757e/a0c233915e9a8451bdd4b75e6650954b/dotnet-sdk-8.0.204-win-x86.zip
