# .NET 8.0.5 - May 14, 2024

The .NET 8.0.5 and .NET SDK 8.0.300 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.300
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/monitor/base](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor-base.md): .NET Monitor Base
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples


## Notable Changes

 [.NET 8.0 Blog][dotnet-blog]

.NET 8.0.5 release carries security and non-security fixes.

[CVE-2024-30045 | .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-30045)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A Remote Code Execution vulnerability exists in  .NET 7.0 and .NET 8.0 where a stack buffer overrun occurs in .NET Double Parse routine.

[CVE-2024-30046 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-30046)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 8.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A Vulnerability exist in Microsoft.AspNetCore.Server.Kestrel.Core.dll where a dead-lock can occur resulting in Denial of Service.

## Visual Studio Compatibility

You need [Visual Studio 17.9](https://visualstudio.microsoft.com) or later to use .NET 8.0 on Windows. While not officially supported, we’ve also enabled rudimentary support for .NET 8 in Visual Studio for Mac. Users have to enable a preview feature in Preferences to enable the IDE to discover and use the .NET 8 SDK for creating, loading, building, and debugging projects. The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 8.0 and C# 12.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9309](https://github.com/dotnet/core/issues/9309) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.5.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.5-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.5-sha.txt

[linux-install]: ../install-linux.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/dotnet-and-dotnet-framework-may-2024-servicing-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-dotnet-8/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.5+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.5+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.5+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.5+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.2xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 8.0.5
Microsoft.Windows.Compatibility | 8.0.5
Microsoft.WindowsDesktop.App.Ref | 8.0.5
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 8.0.5
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.android-arm | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 8.0.5
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 8.0.5
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.arm64 | 8.0.5
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Crossgen2.win-x86 | 8.0.5
Microsoft.NETCore.App.Crossgen2.linux-x64 | 8.0.5
Microsoft.NETCore.App.Host.osx-x64 | 8.0.5
Microsoft.NETCore.App.Ref | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x86 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.browser-wasm | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.linux-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 8.0.5
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 8.0.5
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.5
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 8.0.5
runtime.win-x64.Microsoft.DotNet.ILCompiler | 8.0.5
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 8.0.5
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.5
Microsoft.DotNet.ILCompiler | 8.0.5
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 8.0.5
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 8.0.5
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 8.0.5
Microsoft.NET.Runtime.WebAssembly.Templates | 8.0.5
Microsoft.NETCore.App.Crossgen2.linux-arm | 8.0.5
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.arm64 | 8.0.5
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x86 | 8.0.5
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Crossgen2.win-arm64 | 8.0.5
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 8.0.5
Microsoft.NETCore.App.Host.linux-arm | 8.0.5
Microsoft.NETCore.App.Host.win-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvos-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.NativeAOT.tvos-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 8.0.5
Microsoft.NETCore.DotNetAppHost | 8.0.5
Microsoft.NETCore.DotNetHostResolver | 8.0.5
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.5
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.5
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.5
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 8.0.5
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 8.0.5
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 8.0.5
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 8.0.5
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 8.0.5
runtime.win-x64.Microsoft.NETCore.DotNetHost | 8.0.5
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.5
runtime.win-x86.Microsoft.NETCore.DotNetHost | 8.0.5
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 8.0.5
Microsoft.NET.ILLink.Tasks | 8.0.5
Microsoft.NET.Runtime.Android.Sample.Mono | 8.0.5
Microsoft.NET.Runtime.LibraryBuilder.Sdk | 8.0.5
Microsoft.NET.Runtime.iOS.Sample.Mono | 8.0.5
Microsoft.NET.Runtime.MonoTargets.Sdk | 8.0.5
Microsoft.NET.Runtime.wasm.Sample.Mono | 8.0.5
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 8.0.5
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 8.0.5
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x64 | 8.0.5
Microsoft.NET.Sdk.WebAssembly.Pack | 8.0.5
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.osx-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Runtime.win-x86 | 8.0.5
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 8.0.5
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 8.0.5
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.5
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 8.0.5
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 8.0.5
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 8.0.5
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 8.0.5
Microsoft.NET.Runtime.WebAssembly.Sdk | 8.0.5
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 8.0.5
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 8.0.5
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.arm64 | 8.0.5
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x86 | 8.0.5
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100 | 8.0.5
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 8.0.5
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 8.0.5
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 8.0.5
Microsoft.NETCore.App.Crossgen2.win-x64 | 8.0.5
Microsoft.NETCore.App.Host.linux-musl-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x64 | 8.0.5
Microsoft.NETCore.App.Host.win-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 8.0.5
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.linux-musl-arm | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.linux-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Runtime.NativeAOT.ios-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 8.0.5
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 8.0.5
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.5
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.5
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 8.0.5
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 8.0.5
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.5
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 8.0.5
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.5
runtime.osx-arm64.Microsoft.DotNet.ILCompiler | 8.0.5
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.5
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 8.0.5
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.5
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk | 8.0.5
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100 | 8.0.5
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Host.osx-arm64 | 8.0.5
Microsoft.NETCore.App.Host.linux-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 8.0.5
Microsoft.NETCore.App.Runtime.linux-arm | 8.0.5
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.osx-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.win-x64 | 8.0.5
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 8.0.5
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 8.0.5
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.5
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.5
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.5
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.5
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.5
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.5
System.Security.Cryptography.Xml | 8.0.1
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 8.0.5
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 8.0.5
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 8.0.5
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 8.0.5
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.arm64 | 8.0.5
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100 | 8.0.5
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.ios-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.browser-wasm | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Runtime.win-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 8.0.5
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 8.0.5
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 8.0.5
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.5
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.5
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.5
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.5
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.5
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 8.0.5
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.5
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.5
Microsoft.NETCore.App.Crossgen2.osx-x64 | 8.0.5
Microsoft.NETCore.App.Host.linux-musl-arm | 8.0.5
Microsoft.NETCore.App.Host.linux-arm64 | 8.0.5
Microsoft.NETCore.App.Host.linux-bionic-x64 | 8.0.5
Microsoft.NETCore.App.Host.linux-musl-x64 | 8.0.5
Microsoft.NETCore.App.Host.win-x86 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x86 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.NativeAOT.osx-arm64 | 8.0.5
Microsoft.NETCore.App.Runtime.NativeAOT.osx-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-x64 | 8.0.5
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 8.0.5
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 8.0.5
Microsoft.NETCore.DotNetHostPolicy | 8.0.5
Microsoft.NETCore.DotNetHost | 8.0.5
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 8.0.5
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.5
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 8.0.5
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.5
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 8.0.5
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.5
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 8.0.5
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 8.0.5
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 8.0.5
Microsoft.AspNetCore.DataProtection | 8.0.5
Microsoft.AspNetCore.Connections.Abstractions | 8.0.5
Microsoft.AspNetCore.DataProtection.Extensions | 8.0.5
Microsoft.AspNetCore.DataProtection.Abstractions | 8.0.5
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 8.0.5
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 8.0.5
Microsoft.AspNetCore.MiddlewareAnalysis | 8.0.5
Microsoft.AspNetCore.Metadata | 8.0.5
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 8.0.5
Microsoft.Extensions.ApiDescription.Server | 8.0.5
Microsoft.Extensions.Identity.Core | 8.0.5
Microsoft.Extensions.ObjectPool | 8.0.5
Microsoft.Extensions.WebEncoders | 8.0.5
Microsoft.AspNetCore.Authorization | 8.0.5
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 8.0.5
Microsoft.AspNetCore.Components.Analyzers | 8.0.5
Microsoft.AspNetCore.HeaderPropagation | 8.0.5
Microsoft.AspNetCore.Identity.UI | 8.0.5
Microsoft.AspNetCore.Hosting.WindowsServices | 8.0.5
Microsoft.AspNetCore.Http.Connections.Common | 8.0.5
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 8.0.5
Microsoft.AspNetCore.JsonPatch | 8.0.5
Microsoft.AspNetCore.SignalR.Client.Core | 8.0.5
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 8.0.5
Microsoft.AspNetCore.SpaServices.Extensions | 8.0.5
Microsoft.AspNetCore.TestHost | 8.0.5
Microsoft.AspNetCore.WebUtilities | 8.0.5
Microsoft.Authentication.WebAssembly.Msal | 8.0.5
Microsoft.Extensions.ApiDescription.Client | 8.0.5
Microsoft.AspNetCore.App.Runtime.linux-arm | 8.0.5
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 8.0.5
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 8.0.5
Microsoft.AspNetCore.Authentication.Certificate | 8.0.5
Microsoft.AspNetCore.AzureAppServicesIntegration | 8.0.5
Microsoft.Extensions.Diagnostics.HealthChecks | 8.0.5
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 8.0.5
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 8.0.5
Microsoft.Extensions.Localization.Abstractions | 8.0.5
Microsoft.AspNetCore.App.Ref | 8.0.5
Microsoft.AspNetCore.Authentication.Twitter | 8.0.5
Microsoft.DotNet.Web.ProjectTemplates.8.0 | 8.0.5
Microsoft.Extensions.Identity.Stores | 8.0.5
Microsoft.Extensions.Localization | 8.0.5
Microsoft.Net.Http.Headers | 8.0.5
Microsoft.JSInterop | 8.0.5
Microsoft.JSInterop.WebAssembly | 8.0.5
Microsoft.AspNetCore.Components.WebAssembly.Server | 8.0.5
Microsoft.AspNetCore.Components.CustomElements | 8.0.5
Microsoft.AspNetCore.Components.Forms | 8.0.5
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 8.0.5
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 8.0.5
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 8.0.5
Microsoft.AspNetCore.Grpc.JsonTranscoding | 8.0.5
Microsoft.AspNetCore.Grpc.Swagger | 0.8.5
Microsoft.AspNetCore.Http.Connections.Client | 8.0.5
Microsoft.dotnet-openapi | 8.0.5
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 8.0.5
Microsoft.AspNetCore.App.Runtime.osx-x64 | 8.0.5
AspNetCoreRuntime.8.0.x64 | 8.0.5
dotnet-sql-cache | 8.0.5
Microsoft.AspNetCore.App.Runtime.win-arm64 | 8.0.5
Microsoft.AspNetCore.App.Runtime.win-x64 | 8.0.5
Microsoft.AspNetCore.Authentication.Facebook | 8.0.5
Microsoft.AspNetCore.Authentication.Google | 8.0.5
Microsoft.AspNetCore.Authentication.JwtBearer | 8.0.5
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 8.0.5
Microsoft.AspNetCore.Authentication.Negotiate | 8.0.5
Microsoft.AspNetCore.Authentication.OpenIdConnect | 8.0.5
Microsoft.AspNetCore.Authentication.WsFederation | 8.0.5
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 8.0.5
Microsoft.AspNetCore.Components.Authorization | 8.0.5
Microsoft.AspNetCore.Components.QuickGrid.EntityFrameworkAdapter | 8.0.5
Microsoft.AspNetCore.Components.Web | 8.0.5
Microsoft.AspNetCore.Components.WebAssembly | 8.0.5
Microsoft.AspNetCore.Components.WebView | 8.0.5
Microsoft.AspNetCore.ConcurrencyLimiter | 8.0.5
Microsoft.AspNetCore.Cryptography.Internal | 8.0.5
Microsoft.AspNetCore.Cryptography.KeyDerivation | 8.0.5
Microsoft.AspNetCore.Mvc.Testing | 8.0.5
Microsoft.AspNetCore.OpenApi | 8.0.5
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 8.0.5
Microsoft.AspNetCore.SignalR.Client | 8.0.5
Microsoft.AspNetCore.SignalR.Common | 8.0.5
Microsoft.AspNetCore.SignalR.Protocols.Json | 8.0.5
Microsoft.AspNetCore.SignalR.Specification.Tests | 8.0.5
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 8.0.5
Microsoft.AspNetCore.SpaProxy | 8.0.5
Microsoft.DotNet.Web.ItemTemplates.8.0 | 8.0.5
Microsoft.Extensions.Caching.StackExchangeRedis | 8.0.5
Microsoft.Extensions.Features | 8.0.5
Microsoft.Extensions.FileProviders.Embedded | 8.0.5
Microsoft.Extensions.Http.Polly | 8.0.5
Microsoft.Extensions.Logging.AzureAppServices | 8.0.5
Microsoft.AspNetCore.App.Runtime.linux-x64 | 8.0.5
AspNetCoreRuntime.8.0.x86 | 8.0.5
Microsoft.AspNetCore.App.Runtime.win-x86 | 8.0.5
Microsoft.AspNetCore.Components | 8.0.5
Microsoft.AspNetCore.Components.QuickGrid | 8.0.5
Microsoft.AspNetCore.Owin | 8.0.5
Microsoft.AspNetCore.OutputCaching.StackExchangeRedis | 8.0.5
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 8.0.5
Microsoft.DotNet.Web.Client.ItemTemplates | 8.0.5
Microsoft.Extensions.Caching.SqlServer | 8.0.5
Microsoft.Extensions.Configuration.KeyPerFile | 8.0.5
FSharp.Core | 8.0.300
Microsoft.DotNet.ApiCompat.Tool | 8.0.300
FSharp.Compiler.Service | 43.8.300
Microsoft.DotNet.Common.ItemTemplates | 8.0.300
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.300
Microsoft.NET.Build.Containers | 8.0.300
Microsoft.DotNet.ApiCompat.Task | 8.0.300
System.Drawing.Common | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-arm64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64.Msi.x64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64.Msi.arm64 | 8.0.5
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-arm64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-x64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64.Msi.arm64 | 8.0.5
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x86 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-x64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-arm64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64.Msi.x64 | 8.0.5
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.arm64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-x64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64.Msi.arm64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64 | 8.0.5
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.arm64 | 8.0.5
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-arm64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-x64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-x64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-arm64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-arm64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-x64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-arm64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64.Msi.x64 | 8.0.5
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.arm64 | 8.0.5
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x64 | 8.0.5
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-x64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64.Msi.x64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64.Msi.arm64 | 8.0.5
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64 | 8.0.5
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x86 | 8.0.5
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x64 | 8.0.5
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x86 | 8.0.5
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100 | 8.0.5
dotnet-ef | 8.0.5
Microsoft.EntityFrameworkCore | 8.0.5
Microsoft.EntityFrameworkCore.Sqlite.Core | 8.0.5
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 8.0.5
Microsoft.EntityFrameworkCore.SqlServer.Abstractions | 8.0.5
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 8.0.5
Microsoft.EntityFrameworkCore.SqlServer | 8.0.5
Microsoft.Data.Sqlite.Core | 8.0.5
Microsoft.Data.Sqlite | 8.0.5
Microsoft.EntityFrameworkCore.Analyzers | 8.0.5
Microsoft.EntityFrameworkCore.Abstractions | 8.0.5
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 8.0.5
Microsoft.EntityFrameworkCore.Cosmos | 8.0.5
Microsoft.EntityFrameworkCore.Design | 8.0.5
Microsoft.EntityFrameworkCore.InMemory | 8.0.5
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 8.0.5
Microsoft.EntityFrameworkCore.Relational | 8.0.5
Microsoft.EntityFrameworkCore.Specification.Tests | 8.0.5
Microsoft.EntityFrameworkCore.Sqlite | 8.0.5
Microsoft.EntityFrameworkCore.SqlServer.HierarchyId | 8.0.5
Microsoft.EntityFrameworkCore.Proxies | 8.0.5
Microsoft.EntityFrameworkCore.Tools | 8.0.5
Microsoft.EntityFrameworkCore.Templates | 8.0.5
Microsoft.TemplateEngine.Authoring.CLI | 8.0.300
Microsoft.TemplateEngine.Abstractions | 8.0.300
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.300
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.300
Microsoft.TemplateEngine.Core | 8.0.300
Microsoft.TemplateEngine.Core.Contracts | 8.0.300
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.300
Microsoft.TemplateEngine.Samples | 8.0.300
Microsoft.TemplateSearch.Common | 8.0.300
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.300
Microsoft.TemplateEngine.Utils | 8.0.300
Microsoft.TemplateEngine.Authoring.Templates | 8.0.300
Microsoft.TemplateEngine.IDE | 8.0.300
Microsoft.TemplateEngine.Edge | 8.0.300
FSharp.Core | 8.0.200
Microsoft.DotNet.Common.ItemTemplates | 8.0.205
FSharp.Compiler.Service | 43.8.200
Microsoft.DotNet.ApiCompat.Tool | 8.0.205
Microsoft.DotNet.ApiCompat.Task | 8.0.205
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.205
Microsoft.NET.Build.Containers | 8.0.205
FSharp.Core | 8.0.102
Microsoft.DotNet.ApiCompat.Tool | 8.0.105
Microsoft.DotNet.ApiCompat.Task | 8.0.105
FSharp.Compiler.Service | 43.8.102
Microsoft.DotNet.Common.ItemTemplates | 8.0.105
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.105
Microsoft.NET.Build.Containers | 8.0.105
Microsoft.TemplateEngine.Authoring.Templates | 8.0.105
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.105
Microsoft.TemplateEngine.Core | 8.0.105
Microsoft.TemplateEngine.Core.Contracts | 8.0.105
Microsoft.TemplateEngine.Edge | 8.0.105
Microsoft.TemplateEngine.IDE | 8.0.105
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.105
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.105
Microsoft.TemplateEngine.Utils | 8.0.105
Microsoft.TemplateEngine.Samples | 8.0.105
Microsoft.TemplateEngine.Authoring.CLI | 8.0.105
Microsoft.TemplateEngine.Abstractions | 8.0.105
Microsoft.TemplateSearch.Common | 8.0.105
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.105
Microsoft.CodeAnalysis.RulesetToEditorconfigConverter | 3.11.0-beta1.24219.2
Microsoft.CodeAnalysis.Analyzers | 3.11.0-beta1.24219.2
Microsoft.CodeAnalysis.PerformanceSensitiveAnalyzers | 3.11.0-beta1.24219.2
Roslyn.Diagnostics.Analyzers | 3.11.0-beta1.24219.2
Microsoft.CodeAnalysis.AnalyzerUtilities | 3.11.0-beta1.24219.2
Text.Analyzers | 3.11.0-beta1.24219.2
Microsoft.CodeAnalysis.PublicApiAnalyzers | 3.11.0-beta1.24219.2
Microsoft.CodeAnalysis.ResxSourceGenerator | 3.11.0-beta1.24219.2
Microsoft.CodeAnalysis.Metrics | 4.0.0-beta1.24219.2
Microsoft.CodeAnalysis.BannedApiAnalyzers | 3.11.0-beta1.24219.2
Microsoft.CodeAnalysis.NetAnalyzers | 8.0.0-preview.24219.2

[//]: # ( Runtime 8.0.5)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b52720a7-9dc4-4b9c-97fa-d1caebdaf946/443750ad6f47c855a395abbd36bb3b3a/dotnet-runtime-8.0.5-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/00ca4d7a-e529-4384-8ad4-acb8237d540f/a7df4c26e3c0e1dcf8e17d2abb79aad5/dotnet-runtime-8.0.5-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b3ee2592-2309-4820-b0cc-1d28d4aafc12/7caaf3c9db6c9fdf36ef9b724b637cd6/dotnet-runtime-8.0.5-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cc5d9158-2333-4374-ae66-3af6c8230b10/5a6e467eeb1571256f28c886460bd17a/dotnet-runtime-8.0.5-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b6dedd67-f57e-4953-8826-914d109ff98a/e0c03409ea2d9835f3390c2c1d171e8a/dotnet-runtime-8.0.5-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/baeb5da3-4b77-465b-8816-b29f0bc3e1a9/b04b17a2aae79e5f5635a3ceffbd4645/dotnet-runtime-8.0.5-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e8661f5d-6298-4848-bd34-b3618665d0c4/b259dab85d1283a192200bd814cef7ea/dotnet-runtime-8.0.5-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fac90ccb-5864-4d4a-a116-67387aaee61e/df82eea80efffad3c9ec8b0522847e68/dotnet-runtime-8.0.5-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/181bf41c-91a6-451c-aa7c-b709d1ba79b0/cb44db162c74fa57cb91a04c6926de70/dotnet-runtime-8.0.5-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0dabe69f-fa99-4b53-96d1-9f9791bb0b6b/f72acbfd3b0e60528d9494b43bcf21ca/dotnet-runtime-8.0.5-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/54678360-018e-472b-ad2c-ee0a523aba93/a9bedf02dfc29d11a2c500b682f8338d/dotnet-runtime-8.0.5-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a3a9c305-7dc9-4cfe-a3ed-e852964ebebc/88f9534996718ed976f5e15c13ddc659/dotnet-runtime-8.0.5-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/77284554-b8df-4697-9a9e-4c70a8b35f29/6763c16069d1ab8fa2bc506ef0767366/dotnet-runtime-8.0.5-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/77650902-a341-4f4c-934f-db7056cbfa78/176d961f8bbc798596f8d498ede4cc73/dotnet-runtime-8.0.5-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6baea142-1c35-44d9-a753-d2ff252b2f05/c8d7547c2dba48eb8a196f9210ad417a/dotnet-runtime-8.0.5-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2f8a6349-c15b-47d6-a45a-7b59e21edc39/78c224dcc55cc2684f30ccda1f029ee1/dotnet-runtime-8.0.5-win-x86.zip

[//]: # ( WindowsDesktop 8.0.5)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/3f8a1e03-75f8-4a4d-9454-661951c7766c/d009696cbfdba724337e226d3a84a3f1/windowsdesktop-runtime-8.0.5-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f909f3a0-6cb9-420b-b0d5-2f813c4ff47c/1fb5b6ad0b8442232aca852978ffb3bf/windowsdesktop-runtime-8.0.5-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0ff148e7-bbf6-48ed-bdb6-367f4c8ea14f/bd35d787171a1f0de7da6b57cc900ef5/windowsdesktop-runtime-8.0.5-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1825c526-cca9-4528-b4d8-fff62085ad49/16b2cdd02ac62cc38c912a500490ff23/windowsdesktop-runtime-8.0.5-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/44a63708-94fa-4edf-81a9-50612e4ef82f/1c9f61bc16d3bec6217337951898dbd3/windowsdesktop-runtime-8.0.5-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/5fc6bfd5-8e73-4bbd-ab9e-2e12317cde99/5b195f89f5f5538d3d35cc6969f4e12d/windowsdesktop-runtime-8.0.5-win-x86.zip

[//]: # ( ASP 8.0.5)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4a8e69b4-5f79-4b86-b922-5b431ff02736/db7eb177e07a80137aba9abaaf3246be/aspnetcore-runtime-8.0.5-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/208a57a8-fcc0-4801-a337-79095304d2af/d1ffa79af24735af4bd748229778c1a9/aspnetcore-runtime-8.0.5-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c5190a93-22f9-4e44-afe9-195409867dae/a688dd1e97b5affb7c97936be330f901/aspnetcore-runtime-8.0.5-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e7a0cdac-8a36-44f1-8c99-89473786a71e/f3f0dadb7ca11fe381fed11dedd9410a/aspnetcore-runtime-8.0.5-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f882401a-2f21-4a86-8c19-1e69f3fc14ed/9dcf9a68d11f46bdf0272d692347815f/aspnetcore-runtime-8.0.5-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ccccfeb7-0af4-4713-b4f1-cf49b5c8bd6c/5b04c0188dfcf78b70da78ae3bd7f3ab/aspnetcore-runtime-8.0.5-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c264657c-7a93-4ba5-b6e0-91bf41341e1e/90fb45ed7d2f92c374899b1c7a5254b2/aspnetcore-runtime-8.0.5-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/77cd03cb-5575-48c9-8714-6498ee88694b/8bfba2913a4db23e3dffdff779fb7866/aspnetcore-runtime-8.0.5-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/b5f73667-df10-4877-85c2-9340d5d428be/3309721b7482738b592e03715c76c616/aspnetcore-runtime-8.0.5-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e2ced2b3-e1a5-401a-bcc9-6689e4eea673/93f77de4a39a219d775b403b7ef0cf58/aspnetcore-runtime-8.0.5-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/037d4b04-c96e-4f1a-a754-faa533c151d9/383663d155777ad71863cd951d24224f/aspnetcore-runtime-8.0.5-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/24682756-e652-486d-a9f7-c4411f3141e9/39e6bb61fab38fdfb3472305174422cb/aspnetcore-runtime-8.0.5-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a814686d-474b-4673-8c2a-501bae44e581/04a883d6d9856ff5999603828daa7153/aspnetcore-runtime-8.0.5-win-x86.zip
[aspnetcore-runtime-composite-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e396a133-44f6-4f3b-8622-699def46a2e2/e0377da1eb746d6915f5f6bbdc5289dd/aspnetcore-runtime-composite-8.0.5-linux-arm.tar.gz
[aspnetcore-runtime-composite-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ef17fbc9-1bac-4346-b04b-db0114e2714f/74c4636b4fb78509d65be904c9c1e71e/aspnetcore-runtime-composite-8.0.5-linux-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/60285a37-71c8-4544-a965-ead53392ae14/67b0f0b4e12a1533f66f09073db91e67/aspnetcore-runtime-composite-8.0.5-linux-musl-arm.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/89822e3d-7a9c-4a9a-98e2-39941002d776/0b5847a6b22171f1ab241defa8142977/aspnetcore-runtime-composite-8.0.5-linux-musl-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5aa0b2bb-a909-4e76-a338-aae7007e3107/8d435893e3da0f1f83fd01babb154b31/aspnetcore-runtime-composite-8.0.5-linux-musl-x64.tar.gz
[aspnetcore-runtime-composite-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ce76101f-0ea1-45ee-b38b-1dfa0ffc60e1/8134663bd2d175725ad37733150c1901/aspnetcore-runtime-composite-8.0.5-linux-x64.tar.gz
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/70f96ebd-54ce-4bb2-a90f-2fbfc8fd90c0/aa542f2f158cc6c9e63b4287e4618f0a/dotnet-hosting-8.0.5-win.exe

[//]: # ( SDK 8.0.300)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d915a052-b50b-4305-978c-fbf644e71eed/de3ac6fbebd4db705413aac807aa11fe/dotnet-sdk-8.0.300-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/54e5bb2e-bdd6-496d-8aba-4ed14658ee91/34fd7327eadad7611bded51dcda44c35/dotnet-sdk-8.0.300-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/372c3832-0beb-4d86-b404-818d40bc57a1/2edb3d86bb767b682dc73e2027e842f8/dotnet-sdk-8.0.300-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d14a0fa6-f471-4e69-bc90-20003c3dd4b5/64348ba14e69c04451038daf7782f603/dotnet-sdk-8.0.300-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d5817ef4-da4a-41f0-91dc-afd8436394d1/462bd8eee30ba9fd0fe152cc402bbded/dotnet-sdk-8.0.300-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4a252cd9-d7b7-41bf-a7f0-b2b10b45c068/1aff08f401d0e3980ac29ccba44efb29/dotnet-sdk-8.0.300-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/9f854d0d-dbb2-4bd0-a2e9-d46d0d612be8/142646adaedce26ccc67b020b0123f42/dotnet-sdk-8.0.300-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4d7af168-9a20-40a3-8744-b2f1c10c0227/3d6d8d16545d6c05125c51ef8142296f/dotnet-sdk-8.0.300-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e7e9bfe4-8277-4b2f-946a-b49c2b910884/0a6c4853f7fec5d641087bf3ffabbd55/dotnet-sdk-8.0.300-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e05a3055-c987-4127-a315-51d6b982fd67/fbda30d8e461b2c5098f3c405378b559/dotnet-sdk-8.0.300-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/e195e4f5-00ee-4df3-8736-199aacf00b2a/1663c4f5dc168d390aa4507f09200423/dotnet-sdk-8.0.300-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/e6b2f6c7-43fd-4c8c-9a7f-5fedb699d8e7/b24f635b4bd15493d0cb148e8372fb5f/dotnet-sdk-8.0.300-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/90486d8a-fb5a-41be-bfe4-ad292c06153f/6673965085e00f5b305bbaa0b931cc96/dotnet-sdk-8.0.300-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6dd60d95-f5ae-414e-8259-b2a115e51714/c56f08471133d789dee9ffa52ddf5c1e/dotnet-sdk-8.0.300-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9736c2dc-c21d-4df6-8cb7-9365ed5461a9/4c360dc61c7cb6d26b48d2718341c68e/dotnet-sdk-8.0.300-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/5c682e5b-7ad7-4fca-8c1e-d393b2cd2e13/46a259f7cdfe8fc5e5b626191962c22c/dotnet-sdk-8.0.300-win-x86.zip
