# .NET 8.0.6 - May 28, 2024

The .NET 8.0.6 and .NET SDK 8.0.301 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.301
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/monitor/base](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor-base.md): .NET Monitor Base
* [dotnet/aspire-dashboard](https://github.com/dotnet/dotnet-docker/blob/main/README.aspire-dashboard.md): .NET Aspire Dashboard
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 8.0 Blog][dotnet-blog]

 .NET 8.0.6 release carries the security fixes and non-security fixes.

 ### WiX toolset signed with incorrect certificate

 The .NET 8.0.5 release on May 14, 2024 included updates to the WiX toolset which were incorrectly signed. This caused failures in scenarios on Windows where Code Integrity checks were enabled.

 [CVE-2024-20672 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-20672)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 8.0, .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET when processing X.509 certificates that may result in Denial of Service. This vulnerabilty only affects macOS.

## Visual Studio Compatibility

You need [Visual Studio 17.9](https://visualstudio.microsoft.com) or later to use .NET 8.0 on Windows. While not officially supported, we’ve also enabled rudimentary support for .NET 8 in Visual Studio for Mac. Users have to enable a preview feature in Preferences to enable the IDE to discover and use the .NET 8 SDK for creating, loading, building, and debugging projects. The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 8.0 and C# 12.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9362](https://github.com/dotnet/core/issues/9362) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.6.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.6-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.6-sha.txt

[linux-install]: ../install-linux.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/dotnet-and-dotnet-framework-may-2024-servicing-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-dotnet-8/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.6+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.6+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.6+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.6+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.2xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 8.0.6
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 8.0.6
Microsoft.Windows.Compatibility | 8.0.6
Microsoft.WindowsDesktop.App.Ref | 8.0.6
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 8.0.6
Microsoft.DotNet.ILCompiler | 8.0.6
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.arm64 | 8.0.6
Microsoft.NET.Sdk.WebAssembly.Pack | 8.0.6
Microsoft.NETCore.App.Host.linux-musl-arm | 8.0.6
Microsoft.NETCore.App.Host.linux-musl-x64 | 8.0.6
Microsoft.NETCore.App.Host.linux-x64 | 8.0.6
Microsoft.NETCore.App.Ref | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.browser-wasm | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.linux-musl-arm | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 8.0.6
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.6
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 8.0.6
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 8.0.6
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 8.0.6
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.6
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.6
runtime.win-x64.Microsoft.NETCore.DotNetHost | 8.0.6
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.6
Microsoft.NET.Runtime.WebAssembly.Sdk | 8.0.6
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 8.0.6
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 8.0.6
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x86 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x86 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.linux-arm | 8.0.6
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 8.0.6
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.osx-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.win-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 8.0.6
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 8.0.6
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.6
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 8.0.6
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.6
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 8.0.6
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.6
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.6
runtime.win-x64.Microsoft.DotNet.ILCompiler | 8.0.6
Microsoft.NET.Runtime.iOS.Sample.Mono | 8.0.6
Microsoft.NET.Runtime.LibraryBuilder.Sdk | 8.0.6
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 8.0.6
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 8.0.6
Microsoft.NETCore.App.Host.win-x64 | 8.0.6
Microsoft.NETCore.App.Host.linux-musl-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 8.0.6
Microsoft.NETCore.App.Runtime.linux-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.linux-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 8.0.6
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 8.0.6
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 8.0.6
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.6
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.6
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 8.0.6
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 8.0.6
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 8.0.6
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 8.0.6
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x64 | 8.0.6
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 8.0.6
Microsoft.NETCore.App.Crossgen2.linux-arm | 8.0.6
Microsoft.NETCore.App.Host.linux-arm64 | 8.0.6
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 8.0.6
Microsoft.NETCore.App.Host.linux-bionic-x64 | 8.0.6
Microsoft.NETCore.App.Host.win-arm64 | 8.0.6
Microsoft.NETCore.App.Host.win-x86 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.NativeAOT.osx-x64 | 8.0.6
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.6
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 8.0.6
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.6
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 8.0.6
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.6
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 8.0.6
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 8.0.6
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.6
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 8.0.6
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 8.0.6
Microsoft.NETCore.App.Crossgen2.win-arm64 | 8.0.6
Microsoft.NETCore.App.Host.osx-x64 | 8.0.6
Microsoft.NETCore.App.Host.osx-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.osx-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 8.0.6
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.6
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.6
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.6
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.6
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 8.0.6
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 8.0.6
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.6
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.6
runtime.osx-arm64.Microsoft.DotNet.ILCompiler | 8.0.6
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.6
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 8.0.6
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 8.0.6
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 8.0.6
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 8.0.6
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 8.0.6
Microsoft.NET.Runtime.wasm.Sample.Mono | 8.0.6
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm | 8.0.6
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.NativeAOT.osx-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 8.0.6
Microsoft.NETCore.DotNetHost | 8.0.6
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 8.0.6
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 8.0.6
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 8.0.6
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.6
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.6
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 8.0.6
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.6
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 8.0.6
runtime.win-x86.Microsoft.NETCore.DotNetHost | 8.0.6
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 8.0.6
Microsoft.NET.ILLink.Tasks | 8.0.6
Microsoft.NET.Runtime.MonoTargets.Sdk | 8.0.6
Microsoft.NET.Runtime.Android.Sample.Mono | 8.0.6
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 8.0.6
Microsoft.NET.Runtime.WebAssembly.Templates | 8.0.6
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk | 8.0.6
Microsoft.NETCore.App.Crossgen2.win-x86 | 8.0.6
Microsoft.NETCore.App.Crossgen2.linux-x64 | 8.0.6
Microsoft.NETCore.App.Crossgen2.osx-x64 | 8.0.6
Microsoft.NETCore.App.Crossgen2.win-x64 | 8.0.6
Microsoft.NETCore.App.Host.linux-arm | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.browser-wasm | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.ios-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvos-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.android-arm | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x64 | 8.0.6
Microsoft.NETCore.App.Runtime.NativeAOT.ios-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.NativeAOT.tvos-arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 8.0.6
Microsoft.NETCore.App.Runtime.win-x64 | 8.0.6
Microsoft.NETCore.App.Runtime.win-x86 | 8.0.6
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 8.0.6
Microsoft.NETCore.DotNetAppHost | 8.0.6
Microsoft.NETCore.DotNetHostResolver | 8.0.6
Microsoft.NETCore.DotNetHostPolicy | 8.0.6
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 8.0.6
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.6
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.6
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 8.0.6
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.6
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.6
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 8.0.6
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.6
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 8.0.6
System.Security.Cryptography.Xml | 8.0.1
Microsoft.AspNetCore.App.Runtime.win-x64 | 8.0.6
Microsoft.AspNetCore.App.Runtime.win-arm64 | 8.0.6
Microsoft.AspNetCore.Authentication.Google | 8.0.6
Microsoft.AspNetCore.Authentication.Negotiate | 8.0.6
Microsoft.AspNetCore.Components.Authorization | 8.0.6
Microsoft.AspNetCore.Components.Analyzers | 8.0.6
Microsoft.AspNetCore.Components.CustomElements | 8.0.6
Microsoft.AspNetCore.Components.Forms | 8.0.6
Microsoft.AspNetCore.Components.QuickGrid | 8.0.6
Microsoft.AspNetCore.Components.QuickGrid.EntityFrameworkAdapter | 8.0.6
Microsoft.AspNetCore.Components.WebAssembly.Server | 8.0.6
Microsoft.AspNetCore.Components.WebAssembly | 8.0.6
Microsoft.AspNetCore.Components.WebView | 8.0.6
Microsoft.AspNetCore.ConcurrencyLimiter | 8.0.6
Microsoft.AspNetCore.DataProtection.Abstractions | 8.0.6
Microsoft.AspNetCore.Connections.Abstractions | 8.0.6
Microsoft.AspNetCore.Http.Connections.Common | 8.0.6
Microsoft.AspNetCore.SignalR.Client.Core | 8.0.6
Microsoft.DotNet.Web.ItemTemplates.8.0 | 8.0.6
Microsoft.Extensions.Configuration.KeyPerFile | 8.0.6
Microsoft.Extensions.ApiDescription.Client | 8.0.6
Microsoft.Extensions.ApiDescription.Server | 8.0.6
Microsoft.Extensions.Caching.SqlServer | 8.0.6
Microsoft.Extensions.Caching.StackExchangeRedis | 8.0.6
Microsoft.Extensions.Diagnostics.HealthChecks | 8.0.6
Microsoft.Extensions.FileProviders.Embedded | 8.0.6
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 8.0.6
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 8.0.6
Microsoft.Extensions.Features | 8.0.6
Microsoft.Extensions.Identity.Core | 8.0.6
Microsoft.Extensions.Http.Polly | 8.0.6
Microsoft.Extensions.Logging.AzureAppServices | 8.0.6
Microsoft.Net.Http.Headers | 8.0.6
Microsoft.AspNetCore.App.Ref | 8.0.6
Microsoft.AspNetCore.Authentication.Certificate | 8.0.6
Microsoft.AspNetCore.Authorization | 8.0.6
Microsoft.AspNetCore.AzureAppServicesIntegration | 8.0.6
Microsoft.AspNetCore.Components | 8.0.6
Microsoft.AspNetCore.Components.Web | 8.0.6
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 8.0.6
Microsoft.AspNetCore.JsonPatch | 8.0.6
Microsoft.AspNetCore.Metadata | 8.0.6
Microsoft.AspNetCore.MiddlewareAnalysis | 8.0.6
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 8.0.6
Microsoft.AspNetCore.SignalR.Client | 8.0.6
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 8.0.6
Microsoft.Extensions.ObjectPool | 8.0.6
Microsoft.JSInterop.WebAssembly | 8.0.6
Microsoft.AspNetCore.App.Runtime.osx-x64 | 8.0.6
Microsoft.AspNetCore.Authentication.WsFederation | 8.0.6
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 8.0.6
Microsoft.AspNetCore.Authentication.JwtBearer | 8.0.6
Microsoft.AspNetCore.Authentication.Twitter | 8.0.6
Microsoft.AspNetCore.Authentication.OpenIdConnect | 8.0.6
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 8.0.6
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 8.0.6
Microsoft.AspNetCore.Http.Connections.Client | 8.0.6
Microsoft.AspNetCore.SignalR.Protocols.Json | 8.0.6
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 8.0.6
Microsoft.AspNetCore.SignalR.Common | 8.0.6
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 8.0.6
Microsoft.dotnet-openapi | 8.0.6
Microsoft.AspNetCore.WebUtilities | 8.0.6
Microsoft.DotNet.Web.Client.ItemTemplates | 8.0.6
Microsoft.DotNet.Web.ProjectTemplates.8.0 | 8.0.6
Microsoft.Extensions.Identity.Stores | 8.0.6
Microsoft.Extensions.Localization | 8.0.6
Microsoft.Extensions.WebEncoders | 8.0.6
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 8.0.6
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 8.0.6
Microsoft.AspNetCore.App.Runtime.linux-x64 | 8.0.6
dotnet-sql-cache | 8.0.6
Microsoft.AspNetCore.App.Runtime.linux-arm | 8.0.6
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 8.0.6
AspNetCoreRuntime.8.0.x86 | 8.0.6
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 8.0.6
Microsoft.AspNetCore.App.Runtime.win-x86 | 8.0.6
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 8.0.6
AspNetCoreRuntime.8.0.x64 | 8.0.6
Microsoft.AspNetCore.Authentication.Facebook | 8.0.6
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 8.0.6
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 8.0.6
Microsoft.AspNetCore.Cryptography.KeyDerivation | 8.0.6
Microsoft.AspNetCore.Cryptography.Internal | 8.0.6
Microsoft.AspNetCore.DataProtection | 8.0.6
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 8.0.6
Microsoft.AspNetCore.DataProtection.Extensions | 8.0.6
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 8.0.6
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 8.0.6
Microsoft.AspNetCore.HeaderPropagation | 8.0.6
Microsoft.AspNetCore.Grpc.JsonTranscoding | 8.0.6
Microsoft.AspNetCore.Grpc.Swagger | 0.8.6
Microsoft.AspNetCore.Hosting.WindowsServices | 8.0.6
Microsoft.AspNetCore.Identity.UI | 8.0.6
Microsoft.AspNetCore.OpenApi | 8.0.6
Microsoft.AspNetCore.Mvc.Testing | 8.0.6
Microsoft.AspNetCore.OutputCaching.StackExchangeRedis | 8.0.6
Microsoft.AspNetCore.Owin | 8.0.6
Microsoft.AspNetCore.SignalR.Specification.Tests | 8.0.6
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 8.0.6
Microsoft.AspNetCore.TestHost | 8.0.6
Microsoft.Authentication.WebAssembly.Msal | 8.0.6
Microsoft.AspNetCore.SpaProxy | 8.0.6
Microsoft.AspNetCore.SpaServices.Extensions | 8.0.6
Microsoft.Extensions.Localization.Abstractions | 8.0.6
Microsoft.JSInterop | 8.0.6
Microsoft.NET.Build.Containers | 8.0.106
FSharp.Core | 8.0.102
FSharp.Compiler.Service | 43.8.102
Microsoft.DotNet.ApiCompat.Task | 8.0.106
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.106
Microsoft.DotNet.Common.ItemTemplates | 8.0.106
Microsoft.DotNet.ApiCompat.Tool | 8.0.106
System.Drawing.Common | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-arm64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-x64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-x64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-arm64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-x64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-arm64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64.Msi.x64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-x64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-arm64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-arm64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64.Msi.x64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-arm64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-x64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-x64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64.Msi.arm64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64.Msi.x64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-x64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64.Msi.arm64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64.Msi.arm64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64.Msi.arm64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-arm64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64.Msi.x64 | 8.0.6
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64 | 8.0.6
Microsoft.EntityFrameworkCore.SqlServer.Abstractions | 8.0.6
Microsoft.Data.Sqlite | 8.0.6
Microsoft.EntityFrameworkCore.Abstractions | 8.0.6
Microsoft.EntityFrameworkCore | 8.0.6
Microsoft.EntityFrameworkCore.Cosmos | 8.0.6
Microsoft.EntityFrameworkCore.Sqlite.Core | 8.0.6
Microsoft.EntityFrameworkCore.Relational | 8.0.6
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 8.0.6
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 8.0.6
Microsoft.EntityFrameworkCore.SqlServer | 8.0.6
Microsoft.EntityFrameworkCore.Templates | 8.0.6
Microsoft.EntityFrameworkCore.Analyzers | 8.0.6
Microsoft.EntityFrameworkCore.SqlServer.HierarchyId | 8.0.6
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 8.0.6
Microsoft.EntityFrameworkCore.InMemory | 8.0.6
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 8.0.6
Microsoft.EntityFrameworkCore.Design | 8.0.6
Microsoft.EntityFrameworkCore.Proxies | 8.0.6
Microsoft.EntityFrameworkCore.Specification.Tests | 8.0.6
Microsoft.EntityFrameworkCore.Tools | 8.0.6
dotnet-ef | 8.0.6
Microsoft.Data.Sqlite.Core | 8.0.6
Microsoft.EntityFrameworkCore.Sqlite | 8.0.6
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.106
Microsoft.TemplateEngine.IDE | 8.0.106
Microsoft.TemplateEngine.Utils | 8.0.106
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.106
Microsoft.TemplateEngine.Samples | 8.0.106
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.106
Microsoft.TemplateEngine.Authoring.CLI | 8.0.106
Microsoft.TemplateEngine.Authoring.Templates | 8.0.106
Microsoft.TemplateEngine.Core.Contracts | 8.0.106
Microsoft.TemplateEngine.Abstractions | 8.0.106
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.106
Microsoft.TemplateEngine.Core | 8.0.106
Microsoft.TemplateEngine.Edge | 8.0.106
Microsoft.TemplateSearch.Common | 8.0.106
FSharp.Core | 8.0.200
Microsoft.DotNet.ApiCompat.Task | 8.0.206
Microsoft.DotNet.ApiCompat.Tool | 8.0.206
Microsoft.NET.Build.Containers | 8.0.206
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.206
FSharp.Compiler.Service | 43.8.200
Microsoft.DotNet.Common.ItemTemplates | 8.0.206
Microsoft.TemplateEngine.Abstractions | 8.0.206
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.206
Microsoft.TemplateEngine.Core.Contracts | 8.0.206
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.206
Microsoft.TemplateEngine.Edge | 8.0.206
Microsoft.TemplateEngine.Core | 8.0.206
Microsoft.TemplateEngine.Authoring.Templates | 8.0.206
Microsoft.TemplateEngine.IDE | 8.0.206
Microsoft.TemplateEngine.Samples | 8.0.206
Microsoft.TemplateEngine.Utils | 8.0.206
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.206
Microsoft.TemplateEngine.Authoring.CLI | 8.0.206
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.206
Microsoft.TemplateSearch.Common | 8.0.206
FSharp.Compiler.Service | 43.8.300
FSharp.Core | 8.0.300
Microsoft.DotNet.Common.ProjectTemplates.8.0| 8.0.301
Microsoft.DotNet.ApiCompat.Tool| 8.0.301
Microsoft.DotNet.ApiCompat.Task| 8.0.301
Microsoft.DotNet.Common.ItemTemplates| 8.0.301
Microsoft.NET.Build.Containers| 8.0.301
Microsoft.TemplateEngine.Authoring.Templates| 8.0.301
Microsoft.TemplateEngine.Edge| 8.0.301
Microsoft.TemplateEngine.Core.Contracts| 8.0.301
Microsoft.TemplateSearch.Common| 8.0.301
Microsoft.TemplateEngine.Abstractions| 8.0.301
Microsoft.TemplateEngine.Core| 8.0.301
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 8.0.301
Microsoft.TemplateEngine.Authoring.TemplateVerifier| 8.0.301
Microsoft.TemplateEngine.Authoring.CLI| 8.0.301
Microsoft.TemplateEngine.IDE| 8.0.301
Microsoft.TemplateEngine.Utils| 8.0.301
Microsoft.TemplateEngine.TemplateLocalizer.Core| 8.0.301
Microsoft.TemplateEngine.Authoring.Tasks| 8.0.301
Microsoft.TemplateEngine.Samples| 8.0.301


[//]: # ( Runtime 8.0.6)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eda981d2-9e7c-4764-b0f1-e677dc0d89fe/be9ad5e056212ca31ea1ef7a5dd2d9ba/dotnet-runtime-8.0.6-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0039e2c5-d78d-45fb-94c0-e258ff0335fe/c3bff45767f679bbab149398e9ee2c6b/dotnet-runtime-8.0.6-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2e0537ca-4530-42fb-a2b1-6e0ffd34859d/aa6158265cbc0fd4554d991a9156121e/dotnet-runtime-8.0.6-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/64add4b1-bd51-4710-a2e7-249138091327/72c5112bc9904b36b4d4294a381e8a01/dotnet-runtime-8.0.6-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1f540ce8-5cf0-4429-907b-46fc4a01978e/6f30eb80be6c69043e96b18936894d61/dotnet-runtime-8.0.6-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/021c3de8-14d5-493f-92dc-2c8f8be76961/6ee3407acebf74631bfc01f14301afa6/dotnet-runtime-8.0.6-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ea249dde-337d-417d-a615-1f2e0a29b1fc/ef9f8aab388fc5f9ef11a188c4da92fd/dotnet-runtime-8.0.6-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6f090da0-5f55-44f1-ac17-9bd001b33d66/eae314b23ab350b375e794e136a2ca9e/dotnet-runtime-8.0.6-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/9d3fae98-a6af-4ce8-868a-db721c5825a1/e70f1e87a433ab1fbf6b94eb5d0c162d/dotnet-runtime-8.0.6-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/20271d05-67e0-4356-87a9-0ce5102b5007/b7c91c6470e1c2ffbb493a35dd6883c0/dotnet-runtime-8.0.6-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c3add2bc-3173-4266-a1de-f68779aaf1d9/7bef323356317da51eb19674fed9a9a8/dotnet-runtime-8.0.6-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a4176606-dd6e-4419-9080-01c8c125fd45/162bceb73747f014725c6151c0d1c536/dotnet-runtime-8.0.6-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e4d4b66c-0581-41a1-b7ee-f23ccc79e4ec/1b56841378536d2795faaa214b2872e7/dotnet-runtime-8.0.6-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3c5bbae6-d848-46b0-bb65-c4f7a7ad4b2a/afba8a75f7e7f4f304362de0f1d4b3ea/dotnet-runtime-8.0.6-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5e43df68-58d8-4b50-b334-4ebd6cd017ea/4043450c7ccb64a6ce80780cc0659841/dotnet-runtime-8.0.6-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/53f7cef2-50bf-419d-bf36-69f2989729b6/31261cddb6f9517e76cc4ee71d67be8b/dotnet-runtime-8.0.6-win-x86.zip

[//]: # ( WindowsDesktop 8.0.6)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/3bee8b48-dd89-48c4-bb3c-1d786600a924/7a811fe983a4c5a61d79192e37c38e13/windowsdesktop-runtime-8.0.6-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/1d50d496-fb15-4bf6-957a-c340c0a9a81e/cb7ec8cb099ee10bad57254f1736e4f0/windowsdesktop-runtime-8.0.6-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/76e5dbb2-6ae3-4629-9a84-527f8feb709c/09002599b32d5d01dc3aa5dcdffcc984/windowsdesktop-runtime-8.0.6-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c33ca75f-f47c-4eb2-9b35-0d3a0d39d986/40080ba5834b05fc4ff059f7a60e7033/windowsdesktop-runtime-8.0.6-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/fb4a2e70-0c24-42f8-a549-4ea2b6e16831/e7bf08360f9c96ad3a90b0eb2edf96c0/windowsdesktop-runtime-8.0.6-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/bc38d8f3-ed1a-46ec-8f8f-19544085fc7f/0c2070145654146d4ca8f9e9f9a4601d/windowsdesktop-runtime-8.0.6-win-x86.zip

[//]: # ( ASP 8.0.6)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c27a9707-8627-43d3-837e-fa144bab2984/40f243e656752b87ff033e568d49b510/aspnetcore-runtime-8.0.6-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ccdcbb70-a5e9-4753-b6e3-4461ce56a69d/240803fc1ffba38ab3603778c03e9b87/aspnetcore-runtime-8.0.6-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6f8fc863-9b60-4106-843c-8805927cb87e/21589785dd727d63ff6c8c68decb6922/aspnetcore-runtime-8.0.6-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf5ae5c9-6d2d-44ee-8734-219607b6cb6c/72613294eba7b9bb11bf436da149dab3/aspnetcore-runtime-8.0.6-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/66ecdc3e-be71-4e85-9d55-95c3fee1066e/5e77a37d5ff492217e703ee391b39635/aspnetcore-runtime-8.0.6-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ce31d92b-b514-4f9c-843b-29c466871369/b332eba5641cbc6eed1e3a98480972d2/aspnetcore-runtime-8.0.6-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b90758d2-834d-4fe7-b97f-e8294b68d07c/71d63df9474999f831811dd6989d9ba7/aspnetcore-runtime-8.0.6-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ccd03400-c514-4956-9e9d-ad1bd67d1338/436b9590788dd3df98e73d4c5379c711/aspnetcore-runtime-8.0.6-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/ee1b10d3-aca1-4ae0-b74a-97bd30fa6d2d/87e7a62e9f5438342b66e673d422cd57/aspnetcore-runtime-8.0.6-win-arm64.exe
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/879b35cf-65fe-4072-9bc9-2aff035ed1e1/ecf45be70b47c7e53917237fad886bda/aspnetcore-runtime-8.0.6-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/38b32fc8-8070-4f14-bd52-65505fddc5ff/50e6cf3b7505eee02c3b3db8ea46ffe3/aspnetcore-runtime-8.0.6-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/520cd61e-9682-4051-8d92-865ab45f76ec/98078349ce015c3252baa8e8a8c65132/aspnetcore-runtime-8.0.6-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/88a7d3f3-615e-4771-8709-1e16873645b3/a36f311385df553e54201137f53d041e/aspnetcore-runtime-8.0.6-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/efe7c4fa-23d7-45b4-843e-ac8a466f18b9/178f4917f6b29edc149ebf404018b14d/aspnetcore-runtime-8.0.6-win-x86.zip
[aspnetcore-runtime-composite-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/23223793-f03f-4b30-a0f7-07fcdb687be8/01a4fb13a8360fcc208e172f8aa197d1/aspnetcore-runtime-composite-8.0.6-linux-arm.tar.gz
[aspnetcore-runtime-composite-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/933fe1c2-c361-4893-b187-06122ee95e52/20e0d984ff8be88ccdb6587c29fc8c3b/aspnetcore-runtime-composite-8.0.6-linux-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6cee00e7-81ab-40d9-bfe8-c54d9aee20a5/3f7980778d3bdb550d9fe1f301c5016b/aspnetcore-runtime-composite-8.0.6-linux-musl-arm.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7d2289a3-6d52-4b79-8577-245dcaf61e54/3531b11b9a71e0fea86683226d2f3eef/aspnetcore-runtime-composite-8.0.6-linux-musl-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1fe40625-1390-487a-a739-b78505215e95/a5e64f42110cfa77153011677703b1fa/aspnetcore-runtime-composite-8.0.6-linux-musl-x64.tar.gz
[aspnetcore-runtime-composite-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/23defc47-8cd4-4ada-901b-9bb942e3cde9/9c386c008a3dccc23c70de3dbbbbb1a2/aspnetcore-runtime-composite-8.0.6-linux-x64.tar.gz
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/751d3fcd-72db-4da2-b8d0-709c19442225/33cc492bde704bfd6d70a2b9109005a0/dotnet-hosting-8.0.6-win.exe

[//]: # ( SDK 8.0.301)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/033ecbe9-b763-43e6-ae77-386cc6896f17/991838457685c131961652535f07c46b/dotnet-sdk-8.0.301-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd9decc0-f3ef-46d6-b7d1-348b757781ad/9ad92a8f4b805feb3d017731e78eca15/dotnet-sdk-8.0.301-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b49b3399-7f12-4c7d-8ed4-f91f9228464e/b2490a730a9808c22c1deb8352644ba6/dotnet-sdk-8.0.301-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f83ee59e-214b-4569-9842-30df94f5e618/c6d8088c5bd2989e2cb48de6275f0c70/dotnet-sdk-8.0.301-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f7719d18-599f-4502-a04c-4362d2ec38d7/58df714cbc9fdff3384dd71b269caca7/dotnet-sdk-8.0.301-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/86497c4f-3dc8-4ee7-9f6a-9e0464059427/293d074c28bbfd9410f4db8e021fa290/dotnet-sdk-8.0.301-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/b07f0bc8-ce20-45e5-879a-a931beae3ca5/67426313b0bb8bc63ded3aeacaedca5e/dotnet-sdk-8.0.301-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c503e53c-0567-4604-b7a8-1d6e7a1357f5/53e78f56b01147a092c0cc273b443550/dotnet-sdk-8.0.301-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/825222be-354e-452e-ae45-f116d86ee0d3/c4ac600bb62a44265d54b8de48c1b273/dotnet-sdk-8.0.301-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6ef47a54-b1c6-4000-8df4-486f64464c2b/ae87b597b19312fa9f73b9f2f8c687bd/dotnet-sdk-8.0.301-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/96a6ef30-e6d0-40c8-bd0d-6013b3bddc43/591a51a6e538c12a3e1d5e2b57c5c863/dotnet-sdk-8.0.301-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/90961c76-55e1-406c-80b5-440306ac50cb/337ad62c9692c3e74e4e2b209f3a85f6/dotnet-sdk-8.0.301-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2e3d0e1d-ad81-4ca7-b186-49f2313547e7/ee8546e4148b87c6e14878b5055406e9/dotnet-sdk-8.0.301-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7ac2d880-2d57-4008-850e-4b42b829c354/e1c92cb3b6a85f53cab6fa55b14b49e3/dotnet-sdk-8.0.301-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/911f605a-faa3-4049-a215-749c8fd14d6a/a0f35ffe12843cbc69e484e7e02b857b/dotnet-sdk-8.0.301-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8ffefb00-26bf-4dc0-bfd3-82003b4f122e/05aad9cf85a8456cdbe08b2b59da866e/dotnet-sdk-8.0.301-win-x86.zip
