# .NET 8.0.7 - July 09, 2024

The .NET 8.0.7 and .NET SDK 8.0.303 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.303
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/monitor/base](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor-base.md): .NET Monitor Base
* [dotnet/aspire-dashboard](https://github.com/dotnet/dotnet-docker/blob/main/README.aspire-dashboard.md): .NET Aspire Dashboard
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples


## Notable Changes

 [.NET 8.0 Blog][dotnet-blog]

 .NET 8.0.7 release carries the security fixes and non-security fixes.

[CVE-2024-38095 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-38095)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0 and .NET 8.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A Vulnerability exists when System.Formats.Asn1 in .NET parses an X.509 certificate or collection of certificates, a malicious certificate can result in excessive CPU consumption on all platforms result in Denial of Service.

[CVE-2024-35264 | .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-35264)

Microsoft is releasing this security advisory to provide information about a vulnerability in  .NET 8.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A Vulnerability exists in ASP.NET Core 8 where Data Corruption in Kestrel HTTP/3 can result in remote code execution.

Note: HTTP/3 is experimental in .NET 6.0. If you are on .NET 6.0 and using HTTP/3, please upgrade to .NET 8.0.7

[CVE-2024-30105 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-30105)

Microsoft is releasing this security advisory to provide information about a vulnerability in  .NET 8.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET when calling the JsonSerializer.DeserializeAsyncEnumerable method against an untrusted input using System.Text.Json may result in Denial of Service.


## Visual Studio Compatibility

You need [Visual Studio 17.9](https://visualstudio.microsoft.com) or later to use .NET 8.0 on Windows. While not officially supported, we’ve also enabled rudimentary support for .NET 8 in Visual Studio for Mac. Users have to enable a preview feature in Preferences to enable the IDE to discover and use the .NET 8 SDK for creating, loading, building, and debugging projects. The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 8.0 and C# 12.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9390](https://github.com/dotnet/core/issues/9390) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.7.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.7-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.7-sha.txt

[linux-install]: install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/dotnet-and-dotnet-framework-july-2024-servicing-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-dotnet-8/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.7+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.7+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.7+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.7+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.2xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Ref | 8.0.7
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 8.0.7
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 8.0.7
Microsoft.Windows.Compatibility | 8.0.7
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 8.0.7
Microsoft.Extensions.Configuration.FileExtensions | 8.0.1
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x86 | 8.0.7
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.browser-wasm | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.linux-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 8.0.7
Microsoft.NETCore.DotNetHostPolicy | 8.0.7
Microsoft.NETCore.DotNetHostResolver | 8.0.7
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 8.0.7
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.7
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.7
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.7
Microsoft.NET.Runtime.WebAssembly.Sdk | 8.0.7
Microsoft.NET.Runtime.LibraryBuilder.Sdk | 8.0.7
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 8.0.7
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 8.0.7
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 8.0.7
Microsoft.NET.Runtime.WebAssembly.Templates | 8.0.7
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100 | 8.0.7
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.arm64 | 8.0.7
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Crossgen2.linux-x64 | 8.0.7
Microsoft.NETCore.App.Crossgen2.win-arm64 | 8.0.7
Microsoft.NETCore.App.Host.linux-musl-arm | 8.0.7
Microsoft.NETCore.App.Host.osx-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.ios-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 8.0.7
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.android-arm | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Runtime.NativeAOT.osx-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.NativeAOT.osx-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.NativeAOT.tvos-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.osx-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 8.0.7
Microsoft.NETCore.DotNetAppHost | 8.0.7
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.7
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.7
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 8.0.7
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 8.0.7
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 8.0.7
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.7
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 8.0.7
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.7
runtime.osx-arm64.Microsoft.DotNet.ILCompiler | 8.0.7
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 8.0.7
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.7
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.7
runtime.win-x64.Microsoft.DotNet.ILCompiler | 8.0.7
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 8.0.7
runtime.win-x64.Microsoft.NETCore.DotNetHost | 8.0.7
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 8.0.7
System.Formats.Asn1 | 8.0.1
System.Text.Json | 8.0.4
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk | 8.0.7
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x86 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvos-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.linux-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.NativeAOT.ios-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 8.0.7
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 8.0.7
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 8.0.7
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.7
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 8.0.7
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.7
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 8.0.7
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 8.0.7
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 8.0.7
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.7
System.Threading.Tasks.Dataflow | 8.0.1
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 8.0.7
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x64 | 8.0.7
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100 | 8.0.7
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x64 | 8.0.7
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 8.0.7
Microsoft.NETCore.App.Crossgen2.win-x86 | 8.0.7
Microsoft.NETCore.App.Host.linux-arm | 8.0.7
Microsoft.NETCore.App.Host.linux-musl-arm64 | 8.0.7
Microsoft.NETCore.App.Host.linux-x64 | 8.0.7
Microsoft.NETCore.App.Host.osx-x64 | 8.0.7
Microsoft.NETCore.App.Host.win-arm64 | 8.0.7
Microsoft.NETCore.App.Host.win-x86 | 8.0.7
Microsoft.NETCore.App.Ref | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.osx-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.win-x86 | 8.0.7
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.7
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 8.0.7
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.7
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 8.0.7
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.7
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 8.0.7
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 8.0.7
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 8.0.7
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.7
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.7
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 8.0.7
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.7
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 8.0.7
Microsoft.Extensions.Configuration.Binder | 8.0.2
Microsoft.Extensions.DependencyModel | 8.0.1
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm | 8.0.7
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.arm64 | 8.0.7
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x86 | 8.0.7
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100 | 8.0.7
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x64 | 8.0.7
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 8.0.7
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.browser-wasm | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 8.0.7
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.win-x64 | 8.0.7
Microsoft.NETCore.DotNetHost | 8.0.7
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 8.0.7
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.7
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.7
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.7
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 8.0.7
System.Net.Http.WinHttpHandler | 8.0.1
Microsoft.DotNet.ILCompiler | 8.0.7
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 8.0.7
Microsoft.NET.Runtime.iOS.Sample.Mono | 8.0.7
Microsoft.NET.Runtime.wasm.Sample.Mono | 8.0.7
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 8.0.7
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 8.0.7
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 8.0.7
Microsoft.NET.Sdk.WebAssembly.Pack | 8.0.7
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 8.0.7
Microsoft.NETCore.App.Host.linux-musl-x64 | 8.0.7
Microsoft.NETCore.App.Host.win-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.linux-arm | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.win-arm64 | 8.0.7
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.7
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.7
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.7
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.7
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 8.0.7
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.7
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 8.0.7
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 8.0.7
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.7
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.7
Microsoft.NET.ILLink.Tasks | 8.0.7
Microsoft.NET.Runtime.MonoTargets.Sdk | 8.0.7
Microsoft.NET.Runtime.Android.Sample.Mono | 8.0.7
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 8.0.7
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 8.0.7
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 8.0.7
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 8.0.7
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Crossgen2.linux-arm | 8.0.7
Microsoft.NETCore.App.Crossgen2.osx-x64 | 8.0.7
Microsoft.NETCore.App.Crossgen2.win-x64 | 8.0.7
Microsoft.NETCore.App.Host.linux-arm64 | 8.0.7
Microsoft.NETCore.App.Host.linux-bionic-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x86 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.linux-musl-arm | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 8.0.7
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x64 | 8.0.7
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-x64 | 8.0.7
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 8.0.7
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 8.0.7
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.7
runtime.win-x86.Microsoft.NETCore.DotNetHost | 8.0.7
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 8.0.7
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 8.0.7
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 8.0.7
Microsoft.AspNetCore.Components.WebAssembly.Server | 8.0.7
Microsoft.AspNetCore.Grpc.Swagger | 0.8.7
Microsoft.AspNetCore.Hosting.WindowsServices | 8.0.7
Microsoft.AspNetCore.OpenApi | 8.0.7
Microsoft.AspNetCore.OutputCaching.StackExchangeRedis | 8.0.7
Microsoft.AspNetCore.Owin | 8.0.7
Microsoft.AspNetCore.SignalR.Client | 8.0.7
Microsoft.AspNetCore.SignalR.Client.Core | 8.0.7
Microsoft.Extensions.ApiDescription.Client | 8.0.7
Microsoft.Extensions.Caching.SqlServer | 8.0.7
Microsoft.Extensions.Caching.StackExchangeRedis | 8.0.7
Microsoft.Extensions.Http.Polly | 8.0.7
Microsoft.Extensions.Logging.AzureAppServices | 8.0.7
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 8.0.7
AspNetCoreRuntime.8.0.x64 | 8.0.7
Microsoft.AspNetCore.App.Runtime.win-x86 | 8.0.7
Microsoft.Extensions.Localization | 8.0.7
Microsoft.Extensions.WebEncoders | 8.0.7
Microsoft.Net.Http.Headers | 8.0.7
AspNetCoreRuntime.8.0.x86 | 8.0.7
Microsoft.AspNetCore.App.Runtime.win-x64 | 8.0.7
Microsoft.AspNetCore.Authentication.Twitter | 8.0.7
Microsoft.AspNetCore.Authentication.WsFederation | 8.0.7
Microsoft.AspNetCore.Components.Analyzers | 8.0.7
Microsoft.AspNetCore.Components.QuickGrid | 8.0.7
Microsoft.AspNetCore.HeaderPropagation | 8.0.7
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 8.0.7
Microsoft.AspNetCore.SignalR.Protocols.Json | 8.0.7
Microsoft.AspNetCore.TestHost | 8.0.7
Microsoft.Extensions.Configuration.KeyPerFile | 8.0.7
Microsoft.Extensions.Features | 8.0.7
Microsoft.AspNetCore.App.Runtime.osx-x64 | 8.0.7
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 8.0.7
Microsoft.AspNetCore.Authentication.OpenIdConnect | 8.0.7
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 8.0.7
Microsoft.AspNetCore.Authorization | 8.0.7
Microsoft.AspNetCore.Components | 8.0.7
Microsoft.AspNetCore.Components.CustomElements | 8.0.7
Microsoft.AspNetCore.Components.Authorization | 8.0.7
Microsoft.AspNetCore.Components.Forms | 8.0.7
Microsoft.AspNetCore.Components.QuickGrid.EntityFrameworkAdapter | 8.0.7
Microsoft.AspNetCore.Components.Web | 8.0.7
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 8.0.7
Microsoft.AspNetCore.Components.WebAssembly | 8.0.7
Microsoft.DotNet.Web.ItemTemplates.8.0 | 8.0.7
Microsoft.Extensions.ApiDescription.Server | 8.0.7
Microsoft.AspNetCore.App.Runtime.linux-arm | 8.0.7
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 8.0.7
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 8.0.7
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 8.0.7
Microsoft.AspNetCore.App.Ref | 8.0.7
Microsoft.AspNetCore.App.Runtime.win-arm64 | 8.0.7
Microsoft.AspNetCore.App.Runtime.linux-x64 | 8.0.7
Microsoft.AspNetCore.Authentication.Certificate | 8.0.7
Microsoft.AspNetCore.Authentication.JwtBearer | 8.0.7
Microsoft.AspNetCore.Authentication.Google | 8.0.7
Microsoft.AspNetCore.Authentication.Facebook | 8.0.7
Microsoft.AspNetCore.Authentication.Negotiate | 8.0.7
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 8.0.7
Microsoft.AspNetCore.AzureAppServicesIntegration | 8.0.7
Microsoft.AspNetCore.ConcurrencyLimiter | 8.0.7
Microsoft.AspNetCore.Components.WebView | 8.0.7
Microsoft.AspNetCore.Connections.Abstractions | 8.0.7
Microsoft.AspNetCore.Cryptography.Internal | 8.0.7
Microsoft.AspNetCore.Cryptography.KeyDerivation | 8.0.7
Microsoft.AspNetCore.DataProtection | 8.0.7
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 8.0.7
Microsoft.AspNetCore.Http.Connections.Common | 8.0.7
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 8.0.7
Microsoft.AspNetCore.JsonPatch | 8.0.7
Microsoft.AspNetCore.Metadata | 8.0.7
Microsoft.AspNetCore.MiddlewareAnalysis | 8.0.7
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 8.0.7
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 8.0.7
Microsoft.AspNetCore.SignalR.Common | 8.0.7
Microsoft.AspNetCore.SignalR.Specification.Tests | 8.0.7
Microsoft.AspNetCore.SpaProxy | 8.0.7
Microsoft.AspNetCore.SpaServices.Extensions | 8.0.7
Microsoft.AspNetCore.WebUtilities | 8.0.7
Microsoft.dotnet-openapi | 8.0.7
Microsoft.Authentication.WebAssembly.Msal | 8.0.7
Microsoft.DotNet.Web.ProjectTemplates.8.0 | 8.0.7
Microsoft.Extensions.Diagnostics.HealthChecks | 8.0.7
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 8.0.7
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 8.0.7
Microsoft.Extensions.FileProviders.Embedded | 8.0.7
Microsoft.Extensions.Identity.Stores | 8.0.7
Microsoft.Extensions.Identity.Core | 8.0.7
dotnet-sql-cache | 8.0.7
Microsoft.AspNetCore.DataProtection.Abstractions | 8.0.7
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 8.0.7
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 8.0.7
Microsoft.AspNetCore.DataProtection.Extensions | 8.0.7
Microsoft.AspNetCore.Identity.UI | 8.0.7
Microsoft.AspNetCore.Grpc.JsonTranscoding | 8.0.7
Microsoft.AspNetCore.Http.Connections.Client | 8.0.7
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 8.0.7
Microsoft.AspNetCore.Mvc.Testing | 8.0.7
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 8.0.7
Microsoft.DotNet.Web.Client.ItemTemplates | 8.0.7
Microsoft.Extensions.Localization.Abstractions | 8.0.7
Microsoft.Extensions.ObjectPool | 8.0.7
Microsoft.JSInterop | 8.0.7
Microsoft.JSInterop.WebAssembly | 8.0.7
Microsoft.DotNet.ApiCompat.Task | 8.0.107
Microsoft.NET.Build.Containers | 8.0.107
FSharp.Compiler.Service | 43.8.102
FSharp.Core | 8.0.102
Microsoft.DotNet.Common.ItemTemplates | 8.0.107
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.107
Microsoft.DotNet.ApiCompat.Tool | 8.0.107
System.Drawing.Common | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-arm64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-arm64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-x64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-x64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64.Msi.x64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64.Msi.arm64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-arm64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-x64 | 8.0.7
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.arm64 | 8.0.7
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x86 | 8.0.7
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.arm64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-x64 | 8.0.7
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x64 | 8.0.7
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-arm64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-x64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64.Msi.arm64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64 | 8.0.7
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x86 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64 | 8.0.7
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-arm64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-x64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64.Msi.x64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64.Msi.x64 | 8.0.7
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x64 | 8.0.7
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x86 | 8.0.7
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-arm64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-x64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-arm64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64.Msi.arm64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64.Msi.x64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64.Msi.arm64 | 8.0.7
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.arm64 | 8.0.7
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64 | 8.0.7
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100 | 8.0.7
dotnet-ef | 8.0.7
Microsoft.Data.Sqlite | 8.0.7
Microsoft.EntityFrameworkCore | 8.0.7
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 8.0.7
Microsoft.EntityFrameworkCore.Analyzers | 8.0.7
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 8.0.7
Microsoft.EntityFrameworkCore.Sqlite.Core | 8.0.7
Microsoft.Data.Sqlite.Core | 8.0.7
Microsoft.EntityFrameworkCore.Design | 8.0.7
Microsoft.EntityFrameworkCore.Sqlite | 8.0.7
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 8.0.7
Microsoft.EntityFrameworkCore.SqlServer | 8.0.7
Microsoft.EntityFrameworkCore.SqlServer.HierarchyId | 8.0.7
Microsoft.EntityFrameworkCore.SqlServer.Abstractions | 8.0.7
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 8.0.7
Microsoft.EntityFrameworkCore.Templates | 8.0.7
Microsoft.EntityFrameworkCore.Tools | 8.0.7
Microsoft.EntityFrameworkCore.Abstractions | 8.0.7
Microsoft.EntityFrameworkCore.Cosmos | 8.0.7
Microsoft.EntityFrameworkCore.Specification.Tests | 8.0.7
Microsoft.EntityFrameworkCore.Proxies | 8.0.7
Microsoft.EntityFrameworkCore.InMemory | 8.0.7
Microsoft.EntityFrameworkCore.Relational | 8.0.7
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.107
Microsoft.TemplateEngine.Utils | 8.0.107
Microsoft.TemplateEngine.Abstractions | 8.0.107
Microsoft.TemplateEngine.Authoring.CLI | 8.0.107
Microsoft.TemplateEngine.Authoring.Templates | 8.0.107
Microsoft.TemplateEngine.Core | 8.0.107
Microsoft.TemplateEngine.Edge | 8.0.107
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.107
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.107
Microsoft.TemplateEngine.Core.Contracts | 8.0.107
Microsoft.TemplateSearch.Common | 8.0.107
Microsoft.TemplateEngine.IDE | 8.0.107
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.107
Microsoft.TemplateEngine.Samples | 8.0.107
Microsoft.CodeAnalysis.Metrics | 4.0.0-beta1.24303.2
Microsoft.CodeAnalysis.AnalyzerUtilities | 3.11.0-beta1.24303.2
Microsoft.CodeAnalysis.NetAnalyzers | 8.0.0-preview.24303.2
Microsoft.CodeAnalysis.BannedApiAnalyzers | 3.11.0-beta1.24303.2
Roslyn.Diagnostics.Analyzers | 3.11.0-beta1.24303.2
Microsoft.CodeAnalysis.PerformanceSensitiveAnalyzers | 3.11.0-beta1.24303.2
Microsoft.CodeAnalysis.PublicApiAnalyzers | 3.11.0-beta1.24303.2
Microsoft.CodeAnalysis.RulesetToEditorconfigConverter | 3.11.0-beta1.24303.2
Microsoft.CodeAnalysis.Analyzers | 3.11.0-beta1.24303.2
Microsoft.CodeAnalysis.ResxSourceGenerator | 3.11.0-beta1.24303.2
Text.Analyzers | 3.11.0-beta1.24303.2
FSharp.Compiler.Service | 43.8.301
FSharp.Core | 8.0.301
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.303
Microsoft.DotNet.ApiCompat.Task | 8.0.303
Microsoft.DotNet.Common.ItemTemplates | 8.0.303
Microsoft.DotNet.ApiCompat.Tool | 8.0.303
Microsoft.NET.Build.Containers | 8.0.303
Microsoft.TemplateEngine.Abstractions | 8.0.303
Microsoft.TemplateEngine.Authoring.Templates | 8.0.303
Microsoft.TemplateEngine.Core.Contracts | 8.0.303
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.303
Microsoft.TemplateEngine.Samples | 8.0.303
Microsoft.TemplateEngine.Authoring.CLI | 8.0.303
Microsoft.TemplateEngine.IDE | 8.0.303
Microsoft.TemplateEngine.Edge | 8.0.303
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.303
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.303
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.303
Microsoft.TemplateEngine.Core | 8.0.303
Microsoft.TemplateEngine.Utils | 8.0.303
Microsoft.TemplateSearch.Common | 8.0.303

[//]: # ( Runtime 8.0.7)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1dc20d39-a5c4-4e23-a70b-842fcd6d603a/814d37d9c67811d9d2837905e4330eab/dotnet-runtime-8.0.7-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/710337b9-9cb6-4bc8-8d13-daeab2578a08/b3ec8c17f85e340820a0ab36a3870168/dotnet-runtime-8.0.7-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2bb39900-40fb-4a9b-8c6c-17a46d2022ca/8fa92b782e35d1799e987487b06da37e/dotnet-runtime-8.0.7-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/131bbb56-05f0-42f5-bcd0-7f34519c3987/88bfa5e29ea09629c1e62857402cd466/dotnet-runtime-8.0.7-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/938cbaf9-8ed5-44c4-bbb3-fa982add0482/29c59ec494a4349190c29b2d03d8957b/dotnet-runtime-8.0.7-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cf3418ca-0e14-4b76-b615-ac2f2497f8ec/2583028ea52460cb1534d929dc7970fe/dotnet-runtime-8.0.7-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ae4430fd-26d6-4bd3-838a-314ffd356c78/24147e9a69b371bea66a1789bda6a1d5/dotnet-runtime-8.0.7-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ccacebeb-3dda-4887-9a98-e2dc9a9d9dc2/0ecac27f49c0111f4877cac54ff873a0/dotnet-runtime-8.0.7-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4f7ffd35-2e7a-4a42-b096-7b344ddbb514/bb2e3a4af76ab0f3c39fd01bb0b51e6f/dotnet-runtime-8.0.7-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c0e3a3f4-d235-4531-a1f2-1ff969cac1ab/837430d708532d74b7296108a681b9bb/dotnet-runtime-8.0.7-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/68d0360d-462a-44db-baa9-53fd5d67c05b/6b2c172c219ef4d083c3f4b7f69ae97b/dotnet-runtime-8.0.7-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/12a17ef1-071d-489e-b138-1fd5249ac7f9/4e6030ef34957f9120171a74932f4fb5/dotnet-runtime-8.0.7-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3980ab0a-379f-44a0-9be6-eaf74c07a3b3/bd1cc6107ff3d8fe0104d30f01339b74/dotnet-runtime-8.0.7-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0f2e2c47-3e38-45be-aa3b-f382c5e73ff8/c7890b45dbd8306b4d89daa55abe49f6/dotnet-runtime-8.0.7-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b1dc2db4-3337-4ee1-a1e9-91768860af9e/78fafd2bcbd8937fae5ba1bb97071138/dotnet-runtime-8.0.7-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3e0c1889-b4f7-414c-9ac9-cdc82938563d/daed61ae792654223bcac886ff3725ba/dotnet-runtime-8.0.7-win-x86.zip

[//]: # ( WindowsDesktop 8.0.7)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/93f3856a-ba9e-4fd2-9a6e-abd7cad44c27/3f70ef9e35cc7225199321e70af12d20/windowsdesktop-runtime-8.0.7-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/cd3562da-babb-4500-862c-69a73491ba86/c8f403b2ade8a420ba1f0a2f7634394a/windowsdesktop-runtime-8.0.7-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/bb581716-4cca-466e-9857-512e2371734b/5fe261422a7305171866fd7812d0976f/windowsdesktop-runtime-8.0.7-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c96053c9-c748-460a-a74f-934c0318c219/6f235374716b2edda4cfb2bbb931a923/windowsdesktop-runtime-8.0.7-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/853ca8b3-f0d0-4aac-a33b-d93bb1c991e9/9664c41e36cffd82b4f04471020116a7/windowsdesktop-runtime-8.0.7-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b51c48b6-5d6e-4972-aff6-6670a6e78aad/349941bf042167a212b7041bcbb269f7/windowsdesktop-runtime-8.0.7-win-x86.zip

[//]: # ( ASP 8.0.7)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d37fc703-70c6-46f2-a5a1-b60f45fd71d0/6a74aa0bb89feb7f795df1ea92d030bf/aspnetcore-runtime-8.0.7-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/421d499f-85cb-43dd-97b2-8ebfd06dda8a/61b03be4662125e4af044c7881e66f0e/aspnetcore-runtime-8.0.7-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a3898e56-a160-4817-b6a2-712c5cb64266/1a465710acd917f8002548f426deebd0/aspnetcore-runtime-8.0.7-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d7c07119-b207-4ded-b41f-2f3fca16099b/4463b6690425cf7faa37519dfbe89a46/aspnetcore-runtime-8.0.7-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7fb2c473-d403-4347-83c8-243b9840d7f1/2aeb8220ea65ee119627f6145102599e/aspnetcore-runtime-8.0.7-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/06cbb934-ef54-4627-8848-a24a879f2130/52d4247944cee754ec8f4fd617d502a6/aspnetcore-runtime-8.0.7-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f8909467-b187-4651-86ab-6edbbc21f6e8/f07e4a0141b3907f83079c0dd44188ca/aspnetcore-runtime-8.0.7-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e2410d8b-380c-400f-ae85-c0451afc35e1/cf601795432ee94bf55f03f8fef08e6d/aspnetcore-runtime-8.0.7-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/21fa80b8-7132-497e-a44b-f25b6790ac37/512c8a433fcb462de3ff06dac0f651c7/aspnetcore-runtime-8.0.7-win-arm64.exe
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/c9015caa-2f1c-4eb3-a0c7-69fdca47bb7b/2d5d3957612f18c92f806fc73c999346/aspnetcore-runtime-8.0.7-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e7cd032b-21b3-4a9d-82cc-5249dd7fe092/00af1c24dd391c81df9d89cb737c9954/aspnetcore-runtime-8.0.7-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/66352bdb-4385-424b-bdfd-7b86ff004efd/9688194ae6987d772b703ae025cd1548/aspnetcore-runtime-8.0.7-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/fae41b37-b28e-48d7-8582-8a68fe782c17/bdf588c806eb1316eab1aeade3b511fa/aspnetcore-runtime-8.0.7-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/168ffae8-e7c4-494c-9a2f-47e13c8ce5a4/01361017da1145dd454f12813d534768/aspnetcore-runtime-8.0.7-win-x86.zip
[aspnetcore-runtime-composite-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1a3a7b22-e1a4-49c0-b54a-2d86c4d65190/45d081b0224e9c9155085dce92758ff8/aspnetcore-runtime-composite-8.0.7-linux-arm.tar.gz
[aspnetcore-runtime-composite-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/22c5ff01-2f30-4dae-a415-ccabc5a08982/8db4ea4303f68c207c4e0e0316d0c952/aspnetcore-runtime-composite-8.0.7-linux-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/39b3562d-dc87-4d32-bfaa-dc79764d6106/748a05efe11178c0f60acf7be736611e/aspnetcore-runtime-composite-8.0.7-linux-musl-arm.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a9bc830a-a4ea-4883-ad4f-81bf9fdca20e/f3e33897a16e90b49a775ef220c34a56/aspnetcore-runtime-composite-8.0.7-linux-musl-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1f1e9fd5-c98d-46be-a4b2-904a68af7db4/ddef01f271e583354cfd891f975a4b41/aspnetcore-runtime-composite-8.0.7-linux-musl-x64.tar.gz
[aspnetcore-runtime-composite-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/53cd4d8d-c54a-49e8-bcc3-9892e3f885b9/db1f8704e2e7cc7540aaf9e06b381d43/aspnetcore-runtime-composite-8.0.7-linux-x64.tar.gz
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/7d169ca8-2755-4870-b45c-bfc651013a77/46639ef8e327f00ab1a941288dd28abe/dotnet-hosting-8.0.7-win.exe

[//]: # ( SDK 8.0.303)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9e0bdcde-1878-4351-883a-c0adbb570bba/156df738634f710dad131e993fc0f48a/dotnet-sdk-8.0.303-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4bfdbe1a-e1f9-4535-8da6-6e1e7ea0994c/b110641d008b36dded561ff2bdb0f793/dotnet-sdk-8.0.303-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2ff544fc-a1c1-4dc8-b489-aa43117f314c/228b6791886d5243f29d17390c8661ae/dotnet-sdk-8.0.303-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cc4a53e2-53e4-4d13-8b19-6bb5df78eeaa/1989589954758fa2883080f290da47b4/dotnet-sdk-8.0.303-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c75c7461-fe0f-4483-9e1b-b5f629dbd51b/da8d9a8dbfd6e6bc144ef930259bf346/dotnet-sdk-8.0.303-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/60218cc4-13eb-41d5-aa0b-5fd5a3fb03b8/6c42bee7c3651b1317b709a27a741362/dotnet-sdk-8.0.303-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/763ab233-7f0e-481c-8b8a-c432328330a5/8a1d8bed9188f553e1cd3ea2b615a93a/dotnet-sdk-8.0.303-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d81d84cf-4bb8-4371-a4d2-88699a38a83b/9bddfe1952bedc37e4130ff12abc698d/dotnet-sdk-8.0.303-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/827eac3c-729c-4416-bdf4-0fae6ec6492f/40ccf2187797de61688d354da3e43090/dotnet-sdk-8.0.303-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/295f5e51-4d26-4706-90c1-25b745cd2abf/ef976bfc166782e519036ee7670eac36/dotnet-sdk-8.0.303-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a141a071-019c-4fb3-9611-30bf2015704f/1542d3366480dbf57f1d98e3debde994/dotnet-sdk-8.0.303-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/047ba9ae-13be-47a6-aafc-f95935068573/ba7ab57972d76fae909506a2cde85b9f/dotnet-sdk-8.0.303-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d1adccfa-62de-4306-9410-178eafb4eeeb/48e3746867707de33ef01036f6afc2c6/dotnet-sdk-8.0.303-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/93d39941-31b3-4c50-b124-0de50d464fe5/93a0dddb827811ff50586cb361f613b0/dotnet-sdk-8.0.303-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7ce6d94a-13c1-4102-bb1b-b0f7ea5afb6e/0764c80c81c16ab927c0a7321f7c07cf/dotnet-sdk-8.0.303-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/351df7c4-0671-45da-9eb9-dfb165486ce3/4526c9497d5fe8a68886010f0d298b0a/dotnet-sdk-8.0.303-win-x86.zip
