# .NET 8.0.8 - August 13, 2024

The .NET 8.0.8 and .NET SDK 8.0.400 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.400
```
## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/monitor/base](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor-base.md): .NET Monitor Base
* [dotnet/aspire-dashboard](https://github.com/dotnet/dotnet-docker/blob/main/README.aspire-dashboard.md): .NET Aspire Dashboard
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 8.0 Blog][dotnet-blog]

 .NET 8.0.8 release carries the security fixes and non-security fixes.

[CVE-2024-38168 | .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-38168)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 8.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET when an attacker through unauthenticated requests may trigger a Denial of Service in ASP.NET HTTP.sys web server. This is a windows OS only vulnerability.

[CVE-2024-38167 | .NET Information Disclosure Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-38167)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 8.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET runtime TlsStream which may result in Information Disclosure.

## Visual Studio Compatibility

You need [Visual Studio 17.11](https://visualstudio.microsoft.com) or later to use .NET 8.0 on Windows. While not officially supported, we’ve also enabled rudimentary support for .NET 8 in Visual Studio for Mac. Users have to enable a preview feature in Preferences to enable the IDE to discover and use the .NET 8 SDK for creating, loading, building, and debugging projects. The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 8.0 and C# 12.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #9447](https://github.com/dotnet/core/issues/9447) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.8.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.8-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.8-sha.txt

[linux-install]: ../install-linux.md
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/dotnet-and-dotnet-framework-august-2024-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-dotnet-8/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.8+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.8+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.8+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.8+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.8xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 8.0.8
Microsoft.Windows.Compatibility | 8.0.8
Microsoft.WindowsDesktop.App.Ref | 8.0.8
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 8.0.8
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 8.0.8
Microsoft.NETCore.App.Host.osx-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.osx-x64 | 8.0.8
Microsoft.DotNet.ILCompiler | 8.0.8
Microsoft.NET.Runtime.Android.Sample.Mono | 8.0.8
Microsoft.NET.Runtime.wasm.Sample.Mono | 8.0.8
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.arm64 | 8.0.8
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 8.0.8
Microsoft.NETCore.App.Crossgen2.win-arm64 | 8.0.8
Microsoft.NETCore.App.Crossgen2.win-x64 | 8.0.8
Microsoft.NETCore.App.Host.linux-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvos-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm | 8.0.8
Microsoft.NETCore.App.Runtime.NativeAOT.ios-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.NativeAOT.osx-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.win-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.win-x86 | 8.0.8
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 8.0.8
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.8
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 8.0.8
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 8.0.8
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.8
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 8.0.8
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 8.0.8
runtime.win-x64.Microsoft.NETCore.DotNetHost | 8.0.8
runtime.win-x86.Microsoft.NETCore.DotNetHost | 8.0.8
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.8
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 8.0.8
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 8.0.8
Microsoft.NET.Runtime.LibraryBuilder.Sdk | 8.0.8
Microsoft.NET.Runtime.iOS.Sample.Mono | 8.0.8
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 8.0.8
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 8.0.8
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 8.0.8
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 8.0.8
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x64 | 8.0.8
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100 | 8.0.8
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x64 | 8.0.8
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100 | 8.0.8
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 8.0.8
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.arm64 | 8.0.8
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm | 8.0.8
Microsoft.NETCore.App.Host.linux-arm | 8.0.8
Microsoft.NETCore.App.Host.linux-arm64 | 8.0.8
Microsoft.NETCore.App.Host.linux-musl-arm64 | 8.0.8
Microsoft.NETCore.App.Host.linux-musl-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.browser-wasm | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x86 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.ios-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.linux-arm | 8.0.8
Microsoft.NETCore.App.Runtime.linux-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 8.0.8
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x64 | 8.0.8
Microsoft.NET.Runtime.WebAssembly.Templates | 8.0.8
Microsoft.NETCore.App.Crossgen2.linux-arm | 8.0.8
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 8.0.8
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100 | 8.0.8
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 8.0.8
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 8.0.8
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 8.0.8
Microsoft.NETCore.App.Crossgen2.linux-x64 | 8.0.8
Microsoft.NETCore.App.Crossgen2.osx-x64 | 8.0.8
Microsoft.NETCore.App.Host.linux-bionic-x64 | 8.0.8
Microsoft.NETCore.App.Host.osx-x64 | 8.0.8
Microsoft.NETCore.App.Host.win-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.linux-musl-arm | 8.0.8
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.NativeAOT.tvos-arm64 | 8.0.8
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.8
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.8
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.8
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.8
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.8
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.8
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 8.0.8
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 8.0.8
Microsoft.NET.Runtime.WebAssembly.Sdk | 8.0.8
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 8.0.8
Microsoft.NET.Sdk.WebAssembly.Pack | 8.0.8
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 8.0.8
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 8.0.8
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 8.0.8
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk | 8.0.8
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 8.0.8
Microsoft.NETCore.App.Host.linux-musl-arm | 8.0.8
Microsoft.NETCore.App.Host.win-arm64 | 8.0.8
Microsoft.NETCore.App.Host.win-x86 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x64 | 8.0.8
Microsoft.NETCore.DotNetHost | 8.0.8
Microsoft.NETCore.DotNetHostPolicy | 8.0.8
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 8.0.8
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.8
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 8.0.8
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 8.0.8
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.8
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.8
Microsoft.NET.ILLink.Tasks | 8.0.8
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 8.0.8
Microsoft.NET.Runtime.MonoTargets.Sdk | 8.0.8
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x86 | 8.0.8
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Crossgen2.win-x86 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.browser-wasm | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 8.0.8
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.8
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 8.0.8
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 8.0.8
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.8
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.8
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 8.0.8
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 8.0.8
Microsoft.NETCore.App.Runtime.NativeAOT.osx-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.win-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 8.0.8
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 8.0.8
Microsoft.NETCore.DotNetHostResolver | 8.0.8
Microsoft.NETCore.DotNetAppHost | 8.0.8
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 8.0.8
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.8
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.8
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.8
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 8.0.8
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.8
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.8
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.8
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 8.0.8
System.Net.Http.WinHttpHandler | 8.0.2
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.osx-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 8.0.8
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.8
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.8
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 8.0.8
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 8.0.8
runtime.win-x64.Microsoft.DotNet.ILCompiler | 8.0.8
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 8.0.8
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x86 | 8.0.8
Microsoft.NETCore.App.Ref | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 8.0.8
Microsoft.NETCore.App.Runtime.linux-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 8.0.8
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 8.0.8
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.8
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 8.0.8
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 8.0.8
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-x64 | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 8.0.8
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 8.0.8
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-arm64 | 8.0.8
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.8
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 8.0.8
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.8
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.8
runtime.osx-arm64.Microsoft.DotNet.ILCompiler | 8.0.8
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.8
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.8
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 8.0.8
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 8.0.8
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.arm64 | 8.0.8
AspNetCoreRuntime.8.0.x86 | 8.0.8
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 8.0.8
Microsoft.AspNetCore.Http.Connections.Common | 8.0.8
Microsoft.AspNetCore.Identity.UI | 8.0.8
Microsoft.AspNetCore.SignalR.Specification.Tests | 8.0.8
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 8.0.8
Microsoft.AspNetCore.TestHost | 8.0.8
Microsoft.AspNetCore.SpaServices.Extensions | 8.0.8
Microsoft.AspNetCore.SpaProxy | 8.0.8
Microsoft.Extensions.Logging.AzureAppServices | 8.0.8
Microsoft.JSInterop | 8.0.8
Microsoft.Extensions.WebEncoders | 8.0.8
Microsoft.AspNetCore.App.Runtime.win-x86 | 8.0.8
Microsoft.AspNetCore.App.Runtime.linux-arm | 8.0.8
Microsoft.AspNetCore.Components.WebView | 8.0.8
Microsoft.AspNetCore.Cryptography.Internal | 8.0.8
Microsoft.AspNetCore.Cryptography.KeyDerivation | 8.0.8
Microsoft.AspNetCore.DataProtection | 8.0.8
Microsoft.AspNetCore.Http.Connections.Client | 8.0.8
Microsoft.AspNetCore.Hosting.WindowsServices | 8.0.8
Microsoft.AspNetCore.Owin | 8.0.8
Microsoft.AspNetCore.SignalR.Client.Core | 8.0.8
Microsoft.Extensions.Caching.SqlServer | 8.0.8
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 8.0.8
Microsoft.Extensions.Caching.StackExchangeRedis | 8.0.8
Microsoft.Extensions.Http.Polly | 8.0.8
Microsoft.AspNetCore.App.Runtime.win-arm64 | 8.0.8
Microsoft.AspNetCore.App.Ref | 8.0.8
Microsoft.AspNetCore.Authentication.Certificate | 8.0.8
Microsoft.JSInterop.WebAssembly | 8.0.8
AspNetCoreRuntime.8.0.x64 | 8.0.8
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 8.0.8
Microsoft.AspNetCore.Authorization | 8.0.8
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 8.0.8
Microsoft.AspNetCore.Components | 8.0.8
Microsoft.AspNetCore.AzureAppServicesIntegration | 8.0.8
Microsoft.AspNetCore.DataProtection.Abstractions | 8.0.8
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 8.0.8
Microsoft.AspNetCore.Authentication.Facebook | 8.0.8
Microsoft.AspNetCore.Authentication.Google | 8.0.8
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 8.0.8
Microsoft.AspNetCore.Authentication.JwtBearer | 8.0.8
Microsoft.AspNetCore.Authentication.OpenIdConnect | 8.0.8
Microsoft.AspNetCore.Authentication.Negotiate | 8.0.8
Microsoft.AspNetCore.Authentication.Twitter | 8.0.8
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 8.0.8
Microsoft.AspNetCore.Authentication.WsFederation | 8.0.8
Microsoft.AspNetCore.Components.Analyzers | 8.0.8
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 8.0.8
Microsoft.AspNetCore.Components.Authorization | 8.0.8
Microsoft.AspNetCore.Components.QuickGrid | 8.0.8
Microsoft.AspNetCore.Components.QuickGrid.EntityFrameworkAdapter | 8.0.8
Microsoft.AspNetCore.Components.WebAssembly | 8.0.8
Microsoft.AspNetCore.Components.WebAssembly.Server | 8.0.8
Microsoft.AspNetCore.Metadata | 8.0.8
Microsoft.AspNetCore.JsonPatch | 8.0.8
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 8.0.8
Microsoft.DotNet.Web.ItemTemplates.8.0 | 8.0.8
Microsoft.Extensions.ApiDescription.Server | 8.0.8
Microsoft.Extensions.ApiDescription.Client | 8.0.8
Microsoft.Extensions.Identity.Core | 8.0.8
Microsoft.Extensions.Identity.Stores | 8.0.8
Microsoft.Extensions.Localization | 8.0.8
Microsoft.Extensions.ObjectPool | 8.0.8
Microsoft.Extensions.Localization.Abstractions | 8.0.8
Microsoft.Net.Http.Headers | 8.0.8
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 8.0.8
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 8.0.8
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 8.0.8
Microsoft.AspNetCore.MiddlewareAnalysis | 8.0.8
Microsoft.AspNetCore.OutputCaching.StackExchangeRedis | 8.0.8
Microsoft.AspNetCore.OpenApi | 8.0.8
Microsoft.AspNetCore.Mvc.Testing | 8.0.8
Microsoft.AspNetCore.SignalR.Client | 8.0.8
Microsoft.dotnet-openapi | 8.0.8
Microsoft.AspNetCore.SignalR.Common | 8.0.8
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 8.0.8
Microsoft.AspNetCore.SignalR.Protocols.Json | 8.0.8
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 8.0.8
Microsoft.AspNetCore.WebUtilities | 8.0.8
Microsoft.DotNet.Web.Client.ItemTemplates | 8.0.8
Microsoft.Authentication.WebAssembly.Msal | 8.0.8
Microsoft.DotNet.Web.ProjectTemplates.8.0 | 8.0.8
Microsoft.Extensions.Configuration.KeyPerFile | 8.0.8
Microsoft.Extensions.Diagnostics.HealthChecks | 8.0.8
Microsoft.Extensions.Features | 8.0.8
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 8.0.8
Microsoft.Extensions.FileProviders.Embedded | 8.0.8
Microsoft.AspNetCore.App.Runtime.linux-x64 | 8.0.8
Microsoft.AspNetCore.App.Runtime.osx-x64 | 8.0.8
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 8.0.8
Microsoft.AspNetCore.App.Runtime.win-x64 | 8.0.8
dotnet-sql-cache | 8.0.8
Microsoft.AspNetCore.Components.Forms | 8.0.8
Microsoft.AspNetCore.Components.CustomElements | 8.0.8
Microsoft.AspNetCore.Components.Web | 8.0.8
Microsoft.AspNetCore.Connections.Abstractions | 8.0.8
Microsoft.AspNetCore.ConcurrencyLimiter | 8.0.8
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 8.0.8
Microsoft.AspNetCore.DataProtection.Extensions | 8.0.8
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 8.0.8
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 8.0.8
Microsoft.AspNetCore.Grpc.JsonTranscoding | 8.0.8
Microsoft.AspNetCore.HeaderPropagation | 8.0.8
Microsoft.AspNetCore.Grpc.Swagger | 0.8.8
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 8.0.8
Microsoft.DotNet.Common.ItemTemplates | 8.0.108
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.108
FSharp.Compiler.Service | 43.8.102
FSharp.Core | 8.0.102
Microsoft.DotNet.ApiCompat.Task | 8.0.108
Microsoft.DotNet.ApiCompat.Tool | 8.0.108
Microsoft.NET.Build.Containers | 8.0.108
System.Drawing.Common | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-x64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-x64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-x64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-arm64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64.Msi.arm64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64.Msi.x64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-x64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-arm64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64.Msi.arm64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64.Msi.x64 | 8.0.8
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-arm64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-x64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-x64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64.Msi.x64 | 8.0.8
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.arm64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64.Msi.arm64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-arm64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64.Msi.x64 | 8.0.8
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x86 | 8.0.8
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64 | 8.0.8
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100 | 8.0.8
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.arm64 | 8.0.8
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x86 | 8.0.8
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x64 | 8.0.8
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-arm64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-x64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-arm64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-arm64 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64 | 8.0.8
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.arm64 | 8.0.8
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x86 | 8.0.8
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100 | 8.0.8
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64.Msi.arm64 | 8.0.8
Microsoft.EntityFrameworkCore.SqlServer.Abstractions | 8.0.8
Microsoft.EntityFrameworkCore.InMemory | 8.0.8
Microsoft.EntityFrameworkCore.Analyzers | 8.0.8
Microsoft.EntityFrameworkCore.Cosmos | 8.0.8
Microsoft.EntityFrameworkCore.Proxies | 8.0.8
Microsoft.EntityFrameworkCore.Relational | 8.0.8
Microsoft.EntityFrameworkCore.Abstractions | 8.0.8
Microsoft.Data.Sqlite.Core | 8.0.8
Microsoft.EntityFrameworkCore | 8.0.8
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 8.0.8
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 8.0.8
Microsoft.EntityFrameworkCore.Sqlite | 8.0.8
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 8.0.8
Microsoft.EntityFrameworkCore.Tools | 8.0.8
Microsoft.EntityFrameworkCore.SqlServer.HierarchyId | 8.0.8
Microsoft.EntityFrameworkCore.SqlServer | 8.0.8
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 8.0.8
Microsoft.EntityFrameworkCore.Templates | 8.0.8
Microsoft.Data.Sqlite | 8.0.8
dotnet-ef | 8.0.8
Microsoft.EntityFrameworkCore.Design | 8.0.8
Microsoft.EntityFrameworkCore.Sqlite.Core | 8.0.8
Microsoft.EntityFrameworkCore.Specification.Tests | 8.0.8
Microsoft.TemplateEngine.Authoring.CLI | 8.0.108
Microsoft.TemplateEngine.Abstractions | 8.0.108
Microsoft.TemplateEngine.Edge | 8.0.108
Microsoft.TemplateSearch.Common | 8.0.108
Microsoft.TemplateEngine.Utils | 8.0.108
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.108
Microsoft.TemplateEngine.Samples | 8.0.108
Microsoft.TemplateEngine.Authoring.Templates | 8.0.108
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.108
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.108
Microsoft.TemplateEngine.Core.Contracts | 8.0.108
Microsoft.TemplateEngine.IDE | 8.0.108
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.108
Microsoft.TemplateEngine.Core | 8.0.108
Microsoft.DotNet.ApiCompat.Task | 8.0.304
Microsoft.DotNet.Common.ItemTemplates | 8.0.304
FSharp.Compiler.Service | 43.8.301
Microsoft.NET.Build.Containers | 8.0.304
FSharp.Core | 8.0.301
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.304
Microsoft.DotNet.ApiCompat.Tool | 8.0.304
Microsoft.TemplateEngine.Authoring.CLI | 8.0.304
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.304
Microsoft.TemplateEngine.Authoring.Templates | 8.0.304
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.304
Microsoft.TemplateEngine.Core.Contracts | 8.0.304
Microsoft.TemplateEngine.Edge | 8.0.304
Microsoft.TemplateEngine.IDE | 8.0.304
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.304
Microsoft.TemplateEngine.Abstractions | 8.0.304
Microsoft.TemplateEngine.Core | 8.0.304
Microsoft.TemplateEngine.Samples | 8.0.304
Microsoft.TemplateEngine.Utils | 8.0.304
Microsoft.TemplateSearch.Common | 8.0.304
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.304
FSharp.Compiler.Service | 43.8.400
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.400
FSharp.Core | 8.0.400
Microsoft.DotNet.ApiCompat.Task | 8.0.400
Microsoft.DotNet.Common.ItemTemplates | 8.0.400
Microsoft.DotNet.ApiCompat.Tool | 8.0.400
Microsoft.NET.Build.Containers | 8.0.400
Microsoft.TemplateEngine.Core | 8.0.400-preview.24360.3
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.400-preview.24360.3
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.400-preview.24360.3
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.400-preview.24360.3
Microsoft.TemplateSearch.Common | 8.0.400-preview.24360.3
Microsoft.TemplateEngine.Authoring.Templates | 8.0.400-preview.24360.3
Microsoft.TemplateEngine.IDE | 8.0.400-preview.24360.3
Microsoft.TemplateEngine.Edge | 8.0.400-preview.24360.3
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.400-preview.24360.3
Microsoft.TemplateEngine.Samples | 8.0.400-preview.24360.3
Microsoft.TemplateEngine.Utils | 8.0.400-preview.24360.3
Microsoft.TemplateEngine.Core.Contracts | 8.0.400-preview.24360.3
Microsoft.TemplateEngine.Abstractions | 8.0.400-preview.24360.3
Microsoft.TemplateEngine.Authoring.CLI | 8.0.400-preview.24360.3

[//]: # ( Runtime 8.0.8)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5e427de4-981a-481e-9fec-fa77b02a7edb/0d156acae55ca1329b6b9a8de70f398f/dotnet-runtime-8.0.8-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ac04b123-0542-4e80-9216-93f51a6814b3/d110733c152d34ab4eedb435ccfdab4d/dotnet-runtime-8.0.8-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2f4507aa-972d-429c-9129-cfe95c1279eb/60dd9afc3f4786a568b01119c2280c63/dotnet-runtime-8.0.8-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8d78f160-0833-4db5-bd62-947f8bc2d571/25638f47211018a7bd8fd9d314763196/dotnet-runtime-8.0.8-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d9c4e4e4-bb2d-4f1a-9ded-bff5e354bd5a/0c6dbc5f68bea36a65fdf80e6aa4d55f/dotnet-runtime-8.0.8-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/68c87f8a-862c-4870-a792-9c89b3c8aa2d/2319ebfb46d3a903341966586e8b0898/dotnet-runtime-8.0.8-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/454e6d99-5836-4c51-947e-b75220eebd09/fcbaecbeaa1f95a8ac80aae62e8718b0/dotnet-runtime-8.0.8-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e9ded115-7a30-4952-bb72-ff101583f20b/5a7628261b98d095d2c97ec3fe5267be/dotnet-runtime-8.0.8-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/13a441ce-6908-4f4d-9615-0fcb80e2b41d/b9309626d2013d4e21bd6b0fe405e5f6/dotnet-runtime-8.0.8-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0159972b-a4d6-4683-b32a-9da824d5689e/ffb0784119abf49015be375b5a016413/dotnet-runtime-8.0.8-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b0574522-b0b6-4075-b7e4-3c3d6f1c83d4/43d3e0e551de10faf0ddd1664e2ab4be/dotnet-runtime-8.0.8-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/3c1da0a1-c405-48d0-99d7-273dab3b0083/240aa566253cbd5f86be31a55c1a0f30/dotnet-runtime-8.0.8-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/cc913baa-9bce-482e-bdfc-56c4b6fafd10/e3f24f2ab2fc02b395c1b67f5193b8d1/dotnet-runtime-8.0.8-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d9d43c59-b9f4-47b7-a520-da3a7fa255dc/95b26e342a1ecfa29c527faebdc272e4/dotnet-runtime-8.0.8-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c2083daf-6d33-404f-a7d6-dd3bb012a945/e241d0aff000f63ef8a49c3c7da08087/dotnet-runtime-8.0.8-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e9b87eb9-a673-4b3e-bf22-95ade61bedeb/d9d83b7c82a86c3e35da7454f71bfb58/dotnet-runtime-8.0.8-win-x86.zip

[//]: # ( WindowsDesktop 8.0.8)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/2603d3c8-f891-4121-b84c-54b4c566929d/5f534746507ee61be351289e23680ed7/windowsdesktop-runtime-8.0.8-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/eeb4582f-f809-4d44-aecf-24f73e03e9a0/729e189727ba9abdcfb695dc163d8336/windowsdesktop-runtime-8.0.8-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/907765b0-2bf8-494e-93aa-5ef9553c5d68/a9308dc010617e6716c0e6abd53b05ce/windowsdesktop-runtime-8.0.8-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/65b56aa4-0132-412e-86c0-8bf8decb0d6d/c9df1ca4ab97a2526af9d8388fbce537/windowsdesktop-runtime-8.0.8-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/bd1c2e28-44dd-47bb-a55c-aedd1f3e8cc4/0a15fac821e64cf7b8ec6d99e54e0997/windowsdesktop-runtime-8.0.8-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a24ff6c3-0466-4205-a8f6-4ace56b05b04/dd3c9d2b9dc4d8c6d4c73cf49d826bda/windowsdesktop-runtime-8.0.8-win-x86.zip

[//]: # ( ASP 8.0.8)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/26f16795-9928-4ddd-96f4-666e6e256715/bf797e4f997c965aeb0183b467fcf71a/aspnetcore-runtime-8.0.8-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f6fcf2c9-39ad-49c7-80b5-92306309e796/3cac9217f55528cb60c95702ba92d78b/aspnetcore-runtime-8.0.8-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9255e487-cdf2-4690-9840-74712503e37d/40be3d122db1d1ffa53a9843321c3979/aspnetcore-runtime-8.0.8-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/95f358cf-86b5-4789-8ee8-063067081c8b/e50e603b2453d7dc65eeb26dd4cfb398/aspnetcore-runtime-8.0.8-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7d2ac05d-2bef-4069-9513-bb2ef7fab48d/4f3d2d3fec003a65513dc1f70c126ab7/aspnetcore-runtime-8.0.8-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/648de803-0b0c-46bc-9601-42a94dae0b41/241fd17cee8d473a78675e30681979bb/aspnetcore-runtime-8.0.8-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a7080974-fac8-446c-ba20-313f6f323fbe/f907c126c9bcd394939a7cdf86b85f4b/aspnetcore-runtime-8.0.8-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/465bdf6e-407d-4512-a222-32dafb225ad8/c22004de330d10a06141dee0f42b5d12/aspnetcore-runtime-8.0.8-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/21fe7f94-d40e-4890-9b53-91c9982388f8/7b3bb07fcb21549de69ad6848e66a2f9/aspnetcore-runtime-8.0.8-win-arm64.exe
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f3202aa8-e732-4807-90eb-b0cccae3e21c/6b53dccfe94032a084d279d6df48ebac/aspnetcore-runtime-8.0.8-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b336ee1f-b26c-4a03-958e-1e8a0b3cbf3e/afdfe9f8130098cb759ea933c66806bb/aspnetcore-runtime-8.0.8-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/020128a3-35b6-4f0c-b007-daf912a939a7/d9970e40d5f5b743bc7b041bfc75d318/aspnetcore-runtime-8.0.8-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/bc6a4cfd-be25-4dc0-90e9-2000f740a66b/6c5e6422aec7a09a8cebc1dbe8e37971/aspnetcore-runtime-8.0.8-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/43d7268b-e704-4a36-9c1b-d3091f482471/d6ac5259b0d751532a03a0f943c672dc/aspnetcore-runtime-8.0.8-win-x86.zip
[aspnetcore-runtime-composite-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/979c1823-ee43-4fbf-b9e0-f17411627b00/8e3b9cb3b2f6e1e3b03e38be20b37f07/aspnetcore-runtime-composite-8.0.8-linux-arm.tar.gz
[aspnetcore-runtime-composite-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5d24db42-a622-40ec-9f92-32fa9b319446/220f5807d7a803e9afe88c360460b803/aspnetcore-runtime-composite-8.0.8-linux-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9850633c-fb83-42c4-8a73-e6e3a1c59993/d94ed365a5855270c7555a757753efc2/aspnetcore-runtime-composite-8.0.8-linux-musl-arm.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8ca98cac-c013-4e69-bdac-d8f7662e3c13/af7705d765641174b760af47701e502a/aspnetcore-runtime-composite-8.0.8-linux-musl-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2a6e31eb-47e6-4d2a-b771-a6bd91cbada0/53b59a92b7e2db9aea8cc492edfe9e84/aspnetcore-runtime-composite-8.0.8-linux-musl-x64.tar.gz
[aspnetcore-runtime-composite-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/22051276-9045-4a93-b8b5-57d89e8ab627/0d579b69f59a222d05fa7ee4e65d8d8a/aspnetcore-runtime-composite-8.0.8-linux-x64.tar.gz
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/ef1366bd-3111-468b-93da-17e6ccb057e1/1fac364775c1accb09b9ac5314179004/dotnet-hosting-8.0.8-win.exe

[//]: # ( SDK 8.0.400)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2a388927-c8b0-4411-a211-8a37a9f8876c/1b2fd1d36ee22f2c35cbc04ade46bc7e/dotnet-sdk-8.0.400-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0fcf170f-0f4f-420d-92d4-b2c8e54bb901/9e14c42736ee429407ac6b14bff3c7e9/dotnet-sdk-8.0.400-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/11fcd2ef-81fb-461c-9cab-f6c22ee12ea2/3a6a4fd8e4865c77ecd9de9d8c9aa5c4/dotnet-sdk-8.0.400-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/73dde17f-f2fa-4f11-86bb-e4e9488267a4/7ca5cc43af6130207e545faf97a57d07/dotnet-sdk-8.0.400-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/910f7e06-6178-4d2e-ba0a-dd8f1baa25cd/254f03846baa009e09a5146cc5ccc18c/dotnet-sdk-8.0.400-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/14951030-5b4e-45ce-af0b-3d4aa613a70b/25acaeb050bbba6950a55960c5d3ad73/dotnet-sdk-8.0.400-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/06edb9e2-e2bc-4692-a26f-df48c67d9292/2058cb632932d3c63fb78cd54692bc88/dotnet-sdk-8.0.400-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cfa04712-231b-4ef4-83f0-476c856774f2/9f852a73d183f63cbd50a3e58a4e7306/dotnet-sdk-8.0.400-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a3bb8bc8-66dc-402e-9ced-a53241c4c15e/fc855e95c2e04813fa1efd64cc17ce86/dotnet-sdk-8.0.400-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3187bf57-a0f4-46f3-9021-2c8bc9217859/25930e64d1f3be622e5571118b0daa01/dotnet-sdk-8.0.400-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a91eb253-6568-45bc-a74a-15946e2708a6/75498a48c01018e9a1ce2a8f25f2b208/dotnet-sdk-8.0.400-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/1788607d-b711-4c2c-9492-e081d7ac4f27/c0c21b90236c2a3119471d003c2167b5/dotnet-sdk-8.0.400-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/57ffff70-1b2b-44fe-aa9b-209e30f79c6f/cc24e73a485140d3a32ce93f63acf4e2/dotnet-sdk-8.0.400-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/cfccc24b-46eb-4515-b696-161ec8652b39/9fb1edaba0f12a56446fa6716a1789ca/dotnet-sdk-8.0.400-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/53a96c28-cd09-48fa-a68b-5fdd2a79dc37/5bcc92ce87327b43fa369045a8e8d932/dotnet-sdk-8.0.400-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4bc6c939-8cb1-45c4-afde-a1b0715eec7d/c3835988860504c59187049089ca2466/dotnet-sdk-8.0.400-win-x86.zip
