# .NET 8.0.0 Preview 1 - February 21, 2023

The .NET 8.0.0 Preview 1 and .NET SDK 8.0.100-preview.1.23115.2 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).

## What's new in .NET 8 Preview 1

.NET 8 is the next major release of .NET following .NET 7.0. You can see some of the new features available with .NET 8 Preview 1 at [dotnet/core #8133](https://github.com/dotnet/core/issues/8133).

See the [.NET][dotnet-blog], [EF Core][ef-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 1.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.100-preview.1.23115.2
```

## .NET Multi-Platform App UI (MAUI) Workload Downloads

 After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

 ```console
 $ dotnet workload install maui
 ```

 The following workloads are also available to install individually:

 ```console
 $ dotnet workload install android
 $ dotnet workload install ios
 $ dotnet workload install maccatalyst
 $ dotnet workload install macos
 $ dotnet workload install tvos
 ```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 17.4 latest preview](https://visualstudio.microsoft.com) to use .NET 8.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 8.0 and C# 11.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8213](https://github.com/dotnet/core/issues/8213) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.0-preview.1.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-preview.1-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-preview.1-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-8-preview-1
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-8-preview-1/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8-preview-1/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0-preview1+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0-preview1+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0-preview1+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0-preview1+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.1xx
[linux-packages]: ../install-linux.md



[//]: # ( Runtime 8.0.0-preview.1.23110.8)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3b7465f1-467e-405b-bb4d-546e3f9026d1/818a6a302e7bde633ee0cc62b609aeab/dotnet-runtime-8.0.0-preview.1.23110.8-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/29109381-5068-4e80-a3f8-d0c825202bbc/b4205a8a483c639c0cfdf54bb1fb5ec6/dotnet-runtime-8.0.0-preview.1.23110.8-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4b5ac13b-eb03-468f-b47b-0c0b0a229c34/2b475a0d3fbff23b500230354db0ef87/dotnet-runtime-8.0.0-preview.1.23110.8-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2f8d9b41-337e-4b53-9c1b-a892dc6a8042/ee14d933741ebebc044f7a727d731fc9/dotnet-runtime-8.0.0-preview.1.23110.8-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6c34a04d-9e4c-4644-ae8e-99e02c56bc47/dc4de18e698a932b91834495b9cae624/dotnet-runtime-8.0.0-preview.1.23110.8-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6c535b62-2132-4f07-90d0-2b172d18e436/b4b8aa2b558e1472c650a40707f25241/dotnet-runtime-8.0.0-preview.1.23110.8-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/da75b8f3-eaa6-4e81-89ea-5b1c357e1c14/1abeb68098e58c7c3a290e4d67920cf5/dotnet-runtime-8.0.0-preview.1.23110.8-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/13005a07-288f-4c55-b874-71a336d4c687/ba476df7f39fd64214b1911ac4791c97/dotnet-runtime-8.0.0-preview.1.23110.8-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/b2dfdd00-3ec3-4834-8790-daf3729388b7/fbcd513ad80edeed216a573706b31682/dotnet-runtime-8.0.0-preview.1.23110.8-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/02916946-04e0-45d1-b36d-07ebc9bab6c2/c160d7f42df423bd40d7251ee015b440/dotnet-runtime-8.0.0-preview.1.23110.8-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/f3aad036-4c65-4e2d-95b2-a7a3999f93de/c79f2f807a76114ba22270f29d88bff6/dotnet-runtime-8.0.0-preview.1.23110.8-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/735b4b58-1993-4c90-af52-c18adcd78d27/2e24da183158102b29efac13d96c1078/dotnet-runtime-8.0.0-preview.1.23110.8-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0a3c32e2-f2fb-494e-b70f-690bcbb6943b/346acb237c1b630c21c112ec0163f3e6/dotnet-runtime-8.0.0-preview.1.23110.8-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7518ee75-65fc-4f81-8b2c-cef15d4e9b09/fd3003f3de906ba1bf224d8396054def/dotnet-runtime-8.0.0-preview.1.23110.8-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/65710155-7232-446e-aece-8861bfe97624/28ceecaaef6fb9cbc531119d7973ff9e/dotnet-runtime-8.0.0-preview.1.23110.8-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/02a80df4-e93e-457b-ac26-638572a18fbb/8051f5da52a0c2fa91fb0d22e595ecdc/dotnet-runtime-8.0.0-preview.1.23110.8-win-x86.zip

[//]: # ( WindowsDesktop 8.0.0-preview.1.23112.2)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/19536364-47ac-4668-93b4-7ac161113e97/b76d7bcc975d642ca2f2c6a9849868a6/windowsdesktop-runtime-8.0.0-preview.1.23112.2-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/62660c8f-16f1-4e3e-a08d-9ff07d982841/3a269998e9add66853b52ca3320a5ca3/windowsdesktop-runtime-8.0.0-preview.1.23112.2-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/16b93712-2a98-4e2e-ab28-8d195695163f/74e0b6eba4df1398c6eb5779bbb6ef32/windowsdesktop-runtime-8.0.0-preview.1.23112.2-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b4654cad-81ab-4b77-9e53-3d97c054367a/cd5145a9c61682028bca684b3b7d096b/windowsdesktop-runtime-8.0.0-preview.1.23112.2-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/7568cf55-1140-4afd-bfc0-2af10198215b/d3323aac0a304959c625315bc618433e/windowsdesktop-runtime-8.0.0-preview.1.23112.2-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ae636827-07f0-49c7-9be7-45df8f4c9b3a/ec22c4e75a6800dcf7941547ba6409ee/windowsdesktop-runtime-8.0.0-preview.1.23112.2-win-x86.zip

[//]: # ( ASP 8.0.0-preview.1.23112.2)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1d2c535-8832-48c2-87bb-d033fc2c6f8b/80291a7b9988aca397cbe5ac8821d6cc/aspnetcore-runtime-8.0.0-preview.1.23112.2-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/63cbd12f-0328-4828-878c-4970ebe2561d/3b0e89d0e68beb6d09ad2323d64d039c/aspnetcore-runtime-8.0.0-preview.1.23112.2-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/49f41a35-b175-4699-a6ab-aa6dffc806ee/3247951bf1976a38abe0e0c9d641802a/aspnetcore-runtime-8.0.0-preview.1.23112.2-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/19630d64-685e-4882-a7e8-a70077642cec/0a7680100590d0d4bef2a6ee9004ab4e/aspnetcore-runtime-8.0.0-preview.1.23112.2-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f7a955d6-27fd-4a8f-8c1d-ccafe789c723/c01fcac1c82a6e52bd007a5f83d6251c/aspnetcore-runtime-8.0.0-preview.1.23112.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bcd36740-4478-4104-aad3-97de2eda3c63/4278c479d008a08a82e6ed799ea4cab6/aspnetcore-runtime-8.0.0-preview.1.23112.2-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/00e1ec5d-62c0-4084-bf5d-f5667a77afe5/f4d1ceeb2d51a60323084ef43317b1f2/aspnetcore-runtime-8.0.0-preview.1.23112.2-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/60354a8c-773b-4999-af88-f6232bf5b644/19f1f472670e5625ee6a75d09b95653b/aspnetcore-runtime-8.0.0-preview.1.23112.2-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a078e06e-3942-4fca-99ee-29e1aa50b07b/af7d350201b779ee06365f19f0e487e6/aspnetcore-runtime-8.0.0-preview.1.23112.2-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/12ddd219-183e-4c8f-9079-ed04118328ad/6a51b50f0469e83ab21656e89079ee4d/aspnetcore-runtime-8.0.0-preview.1.23112.2-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7a8d9400-6123-4da2-9425-2206666af7b7/234ab5bcdcc243f9a096deb6e5005629/aspnetcore-runtime-8.0.0-preview.1.23112.2-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d922e621-f8ad-49ae-b68f-468884902a4b/195ddbf5b9091f70eb86fe268c099e01/aspnetcore-runtime-8.0.0-preview.1.23112.2-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c4d490ef-b84c-4d72-917e-ca888708897b/890bb35f7eb345a41d417f6f3fb27a50/aspnetcore-runtime-8.0.0-preview.1.23112.2-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/b671a565-b18e-4c5d-84f3-1dba30b2d5ec/ea9dae82779be5c3456f94b60d74b418/dotnet-hosting-8.0.0-preview.1.23112.2-win.exe

[//]: # ( SDK 8.0.100-preview.1.23115.2)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1fb6d1b1-e976-4e94-9009-229ee313dfa5/5476a83dcda6d51617598cff9db793bd/dotnet-sdk-8.0.100-preview.1.23115.2-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57c316ef-4b1d-4b1e-b180-f38302132d3d/b938e1b373897fadfb25ff4b55ca32e6/dotnet-sdk-8.0.100-preview.1.23115.2-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/23b0480f-384f-4ba8-b047-140ff0d67806/a1a01f23f1a7fc8d996a1e2d99560273/dotnet-sdk-8.0.100-preview.1.23115.2-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b4fde77f-5016-40ef-be38-ecea34fe73b3/6f2f78d153c102f592aecbf364befba6/dotnet-sdk-8.0.100-preview.1.23115.2-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/60cae83e-cc73-4ce4-9d94-c828fad4d9e0/4add3672b15f491291764c6530eb1bb5/dotnet-sdk-8.0.100-preview.1.23115.2-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e2578737-231b-493c-a6ee-f181496fe679/18038808d2621094ebe172ca011a7c22/dotnet-sdk-8.0.100-preview.1.23115.2-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/b54698c3-d371-492f-b9f1-998a60136156/3ff37050db93fd5fd5ab86befe42bb08/dotnet-sdk-8.0.100-preview.1.23115.2-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/00476255-fac3-4e26-98a4-c487aa89945c/76550e8fb59f35fcb6b789d570b9ace5/dotnet-sdk-8.0.100-preview.1.23115.2-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/993e8460-176f-4669-9337-b4725c355146/f903c2ff758fee42121da67772dfd0c5/dotnet-sdk-8.0.100-preview.1.23115.2-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0b01073d-3861-4fe0-abba-41e271c79725/12150bdbeeeb50e157b91f2adab90c80/dotnet-sdk-8.0.100-preview.1.23115.2-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/4f5a7e91-b186-40da-95a9-c01a8f8cd55f/1189b1bf14136d7075ef6a23c3a5b70d/dotnet-sdk-8.0.100-preview.1.23115.2-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/86553a5e-ed5f-462b-819a-e850972413d2/41e5581320aac04fb55fa929603f1b2a/dotnet-sdk-8.0.100-preview.1.23115.2-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9b723333-0fa0-4601-bb83-aa842fda27d7/fd2b0e727ba2442a93a511aaa3817e67/dotnet-sdk-8.0.100-preview.1.23115.2-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a1b7c03d-7c06-4d07-a99d-b7c919fc9b9a/0b57d52282f0e56c8701aaafd31cab90/dotnet-sdk-8.0.100-preview.1.23115.2-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/efef3a6c-b2b0-4c2e-82d0-ead02e4d6bb0/a4e88db099d462f65e08823d7c526ed3/dotnet-sdk-8.0.100-preview.1.23115.2-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/83c277bd-f1da-404e-8d7b-d3ecaeff3033/bd44769f850d158983a5d9215facc02d/dotnet-sdk-8.0.100-preview.1.23115.2-win-x86.zip
