# .NET 8.0.0 Preview 2 - March 14, 2023

The .NET 8.0.0 Preview 2 and .NET SDK 8.0.100-preview.2.23157.25 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).

## What's new in .NET 8 Preview 2

.NET 8 is the next major release of .NET following .NET 7.0. You can see some of the new features available with .NET 8 Preview 2 at [dotnet/core #8134](https://github.com/dotnet/core/issues/8134).

See the [.NET][dotnet-blog], [EF Core][ef-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 2.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.100-preview.2.23157.25
```

## .NET Multi-Platform App UI (MAUI) Workload Downloads

 After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

 ```console
 $ dotnet workload install maui
 ```

 The following workloads are also available to install individually:

 ```console
 $ dotnet workload install android
 $ dotnet workload install ios
 $ dotnet workload install maccatalyst
 $ dotnet workload install macos
 $ dotnet workload install tvos
 ```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 17.5 latest preview](https://visualstudio.microsoft.com) to use .NET 8.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 8.0 and C# 11.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8286](https://github.com/dotnet/core/issues/8286) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.0-preview.2.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-preview.2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-preview.2-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-8-preview-2
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-8-preview-2/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8-preview-2/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0-preview1+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0-preview1+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0-preview1+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0-preview1+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.1xx
[linux-packages]: ../install-linux.md


[//]: # ( Runtime 8.0.0-preview.2.23128.3)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1fe1fa52-f44f-4e97-9b80-03c91eaec094/f8c6e96815e2ea4d697b4cd5c7d09e3b/dotnet-runtime-8.0.0-preview.2.23128.3-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/31b60621-dcaf-4b89-83c6-cd9cc5657350/6a5b181b84409a029d80acc94c0387b5/dotnet-runtime-8.0.0-preview.2.23128.3-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/83e2d5a9-d10c-4fb0-ba36-79ecefa276ba/1a94872fad223cf1896a3655a3a71fb5/dotnet-runtime-8.0.0-preview.2.23128.3-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e2fc9e6f-b989-4fa3-be19-4bb241196f51/5fe0d03193b94d66cebcbb34908f0726/dotnet-runtime-8.0.0-preview.2.23128.3-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5967473b-a9ac-48e7-bc55-6d29d08c2561/8363715ad3db857ebe94b2296bc8b8dd/dotnet-runtime-8.0.0-preview.2.23128.3-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f74940ab-c6c8-4464-8a4d-a1149a9dc965/c774b22355f65c13101937cbd2a79071/dotnet-runtime-8.0.0-preview.2.23128.3-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e6a7dd4d-46c5-4ad2-9512-e2759a6796fe/f4b996a2a5c33c548d03b80d5f5226a2/dotnet-runtime-8.0.0-preview.2.23128.3-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6651d249-9e3a-4726-9733-76307787c213/445ad516907a2939a3da383501e51cfe/dotnet-runtime-8.0.0-preview.2.23128.3-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/94271da7-60cd-435c-b273-c03c3b866ac4/9f3612d079ced4b017aec3e917a3fb45/dotnet-runtime-8.0.0-preview.2.23128.3-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/79a747b1-a7b8-432f-a641-fdc528f4d885/242cab0619683336965c964038e57ff7/dotnet-runtime-8.0.0-preview.2.23128.3-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/46991efb-2af2-4c02-82f3-ec023db2e7ea/c77a545c316ce63e88621bdf30cfb939/dotnet-runtime-8.0.0-preview.2.23128.3-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f988fdd3-2f90-4222-847e-0d9cc55ca314/b4bee913b5570e3c82c74b0d41554f8b/dotnet-runtime-8.0.0-preview.2.23128.3-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/207e554d-fbf1-4238-a4b5-087425a29f51/8daf5a8c93f93b95e044cbb6b393bc3c/dotnet-runtime-8.0.0-preview.2.23128.3-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7fbb862a-d582-4d1e-a6e6-67a69e1822af/baff37166c711b1242b8984a898088ba/dotnet-runtime-8.0.0-preview.2.23128.3-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c9178525-9791-47a3-8195-aed3e97884e4/07198c92dc8744cc9dc249c241e01ed0/dotnet-runtime-8.0.0-preview.2.23128.3-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3c3735db-0143-4999-a28e-b1500ed60057/fd6fefa4583e6324762ad1299cdeab6a/dotnet-runtime-8.0.0-preview.2.23128.3-win-x86.zip

[//]: # ( WindowsDesktop 8.0.0-preview.2.23128.5)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/7719c1f6-0a3c-4639-88b9-68d9fa7ad6b6/3e0ae6d7eb42cfded0b243f66f6bd60b/windowsdesktop-runtime-8.0.0-preview.2.23128.5-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f9c1a74b-a647-477d-96bd-a138ece231df/371d2c9c8ad603903367a2623c15845f/windowsdesktop-runtime-8.0.0-preview.2.23128.5-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/fbf2b09d-94c1-4dc8-909c-b586d263a633/1b55ad91c53b45a3705f6fa271b5753d/windowsdesktop-runtime-8.0.0-preview.2.23128.5-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6e9f9d07-7d1e-43f5-bbe4-bd5d59739733/9663e9b1fffe20978c7a74dc01276e9e/windowsdesktop-runtime-8.0.0-preview.2.23128.5-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9ac13759-6661-4d3b-910d-81b922ca3290/34729748c5fb074fcdf9876dd8fa0498/windowsdesktop-runtime-8.0.0-preview.2.23128.5-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/44bcefee-91fa-46a6-82c3-6d1b8efe1741/83034a3c41294cc40a34e0dad5619c72/windowsdesktop-runtime-8.0.0-preview.2.23128.5-win-x86.zip

[//]: # ( ASP 8.0.0-preview.2.23153.2)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ac41f19c-570a-4fcb-bcef-0fce300429ee/462d353178f0551e92f0f480d34a0812/aspnetcore-runtime-8.0.0-preview.2.23153.2-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/87c69e56-17b4-4346-995d-14242e2ec5bb/b656ba5e42d9d96ba065a4d0f971590b/aspnetcore-runtime-8.0.0-preview.2.23153.2-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7bbbd453-d4d8-4b59-ba02-5003d55bba07/a1f898e34226cb6fb7dcac8cc686dbe8/aspnetcore-runtime-8.0.0-preview.2.23153.2-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4c12892a-4978-4f31-a5db-8d3d61332199/16428bd7f55d2c84d2a922405283ecf1/aspnetcore-runtime-8.0.0-preview.2.23153.2-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57b321b0-2e26-42b7-a8ac-51d02bf166a3/6002ae90405d0afd8674ee5225961db5/aspnetcore-runtime-8.0.0-preview.2.23153.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/930d8abc-009c-47c8-97cc-4c61ca7a74ef/7a116b9554c6db0d84f53937f89d5240/aspnetcore-runtime-8.0.0-preview.2.23153.2-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/af525c46-4f32-4fb6-9435-522cb5f6b8e5/2323948790b195eebccfa5121d434e74/aspnetcore-runtime-8.0.0-preview.2.23153.2-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8bf4989d-9696-45f8-af31-afd2a7fc5ca9/0892caa5dcc0ee2b342d85963610fe15/aspnetcore-runtime-8.0.0-preview.2.23153.2-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0a1a518b-3ce4-4b69-a9dc-793760104a1c/cd3b44f49739c57b3e0ee0854ee3c54a/aspnetcore-runtime-8.0.0-preview.2.23153.2-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b3979a0b-35a9-4f3e-9cdc-7049d333005c/4d47b2f55a3974c93462c715f46384cf/aspnetcore-runtime-8.0.0-preview.2.23153.2-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9d45b8bf-f308-4c68-9b76-07f612c66add/59cdbd09d2e49fea0ec7b798ce59121f/aspnetcore-runtime-8.0.0-preview.2.23153.2-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9c77d920-9a7e-400f-bbd2-7062857b4481/8ec60d90333399f857b9e1b18e42ee8e/aspnetcore-runtime-8.0.0-preview.2.23153.2-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/94b02d11-90e9-41f8-8dd1-e9b1551c2596/f955ed50c422a27cb1e076020e5b2473/aspnetcore-runtime-8.0.0-preview.2.23153.2-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/09af9a4b-7cd4-425e-b9ce-25579faaf528/99930a6816270440fee1268a6652cb34/dotnet-hosting-8.0.0-preview.2.23153.2-win.exe

[//]: # ( SDK 8.0.100-preview.2.23157.25)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ba3b846b-fe26-4797-bfb6-3a2a611943af/4f97df1d2f5886b30809dfc3144111f6/dotnet-sdk-8.0.100-preview.2.23157.25-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5ca09c3e-e6c0-4ea2-bc1c-371cc4d0b79a/f05e4e38788662b2e226bf75569e42aa/dotnet-sdk-8.0.100-preview.2.23157.25-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fbe6986c-d1a2-47be-b479-9adf9001ba15/d789b0f1421729f0a62ee3360184eaaf/dotnet-sdk-8.0.100-preview.2.23157.25-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/320c9224-81a3-4726-bdc6-88adb8391ec4/b1073d8f721ab4131892263b82f85529/dotnet-sdk-8.0.100-preview.2.23157.25-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3394d9eb-aac2-4f47-b98b-94c0c89669d6/ebf994a7e8ac6e1c67ae2acccc6ed5c3/dotnet-sdk-8.0.100-preview.2.23157.25-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a042ab5b-f160-4621-ac14-77be759167d7/373e6e8ae9381ffc1ba853bb6542d55c/dotnet-sdk-8.0.100-preview.2.23157.25-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/9bb7054e-4547-4021-b46f-edee2428b10d/1dbe4945aabec0cd9c8b15080ec98b37/dotnet-sdk-8.0.100-preview.2.23157.25-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/62c49e14-4f0a-4698-aa08-8d77d383fa8f/909bb059d035324ddc2e8a8fdb77a01e/dotnet-sdk-8.0.100-preview.2.23157.25-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d22c5e44-5ddc-41c2-bc23-cc7cbf7bed72/25e24c6de0c41648965533073cfba2c2/dotnet-sdk-8.0.100-preview.2.23157.25-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6a390a1a-2d50-4ea3-a5f7-0a945b30a436/1968bbba00d7c4a3d2f0b8d13002d77e/dotnet-sdk-8.0.100-preview.2.23157.25-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c53014ba-5042-472f-bba4-0132cb9af3bd/88871b19317e841753a69f693ccbee91/dotnet-sdk-8.0.100-preview.2.23157.25-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/79a658c6-b6aa-4c02-9e63-77c153b809d6/6425c500ef3be2bb958f9fbe4ee06917/dotnet-sdk-8.0.100-preview.2.23157.25-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/324e1250-4406-4e9e-ab37-c44c7f584e1f/ebb40cc17c3f757386a90f9499cf0d93/dotnet-sdk-8.0.100-preview.2.23157.25-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/42e8780b-d8eb-4c1e-b8d6-ab7b44d5e273/a7b8f51ea935fdee14c871a3d1b11001/dotnet-sdk-8.0.100-preview.2.23157.25-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/cb781990-a87b-40ab-a4d0-42c8ea899be1/39cf83e15e54c382658f9c8334994bbd/dotnet-sdk-8.0.100-preview.2.23157.25-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/24c994d9-faf9-4222-a9a2-843390f22a50/4898b52495aaff3b76181d919c185bbb/dotnet-sdk-8.0.100-preview.2.23157.25-win-x86.zip
