# .NET 8.0.0 Preview 3 -April 11, 2023

The .NET 8.0.0 Preview 3 and .NET SDK 8.0.100-preview.3.23178.7 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).

## What's new in .NET 8 Preview 3

.NET 8 is the next major release of .NET following .NET 7.0. You can see some of the new features available with .NET 8 Preview 3 at [dotnet/core #8135](https://github.com/dotnet/core/issues/8135).

See the [.NET][dotnet-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 3.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.100-preview.3.23178.7
```

## .NET Multi-Platform App UI (MAUI) Workload Downloads

 After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

 ```console
 $ dotnet workload install maui
 ```

 The following workloads are also available to install individually:

 ```console
 $ dotnet workload install android
 $ dotnet workload install ios
 $ dotnet workload install maccatalyst
 $ dotnet workload install macos
 $ dotnet workload install tvos
 ```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 17.5 latest preview](https://visualstudio.microsoft.com) to use .NET 8.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 8.0 and C# 11.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8384](https://github.com/dotnet/core/issues/8384) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.0-preview.3.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-preview.3-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-preview.3-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-8-preview-3
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-8-preview-3/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8-preview-3/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0-preview3+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0-preview3+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0-preview3+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0-preview3+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.1xx
[linux-packages]: ../install-linux.md


[//]: # ( Runtime 8.0.0-preview.3.23174.8)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b7a9eac3-04d0-45d0-9e43-c740b9d83778/89811db94da722afde21c43cd49cabfb/dotnet-runtime-8.0.0-preview.3.23174.8-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7b272393-da0b-4386-ac78-416ee38195fe/4f0d5a3d43cd7b32ae6051b191edd5e8/dotnet-runtime-8.0.0-preview.3.23174.8-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fe8fefe1-174c-4a5d-9dfc-354904ba6585/2c299f7568477ec59e2664b2a1111e94/dotnet-runtime-8.0.0-preview.3.23174.8-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d4217422-1fb5-47c3-89cb-dd7a99efde29/9ff5d5af3b76d45be5624a5d76e16c1a/dotnet-runtime-8.0.0-preview.3.23174.8-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f94d4673-19cc-4c77-b094-34fa8daeb3e7/c19706ae3c9ce5034a504a021104b77f/dotnet-runtime-8.0.0-preview.3.23174.8-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6c4d4118-bc92-4601-b42b-2b6e91fc28f6/7b3a642aab860b394982d48bf5681243/dotnet-runtime-8.0.0-preview.3.23174.8-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4d50ef46-86ee-4be2-bcf4-1d27ab4f2a21/29a3ab71de1327a7976e475290e11ca7/dotnet-runtime-8.0.0-preview.3.23174.8-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e29d7a01-41b9-4cdb-9c87-640871cd7b31/cfc38e882c713763339265cdfd1e4fac/dotnet-runtime-8.0.0-preview.3.23174.8-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/018cf078-39d9-450f-a8fe-d8d84418e220/0b2e9114fa3cb3201f5a8ec39f7c2b2c/dotnet-runtime-8.0.0-preview.3.23174.8-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/962423a9-e286-4a7e-b3a8-4fdcde16d9e2/0b11e7166df8ed292c44d4a7594e482a/dotnet-runtime-8.0.0-preview.3.23174.8-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/f5c46df2-dbb8-4500-ae40-8bf1c8a00f7f/bc4f1a30e47178b937d4b9a73cec3bbe/dotnet-runtime-8.0.0-preview.3.23174.8-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f7f19db6-47af-48ad-b5a0-87ee3af22672/223ee8d203a1320b36b93d0848619842/dotnet-runtime-8.0.0-preview.3.23174.8-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/bb312c63-6d61-4c40-aeb0-063e835ae2c6/1cb498d0e1dee9f70f8907dd99d919bc/dotnet-runtime-8.0.0-preview.3.23174.8-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/800e44e9-ade5-45be-a729-d2ddb1177cff/9fe0d28f5a8a0d59726b16e7a6f8ce04/dotnet-runtime-8.0.0-preview.3.23174.8-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6a368cbe-6674-4713-86b8-8b7f93e9474d/7b347d2cdb51946654bf4410462d1630/dotnet-runtime-8.0.0-preview.3.23174.8-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/674ea378-c815-4ed1-90db-b927ac89cc61/72624a1ece328b3c48f27d2f61e1fdde/dotnet-runtime-8.0.0-preview.3.23174.8-win-x86.zip

[//]: # ( WindowsDesktop 8.0.0-preview.3.23178.1)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/722a6ab7-8665-4bc2-9b54-d78d944a060a/6054922293fcd36ade2db9aa024df4a3/windowsdesktop-runtime-8.0.0-preview.3.23178.1-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f7079b52-a813-4022-9c50-b0823c181657/ec5fbab2004c7a530bcd869c1a6c1edd/windowsdesktop-runtime-8.0.0-preview.3.23178.1-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/032fc8f7-fe07-4f28-b6a6-58001c9b2c2f/b2726891cad9c9056bc8524868fc88db/windowsdesktop-runtime-8.0.0-preview.3.23178.1-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/cb3356c8-918c-4140-af97-2466a7ad745a/8587adcc9b3a994ef0c0fd43c1ce6be8/windowsdesktop-runtime-8.0.0-preview.3.23178.1-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/cbf082c3-7e15-473d-9aa4-6a6095b8a619/2597c95c8abb1c87dcfa3a2e18316e92/windowsdesktop-runtime-8.0.0-preview.3.23178.1-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/13786127-2141-4641-a026-984e8c18076b/9fda1d2742cc7582fb442bce644ae251/windowsdesktop-runtime-8.0.0-preview.3.23178.1-win-x86.zip

[//]: # ( ASP 8.0.0-preview.3.23177.8)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ddeafd2f-5565-4837-898e-4f17530a9eb4/90542cd3802e70bbacde439870cd0743/aspnetcore-runtime-8.0.0-preview.3.23177.8-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0d98023b-349e-4893-b717-176eab3ca4fe/ab919484bd5a5a981057f60828c8d8d8/aspnetcore-runtime-8.0.0-preview.3.23177.8-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/133c590e-b4e7-4b4e-a78b-36b7d8759af6/8eba70a0c3b5c1b31d7de85e1415c2de/aspnetcore-runtime-8.0.0-preview.3.23177.8-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/77a941bf-9c25-49f3-a105-74fe0d896d91/63b3ed1a09636480cfb7357737949b34/aspnetcore-runtime-8.0.0-preview.3.23177.8-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5c650eba-d339-4862-8e02-13932539b937/6dd28799edf930dc4233ad30366eabe9/aspnetcore-runtime-8.0.0-preview.3.23177.8-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e47f5b95-4eb2-451d-8ec5-2e37b928d91f/e386c9fb8185cd35674fe2a44dedb318/aspnetcore-runtime-8.0.0-preview.3.23177.8-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0e9f855d-b7eb-4641-b859-218d7d61e169/c7ecfeb28526a57668f53d7da4fa0c90/aspnetcore-runtime-8.0.0-preview.3.23177.8-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/18fcf656-e2e0-4fb0-8141-ffeaf76b2785/cd4ff90bbf9b25d10cdc9fb8aacf94be/aspnetcore-runtime-8.0.0-preview.3.23177.8-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/2b13764e-d1a8-4a24-86d9-9182fc6a12d1/74e951e0a794456ce43201b70dfa100d/aspnetcore-runtime-8.0.0-preview.3.23177.8-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3a84bf7c-f603-4e17-a46a-9630a75291a9/a9b1e5be029575155b3ad55d4c2bedda/aspnetcore-runtime-8.0.0-preview.3.23177.8-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2b0a5809-166b-43b0-b076-ee2f624982ca/696f325b0b4f05a9d97abc9bd330fddc/aspnetcore-runtime-8.0.0-preview.3.23177.8-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ccbffcd2-25cb-47db-bf84-259771035cf4/96f4d3e59807443400e387e4535c9fa5/aspnetcore-runtime-8.0.0-preview.3.23177.8-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6bf9bbc5-b1d4-4c4c-a69c-e1a3de12a307/e0da0e72a072ad34e4b829cd48387975/aspnetcore-runtime-8.0.0-preview.3.23177.8-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/918bc3d0-2005-4cc9-91dd-87224f7ed0b8/51656a86318ef5f4c6e9ec4b1bf13101/dotnet-hosting-8.0.0-preview.3.23177.8-win.exe

[//]: # ( SDK 8.0.100-preview.3.23178.7)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c17b7dd9-41be-4ac1-9eae-a9707049c2ad/9dda015bc0f85cf8ff8bd0858936816c/dotnet-sdk-8.0.100-preview.3.23178.7-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3b23cbd9-f068-408f-8c3c-551a5432ff08/876e15ab4041bde421e96d21e259b3b9/dotnet-sdk-8.0.100-preview.3.23178.7-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/78acbfcc-88a2-477a-a65f-3bcf64b33a4c/43db7ffc9dfcd60c37390fc3f8a89357/dotnet-sdk-8.0.100-preview.3.23178.7-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/87c2871f-eca3-4ae0-b0cb-06903edfd8c9/b2e6fb1b8e668ebd79307ae3d40b172e/dotnet-sdk-8.0.100-preview.3.23178.7-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2163a1fe-2549-4f2b-8a60-38be443b2861/7dddadb7edce37cf19304c054bd51691/dotnet-sdk-8.0.100-preview.3.23178.7-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/103d5e2c-d5c4-4101-bb6e-b82bc73a7d93/284a5cdccbc995f39806a3ba2dc17b93/dotnet-sdk-8.0.100-preview.3.23178.7-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3fa4c32e-6c76-4055-b6ea-e9dee2785da9/117d47e8b1cbbaa762390b30329e935f/dotnet-sdk-8.0.100-preview.3.23178.7-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7fc953e8-4e3f-422b-ae45-719b38eb798e/6559f9ed96b446bbaf2e2fd2af694dd0/dotnet-sdk-8.0.100-preview.3.23178.7-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/199b3c2b-0840-4c91-ab2e-5d5a740d1f07/f8669fcc04fc2a171121cfc7764f299c/dotnet-sdk-8.0.100-preview.3.23178.7-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1d4d98db-3a0a-4b77-bd3f-5ead1fc106a9/1a3410ec0ce6b08a02947a5541a3b5a7/dotnet-sdk-8.0.100-preview.3.23178.7-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b33440b5-12ff-4912-8bd6-b46620d62df5/6867dd023dc0ebe9b6f20d6106bbb0ad/dotnet-sdk-8.0.100-preview.3.23178.7-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/6415f213-08c9-42e1-85da-d79ed3a3b05a/fd4ba6e48060f8a46eea63ca0076902b/dotnet-sdk-8.0.100-preview.3.23178.7-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d4e1c5a0-a275-472f-b3eb-e61e1637cb1d/4a1b6861032e3927adca5538ad01e370/dotnet-sdk-8.0.100-preview.3.23178.7-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ab32ea63-4d92-4624-a31d-a97641452ea3/794390d056a1ca8dd083b78586a6ae66/dotnet-sdk-8.0.100-preview.3.23178.7-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5cf70eda-2b26-4de7-ab92-16ee4b6607ba/6a00e555caa4ca3582604f44c5c78b16/dotnet-sdk-8.0.100-preview.3.23178.7-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a756c7df-d9b6-43e5-ad03-b34c2ebd5b50/0e974374688670669eab181550ebfc04/dotnet-sdk-8.0.100-preview.3.23178.7-win-x86.zip
