# .NET 8.0.0 Preview 4 - May 16, 2023

The .NET 8.0.0 Preview 4 and .NET SDK 8.0.100-preview.4.23260.5 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).

## What's new in .NET 8 Preview 4

.NET 8 is the next major release of .NET following .NET 7.0. You can see some of the new features available with .NET 8 Preview 4 at [dotnet/core #8234](https://github.com/dotnet/core/issues/8234).

See the [.NET][dotnet-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 4.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.100-preview.4.23260.5
```

## .NET Multi-Platform App UI (MAUI) Workload Downloads

 After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

 ```console
 $ dotnet workload install maui
 ```

 The following workloads are also available to install individually:

 ```console
 $ dotnet workload install android
 $ dotnet workload install ios
 $ dotnet workload install maccatalyst
 $ dotnet workload install macos
 $ dotnet workload install tvos
 ```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 17.7 latest preview](https://visualstudio.microsoft.com) to use .NET 8.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 8.0 and C# 11.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8458](https://github.com/dotnet/core/issues/8458) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.0-preview.4.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-preview.4-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-preview.4-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-8-preview-4
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-8-preview-4/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8-preview-4/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0-preview4+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0-preview4+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0-preview4+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0-preview4+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.1xx
[linux-packages]: ../install-linux.md


[//]: # ( Runtime 8.0.0-preview.4.23259.5)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2c47ffa5-2421-40a2-b6f8-6ab3c5ecce1c/416c52cd0c0ca2031ed809f2260e341f/dotnet-runtime-8.0.0-preview.4.23259.5-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8fac5d3e-dd32-4b29-a187-1887a912e185/d350aabe412cb33d9c2f2cafbf7c9bed/dotnet-runtime-8.0.0-preview.4.23259.5-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/786e0b38-6f56-4f40-b56b-bbc487a7afb4/cec044de65638aaa911bdbadd8bae621/dotnet-runtime-8.0.0-preview.4.23259.5-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/04ad1363-909b-4d8f-bdef-214ae6a321bf/2702b42fd820dc8cef89aa7fb897427d/dotnet-runtime-8.0.0-preview.4.23259.5-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/90b250f7-2c73-4dc7-83f2-9ede5735345a/f9f2b2d0caf1130430aba3a067eebfde/dotnet-runtime-8.0.0-preview.4.23259.5-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7267fec0-ae12-4f40-9c3d-56da5fbf83e4/f64c2758980c1f908cbe089a6233bbe7/dotnet-runtime-8.0.0-preview.4.23259.5-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/860cf807-c96d-406f-9122-a2d0fc1d23b7/3ed6d45cf281601671305dd8160e09bd/dotnet-runtime-8.0.0-preview.4.23259.5-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c0d0406b-3995-403d-b25c-6ad764291eaa/7f1d366577de292f32623bdf88a5dacf/dotnet-runtime-8.0.0-preview.4.23259.5-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/b9f27a14-46ea-4213-ad1b-f31bb41d3ff3/f9512906f1127157f23bfe0d583fb347/dotnet-runtime-8.0.0-preview.4.23259.5-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/636e676d-136c-4ad3-86c8-d4e86869832e/627c24b6a6753b0dee5af4a322f79155/dotnet-runtime-8.0.0-preview.4.23259.5-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b1a6ac5c-c3eb-408e-b56b-d82744319195/89550f195d1402957204efa8ecff51ce/dotnet-runtime-8.0.0-preview.4.23259.5-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/70181b8a-3bee-45cb-a8ac-4e6df1c2f2c4/b20f3622e4f6228d9f6fefe309db8003/dotnet-runtime-8.0.0-preview.4.23259.5-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/91d346d8-b078-4453-b4e7-2f7a10b1f4c8/b7b5d5a64e099eddf0527dce06424b88/dotnet-runtime-8.0.0-preview.4.23259.5-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3e0dd88b-4cf2-4eaf-80bc-0b60a3b0c3ae/f6fcf001bd315722499f5279779e4586/dotnet-runtime-8.0.0-preview.4.23259.5-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/cece103d-1860-4c54-8c0e-c31f13d07873/a9a3784cb4431a8d7515dc62269174ed/dotnet-runtime-8.0.0-preview.4.23259.5-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/457e3280-4515-4cf6-92bf-d8c9c96b4cf8/df2f8f8e9fdaf87bf2991aa35774b728/dotnet-runtime-8.0.0-preview.4.23259.5-win-x86.zip

[//]: # ( WindowsDesktop 8.0.0-preview.4.23260.1)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/31e64f0e-a70e-499f-a9ff-b82358c93127/18347397fef3a112f62d07244d68eaec/windowsdesktop-runtime-8.0.0-preview.4.23260.1-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/bb4ad84c-ff18-402b-bdee-6a4e6bf2d898/c14647e0b4cbc0547aa192989bc80e8e/windowsdesktop-runtime-8.0.0-preview.4.23260.1-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d8cfe5d8-7da8-4163-bd7c-78aeb4fe3ef1/f55c5964da9bf2c8b5117f61c801122d/windowsdesktop-runtime-8.0.0-preview.4.23260.1-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a7b2af9e-8c69-4448-a1af-06d0a16f4113/ac8833f6d88e80b017cbe5133b12f095/windowsdesktop-runtime-8.0.0-preview.4.23260.1-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/76764fc3-010b-4a35-a4d3-be421abd1600/fedc1e3efae967a0f138c135e981b0be/windowsdesktop-runtime-8.0.0-preview.4.23260.1-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b3e54939-7a01-411a-a1fa-44d0be515951/a339f75955209b5bf613e5b003fe45a8/windowsdesktop-runtime-8.0.0-preview.4.23260.1-win-x86.zip

[//]: # ( ASP 8.0.0-preview.4.23260.4)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a54ce371-fa43-4084-aa97-3a46b21ba459/bc4182da9ec260f9f8743c1442c8bd8f/aspnetcore-runtime-8.0.0-preview.4.23260.4-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c9d4a334-d522-4439-a98a-0af0e7852621/9c3afe685d3e65a92d5c538afa211de7/aspnetcore-runtime-8.0.0-preview.4.23260.4-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/460b796e-149a-4d8c-947f-4b05dacb7913/f092b7b18390d05824a5296644b1b8cd/aspnetcore-runtime-8.0.0-preview.4.23260.4-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/75da9aba-3764-4102-ae46-331d4f8e72f4/ad0e2d747b09b0172ea5282b962c8e0e/aspnetcore-runtime-8.0.0-preview.4.23260.4-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f4e522c0-c15d-440a-9e52-fc75154d2c47/37abb264ee842770e2bc2c23b14570e8/aspnetcore-runtime-8.0.0-preview.4.23260.4-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bda9e867-46d3-416b-864f-5fb28658a8fd/c58375f59b0c0a9946a2be04617a7276/aspnetcore-runtime-8.0.0-preview.4.23260.4-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5acf37f1-8232-4421-b4ae-41d635e2c8d1/3de8d329bb5d905e539f61a12d6091c9/aspnetcore-runtime-8.0.0-preview.4.23260.4-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6011ab96-f3be-414f-b13b-792aad1e383c/e78722ebae2ad81640e05286a30eb0c8/aspnetcore-runtime-8.0.0-preview.4.23260.4-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/c19f5aeb-64fd-4fcd-8dbc-8ae1f849ee7e/27d856701f072bd23bf55860fc0633bf/aspnetcore-runtime-8.0.0-preview.4.23260.4-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b01a486b-6162-4b42-80b2-292ab171f496/50e07451b5da0247a4eb4ad7c82b1fa7/aspnetcore-runtime-8.0.0-preview.4.23260.4-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f53d0e00-0619-4acf-9f49-6f15d2852c03/561e04a11568141444b17384571c90bc/aspnetcore-runtime-8.0.0-preview.4.23260.4-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/fbe6cacf-7351-44d3-8328-2fd75ee013fc/039d0a3710915d761956e7d210732d13/aspnetcore-runtime-8.0.0-preview.4.23260.4-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/cafe2d88-b226-417a-ac44-126900b2f125/d977e066aee6eb423ed7a6d8355989b9/aspnetcore-runtime-8.0.0-preview.4.23260.4-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/5b020624-0e07-4852-b890-2f98fdec314b/76cf89fea997edf1de853ba46442135d/dotnet-hosting-8.0.0-preview.4.23260.4-win.exe

[//]: # ( SDK 8.0.100-preview.4.23260.5)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dd751a26-8daf-464b-9757-f65e1f99965e/5d8deaee6d4fb201dde914f9eab9e2e1/dotnet-sdk-8.0.100-preview.4.23260.5-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9de5d7d8-6062-4a61-b8bf-b1b61dd4b768/f23a336abc7548309acf01314ddc8904/dotnet-sdk-8.0.100-preview.4.23260.5-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ddea41d5-5b82-4d81-ac3e-9f8489965ff8/25301fa68fde2d1f9d1038a98a4a8b7a/dotnet-sdk-8.0.100-preview.4.23260.5-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0c7bf063-7a58-4fb1-88c5-6d07523c4dd6/58e9da1af1ed202ce0782d9819bb724b/dotnet-sdk-8.0.100-preview.4.23260.5-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c026f1ec-53fc-4874-aefd-fe1fdb60bb9c/6de2202f38d1d85e658e9829a7386cb9/dotnet-sdk-8.0.100-preview.4.23260.5-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ae0534ab-1c49-4055-ba2a-b8159c4f94d2/3a5945c949d2eb141f8ce52096fca13c/dotnet-sdk-8.0.100-preview.4.23260.5-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/593bd437-c6f3-412c-9cb0-206addab56d3/330ac8f331f7c9b9e8860669c767cb43/dotnet-sdk-8.0.100-preview.4.23260.5-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2c6668f9-b531-427a-b3b5-5c9dc456c5b8/ef5ef0a8db2df07d12ef138e05fa2231/dotnet-sdk-8.0.100-preview.4.23260.5-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c06279c7-f65e-4da0-bca8-5ae18a652e75/f645c5e53f6d3d51120b1e62cec2cc78/dotnet-sdk-8.0.100-preview.4.23260.5-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/78706993-4be4-46e0-8b14-48f295884a1b/39c2db8388ac84cdfe7e909bdde39384/dotnet-sdk-8.0.100-preview.4.23260.5-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/0e032e13-f32d-4451-b4ee-b54297038964/9c13febb635874b38b23ec449c6cb43c/dotnet-sdk-8.0.100-preview.4.23260.5-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/bd93fe19-5599-47d2-a813-33d34e62cfa5/5c74e0f06376af41a6881ef1c038c5ef/dotnet-sdk-8.0.100-preview.4.23260.5-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1b55b379-5ef2-4f21-8fad-aba058913cbc/c26ee3ba55cb40407a79564e28ed6d98/dotnet-sdk-8.0.100-preview.4.23260.5-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e90be9dd-d567-4fe6-a1f5-966dd8fbceae/99a6b0d8c3a53060f48ade66e62cf20a/dotnet-sdk-8.0.100-preview.4.23260.5-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/aecb896a-d517-4079-af5a-8be87c1ebeef/5e3dbc9053755eec240dad14f1d789d7/dotnet-sdk-8.0.100-preview.4.23260.5-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d7cd2b4d-8544-4708-ac31-10dcd254e06f/18f1342f13f754400cf9ddfd34ad4dd6/dotnet-sdk-8.0.100-preview.4.23260.5-win-x86.zip
