# .NET 8.0.0 Preview 5 - June 13, 2023

The .NET 8.0.0 Preview 5 and .NET SDK 8.0.100-preview.5.23303.2 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).

## What's new in .NET 8 Preview 5

.NET 8 is the next major release of .NET following .NET 7.0. You can see some of the new features available with .NET 8 Preview 5 at [dotnet/core #8436](https://github.com/dotnet/core/issues/8436).

See the [.NET][dotnet-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 4.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.100-preview.5.23303.2
```

## .NET Multi-Platform App UI (MAUI) Workload Downloads

 After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

 ```console
 $ dotnet workload install maui
 ```

 The following workloads are also available to install individually:

 ```console
 $ dotnet workload install android
 $ dotnet workload install ios
 $ dotnet workload install maccatalyst
 $ dotnet workload install macos
 $ dotnet workload install tvos
 ```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 17.7 latest preview](https://visualstudio.microsoft.com) to use .NET 8.0 on Windows. Visual Studio for Mac is currently not supported for .NET 8.0 Preview releases.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8540](https://github.com/dotnet/core/issues/8540) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.0-preview.5.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-preview.5-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-preview.5-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-8-preview-5
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-8-preview-5/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8-preview-5/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0-preview5+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0-preview5+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0-preview5+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0-preview5+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.1xx
[linux-packages]: ../install-linux.md

[//]: # ( Runtime 8.0.0-preview.5.23280.8)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0c3d9bdf-f42f-46f4-9d3d-b3b3b49567b5/5a1de67d7d5b0406413c52efe704dd56/dotnet-runtime-8.0.0-preview.5.23280.8-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c5c38c9e-775f-48e1-93db-bdeaccf15876/be5113d9c28eaa96d6317bc6e38e9528/dotnet-runtime-8.0.0-preview.5.23280.8-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e428e4f4-4988-4b4f-bb08-433df7e50846/839d462461759ebdb2c0a7bd4e22b9f6/dotnet-runtime-8.0.0-preview.5.23280.8-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a2d69149-41c1-4d72-babf-2bdfa7815a0e/1923f497b0c39ba3127f441c3b03f0f7/dotnet-runtime-8.0.0-preview.5.23280.8-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6ab45a91-0f20-4cac-8058-69e10784efd3/afb56e427a9edadcbb1f4439c749a3f0/dotnet-runtime-8.0.0-preview.5.23280.8-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bbdc7ec0-d87e-4b6b-bb3f-9dbe5db3078e/6cda9733bbedf8f4fb9e18829e301051/dotnet-runtime-8.0.0-preview.5.23280.8-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/99c39037-df94-4eb1-b76c-0112bdc08c3e/7b842415a04b9a86c2f84d97e694dccc/dotnet-runtime-8.0.0-preview.5.23280.8-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/620a82a4-38d2-4967-9076-388de70cefaa/9ae3a2b33a9df5b312861995b0bcb08b/dotnet-runtime-8.0.0-preview.5.23280.8-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1bb1ad11-9477-490b-b85c-171525ca2fbb/b8afd518f97e57839d938376f4087a87/dotnet-runtime-8.0.0-preview.5.23280.8-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/07613650-5f43-4792-b975-10fb0dd512b6/966e29340d90ab182f7e73925cf46d28/dotnet-runtime-8.0.0-preview.5.23280.8-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/71c58504-c892-4c30-aece-3e04130f0f5a/e9f5990fedb249bb54777540c49e029f/dotnet-runtime-8.0.0-preview.5.23280.8-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/af0e69c0-6c0a-401e-acf5-7bb4a016bee8/b4603d0632ea48ba601394bc47e9ffae/dotnet-runtime-8.0.0-preview.5.23280.8-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ad867ebb-826e-4c6c-b46c-c55b343a3a60/f81f668a1f0d0cb4e877d1317a37d254/dotnet-runtime-8.0.0-preview.5.23280.8-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/137e9b39-5c16-4642-8509-0b7625139dd2/c423f3e9f58c5ec80f48da2a6c2fd9bf/dotnet-runtime-8.0.0-preview.5.23280.8-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c4598208-aa91-4187-a1cd-c8e750222fa3/756c4adae106e0879d7d361c829f487d/dotnet-runtime-8.0.0-preview.5.23280.8-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1bffab93-bd84-4b34-82eb-b74c86038d3b/2b307135839ec33ce1b38ceabb460f9d/dotnet-runtime-8.0.0-preview.5.23280.8-win-x86.zip

[//]: # ( WindowsDesktop 8.0.0-preview.5.23302.2)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a77682fc-fabc-4eb9-addd-73362dba271b/676d862e408154eec62a09103c317f76/windowsdesktop-runtime-8.0.0-preview.5.23302.2-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/fe3d1721-b4f2-4b66-af26-f31447e2af6f/1053643c75356624c21cb72120640e4b/windowsdesktop-runtime-8.0.0-preview.5.23302.2-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/871d915f-d6f0-4131-854c-685d24326f88/9a97e552e882ae429f3b0f5812975802/windowsdesktop-runtime-8.0.0-preview.5.23302.2-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5f69625b-2769-4204-bbd3-bc5c944d95e0/c059b6fbc67f5b2c91d980af96dac8fb/windowsdesktop-runtime-8.0.0-preview.5.23302.2-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c43810a9-4267-48f3-972e-6ad774ce9426/c42da63f7ea2a9ea2c71b79c1fb62da7/windowsdesktop-runtime-8.0.0-preview.5.23302.2-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e491f888-b63c-48b2-ad78-5145172e1f8f/6d26aab4ab62148b37c70b1b73959b14/windowsdesktop-runtime-8.0.0-preview.5.23302.2-win-x86.zip

[//]: # ( ASP 8.0.0-preview.5.23302.2)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7b3651c6-33a2-40f8-a99e-95a173361054/60a8be42f8fe2171c4ad6015304eacfa/aspnetcore-runtime-8.0.0-preview.5.23302.2-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3a1b9bf4-f6b5-47ed-b325-38e31af9f60d/dfa9cbb848ab710dc162b5cff1f26f2d/aspnetcore-runtime-8.0.0-preview.5.23302.2-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/05cb5500-de4c-47f3-a1aa-97207d0a4ec8/a9bdb6a6a0ff97b5ed84ac28c1f058c9/aspnetcore-runtime-8.0.0-preview.5.23302.2-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3a96363b-962d-4d94-bdd4-d91afba8bbd7/7d5e78824c7b48f6fdfee50e5bb45488/aspnetcore-runtime-8.0.0-preview.5.23302.2-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/64370422-8f61-4946-8660-b57493eeaa13/8e6cc1fee3bbcb037a6b819ef80f20bc/aspnetcore-runtime-8.0.0-preview.5.23302.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b95d1c31-20bb-43ad-a6e3-7d14e955f759/003b3b17dbbc72ac8ee66c54aef85c04/aspnetcore-runtime-8.0.0-preview.5.23302.2-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e1fe9f3b-448e-4ed8-85f1-9ab58c51438d/823051b4bdaff6e19c7b78bfbaa1101f/aspnetcore-runtime-8.0.0-preview.5.23302.2-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c588c5f1-58e5-4cfe-b1a7-622458123783/42b3f9e884a7e995da49ad847ee8ffe6/aspnetcore-runtime-8.0.0-preview.5.23302.2-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/544f5525-7076-4e10-8e70-f4662021b0af/8e18ace519b2e3de79453a235f5063fd/aspnetcore-runtime-8.0.0-preview.5.23302.2-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3bbcb2f1-6014-4b77-ad6d-b5177ed475fd/21a0cd10a245696ec8269a09b1699f62/aspnetcore-runtime-8.0.0-preview.5.23302.2-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b23ae2b0-dc75-4581-857d-282a64e618d8/1385d6687bbce010f16d508df432075a/aspnetcore-runtime-8.0.0-preview.5.23302.2-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/03e90d57-b66c-4060-ad91-0a2dd14323bf/59025c40561bfcc6fdd20a4d01045555/aspnetcore-runtime-8.0.0-preview.5.23302.2-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/41e6ba94-2967-46bb-89fe-74158c86828f/952b86cc1b5253c1a8aa3f4c84fb580d/aspnetcore-runtime-8.0.0-preview.5.23302.2-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/661388ec-0bcf-4331-8f0f-e0d183443d49/a8ba9626853c6c1f078ce10210df9640/dotnet-hosting-8.0.0-preview.5.23302.2-win.exe

[//]: # ( SDK 8.0.100-preview.5.23303.2)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bec1bcaf-802f-4337-99ea-dc775f4db430/d6c60f6694b77394cd75d2a2f6ecab7c/dotnet-sdk-8.0.100-preview.5.23303.2-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/93db1aea-6913-4cdc-8129-23e3e3de8dd1/4a942a2fbbb6ca6667c01ec414096ee0/dotnet-sdk-8.0.100-preview.5.23303.2-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ae43e51f-116a-4935-9d43-f2860e15d9f0/826dfb83f19526df16cd620b9b5188b9/dotnet-sdk-8.0.100-preview.5.23303.2-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/99f25d86-1de8-4063-b592-cc7630a5b145/e3e0de280a743cea989be7a1872676c7/dotnet-sdk-8.0.100-preview.5.23303.2-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3fe10d43-8a50-4f13-a44e-9e2de1434819/b2c804d8631b388aee85f968e38b302d/dotnet-sdk-8.0.100-preview.5.23303.2-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/07b027f8-4ef8-48cb-becc-132652c625bb/441ef662adfe931013745df24d53b26d/dotnet-sdk-8.0.100-preview.5.23303.2-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c4f8255b-c638-4977-a407-b5f8e666ca22/a55fa273c57a3f754f9a6bfdb7132e39/dotnet-sdk-8.0.100-preview.5.23303.2-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/078ed12c-82d5-486c-85b2-5f4ed34ddf34/a314372565e2e62d8de3497118a41888/dotnet-sdk-8.0.100-preview.5.23303.2-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/32b6e063-c6c3-427c-a734-e8fcf368c2a9/2abc4575ecd422aae6bc2bfe8c569be4/dotnet-sdk-8.0.100-preview.5.23303.2-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/47115ea7-dffc-436d-a0ac-e7445a932d12/b59ac26284ffa2162139c21052feaed9/dotnet-sdk-8.0.100-preview.5.23303.2-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/0b9ae556-f7cf-41c5-82b2-a5ade109030b/2e832a1fdcfc91b193be445f092a54a0/dotnet-sdk-8.0.100-preview.5.23303.2-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d8b5e3c6-eda5-437e-9747-e43db9f13887/9e4dbab66957af062745f0da5b10ff51/dotnet-sdk-8.0.100-preview.5.23303.2-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f284354a-f415-4630-ae2c-73ede1998d21/0ba6c31a896243bec8731c8b57ccca1b/dotnet-sdk-8.0.100-preview.5.23303.2-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4b6a9fcd-66d0-4e6d-9841-a14a0282c00d/5d27168e3323fcd82939859ccbc3f2f2/dotnet-sdk-8.0.100-preview.5.23303.2-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9726b5ef-0ac7-41cc-95c5-c4b3b7876f0b/4b6a76f42401a0aa17a54a2200b1647f/dotnet-sdk-8.0.100-preview.5.23303.2-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/bb2b82e3-02e7-4060-92ea-44a0c0ad118a/6b7d39bbbdbae34d787736165acf6d21/dotnet-sdk-8.0.100-preview.5.23303.2-win-x86.zip
