# .NET 8.0.0 Preview 6 - July 11, 2023

The .NET 8.0.0 Preview 6 and .NET SDK 8.0.100-preview.6.23330.14 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).

## What's new in .NET 8 Preview 6

.NET 8 is the next major release of .NET following .NET 7.0. You can see some of the new features available with .NET 8 Preview 6 at [dotnet/core #8437](https://github.com/dotnet/core/issues/8437).

See the [.NET][dotnet-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 6.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.100-preview.6.23330.14
```

## .NET Multi-Platform App UI (MAUI) Workload Downloads

 After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

 ```console
 $ dotnet workload install maui
 ```

 The following workloads are also available to install individually:

 ```console
 $ dotnet workload install android
 $ dotnet workload install ios
 $ dotnet workload install maccatalyst
 $ dotnet workload install macos
 $ dotnet workload install tvos
 ```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 17.7 latest preview](https://visualstudio.microsoft.com) to use .NET 8.0 on Windows. Visual Studio for Mac 17.6.1 now supports .NET 8.0 Previews. Users can separately install the .NET 8 SDK and enable a preview feature in Preferences to enable the IDE to discover and use the .NET 8 SDK for creating, loading, building, and debugging projects.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8614](https://github.com/dotnet/core/issues/8614) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.0-preview.6.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-preview.6-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-preview.6-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-8-preview-6
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-8-preview-6/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8-preview-6/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0-preview6+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0-preview6+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0-preview6+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0-preview6+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.1xx
[linux-packages]: ../install-linux.md


[//]: # ( Runtime 8.0.0-preview.6.23329.7)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3c157004-f9ac-4178-8512-86e946280803/e651125c10950721bb00f72ec9224e73/dotnet-runtime-8.0.0-preview.6.23329.7-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/794d54ca-66a0-48b4-8ab3-0c26679df9ba/2e2a9052dd41ba89a780c290ec6daacd/dotnet-runtime-8.0.0-preview.6.23329.7-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7f638237-90ed-468d-a7f8-c3450dc3429b/64fda9f7661c3b3ee07d2937bae715f2/dotnet-runtime-8.0.0-preview.6.23329.7-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/33a2195d-09d1-4de0-9d43-ab7bad1e4109/37f4b58b180c0c83a28f15aae080e184/dotnet-runtime-8.0.0-preview.6.23329.7-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e47d704f-05cb-4148-a0a5-752b66e0a3ad/6f1bf5488939ac3484c7df4a4f72f1a1/dotnet-runtime-8.0.0-preview.6.23329.7-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6b2b077e-c282-4b4a-a085-aa15dfa5ad96/31668a112cfbe7e23a3238e368bf741a/dotnet-runtime-8.0.0-preview.6.23329.7-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f73b25df-809a-4154-bd8f-e88983d93fe2/f1745c329b0e2c93e5c8044398c49493/dotnet-runtime-8.0.0-preview.6.23329.7-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/34e71a1b-88fd-4cd6-91a1-cc13c9ff3ed4/fc7608c28c9052d81d1318b06cba4f07/dotnet-runtime-8.0.0-preview.6.23329.7-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3e429e54-5523-434d-8aab-839292abc6e6/12174b2dd00fdc23cc832ec8abeb8813/dotnet-runtime-8.0.0-preview.6.23329.7-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3cee771a-f57d-49a8-817e-fcbbb7f34e30/1153323701b97a089c5111bb74129824/dotnet-runtime-8.0.0-preview.6.23329.7-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/102c7665-9ec4-499e-ba65-6e4e5e231c10/4109a22b8d843bb6251101d1468e32ec/dotnet-runtime-8.0.0-preview.6.23329.7-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/9414dcb9-ccf8-4ca0-99c7-e773b00d31be/9f746d8dfc655fca87e497550c15d084/dotnet-runtime-8.0.0-preview.6.23329.7-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/bb9c1824-8202-45e2-8560-53e5edf84177/b477d34e83c66b01c30656bb20fb66a7/dotnet-runtime-8.0.0-preview.6.23329.7-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/80f1ffdd-0818-47be-9a12-5bb2010883c1/a6ab2d67c399e7501ca6162e9138c284/dotnet-runtime-8.0.0-preview.6.23329.7-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6829ab05-93ff-4604-89d2-17825898252c/bdc66818c2af9ad356a7aebea0c78001/dotnet-runtime-8.0.0-preview.6.23329.7-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/f7912222-baf3-42c7-af80-f3e6d23ceb7f/7ee8a766c1181c57270eb377e3fa6b5a/dotnet-runtime-8.0.0-preview.6.23329.7-win-x86.zip

[//]: # ( WindowsDesktop 8.0.0-preview.6.23329.4)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/0e21f1a3-894d-4c4b-89bf-4b89ce2b9145/c0fefc1e069d34d946b8185c8a921d94/windowsdesktop-runtime-8.0.0-preview.6.23329.4-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/ddee6b3b-99b0-4e2d-a6e3-130a6539d892/bd6215923b4f4805522321823b8fba89/windowsdesktop-runtime-8.0.0-preview.6.23329.4-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a966665a-47dc-4f8e-b10a-1a73e2d1ba76/bd647778a8fc10199eb376a551ec9a45/windowsdesktop-runtime-8.0.0-preview.6.23329.4-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7b7e515e-a389-40f2-9fd0-0f610e9e8b32/57cf295da910738d132121a2c0907787/windowsdesktop-runtime-8.0.0-preview.6.23329.4-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b2cba6be-5f71-423c-b169-4c2178fff500/ed621128abd1ba8fe275413e48cade70/windowsdesktop-runtime-8.0.0-preview.6.23329.4-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/19043ac5-c8a4-4425-97a6-9219b277daac/520f2f419fb991390d1697591460b1bd/windowsdesktop-runtime-8.0.0-preview.6.23329.4-win-x86.zip

[//]: # ( ASP 8.0.0-preview.6.23329.11)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aae52695-b838-49cf-861a-1b41806f86bd/fd803406f1b70860d6a8e3cefcf88660/aspnetcore-runtime-8.0.0-preview.6.23329.11-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ffeb1444-c55b-4689-9def-e641851fe9aa/44b8b52675cc384a8ec44004e9581ba2/aspnetcore-runtime-8.0.0-preview.6.23329.11-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/49fa5ede-bffc-4d51-a3b0-87f9e7eb0835/ba89da44b7038a98e1442a5cd863a705/aspnetcore-runtime-8.0.0-preview.6.23329.11-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0edf7924-861d-4ba3-9f13-a4486d4abae8/82920fbb9ae1a61d784d587430a642d3/aspnetcore-runtime-8.0.0-preview.6.23329.11-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a82e91e6-afcd-4526-9cd6-da67312a6ee7/0df4b4587ef2a20ca2eee09b4fab21ff/aspnetcore-runtime-8.0.0-preview.6.23329.11-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5402fd3d-387d-4841-a9a9-25398ca06f65/812b7d489d7da2513a77c4b47787ae72/aspnetcore-runtime-8.0.0-preview.6.23329.11-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ef1f200a-ce41-495b-ad24-8f9e440cf1bc/9c842f011eebc29615d19ac112217329/aspnetcore-runtime-8.0.0-preview.6.23329.11-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/34774716-83ca-427a-a594-4afbc9d4c0e4/bb7044656d62de96684c2215abbfb01a/aspnetcore-runtime-8.0.0-preview.6.23329.11-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/edb0b79e-1747-4758-85f9-0d370a48c0a6/74b7496ff100fb49487de7d878c8490f/aspnetcore-runtime-8.0.0-preview.6.23329.11-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/16de2688-7406-4e47-9428-b03a7ff6fd84/5aa7a34eb427f01bcd746ed17c82656c/aspnetcore-runtime-8.0.0-preview.6.23329.11-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/cb4502e1-db26-4b0b-8b45-caee821ecfd1/28bc2b7c0e99b98f35509cabe3c454e7/aspnetcore-runtime-8.0.0-preview.6.23329.11-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/09a72063-5e82-47b3-91b7-c14c44090640/e28ff6cb8fd6fd77220e4f76687fbcfb/aspnetcore-runtime-8.0.0-preview.6.23329.11-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d7db50b5-21e0-4fa9-9449-d114d6aff13f/f8d3183ec0c82868147a4f2d4b3beae7/aspnetcore-runtime-8.0.0-preview.6.23329.11-win-x86.zip
[aspnetcore-runtime-composite-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c366c5eb-07fa-4bf5-ba84-e4aed37eaad6/564a1172a29aa750860b273792d67c34/aspnetcore-runtime-composite-8.0.0-preview.6.23329.11-linux-arm.tar.gz
[aspnetcore-runtime-composite-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e63d3375-efb7-4f36-88d3-b15b35ab095e/7660a04729d8645e3c8f05e8fbf66bfc/aspnetcore-runtime-composite-8.0.0-preview.6.23329.11-linux-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d61b2c96-997e-4b02-9a02-4557bf39caf9/7aea3b097faf0a45afea7ac11342d47c/aspnetcore-runtime-composite-8.0.0-preview.6.23329.11-linux-musl-arm.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f0b22d3c-ebe6-4891-97e7-36339b4bd907/01e4e8cfd8196d206a76992bd5f1788e/aspnetcore-runtime-composite-8.0.0-preview.6.23329.11-linux-musl-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c65ecf97-9824-4cb9-bd83-b395f658b340/1a05cca5cbdf3e2f488a52a004494e3d/aspnetcore-runtime-composite-8.0.0-preview.6.23329.11-linux-musl-x64.tar.gz
[aspnetcore-runtime-composite-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/afee2c1e-b4d0-41c9-9b6a-7c7bdee63b15/cfea917d52db073672aaac66c2d733c5/aspnetcore-runtime-composite-8.0.0-preview.6.23329.11-linux-x64.tar.gz
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/e5db48f5-99c6-42ca-804a-85b89ae09671/b5594181b347a9a77246e3645916bd0e/dotnet-hosting-8.0.0-preview.6.23329.11-win.exe

[//]: # ( SDK 8.0.100-preview.6.23330.14)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d5859f18-7182-405d-b933-bf83cb96673c/dddba064f022527ff32778023d0f36b6/dotnet-sdk-8.0.100-preview.6.23330.14-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/46626be9-8672-4c2c-b149-3233496e4372/fb49425c9eeb4f05291a9f57250c0e0d/dotnet-sdk-8.0.100-preview.6.23330.14-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5eb93ae1-7c05-4383-a820-59cc050f42c2/71e6f9bcf3815d192e7ce12ce705ce6a/dotnet-sdk-8.0.100-preview.6.23330.14-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c0190d44-8ef8-44cf-a945-4b3832230a9b/a31907dc74e7031760f0eddedde56696/dotnet-sdk-8.0.100-preview.6.23330.14-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b2ade609-8b55-4a3a-9e5b-2b29b86ba54b/42a8f36929cd50ec1645d3fb99ddc520/dotnet-sdk-8.0.100-preview.6.23330.14-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0ce806be-89f7-4264-ad1b-6ff1887e7b6b/08a75d03919470fba420b970a7565ef5/dotnet-sdk-8.0.100-preview.6.23330.14-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7f22cf54-5a57-496d-91a2-87a6ad84f082/0c8e092af75683cf7703193b6473e608/dotnet-sdk-8.0.100-preview.6.23330.14-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2eab2544-17ce-46fd-bbef-f945f5d39f89/9a31a37fb7b506d8e2accee49d4e6508/dotnet-sdk-8.0.100-preview.6.23330.14-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/6672a02f-48fd-4f4b-80cd-ed58f8a59f85/112dc40e791e651a818780d5054622f0/dotnet-sdk-8.0.100-preview.6.23330.14-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/28518a51-cc36-488f-85e3-0c8538d26a78/52ca92f96fd142ea1fac7d57155cf002/dotnet-sdk-8.0.100-preview.6.23330.14-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/c4af360f-1797-4f1d-9e49-0582dbf22466/75060ec5f640ff05c7f842eb3978e341/dotnet-sdk-8.0.100-preview.6.23330.14-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d58c6a86-a3fc-4484-8d46-cb6a6f435643/3c06d473116838f0789cdd601a2a8344/dotnet-sdk-8.0.100-preview.6.23330.14-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/894a1d1d-e77d-4e46-b134-9d2263c1dd85/387ade6049e0fd1387052e4c7264a26b/dotnet-sdk-8.0.100-preview.6.23330.14-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0072b092-a2f3-4f94-9d74-ded4a9778ff8/ebee51c1135ac31bf746dff35d919216/dotnet-sdk-8.0.100-preview.6.23330.14-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/06f61e1a-4e95-401b-a547-93b9199eb9df/f9c28caf93521f1062b360063152306b/dotnet-sdk-8.0.100-preview.6.23330.14-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2836f636-73b4-40f9-a55e-14d8e3e6ce8f/591a87f0f9decb6c1cc7d77574787505/dotnet-sdk-8.0.100-preview.6.23330.14-win-x86.zip
