# .NET 8.0.0 RC 1 - September 12, 2023

The .NET 8.0.0 RC 1 and .NET SDK 8.0.100-rc.1.23463.5 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).

## .NET SDK 8.0.100-rc.1.23463.5 - September 14 2023

Today, we are releasing a new version of .NET SDK. This release suprecedes the `.NET SDK 8.0.100-rc.1.23455.8` version. The  `.NET SDK 8.0.100-rc.1.23463.5` is available in Visual Studio 17.8 Preview 1.

This resolves an issue where the `.NET SDK 8.0.100-rc.1.23455.8` did not recognize a new certificate in MAUI optional workload. This caused the workload install to fail when using the .NET CLI. Customers would see an error even though the package was correctly signed.

```
Failed to update the advertising manifest microsoft.net.sdk.maui: Failed to validate package signing.
Verifying Microsoft.NET.Sdk.Maui.Manifest-8.0.100-rc.1.Msi.x64.8.0.0-rc.1.9171
```


## What's new in .NET 8 RC 1

.NET 8 is the next major release of .NET following .NET 7.0. You can see some of the new features available with .NET 8 RC 1 at [dotnet/core #8439](https://github.com/dotnet/core/issues/8439).

See the [.NET][dotnet-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in RC 1.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.100-rc.1.23463.5
```

## .NET Multi-Platform App UI (MAUI) Workload Downloads

 After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

 ```console
 $ dotnet workload install maui
 ```

 The following workloads are also available to install individually:

 ```console
 $ dotnet workload install android
 $ dotnet workload install ios
 $ dotnet workload install maccatalyst
 $ dotnet workload install macos
 $ dotnet workload install tvos
 ```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 17.7 latest preview](https://visualstudio.microsoft.com) to use .NET 8.0 on Windows. Visual Studio for Mac 17.6.1 now supports .NET 8.0 Previews. Users can separately install the .NET 8 SDK and enable a preview feature in Preferences to enable the IDE to discover and use the .NET 8 SDK for creating, loading, building, and debugging projects.

## Notable Fixes
.NET 8.0 RC 1 carries security fixes

**Note:** The vulnerabilities [CVE-2023-36792]( https://www.cve.org/CVERecord?id=CVE-2023-36792), [CVE-2023-36793]( https://www.cve.org/CVERecord?id=CVE-2023-36793), [CVE-2023-36792]( https://www.cve.org/CVERecord?id=CVE-2023-36794), [CVE-2023-36796]( https://www.cve.org/CVERecord?id=CVE-2023-36796) are all resolved by a single patch. Get this update to resolve all of them.

[CVE-2023-36792 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36792)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36793 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36793)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36794 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36794)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36796 - .NET Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36796)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in Microsoft.DiaSymReader.Native.amd64.dll when reading a corrupted PDB file which may lead to remote code execution. This issue only affects Windows systems.

[CVE-2023-36799 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36799)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET where reading a maliciously crafted X.509 certificate may result in Denial of Service. This issue only affects Linux systems.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8759](https://github.com/dotnet/core/issues/8759) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.0-rc.1.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-rc.1-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-rc.1-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-8-rc1
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-8-rc-1/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8-rc-1/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0-rc1+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0-rc1+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0-rc1+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0-rc1+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.1xx
[linux-packages]: ../install-linux.md

[//]: # ( Runtime 8.0.0-rc.1.23419.4)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/46cc97e9-6e4f-49d3-b986-756a60997c54/6f02c425dc3e3985f648cfd2c50188a3/dotnet-runtime-8.0.0-rc.1.23419.4-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/78e40734-8864-48f7-8c03-971ee500d93a/4b2fd807bb790d9ac3cd8585ff8cb6ad/dotnet-runtime-8.0.0-rc.1.23419.4-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/96aedec8-279d-4eac-85bb-f9eef088d86a/d1de434b0542a30960fc9dd9fde08767/dotnet-runtime-8.0.0-rc.1.23419.4-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9506a479-dc4f-4cad-a087-045ab50a0891/39ed2fe9839c4483e9eab9d9a13906a0/dotnet-runtime-8.0.0-rc.1.23419.4-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/13fa250c-d408-4ee2-8e65-e7150017187c/5c3cad1abf8fb67b7b42b000c75dc5c9/dotnet-runtime-8.0.0-rc.1.23419.4-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8cac1522-acbe-4052-9f6a-19341a8f9dae/1cf1396b382e22cb1ba21a27f3b79725/dotnet-runtime-8.0.0-rc.1.23419.4-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d96533ea-069f-4e74-8831-6a84fa91a0df/cb2ce1df9164639d3d2587af1f90364d/dotnet-runtime-8.0.0-rc.1.23419.4-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/59ecb50d-0abc-4bd1-ae81-8a252027d3e0/43ed857eea3316732b1a5cb0c68eaa50/dotnet-runtime-8.0.0-rc.1.23419.4-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/518bdac4-3c24-48a9-9eeb-c0371683054a/68a5cff19edd10fa9f3136acd802b7dd/dotnet-runtime-8.0.0-rc.1.23419.4-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/29e68c3a-f37a-4dea-b7dc-bb1890b28d48/3ee60668c4ccd17ea565d6c204ef1f64/dotnet-runtime-8.0.0-rc.1.23419.4-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/032d3a90-195e-41c0-b01f-1480455a832c/463589e60cba1a94e71d1ef24226292f/dotnet-runtime-8.0.0-rc.1.23419.4-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/7f765a2c-2593-4ab6-aaaf-8545d0fac2d7/d09ada8628589ee5b13dd2ad5c9b23e0/dotnet-runtime-8.0.0-rc.1.23419.4-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a51f4fa7-0daa-4cc4-9430-c09031f4e749/f3923dd69adaf62fa41b280d9ea108dd/dotnet-runtime-8.0.0-rc.1.23419.4-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7869bd18-4975-4847-b820-c70cdafd6a30/b60796da83cb525a3236d3c541834ed3/dotnet-runtime-8.0.0-rc.1.23419.4-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a20f1eb5-784a-4be9-85cd-8c0f25010396/d81f6e2678805a399d536e0260cb5c44/dotnet-runtime-8.0.0-rc.1.23419.4-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/926c5740-b221-4bc5-bdfe-6296efc44f8c/12f6eedbd02415dd2beddf0d3c9db413/dotnet-runtime-8.0.0-rc.1.23419.4-win-x86.zip

[//]: # ( WindowsDesktop 8.0.0-rc.1.23420.5)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/3379e273-7ca5-44d2-af49-5b5a1c4f3cd2/4767fe6fb859d2d908c5f05fde99ed96/windowsdesktop-runtime-8.0.0-rc.1.23420.5-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/607f1b8e-fbf9-429f-9355-2763b5075921/cc879c3d434d02403e4733a7d569b78e/windowsdesktop-runtime-8.0.0-rc.1.23420.5-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3c2be57d-f02c-4317-a2cf-1d9ac406bfb8/3277392bf76f06d8cd597cdf8f124c4b/windowsdesktop-runtime-8.0.0-rc.1.23420.5-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e51723e0-dc33-412d-8630-649d925a51fd/4b2952ea79a010ddfae7aac2fcf4aacd/windowsdesktop-runtime-8.0.0-rc.1.23420.5-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3bacce43-d067-4abf-8ac8-15eeb144a104/23475f771b28a14e652657205b855ce7/windowsdesktop-runtime-8.0.0-rc.1.23420.5-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/fed1fa78-25fa-4d1f-ad10-273201758655/5165e6b754492f51aa2a4251d12db47b/windowsdesktop-runtime-8.0.0-rc.1.23420.5-win-x86.zip

[//]: # ( ASP 8.0.0-rc.1.23421.29)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4c62796c-0c3c-480f-80a9-d73bd22195b2/ba7033a5b41a4476107c3bc1bdb542a7/aspnetcore-runtime-8.0.0-rc.1.23421.29-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/de4037e0-6e5e-4a40-9c83-555d30d9c21f/f607c58db3f81aea2c7e56b0ddbf9ac6/aspnetcore-runtime-8.0.0-rc.1.23421.29-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f9277f72-04fe-4193-9d82-2af1b44ca772/e18f57193e213422f9d1bf4df4083251/aspnetcore-runtime-8.0.0-rc.1.23421.29-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5f345557-8a26-4bbf-93c2-739e29d344fc/a4aaacd6c4ad013fe05205fd5edb7180/aspnetcore-runtime-8.0.0-rc.1.23421.29-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b9742940-bab3-48ef-ab4d-548b20c472ca/69df6711bbc7e31a8c67766a4fe5c439/aspnetcore-runtime-8.0.0-rc.1.23421.29-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/02f4c6c2-c137-448d-a189-9ee3a3f6f99f/192f2c750089fa0194f04f5a805bd21e/aspnetcore-runtime-8.0.0-rc.1.23421.29-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6dbd02b7-f3e8-46b5-a3e9-ea482762a02d/430b0d87ec687b4a9968ca143ea95789/aspnetcore-runtime-8.0.0-rc.1.23421.29-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c3612fc1-f335-4b1c-a08a-08267100ff43/dd06c8e7021c27becdfed27838be253f/aspnetcore-runtime-8.0.0-rc.1.23421.29-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/38aa13dc-0e8f-4b3f-92f6-493947c4fd7e/d540b05184fc7f1185923570ebf49028/aspnetcore-runtime-8.0.0-rc.1.23421.29-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ef4ff8b6-87e5-44ef-8b34-89818d771aa8/b4fa0483c74ff540442431c5c8dfab2f/aspnetcore-runtime-8.0.0-rc.1.23421.29-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d8548d19-54e2-4976-a299-453b542fa67b/1741ac8a590e7c01326732d26d55db7b/aspnetcore-runtime-8.0.0-rc.1.23421.29-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1c20bfad-70d4-4be3-be55-48ae3e64e8b6/d2cfb42f9753a6a2e7f033e197125608/aspnetcore-runtime-8.0.0-rc.1.23421.29-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/68aca5b8-95ef-4ce3-9a1c-f93728b4a968/fca35b660c324cc23421129234ecfb9c/aspnetcore-runtime-8.0.0-rc.1.23421.29-win-x86.zip
[aspnetcore-runtime-composite-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/823bdee6-9769-41e1-92a7-5ddd21c557df/ba4611686601ec4658f3305787bf7613/aspnetcore-runtime-composite-8.0.0-rc.1.23421.29-linux-arm.tar.gz
[aspnetcore-runtime-composite-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cf6dcaee-57ac-4d16-bf3d-ed6f68f1632b/a503511af3d1f2225a05d9106fce137d/aspnetcore-runtime-composite-8.0.0-rc.1.23421.29-linux-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4309967b-8503-455c-b9f2-c803f50ebda7/866093d5f30a08587a212e642629c712/aspnetcore-runtime-composite-8.0.0-rc.1.23421.29-linux-musl-arm.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a591f1a4-a753-496e-b5a8-0250fbaf3e7e/171349f17490817a2f016553c2935c59/aspnetcore-runtime-composite-8.0.0-rc.1.23421.29-linux-musl-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/729aab99-04e0-45d7-b978-f42cbab521f5/9cffda818eaea6ef5bd567f239a66cd7/aspnetcore-runtime-composite-8.0.0-rc.1.23421.29-linux-musl-x64.tar.gz
[aspnetcore-runtime-composite-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f54be620-7d5c-4d45-8457-8d55c71084e5/7ce19748b32677132fbd69e3a601f318/aspnetcore-runtime-composite-8.0.0-rc.1.23421.29-linux-x64.tar.gz
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/f6fcf7ad-2ae2-4b26-97be-bfaff4e6d873/4005d9603269b7266bd156ad1393475c/dotnet-hosting-8.0.0-rc.1.23421.29-win.exe

[//]: # ( SDK 8.0.100-rc.1.23463.5)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d6eef49a-f74b-4c48-a8c9-51e09fc39bea/6822a9284fdd487f01b9a5cc90b00d68/dotnet-sdk-8.0.100-rc.1.23463.5-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/46cee660-92b3-4b07-9082-a397866c909f/c708a7d23c446fbc63b2a70b86c5fe29/dotnet-sdk-8.0.100-rc.1.23463.5-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6d879005-a221-4c89-bf1c-ba2119f54f91/2dbd97e8001df539c7635c8f36bda621/dotnet-sdk-8.0.100-rc.1.23463.5-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3e0f9465-fa71-45f8-a8ce-75052931ed32/096aa561e8374b3c9dfb3ddf7623484a/dotnet-sdk-8.0.100-rc.1.23463.5-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d6758898-f104-4fb4-8b46-67803e0882ef/069c803d74cadc9369d8f1d9c6a6c0b5/dotnet-sdk-8.0.100-rc.1.23463.5-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/764f2fec-710d-490d-a341-88636bce1a8d/35fc13fc20161a7d196200d9c2c6a8f0/dotnet-sdk-8.0.100-rc.1.23463.5-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/030ab62d-61c2-4f8f-bcec-ee45837f7df0/f69ba0e33588a4fa6a41e7b56cd52654/dotnet-sdk-8.0.100-rc.1.23463.5-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9dbb7558-b41d-4e07-986c-65bc76ea6df6/962f24b52a00209464f4d3e9d6f4334c/dotnet-sdk-8.0.100-rc.1.23463.5-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a1c8239d-f1fd-4b47-be6b-e07217068e46/78337c7ab38ad4cf0f4ed2db5f7ebe66/dotnet-sdk-8.0.100-rc.1.23463.5-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/207ba9ff-0f08-4766-bf0e-91e4add99dc7/7270b0ff0340f435b984cf2116558374/dotnet-sdk-8.0.100-rc.1.23463.5-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/1171f406-75b3-4970-8c83-f1b2a1922d33/5f59c61ba38b6c224f73fc9263c23e77/dotnet-sdk-8.0.100-rc.1.23463.5-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/edbfe0e9-875f-4aed-bd96-abc303c8e45b/a273f39fcb9b813af24e928c114b01a7/dotnet-sdk-8.0.100-rc.1.23463.5-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/60e99454-eb0c-4ec3-b258-836171b3e053/52ff90f9b31b6bb4a77200216694b03d/dotnet-sdk-8.0.100-rc.1.23463.5-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/577fe112-f607-4ab3-abbc-8be20c643c29/b51011ff804ad47051bd9d81c6e737c0/dotnet-sdk-8.0.100-rc.1.23463.5-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/75343315-859e-46f6-a37f-e034773a5783/7b1d74087a336ab9fe3e56be7f013f8e/dotnet-sdk-8.0.100-rc.1.23463.5-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/59243a79-5fbc-40b2-922e-d4fd81275d56/e630a061711891740fe397a291bcded7/dotnet-sdk-8.0.100-rc.1.23463.5-win-x86.zip

