# .NET 8.0.0 RC 2 - October 10, 2023

The .NET 8.0.0 RC 2 and .NET SDK 8.0.100-rc.2.23502.2 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).


## What's new in .NET 8 RC 2

.NET 8 is the next major release of .NET following .NET 7.0. You can see some of the new features available with .NET 8 RC 2 at [dotnet/core #8440](https://github.com/dotnet/core/issues/8440).

See the [.NET][dotnet-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in RC 2.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.100-rc.2.23502.2
```

## .NET Multi-Platform App UI (MAUI) Workload Downloads

 After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

 ```console
 $ dotnet workload install maui
 ```

 The following workloads are also available to install individually:

 ```console
 $ dotnet workload install android
 $ dotnet workload install ios
 $ dotnet workload install maccatalyst
 $ dotnet workload install macos
 $ dotnet workload install tvos
 ```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 17.7 latest preview](https://visualstudio.microsoft.com) to use .NET 8.0 on Windows. Visual Studio for Mac 17.6.1 now supports .NET 8.0 Previews. Users can separately install the .NET 8 SDK and enable a preview feature in Preferences to enable the IDE to discover and use the .NET 8 SDK for creating, loading, building, and debugging projects.

## Notable Fixes
.NET 8.0 RC 2 carries security fixes.

[CVE-2023-44487 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-44487)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 8.0 RC1, .NET 7.0 ,and .NET 6.0. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A vulnerability exists in the ASP.NET  Core Kestrel web server where a malicious client may flood the server with specially crafted HTTP/2 requests, causing denial of service.

[CVE-2023-38171 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-38171)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 8.0 RC1. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A null pointer vulnerability exists in MsQuic.dll which may lead to Denial of Service. This issue only affects Windows systems.

[CVE-2023-36435 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36435)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 7.0 and .NET 8.0 RC1. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A memory leak vulnerability exists in MsQuic.dll which may lead to Denial of Service. This issue only affects Windows systems.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8828](https://github.com/dotnet/core/issues/8828) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.0-rc.2.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-rc.2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-rc.2-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-8-rc2
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-8-rc-2/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8-rc-2/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0-rc2+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0-rc2+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0-rc2+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0-rc2+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.1xx
[linux-packages]: ../install-linux.md

[//]: # ( Runtime 8.0.0-rc.2.23479.6)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/746338e0-bbc9-462a-ad39-cea55feabd1e/d3ca65fff11bfe2ec5c22be106e6c61e/dotnet-runtime-8.0.0-rc.2.23479.6-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d16acf4b-d37e-4e3e-8f8c-73c7eff96bf0/ceb8eee1c24d194d8614f3b0a885e9ce/dotnet-runtime-8.0.0-rc.2.23479.6-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/864823ab-59a5-483f-80a0-34eb9d26e098/61bbd01a246800cfdde48249d8faa347/dotnet-runtime-8.0.0-rc.2.23479.6-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/154f1f09-8bcb-4de9-93db-587d1454a978/16db2b4d211ca1629a96ef7298570c60/dotnet-runtime-8.0.0-rc.2.23479.6-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f0b63512-6aec-4d1e-9aa3-eabf541d947d/8470136d9a6a1737b0574d9dca57f278/dotnet-runtime-8.0.0-rc.2.23479.6-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4fb768da-b0ff-495f-8673-869c2f7e59bf/527c1e1d55a9fbcdd86018bc62b07a03/dotnet-runtime-8.0.0-rc.2.23479.6-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/049d48f9-e924-424e-8555-87221458e1f9/ac1890c81c8e6c52a96329afce30c8e0/dotnet-runtime-8.0.0-rc.2.23479.6-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/148f6949-ee92-475f-b45c-814139f2bccb/1e031945c3524f31abac2c8442794875/dotnet-runtime-8.0.0-rc.2.23479.6-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a1dd621a-97c9-4e6d-ad4f-3d257b9eb4c9/0b629b86765f30c694d727fec87225f7/dotnet-runtime-8.0.0-rc.2.23479.6-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d8b1d5c7-2328-49bb-92d4-7c3db905a1bf/500d836a2747b281059ff025cac9a79e/dotnet-runtime-8.0.0-rc.2.23479.6-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/bd0302de-8aad-4576-ab4a-d21106c7c78a/44c56634f350a9894e97dbfc58922562/dotnet-runtime-8.0.0-rc.2.23479.6-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/2f43fe5f-df80-47b7-bdab-677596e05f2c/5ba45cfe163b8662122434c762d3d42e/dotnet-runtime-8.0.0-rc.2.23479.6-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/aebdca89-6bdc-4d2b-8f50-96abd8a21308/1949f6958ea40fd143009059ab3e8efc/dotnet-runtime-8.0.0-rc.2.23479.6-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/986289ec-503e-4cdd-bd6d-bb3aae442177/26a18571e620007b90067361618a622b/dotnet-runtime-8.0.0-rc.2.23479.6-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a69b7628-d127-4dff-a808-3da5d7554896/95123b7c28d55ea34f59f9b88f54bcfe/dotnet-runtime-8.0.0-rc.2.23479.6-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9bf45c99-29cf-43ce-be4f-12cea5cad888/2236415a0515db0ce9b5c80d1ad994cc/dotnet-runtime-8.0.0-rc.2.23479.6-win-x86.zip

[//]: # ( WindowsDesktop 8.0.0-rc.2.23479.10)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/49108dc5-d835-4a43-8594-845188e1b36a/24d73eeb63bd831a2b4b76a1184fefa5/windowsdesktop-runtime-8.0.0-rc.2.23479.10-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/7bef3f67-d5ef-494b-8f0b-1c161aeaa333/1c7ff537b191d51779f7bd5b947a9df3/windowsdesktop-runtime-8.0.0-rc.2.23479.10-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9c540179-a75c-4418-94fd-3bfe580e4251/6560fb0d71bf6434a4fe17b5cfa00a45/windowsdesktop-runtime-8.0.0-rc.2.23479.10-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5c797b34-8aa5-4ce1-b8d2-ba5f47e6b6c8/bd766b9f0417ea95d057cc85db6334f9/windowsdesktop-runtime-8.0.0-rc.2.23479.10-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c2d2d578-40f2-4055-bf2f-77aec390e710/5dd9089e2fc23e7e87e8a691489cf617/windowsdesktop-runtime-8.0.0-rc.2.23479.10-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c327464f-7b35-4f22-ae79-31e7da55f874/39dd2daae5b0da713c3c9d6ac19ab565/windowsdesktop-runtime-8.0.0-rc.2.23479.10-win-x86.zip

[//]: # ( ASP 8.0.0-rc.2.23480.2)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bfa751f5-17fe-489b-bc5d-6f53a578e601/4137a4e66d3c0895035925e7073cb47a/aspnetcore-runtime-8.0.0-rc.2.23480.2-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c5d92a9c-c318-422e-b66a-7849199de735/6c3bc3f5958917851fe7dacd383bcaea/aspnetcore-runtime-8.0.0-rc.2.23480.2-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cf65e237-fdc1-490d-a875-345d8e24c74e/225c027ed5aad427f8b06f29122caac5/aspnetcore-runtime-8.0.0-rc.2.23480.2-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/19b54304-6e1a-4ee3-937b-6c915aa12539/dff23895425552ede94293eaba89f643/aspnetcore-runtime-8.0.0-rc.2.23480.2-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/382665a5-f3b3-4612-a06c-34ea8dfc9793/bf4f8ab64529b600657bde4e49158f5d/aspnetcore-runtime-8.0.0-rc.2.23480.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0d7fb51b-f30e-4b84-b4c2-b739ec8f7978/68e9fc71fb2c4f01a9c7f25672caf1d1/aspnetcore-runtime-8.0.0-rc.2.23480.2-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/32f5d2b8-3b63-4d4d-8a7f-876adad4efc0/c1f62a3e480fb0e38faa957d34c0be54/aspnetcore-runtime-8.0.0-rc.2.23480.2-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/76affdcb-9294-41e4-a5c7-91629309e11b/75a24f3cf07097a94c58e22acf1e709a/aspnetcore-runtime-8.0.0-rc.2.23480.2-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/b847af17-0ad5-4378-a966-4b0da30d7fe4/c061dcb760e6e6525e576edc2d793b43/aspnetcore-runtime-8.0.0-rc.2.23480.2-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/38a7d56f-0d3e-4118-aae3-e547e07a71ca/84363ea03acebee9ef647bfdd819941d/aspnetcore-runtime-8.0.0-rc.2.23480.2-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3a0b8a34-0b0e-4d4b-b3b4-d1b48f8af679/d70edde788fa0b7af1100f8e2f4bc213/aspnetcore-runtime-8.0.0-rc.2.23480.2-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b0f42aad-9cd2-4d99-8287-3ce1abf88dfe/0a0076ab2fbc200705659218941d69d4/aspnetcore-runtime-8.0.0-rc.2.23480.2-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/82d2d2ad-ae11-4bc9-8319-3d5af03dbf55/b913233f3ce849136c1e6a367d5bfbdb/aspnetcore-runtime-8.0.0-rc.2.23480.2-win-x86.zip
[aspnetcore-runtime-composite-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3bd00f7e-69e1-45a8-a57d-0e738ea5d62f/cd02d40df3695dd050c6371b18facf48/aspnetcore-runtime-composite-8.0.0-rc.2.23480.2-linux-arm.tar.gz
[aspnetcore-runtime-composite-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3040bb18-09ed-4deb-9289-cf69001ffd8c/0c92df34cdb9a938b99fab1b23b1c5d1/aspnetcore-runtime-composite-8.0.0-rc.2.23480.2-linux-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b1ec33ed-82bd-4928-a866-9b860205d57c/39b7a38bfdbe93b18bf6e5530c31d89d/aspnetcore-runtime-composite-8.0.0-rc.2.23480.2-linux-musl-arm.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e63dba7f-077b-491c-9d76-9cbcd0bb1b1f/f48bef18f90e7b9b839199844b763738/aspnetcore-runtime-composite-8.0.0-rc.2.23480.2-linux-musl-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1e91817-dcf4-4206-9bef-37e11f3df091/bba6461e0ca2dfca2331f96a0bfec6a4/aspnetcore-runtime-composite-8.0.0-rc.2.23480.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-composite-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/25464a05-4d8d-4545-aa68-14f10f002d55/47a2f7e5dfef0e814cfad0fb25b7645a/aspnetcore-runtime-composite-8.0.0-rc.2.23480.2-linux-x64.tar.gz
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/f0a627b7-bd46-4ed2-978d-00a445174074/182420f488062f1983fc392b2fb66967/dotnet-hosting-8.0.0-rc.2.23480.2-win.exe

[//]: # ( SDK 8.0.100-rc.2.23502.2)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/89cdc88a-aaf3-4aab-9b76-d663dfcf920b/feb04f8f017eab8d78eef2ae7554d675/dotnet-sdk-8.0.100-rc.2.23502.2-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0247681a-1a4a-4a32-a1a6-4149d56af27e/5bcbf1d8189c2649b16d27f5199e04a4/dotnet-sdk-8.0.100-rc.2.23502.2-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ef76b84f-8f44-42df-a9f8-69832ff2ea91/4b6c4925955563a97d77990fcd02cd23/dotnet-sdk-8.0.100-rc.2.23502.2-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d6fdd8f9-1390-4d17-b7a0-43e55d93d51b/27477cb710f473f2586f8666418f2d1d/dotnet-sdk-8.0.100-rc.2.23502.2-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/10099e3c-c2e0-4f4c-a33e-6477a46f8d6b/f62cb118d5ded76cf81d702353255593/dotnet-sdk-8.0.100-rc.2.23502.2-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9144f37e-b370-41ee-a86f-2d2a69251652/bc1d544112ec134184a5aec7f7a1eaf9/dotnet-sdk-8.0.100-rc.2.23502.2-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0e35f353-a3c0-4fe5-9f8c-9db472d07f50/ae1ad30cfc182e4d7766b2bf4a063097/dotnet-sdk-8.0.100-rc.2.23502.2-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6c9084b3-c512-41be-afe5-84e156f250b1/6e1c12684b4c5b95f122f0659f337ab3/dotnet-sdk-8.0.100-rc.2.23502.2-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/69d7c726-56c4-4652-94e5-4e10a5ac846f/4ef542bc620666656a74d0f6e2235fb8/dotnet-sdk-8.0.100-rc.2.23502.2-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2cb4fcbd-ba5d-41c4-9907-8120aa4b5f23/98fd104ada4105462cefb1123a0df533/dotnet-sdk-8.0.100-rc.2.23502.2-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/9ef2b234-c856-45cc-8346-686683e612cd/169c0c4fa9d55a18a69be6fd59100654/dotnet-sdk-8.0.100-rc.2.23502.2-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/20be942d-d5da-475b-8a33-dd02182a8887/0e3ee04cfd41010bd879b380a39b6d56/dotnet-sdk-8.0.100-rc.2.23502.2-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/92e8b771-8624-48a6-9ffc-9fda1f301fb4/85b45cdf39b2a773fbf8d5d71c3d4774/dotnet-sdk-8.0.100-rc.2.23502.2-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/bbf52fad-c6a2-4b83-a966-fb5c03ab3d61/476acd23413a7f46679c257e0ebe437d/dotnet-sdk-8.0.100-rc.2.23502.2-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8e8b12d2-121d-48d5-a9c6-582a034d6160/6581a9180afbf1d855c9d7f0aa541541/dotnet-sdk-8.0.100-rc.2.23502.2-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/53977a97-20a3-4e2e-b187-37755d655100/dfcb40d2b8c80c0c78471488124776fb/dotnet-sdk-8.0.100-rc.2.23502.2-win-x86.zip

