# Microsoft.AspNetCore.Builder

``` diff
 namespace Microsoft.AspNetCore.Builder {
     public static class ConnectionEndpointRouteBuilderExtensions {
-        public static ConnectionEndpointRouteBuilder MapConnectionHandler<TConnectionHandler>(this IEndpointRouteBuilder endpoints, string pattern) where TConnectionHandler : ConnectionHandler;
+        public static ConnectionEndpointRouteBuilder MapConnectionHandler<TConnectionHandler>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern) where TConnectionHandler : ConnectionHandler;
-        public static ConnectionEndpointRouteBuilder MapConnectionHandler<TConnectionHandler>(this IEndpointRouteBuilder endpoints, string pattern, Action<HttpConnectionDispatcherOptions>? configureOptions) where TConnectionHandler : ConnectionHandler;
+        public static ConnectionEndpointRouteBuilder MapConnectionHandler<TConnectionHandler>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Action<HttpConnectionDispatcherOptions>? configureOptions) where TConnectionHandler : ConnectionHandler;
-        public static ConnectionEndpointRouteBuilder MapConnections(this IEndpointRouteBuilder endpoints, string pattern, HttpConnectionDispatcherOptions options, Action<IConnectionBuilder> configure);
+        public static ConnectionEndpointRouteBuilder MapConnections(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, HttpConnectionDispatcherOptions options, Action<IConnectionBuilder> configure);
-        public static ConnectionEndpointRouteBuilder MapConnections(this IEndpointRouteBuilder endpoints, string pattern, Action<IConnectionBuilder> configure);
+        public static ConnectionEndpointRouteBuilder MapConnections(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Action<IConnectionBuilder> configure);
     }
     public static class FallbackEndpointRouteBuilderExtensions {
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, RequestDelegate requestDelegate);
+        public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, RequestDelegate requestDelegate);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
+        public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
     }
     public static class HealthCheckEndpointRouteBuilderExtensions {
-        public static IEndpointConventionBuilder MapHealthChecks(this IEndpointRouteBuilder endpoints, string pattern);
+        public static IEndpointConventionBuilder MapHealthChecks(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern);
-        public static IEndpointConventionBuilder MapHealthChecks(this IEndpointRouteBuilder endpoints, string pattern, HealthCheckOptions options);
+        public static IEndpointConventionBuilder MapHealthChecks(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, HealthCheckOptions options);
     }
     public static class HubEndpointRouteBuilderExtensions {
-        public static HubEndpointConventionBuilder MapHub<THub>(this IEndpointRouteBuilder endpoints, string pattern) where THub : Hub;
+        public static HubEndpointConventionBuilder MapHub<THub>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern) where THub : Hub;
-        public static HubEndpointConventionBuilder MapHub<THub>(this IEndpointRouteBuilder endpoints, string pattern, Action<HttpConnectionDispatcherOptions>? configureOptions) where THub : Hub;
+        public static HubEndpointConventionBuilder MapHub<THub>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Action<HttpConnectionDispatcherOptions>? configureOptions) where THub : Hub;
     }
     public static class RazorPagesEndpointRouteBuilderExtensions {
-        public static void MapDynamicPageRoute<TTransformer>(this IEndpointRouteBuilder endpoints, string pattern) where TTransformer : DynamicRouteValueTransformer;
+        public static void MapDynamicPageRoute<TTransformer>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern) where TTransformer : DynamicRouteValueTransformer;
-        public static void MapDynamicPageRoute<TTransformer>(this IEndpointRouteBuilder endpoints, string pattern, object? state) where TTransformer : DynamicRouteValueTransformer;
+        public static void MapDynamicPageRoute<TTransformer>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, object? state) where TTransformer : DynamicRouteValueTransformer;
-        public static void MapDynamicPageRoute<TTransformer>(this IEndpointRouteBuilder endpoints, string pattern, object state, int order) where TTransformer : DynamicRouteValueTransformer;
+        public static void MapDynamicPageRoute<TTransformer>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, object state, int order) where TTransformer : DynamicRouteValueTransformer;
-        public static IEndpointConventionBuilder MapFallbackToAreaPage(this IEndpointRouteBuilder endpoints, string pattern, string page, string area);
+        public static IEndpointConventionBuilder MapFallbackToAreaPage(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, string page, string area);
-        public static IEndpointConventionBuilder MapFallbackToPage(this IEndpointRouteBuilder endpoints, string pattern, string page);
+        public static IEndpointConventionBuilder MapFallbackToPage(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, string page);
     }
     public class RequestLocalizationOptions {
+        public bool CultureInfoUseUserOverride { get; set; }
     }
     public class StaticFileOptions : SharedOptionsBase {
+        public Func<StaticFileResponseContext, Task> OnPrepareResponseAsync { get; set; }
     }
     public sealed class WebApplication : IApplicationBuilder, IAsyncDisposable, IDisposable, IEndpointRouteBuilder, IHost {
+        public static WebApplicationBuilder CreateSlimBuilder();
+        public static WebApplicationBuilder CreateSlimBuilder(WebApplicationOptions options);
+        public static WebApplicationBuilder CreateSlimBuilder(string[] args);
-        public void Run(string? url = null);
+        public void Run([StringSyntaxAttribute("Uri")] string? url = null);
-        public Task RunAsync(string? url = null);
+        public Task RunAsync([StringSyntaxAttribute("Uri")] string? url = null);
     }
 }
```

