# Microsoft.AspNetCore.Components

``` diff
 namespace Microsoft.AspNetCore.Components {
     public static class BindConverter {
-        public static string FormatValue(DateOnly value, string format, CultureInfo? culture = null);
+        public static string FormatValue(DateOnly value, [StringSyntaxAttribute("DateOnlyFormat")] string format, CultureInfo? culture = null);
-        public static string FormatValue(DateTime value, string format, CultureInfo? culture = null);
+        public static string FormatValue(DateTime value, [StringSyntaxAttribute("DateTimeFormat")] string format, CultureInfo? culture = null);
-        public static string FormatValue(DateOnly? value, string format, CultureInfo culture = null);
+        public static string FormatValue(DateOnly? value, [StringSyntaxAttribute("DateOnlyFormat")] string format, CultureInfo culture = null);
-        public static string FormatValue(DateTime? value, string format, CultureInfo culture = null);
+        public static string FormatValue(DateTime? value, [StringSyntaxAttribute("DateTimeFormat")] string format, CultureInfo culture = null);
-        public static string FormatValue(TimeOnly? value, string format, CultureInfo culture = null);
+        public static string FormatValue(TimeOnly? value, [StringSyntaxAttribute("TimeOnlyFormat")] string format, CultureInfo culture = null);
-        public static string FormatValue(TimeOnly value, string format, CultureInfo? culture = null);
+        public static string FormatValue(TimeOnly value, [StringSyntaxAttribute("TimeOnlyFormat")] string format, CultureInfo? culture = null);
-        public static bool TryConvertToDateOnly(object obj, CultureInfo culture, string format, out DateOnly value);
+        public static bool TryConvertToDateOnly(object obj, CultureInfo culture, [StringSyntaxAttribute("DateOnlyFormat")] string format, out DateOnly value);
-        public static bool TryConvertToDateTime(object obj, CultureInfo culture, string format, out DateTime value);
+        public static bool TryConvertToDateTime(object obj, CultureInfo culture, [StringSyntaxAttribute("DateTimeFormat")] string format, out DateTime value);
-        public static bool TryConvertToNullableDateOnly(object obj, CultureInfo culture, string format, out DateOnly? value);
+        public static bool TryConvertToNullableDateOnly(object obj, CultureInfo culture, [StringSyntaxAttribute("DateOnlyFormat")] string format, out DateOnly? value);
-        public static bool TryConvertToNullableDateTime(object obj, CultureInfo culture, string format, out DateTime? value);
+        public static bool TryConvertToNullableDateTime(object obj, CultureInfo culture, [StringSyntaxAttribute("DateTimeFormat")] string format, out DateTime? value);
-        public static bool TryConvertToNullableTimeOnly(object obj, CultureInfo culture, string format, out TimeOnly? value);
+        public static bool TryConvertToNullableTimeOnly(object obj, CultureInfo culture, [StringSyntaxAttribute("TimeOnlyFormat")] string format, out TimeOnly? value);
-        public static bool TryConvertToTimeOnly(object obj, CultureInfo culture, string format, out TimeOnly value);
+        public static bool TryConvertToTimeOnly(object obj, CultureInfo culture, [StringSyntaxAttribute("TimeOnlyFormat")] string format, out TimeOnly value);
     }
     public abstract class ComponentBase : IComponent, IHandleAfterRender, IHandleEvent {
+        protected Task DispatchExceptionAsync(Exception exception);
     }
     public abstract class NavigationManager {
-        public void NavigateTo(string uri, NavigationOptions options);
+        public void NavigateTo([StringSyntaxAttribute("Uri")] string uri, NavigationOptions options);
-        public void NavigateTo(string uri, bool forceLoad);
+        public void NavigateTo([StringSyntaxAttribute("Uri")] string uri, bool forceLoad);
-        public void NavigateTo(string uri, bool forceLoad = false, bool replace = false);
+        public void NavigateTo([StringSyntaxAttribute("Uri")] string uri, bool forceLoad = false, bool replace = false);
-        protected virtual void NavigateToCore(string uri, NavigationOptions options);
+        protected virtual void NavigateToCore([StringSyntaxAttribute("Uri")] string uri, NavigationOptions options);
-        protected virtual void NavigateToCore(string uri, bool forceLoad);
+        protected virtual void NavigateToCore([StringSyntaxAttribute("Uri")] string uri, bool forceLoad);
-        public Uri ToAbsoluteUri(string relativeUri);
+        public Uri ToAbsoluteUri(string? relativeUri);
     }
     public readonly struct RenderHandle {
+        public Task DispatchExceptionAsync(Exception exception);
     }
 }
```

