# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
     public class BindingAddress {
+        public bool IsNamedPipe { get; }
+        public string NamedPipeName { get; }
     }
     public static class EndpointFilterExtensions {
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static TBuilder AddEndpointFilter<TBuilder, TFilterType>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder where TFilterType : IEndpointFilter;
+        public static TBuilder AddEndpointFilter<TBuilder, TFilterType>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder where TFilterType : IEndpointFilter;
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static TBuilder AddEndpointFilter<TBuilder>(this TBuilder builder, IEndpointFilter filter) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder AddEndpointFilter<TBuilder>(this TBuilder builder, IEndpointFilter filter) where TBuilder : IEndpointConventionBuilder;
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static TBuilder AddEndpointFilter<TBuilder>(this TBuilder builder, Func<EndpointFilterInvocationContext, EndpointFilterDelegate, ValueTask<object?>> routeHandlerFilter) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder AddEndpointFilter<TBuilder>(this TBuilder builder, Func<EndpointFilterInvocationContext, EndpointFilterDelegate, ValueTask<object?>> routeHandlerFilter) where TBuilder : IEndpointConventionBuilder;
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static RouteHandlerBuilder AddEndpointFilter<TFilterType>(this RouteHandlerBuilder builder) where TFilterType : IEndpointFilter;
+        public static RouteHandlerBuilder AddEndpointFilter<TFilterType>(this RouteHandlerBuilder builder) where TFilterType : IEndpointFilter;
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static RouteGroupBuilder AddEndpointFilter<TFilterType>(this RouteGroupBuilder builder) where TFilterType : IEndpointFilter;
+        public static RouteGroupBuilder AddEndpointFilter<TFilterType>(this RouteGroupBuilder builder) where TFilterType : IEndpointFilter;
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static TBuilder AddEndpointFilterFactory<TBuilder>(this TBuilder builder, Func<EndpointFilterFactoryContext, EndpointFilterDelegate, EndpointFilterDelegate> filterFactory) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder AddEndpointFilterFactory<TBuilder>(this TBuilder builder, Func<EndpointFilterFactoryContext, EndpointFilterDelegate, EndpointFilterDelegate> filterFactory) where TBuilder : IEndpointConventionBuilder;
     }
     public static class HttpRequestJsonExtensions {
+        public static ValueTask<object?> ReadFromJsonAsync(this HttpRequest request, JsonTypeInfo jsonTypeInfo, CancellationToken cancellationToken = default(CancellationToken));
-        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
-        public static ValueTask<object?> ReadFromJsonAsync(this HttpRequest request, Type type, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<object?> ReadFromJsonAsync(this HttpRequest request, Type type, CancellationToken cancellationToken = default(CancellationToken));
-        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
-        public static ValueTask<TValue?> ReadFromJsonAsync<TValue>(this HttpRequest request, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<TValue?> ReadFromJsonAsync<TValue>(this HttpRequest request, CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class HttpResponse {
-        public virtual void Redirect(string location);
+        public virtual void Redirect([StringSyntaxAttribute("Uri")] string location);
-        public abstract void Redirect(string location, bool permanent);
+        public abstract void Redirect([StringSyntaxAttribute("Uri")] string location, bool permanent);
     }
     public static class HttpResponseJsonExtensions {
+        public static Task WriteAsJsonAsync(this HttpResponse response, object? value, JsonTypeInfo jsonTypeInfo, string? contentType = null, CancellationToken cancellationToken = default(CancellationToken));
-        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
-        public static Task WriteAsJsonAsync(this HttpResponse response, object? value, Type type, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task WriteAsJsonAsync(this HttpResponse response, object? value, Type type, CancellationToken cancellationToken = default(CancellationToken));
-        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
-        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, CancellationToken cancellationToken = default(CancellationToken));
     }
     public readonly struct QueryString : IEquatable<QueryString> {
-        public bool HasValue { get; }
+        [MemberNotNullWhenAttribute(true, "Value")]
+        public bool HasValue { [MemberNotNullWhenAttribute(true, "Value")] get; }
     }
-    [UnconditionalSuppressMessageAttribute("Trimmer", "IL2026", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
-    [UnconditionalSuppressMessageAttribute("Trimmer", "IL2060", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
-    [UnconditionalSuppressMessageAttribute("Trimmer", "IL2072", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
-    [UnconditionalSuppressMessageAttribute("Trimmer", "IL2075", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
-    [UnconditionalSuppressMessageAttribute("Trimmer", "IL2077", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
-    public static class RequestDelegateFactory {
+    [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
+    public static class RequestDelegateFactory {
-        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
-        public static RequestDelegateResult Create(Delegate handler, RequestDelegateFactoryOptions? options);
+        public static RequestDelegateResult Create(Delegate handler, RequestDelegateFactoryOptions? options);
-        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
-        public static RequestDelegateResult Create(Delegate handler, RequestDelegateFactoryOptions? options = null, RequestDelegateMetadataResult? metadataResult = null);
+        public static RequestDelegateResult Create(Delegate handler, RequestDelegateFactoryOptions? options = null, RequestDelegateMetadataResult? metadataResult = null);
-        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
-        public static RequestDelegateResult Create(MethodInfo methodInfo, Func<HttpContext, object>? targetFactory, RequestDelegateFactoryOptions? options);
+        public static RequestDelegateResult Create(MethodInfo methodInfo, Func<HttpContext, object>? targetFactory, RequestDelegateFactoryOptions? options);
-        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
-        public static RequestDelegateResult Create(MethodInfo methodInfo, Func<HttpContext, object>? targetFactory = null, RequestDelegateFactoryOptions? options = null, RequestDelegateMetadataResult? metadataResult = null);
+        public static RequestDelegateResult Create(MethodInfo methodInfo, Func<HttpContext, object>? targetFactory = null, RequestDelegateFactoryOptions? options = null, RequestDelegateMetadataResult? metadataResult = null);
-        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
-        public static RequestDelegateMetadataResult InferMetadata(MethodInfo methodInfo, RequestDelegateFactoryOptions? options = null);
+        public static RequestDelegateMetadataResult InferMetadata(MethodInfo methodInfo, RequestDelegateFactoryOptions? options = null);
     }
     public static class Results {
-        public static IResult AcceptedAtRoute(string routeName = null, object routeValues = null, object value = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static IResult AcceptedAtRoute(string routeName = null, object routeValues = null, object value = null);
-        public static IResult AcceptedAtRoute<TValue>(string routeName = null, object routeValues = null, TValue value = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static IResult AcceptedAtRoute<TValue>(string routeName = null, object routeValues = null, TValue value = null);
+        public static IResult Created();
-        public static IResult Created(string uri, object? value);
+        public static IResult Created(string uri, object value);
-        public static IResult Created(Uri uri, object? value);
+        public static IResult Created(Uri uri, object value);
-        public static IResult Created<TValue>(string uri, TValue? value);
+        public static IResult Created<TValue>(string uri, TValue value);
-        public static IResult Created<TValue>(Uri uri, TValue? value);
+        public static IResult Created<TValue>(Uri uri, TValue value);
-        public static IResult CreatedAtRoute(string routeName = null, object routeValues = null, object value = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static IResult CreatedAtRoute(string routeName = null, object routeValues = null, object value = null);
-        public static IResult CreatedAtRoute<TValue>(string routeName = null, object routeValues = null, TValue value = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static IResult CreatedAtRoute<TValue>(string routeName = null, object routeValues = null, TValue value = null);
-        public static IResult LocalRedirect(string localUrl, bool permanent = false, bool preserveMethod = false);
+        public static IResult LocalRedirect([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl, bool permanent = false, bool preserveMethod = false);
-        public static IResult Redirect(string url, bool permanent = false, bool preserveMethod = false);
+        public static IResult Redirect([StringSyntaxAttribute("Uri")] string url, bool permanent = false, bool preserveMethod = false);
-        public static IResult RedirectToRoute(string routeName = null, object routeValues = null, bool permanent = false, bool preserveMethod = false, string fragment = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static IResult RedirectToRoute(string routeName = null, object routeValues = null, bool permanent = false, bool preserveMethod = false, string fragment = null);
     }
     public static class TypedResults {
-        public static AcceptedAtRoute AcceptedAtRoute(string routeName = null, object routeValues = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static AcceptedAtRoute AcceptedAtRoute(string routeName = null, object routeValues = null);
-        public static AcceptedAtRoute<TValue> AcceptedAtRoute<TValue>(TValue value, string routeName = null, object routeValues = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static AcceptedAtRoute<TValue> AcceptedAtRoute<TValue>(TValue value, string routeName = null, object routeValues = null);
+        public static Created Created();
-        public static Created Created(string uri);
+        public static Created Created(string? uri);
-        public static Created Created(Uri uri);
+        public static Created Created(Uri? uri);
-        public static Created<TValue> Created<TValue>(string uri, TValue? value);
+        public static Created<TValue> Created<TValue>(string uri, TValue value);
-        public static Created<TValue> Created<TValue>(Uri uri, TValue? value);
+        public static Created<TValue> Created<TValue>(Uri uri, TValue value);
-        public static CreatedAtRoute CreatedAtRoute(string routeName = null, object routeValues = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static CreatedAtRoute CreatedAtRoute(string routeName = null, object routeValues = null);
-        public static CreatedAtRoute<TValue> CreatedAtRoute<TValue>(TValue value, string routeName = null, object routeValues = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static CreatedAtRoute<TValue> CreatedAtRoute<TValue>(TValue value, string routeName = null, object routeValues = null);
-        public static RedirectHttpResult LocalRedirect(string localUrl, bool permanent = false, bool preserveMethod = false);
+        public static RedirectHttpResult LocalRedirect([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl, bool permanent = false, bool preserveMethod = false);
-        public static RedirectHttpResult Redirect(string url, bool permanent = false, bool preserveMethod = false);
+        public static RedirectHttpResult Redirect([StringSyntaxAttribute("Uri")] string url, bool permanent = false, bool preserveMethod = false);
-        public static RedirectToRouteHttpResult RedirectToRoute(string routeName = null, object routeValues = null, bool permanent = false, bool preserveMethod = false, string fragment = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static RedirectToRouteHttpResult RedirectToRoute(string routeName = null, object routeValues = null, bool permanent = false, bool preserveMethod = false, string fragment = null);
     }
 }
```

