# Microsoft.AspNetCore.Identity

``` diff
 namespace Microsoft.AspNetCore.Identity {
     public class IdentityBuilder {
-        public virtual IdentityBuilder AddClaimsPrincipalFactory<TFactory>() where TFactory : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because UserType is a reference type.")]
+        public virtual IdentityBuilder AddClaimsPrincipalFactory<TFactory>() where TFactory : class;
-        public virtual IdentityBuilder AddPasswordValidator<TValidator>() where TValidator : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because UserType is a reference type.")]
+        public virtual IdentityBuilder AddPasswordValidator<TValidator>() where TValidator : class;
-        public virtual IdentityBuilder AddRoleManager<TRoleManager>() where TRoleManager : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because RoleType is a reference type.")]
+        public virtual IdentityBuilder AddRoleManager<TRoleManager>() where TRoleManager : class;
-        public virtual IdentityBuilder AddRoles<TRole>() where TRole : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because UserType is a reference type.")]
+        public virtual IdentityBuilder AddRoles<TRole>() where TRole : class;
-        public virtual IdentityBuilder AddRoleStore<TStore>() where TStore : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because RoleType is a reference type.")]
+        public virtual IdentityBuilder AddRoleStore<TStore>() where TStore : class;
-        public virtual IdentityBuilder AddRoleValidator<TRole>() where TRole : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because RoleType is a reference type.")]
+        public virtual IdentityBuilder AddRoleValidator<TRole>() where TRole : class;
-        public virtual IdentityBuilder AddTokenProvider(string providerName, Type provider);
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because UserType is a reference type.")]
+        public virtual IdentityBuilder AddTokenProvider(string providerName, Type provider);
-        public virtual IdentityBuilder AddUserConfirmation<TUserConfirmation>() where TUserConfirmation : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because UserType is a reference type.")]
+        public virtual IdentityBuilder AddUserConfirmation<TUserConfirmation>() where TUserConfirmation : class;
-        public virtual IdentityBuilder AddUserManager<TUserManager>() where TUserManager : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because UserType is a reference type.")]
+        public virtual IdentityBuilder AddUserManager<TUserManager>() where TUserManager : class;
-        public virtual IdentityBuilder AddUserStore<TStore>() where TStore : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because UserType is a reference type.")]
+        public virtual IdentityBuilder AddUserStore<TStore>() where TStore : class;
-        public virtual IdentityBuilder AddUserValidator<TValidator>() where TValidator : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because UserType is a reference type.")]
+        public virtual IdentityBuilder AddUserValidator<TValidator>() where TValidator : class;
     }
     public static class IdentityBuilderExtensions {
-        public static IdentityBuilder AddDefaultTokenProviders(this IdentityBuilder builder);
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because user type is a reference type.")]
+        public static IdentityBuilder AddDefaultTokenProviders(this IdentityBuilder builder);
-        public static IdentityBuilder AddSignInManager(this IdentityBuilder builder);
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because user type is a reference type.")]
+        public static IdentityBuilder AddSignInManager(this IdentityBuilder builder);
-        public static IdentityBuilder AddSignInManager<TSignInManager>(this IdentityBuilder builder) where TSignInManager : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because user type is a reference type.")]
+        public static IdentityBuilder AddSignInManager<TSignInManager>(this IdentityBuilder builder) where TSignInManager : class;
     }
     public class SignInManager<TUser> where TUser : class {
-        public virtual AuthenticationProperties ConfigureExternalAuthenticationProperties(string? provider, string? redirectUrl, string? userId = null);
+        public virtual AuthenticationProperties ConfigureExternalAuthenticationProperties(string? provider, [StringSyntaxAttribute("Uri")] string? redirectUrl, string? userId = null);
+        public virtual Task<bool> IsTwoFactorEnabledAsync(TUser user);
     }
 }
```

