# Microsoft.AspNetCore.Mvc.Razor.TagHelpers

``` diff
 namespace Microsoft.AspNetCore.Mvc.Razor.TagHelpers {
     [HtmlTargetElementAttribute("*", Attributes="[itemid^='~/']")]
     [HtmlTargetElementAttribute("a", Attributes="[href^='~/']")]
     [HtmlTargetElementAttribute("applet", Attributes="[archive^='~/']")]
     [HtmlTargetElementAttribute("area", Attributes="[href^='~/']", TagStructure=TagStructure.WithoutEndTag)]
     [HtmlTargetElementAttribute("audio", Attributes="[src^='~/']")]
     [HtmlTargetElementAttribute("base", Attributes="[href^='~/']", TagStructure=TagStructure.WithoutEndTag)]
     [HtmlTargetElementAttribute("blockquote", Attributes="[cite^='~/']")]
     [HtmlTargetElementAttribute("button", Attributes="[formaction^='~/']")]
     [HtmlTargetElementAttribute("del", Attributes="[cite^='~/']")]
     [HtmlTargetElementAttribute("embed", Attributes="[src^='~/']", TagStructure=TagStructure.WithoutEndTag)]
     [HtmlTargetElementAttribute("form", Attributes="[action^='~/']")]
     [HtmlTargetElementAttribute("html", Attributes="[manifest^='~/']")]
     [HtmlTargetElementAttribute("iframe", Attributes="[src^='~/']")]
     [HtmlTargetElementAttribute("img", Attributes="[src^='~/']", TagStructure=TagStructure.WithoutEndTag)]
     [HtmlTargetElementAttribute("img", Attributes="[srcset^='~/']", TagStructure=TagStructure.WithoutEndTag)]
     [HtmlTargetElementAttribute("input", Attributes="[formaction^='~/']", TagStructure=TagStructure.WithoutEndTag)]
     [HtmlTargetElementAttribute("input", Attributes="[src^='~/']", TagStructure=TagStructure.WithoutEndTag)]
     [HtmlTargetElementAttribute("ins", Attributes="[cite^='~/']")]
     [HtmlTargetElementAttribute("link", Attributes="[href^='~/']", TagStructure=TagStructure.WithoutEndTag)]
     [HtmlTargetElementAttribute("menuitem", Attributes="[icon^='~/']")]
     [HtmlTargetElementAttribute("object", Attributes="[archive^='~/']")]
     [HtmlTargetElementAttribute("object", Attributes="[data^='~/']")]
     [HtmlTargetElementAttribute("q", Attributes="[cite^='~/']")]
     [HtmlTargetElementAttribute("script", Attributes="[src^='~/']")]
     [HtmlTargetElementAttribute("source", Attributes="[src^='~/']", TagStructure=TagStructure.WithoutEndTag)]
     [HtmlTargetElementAttribute("source", Attributes="[srcset^='~/']", TagStructure=TagStructure.WithoutEndTag)]
     [HtmlTargetElementAttribute("track", Attributes="[src^='~/']", TagStructure=TagStructure.WithoutEndTag)]
     [HtmlTargetElementAttribute("video", Attributes="[poster^='~/']")]
     [HtmlTargetElementAttribute("video", Attributes="[src^='~/']")]
     public class UrlResolutionTagHelper : TagHelper {
-        protected bool TryResolveUrl(string url, [NotNullWhenAttribute(true)] out IHtmlContent? resolvedUrl);
+        protected bool TryResolveUrl([StringSyntaxAttribute("Uri", new object[]{ 2})] string url, [NotNullWhenAttribute(true)] out IHtmlContent? resolvedUrl);
-        protected bool TryResolveUrl(string url, out string? resolvedUrl);
+        protected bool TryResolveUrl([StringSyntaxAttribute("Uri", new object[]{ 2})] string url, out string? resolvedUrl);
     }
 }
```

