# Microsoft.AspNetCore.Mvc

``` diff
 namespace Microsoft.AspNetCore.Mvc {
     [ControllerAttribute]
     public abstract class ControllerBase {
+        [NonActionAttribute]
+        public virtual CreatedResult Created();
-        [NonActionAttribute]
-        public virtual CreatedResult Created(string uri, [ActionResultObjectValueAttribute] object? value);
+        [NonActionAttribute]
+        public virtual CreatedResult Created(string? uri, [ActionResultObjectValueAttribute] object? value);
-        [NonActionAttribute]
-        public virtual CreatedResult Created(Uri uri, [ActionResultObjectValueAttribute] object? value);
+        [NonActionAttribute]
+        public virtual CreatedResult Created(Uri? uri, [ActionResultObjectValueAttribute] object? value);
-        [NonActionAttribute]
-        public virtual LocalRedirectResult LocalRedirect(string localUrl);
+        [NonActionAttribute]
+        public virtual LocalRedirectResult LocalRedirect([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl);
-        [NonActionAttribute]
-        public virtual LocalRedirectResult LocalRedirectPermanent(string localUrl);
+        [NonActionAttribute]
+        public virtual LocalRedirectResult LocalRedirectPermanent([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl);
-        [NonActionAttribute]
-        public virtual LocalRedirectResult LocalRedirectPermanentPreserveMethod(string localUrl);
+        [NonActionAttribute]
+        public virtual LocalRedirectResult LocalRedirectPermanentPreserveMethod([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl);
-        [NonActionAttribute]
-        public virtual LocalRedirectResult LocalRedirectPreserveMethod(string localUrl);
+        [NonActionAttribute]
+        public virtual LocalRedirectResult LocalRedirectPreserveMethod([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl);
-        [NonActionAttribute]
-        public virtual RedirectResult Redirect(string url);
+        [NonActionAttribute]
+        public virtual RedirectResult Redirect([StringSyntaxAttribute("Uri")] string url);
-        [NonActionAttribute]
-        public virtual RedirectResult RedirectPermanent(string url);
+        [NonActionAttribute]
+        public virtual RedirectResult RedirectPermanent([StringSyntaxAttribute("Uri")] string url);
-        [NonActionAttribute]
-        public virtual RedirectResult RedirectPermanentPreserveMethod(string url);
+        [NonActionAttribute]
+        public virtual RedirectResult RedirectPermanentPreserveMethod([StringSyntaxAttribute("Uri")] string url);
-        [NonActionAttribute]
-        public virtual RedirectResult RedirectPreserveMethod(string url);
+        [NonActionAttribute]
+        public virtual RedirectResult RedirectPreserveMethod([StringSyntaxAttribute("Uri")] string url);
     }
     [DefaultStatusCodeAttribute(201)]
     public class CreatedResult : ObjectResult {
+        public CreatedResult();
-        public CreatedResult(string location, object? value);
+        public CreatedResult(string location, object value);
-        public CreatedResult(Uri location, object? value);
+        public CreatedResult(Uri location, object value);
-        public string Location { get; [MemberNotNullAttribute("_location")] set; }
+        public string Location { get; set; }
     }
     public interface IUrlHelper {
-        bool IsLocalUrl([NotNullWhenAttribute(true)] string? url);
+        bool IsLocalUrl([NotNullWhenAttribute(true), StringSyntaxAttribute("Uri")] string? url);
     }
     public class LocalRedirectResult : ActionResult {
-        public LocalRedirectResult(string localUrl);
+        public LocalRedirectResult([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl);
-        public LocalRedirectResult(string localUrl, bool permanent);
+        public LocalRedirectResult([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl, bool permanent);
-        public LocalRedirectResult(string localUrl, bool permanent, bool preserveMethod);
+        public LocalRedirectResult([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl, bool permanent, bool preserveMethod);
     }
     public class RedirectResult : ActionResult, IActionResult, IKeepTempDataResult {
-        public RedirectResult(string url);
+        public RedirectResult([StringSyntaxAttribute("Uri")] string url);
-        public RedirectResult(string url, bool permanent);
+        public RedirectResult([StringSyntaxAttribute("Uri")] string url, bool permanent);
-        public RedirectResult(string url, bool permanent, bool preserveMethod);
+        public RedirectResult([StringSyntaxAttribute("Uri")] string url, bool permanent, bool preserveMethod);
     }
 }
```

