# Microsoft.AspNetCore.Routing

``` diff
 namespace Microsoft.AspNetCore.Routing {
     public static class ControllerLinkGeneratorExtensions {
-        public static string GetPathByAction(this LinkGenerator generator, HttpContext httpContext, string action = null, string controller = null, object values = null, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        public static string? GetPathByAction(this LinkGenerator generator, HttpContext httpContext, string? action = null, string? controller = null, object? values = null, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
-        public static string GetUriByAction(this LinkGenerator generator, HttpContext httpContext, string action = null, string controller = null, object values = null, string scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        public static string? GetUriByAction(this LinkGenerator generator, HttpContext httpContext, string? action = null, string? controller = null, object? values = null, string? scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
-        public static string GetUriByAction(this LinkGenerator generator, string action, string controller, object values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        public static string? GetUriByAction(this LinkGenerator generator, string action, string controller, object? values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
     }
     public abstract class LinkGenerator {
-        public abstract string GetUriByAddress<TAddress>(TAddress address, RouteValueDictionary values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        public abstract string? GetUriByAddress<TAddress>(TAddress address, RouteValueDictionary values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
     }
     public static class LinkGeneratorEndpointNameAddressExtensions {
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static string? GetPathByName(this LinkGenerator generator, HttpContext httpContext, string endpointName, object? values, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static string? GetPathByName(this LinkGenerator generator, HttpContext httpContext, string endpointName, object? values, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static string? GetPathByName(this LinkGenerator generator, string endpointName, object? values, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static string? GetPathByName(this LinkGenerator generator, string endpointName, object? values, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static string? GetUriByName(this LinkGenerator generator, HttpContext httpContext, string endpointName, object? values, string? scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static string? GetUriByName(this LinkGenerator generator, HttpContext httpContext, string endpointName, object? values, string? scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static string? GetUriByName(this LinkGenerator generator, string endpointName, object? values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static string? GetUriByName(this LinkGenerator generator, string endpointName, object? values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
     }
     public static class LinkGeneratorRouteValuesAddressExtensions {
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static string GetPathByRouteValues(this LinkGenerator generator, HttpContext httpContext, string routeName, object values, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static string GetPathByRouteValues(this LinkGenerator generator, HttpContext httpContext, string routeName, object values, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static string GetPathByRouteValues(this LinkGenerator generator, string routeName, object values, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static string GetPathByRouteValues(this LinkGenerator generator, string routeName, object values, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static string GetUriByRouteValues(this LinkGenerator generator, HttpContext httpContext, string routeName, object values, string scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static string GetUriByRouteValues(this LinkGenerator generator, HttpContext httpContext, string routeName, object values, string scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static string GetUriByRouteValues(this LinkGenerator generator, string routeName, object values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static string GetUriByRouteValues(this LinkGenerator generator, string routeName, object values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
     }
+    [EditorBrowsableAttribute(1)]
+    public static class RouteHandlerServices {
+        public static RouteHandlerBuilder Map(IEndpointRouteBuilder endpoints, string pattern, Delegate handler, IEnumerable<string> httpMethods, Func<MethodInfo, RequestDelegateFactoryOptions?, RequestDelegateMetadataResult> populateMetadata, Func<Delegate, RequestDelegateFactoryOptions, RequestDelegateMetadataResult?, RequestDelegateResult> createRequestDelegate);
+    }
 }
```

