# System.Collections.Frozen

``` diff
+namespace System.Collections.Frozen {
+    public static class FrozenDictionary {
+        public static FrozenDictionary<TKey, TValue> ToFrozenDictionary<TKey, TValue>(this IEnumerable<KeyValuePair<TKey, TValue>> source, bool optimizeForReading);
+        public static FrozenDictionary<TKey, TValue> ToFrozenDictionary<TKey, TValue>(this IEnumerable<KeyValuePair<TKey, TValue>> source, IEqualityComparer<TKey>? comparer = null);
+        public static FrozenDictionary<TKey, TValue> ToFrozenDictionary<TKey, TValue>(this IEnumerable<KeyValuePair<TKey, TValue>> source, IEqualityComparer<TKey>? comparer, bool optimizeForReading);
+        public static FrozenDictionary<TKey, TElement> ToFrozenDictionary<TSource, TKey, TElement>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey>? comparer = null);
+        public static FrozenDictionary<TKey, TSource> ToFrozenDictionary<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey>? comparer = null);
+    }
+    public abstract class FrozenDictionary<TKey, TValue> : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue> {
+        public IEqualityComparer<TKey> Comparer { get; }
+        public int Count { get; }
+        public static FrozenDictionary<TKey, TValue> Empty { get; }
+        public ImmutableArray<TKey> Keys { get; }
+        bool ICollection<KeyValuePair<TKey, TValue>>.IsReadOnly { get; }
+        TValue IDictionary<TKey, TValue>.this[TKey key] { get; set; }
+        ICollection<TKey> IDictionary<TKey, TValue>.Keys { get; }
+        ICollection<TValue> IDictionary<TKey, TValue>.Values { get; }
+        TValue IReadOnlyDictionary<TKey, TValue>.this[TKey key] { get; }
+        IEnumerable<TKey> IReadOnlyDictionary<TKey, TValue>.Keys { get; }
+        IEnumerable<TValue> IReadOnlyDictionary<TKey, TValue>.Values { get; }
+        bool ICollection.IsSynchronized { get; }
+        object ICollection.SyncRoot { get; }
+        bool IDictionary.IsFixedSize { get; }
+        bool IDictionary.IsReadOnly { get; }
+        object? IDictionary.this[object key] { get; set; }
+        ICollection IDictionary.Keys { get; }
+        ICollection IDictionary.Values { get; }
+        public ref readonly TValue this[TKey key] { get; }
+        public ImmutableArray<TValue> Values { get; }
+        public bool ContainsKey(TKey key);
+        public void CopyTo(KeyValuePair<TKey, TValue>[] destination, int destinationIndex);
+        public void CopyTo(Span<KeyValuePair<TKey, TValue>> destination);
+        public FrozenDictionary<TKey, TValue>.Enumerator GetEnumerator();
+        public ref readonly TValue GetValueRefOrNullRef(TKey key);
+        void ICollection<KeyValuePair<TKey, TValue>>.Add(KeyValuePair<TKey, TValue> item);
+        void ICollection<KeyValuePair<TKey, TValue>>.Clear();
+        bool ICollection<KeyValuePair<TKey, TValue>>.Contains(KeyValuePair<TKey, TValue> item);
+        bool ICollection<KeyValuePair<TKey, TValue>>.Remove(KeyValuePair<TKey, TValue> item);
+        void IDictionary<TKey, TValue>.Add(TKey key, TValue value);
+        bool IDictionary<TKey, TValue>.Remove(TKey key);
+        IEnumerator<KeyValuePair<TKey, TValue>> IEnumerable<KeyValuePair<TKey, TValue>>.GetEnumerator();
+        void ICollection.CopyTo(Array array, int index);
+        void IDictionary.Add(object key, object value);
+        void IDictionary.Clear();
+        bool IDictionary.Contains(object key);
+        IDictionaryEnumerator IDictionary.GetEnumerator();
+        void IDictionary.Remove(object key);
+        IEnumerator IEnumerable.GetEnumerator();
+        public bool TryGetValue(TKey key, [MaybeNullWhenAttribute(false)] out TValue value);
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<KeyValuePair<TKey, TValue>> {
+            public KeyValuePair<TKey, TValue> Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void IEnumerator.Reset();
+            void IDisposable.Dispose();
+        }
+    }
+    public static class FrozenSet {
+        public static FrozenSet<T> ToFrozenSet<T>(this IEnumerable<T> source, bool optimizeForReading);
+        public static FrozenSet<T> ToFrozenSet<T>(this IEnumerable<T> source, IEqualityComparer<T>? comparer = null);
+        public static FrozenSet<T> ToFrozenSet<T>(this IEnumerable<T> source, IEqualityComparer<T>? comparer, bool optimizeForReading);
+    }
+    public abstract class FrozenSet<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, IReadOnlySet<T>, ISet<T> {
+        public IEqualityComparer<T> Comparer { get; }
+        public int Count { get; }
+        public static FrozenSet<T> Empty { get; }
+        public ImmutableArray<T> Items { get; }
+        bool ICollection<T>.IsReadOnly { get; }
+        bool ICollection.IsSynchronized { get; }
+        object ICollection.SyncRoot { get; }
+        public bool Contains(T item);
+        public void CopyTo(Span<T> destination);
+        public void CopyTo(T[] destination, int destinationIndex);
+        public FrozenSet<T>.Enumerator GetEnumerator();
+        public bool IsProperSubsetOf(IEnumerable<T> other);
+        public bool IsProperSupersetOf(IEnumerable<T> other);
+        public bool IsSubsetOf(IEnumerable<T> other);
+        public bool IsSupersetOf(IEnumerable<T> other);
+        public bool Overlaps(IEnumerable<T> other);
+        public bool SetEquals(IEnumerable<T> other);
+        void ICollection<T>.Add(T item);
+        void ICollection<T>.Clear();
+        bool ICollection<T>.Remove(T item);
+        IEnumerator<T> IEnumerable<T>.GetEnumerator();
+        bool ISet<T>.Add(T item);
+        void ISet<T>.ExceptWith(IEnumerable<T> other);
+        void ISet<T>.IntersectWith(IEnumerable<T> other);
+        void ISet<T>.SymmetricExceptWith(IEnumerable<T> other);
+        void ISet<T>.UnionWith(IEnumerable<T> other);
+        void ICollection.CopyTo(Array array, int index);
+        IEnumerator IEnumerable.GetEnumerator();
+        public bool TryGetValue(T equalValue, [MaybeNullWhenAttribute(false)] out T actualValue);
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<T> {
+            public T Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public bool MoveNext();
+            void IEnumerator.Reset();
+            void IDisposable.Dispose();
+        }
+    }
+}
```

