# System.Collections.Generic

``` diff
 namespace System.Collections.Generic {
     public static class CollectionExtensions {
+        public static void AddRange<T>(this List<T> list, ReadOnlySpan<T> source);
+        public static void CopyTo<T>(this List<T> list, Span<T> destination);
+        public static void InsertRange<T>(this List<T> list, int index, ReadOnlySpan<T> source);
     }
     public class Dictionary<TKey, TValue> : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDeserializationCallback, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue>, ISerializable {
         public sealed class KeyCollection : ICollection, ICollection<TKey>, IEnumerable, IEnumerable<TKey>, IReadOnlyCollection<TKey> {
+            public bool Contains(TKey item);
-            bool ICollection<TKey>.Contains(TKey item);
         }
     }
     public abstract class EqualityComparer<T> : IEqualityComparer, IEqualityComparer<T> {
+        public static EqualityComparer<T> Create(Func<T?, T?, bool> equals, Func<T, int>? getHashCode = null);
     }
     public class List<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
+        public List<T> Slice(int start, int length);
     }
     public class PriorityQueue<TElement, TPriority> {
+        public TElement DequeueEnqueue(TElement element, TPriority priority);
     }
     public class SortedDictionary<TKey, TValue> : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue> {
         public sealed class KeyCollection : ICollection, ICollection<TKey>, IEnumerable, IEnumerable<TKey>, IReadOnlyCollection<TKey> {
+            public bool Contains(TKey item);
-            bool ICollection<TKey>.Contains(TKey item);
         }
     }
 }
```

