# System.Numerics

``` diff
 namespace System.Numerics {
     public static class BitOperations {
+        [CLSCompliantAttribute(false)]
+        public static uint Crc32C(uint crc, byte data);
+        [CLSCompliantAttribute(false)]
+        public static uint Crc32C(uint crc, ushort data);
+        [CLSCompliantAttribute(false)]
+        public static uint Crc32C(uint crc, uint data);
+        [CLSCompliantAttribute(false)]
+        public static uint Crc32C(uint crc, ulong data);
     }
     public interface IFloatingPointIeee754<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IExponentialFunctions<TSelf>, IFloatingPoint<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IHyperbolicFunctions<TSelf>, IIncrementOperators<TSelf>, ILogarithmicFunctions<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, IPowerFunctions<TSelf>, IRootFunctions<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, ITrigonometricFunctions<TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IFloatingPointIeee754<TSelf>? {
+        static TSelf Lerp(TSelf value1, TSelf value2, TSelf amount);
     }
+    public readonly struct TotalOrderIeee754Comparer<T> : IComparer<T>, IEqualityComparer<T>, IEquatable<TotalOrderIeee754Comparer<T>> where T : IFloatingPointIeee754<T>? {
+        public int Compare(T x, T y);
+        public bool Equals(TotalOrderIeee754Comparer<T> other);
+        public override bool Equals([NotNullWhenAttribute(true)] object obj);
+        public bool Equals(T x, T y);
+        public override int GetHashCode();
+        public int GetHashCode([DisallowNullAttribute] T obj);
+    }
     public static class Vector {
+        public static Vector<T> Divide<T>(Vector<T> left, T right) where T : struct;
+        public static T GetElement<T>(this Vector<T> vector, int index) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector<T> Load<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector<T> LoadAligned<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector<T> LoadAlignedNonTemporal<T>(T* source) where T : struct;
+        public static Vector<T> LoadUnsafe<T>(ref T source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector<T> LoadUnsafe<T>(ref T source, UIntPtr elementOffset) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Store<T>(this Vector<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAligned<T>(this Vector<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAlignedNonTemporal<T>(this Vector<T> source, T* destination) where T : struct;
+        public static void StoreUnsafe<T>(this Vector<T> source, ref T destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static void StoreUnsafe<T>(this Vector<T> source, ref T destination, UIntPtr elementOffset) where T : struct;
+        public static T ToScalar<T>(this Vector<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector<ushort> WidenLower(Vector<byte> source);
+        public static Vector<int> WidenLower(Vector<short> source);
+        public static Vector<long> WidenLower(Vector<int> source);
+        [CLSCompliantAttribute(false)]
+        public static Vector<short> WidenLower(Vector<sbyte> source);
+        public static Vector<double> WidenLower(Vector<float> source);
+        [CLSCompliantAttribute(false)]
+        public static Vector<uint> WidenLower(Vector<ushort> source);
+        [CLSCompliantAttribute(false)]
+        public static Vector<ulong> WidenLower(Vector<uint> source);
+        [CLSCompliantAttribute(false)]
+        public static Vector<ushort> WidenUpper(Vector<byte> source);
+        public static Vector<int> WidenUpper(Vector<short> source);
+        public static Vector<long> WidenUpper(Vector<int> source);
+        [CLSCompliantAttribute(false)]
+        public static Vector<short> WidenUpper(Vector<sbyte> source);
+        public static Vector<double> WidenUpper(Vector<float> source);
+        [CLSCompliantAttribute(false)]
+        public static Vector<uint> WidenUpper(Vector<ushort> source);
+        [CLSCompliantAttribute(false)]
+        public static Vector<ulong> WidenUpper(Vector<uint> source);
+        public static Vector<T> WithElement<T>(this Vector<T> vector, int index, T value) where T : struct;
     }
     public readonly struct Vector<T> : IEquatable<Vector<T>>, IFormattable where T : struct {
+        public static Vector<T> AllBitsSet { get; }
+        public static Vector<T> operator /(Vector<T> left, T right);
+        public static Vector<T> operator <<(Vector<T> value, int shiftCount);
+        public static Vector<T> operator >>(Vector<T> value, int shiftCount);
+        public static Vector<T> operator +(Vector<T> value);
+        public static Vector<T> operator >>>(Vector<T> value, int shiftCount);
     }
 }
```

