# System.Runtime.Intrinsics.Wasm

``` diff
+namespace System.Runtime.Intrinsics.Wasm {
+    [CLSCompliantAttribute(false)]
+    public abstract class PackedSimd {
+        protected PackedSimd();
+        public static bool IsSupported { get; }
+        public static Vector128<byte> Add(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<short> Add(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> Add(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> Add(Vector128<long> left, Vector128<long> right);
+        public static Vector128<IntPtr> Add(Vector128<IntPtr> left, Vector128<IntPtr> right);
+        public static Vector128<sbyte> Add(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> Add(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Add(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> Add(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<UIntPtr> Add(Vector128<UIntPtr> left, Vector128<UIntPtr> right);
+        public static Vector128<byte> And(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> And(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> And(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> And(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> And(Vector128<long> left, Vector128<long> right);
+        public static Vector128<IntPtr> And(Vector128<IntPtr> left, Vector128<IntPtr> right);
+        public static Vector128<sbyte> And(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<float> And(Vector128<float> left, Vector128<float> right);
+        public static Vector128<ushort> And(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> And(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> And(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<UIntPtr> And(Vector128<UIntPtr> left, Vector128<UIntPtr> right);
+        public static int Bitmask(Vector128<byte> value);
+        public static int Bitmask(Vector128<short> value);
+        public static int Bitmask(Vector128<int> value);
+        public static int Bitmask(Vector128<long> value);
+        public static int Bitmask(Vector128<IntPtr> value);
+        public static int Bitmask(Vector128<sbyte> value);
+        public static int Bitmask(Vector128<ushort> value);
+        public static int Bitmask(Vector128<uint> value);
+        public static int Bitmask(Vector128<ulong> value);
+        public static int Bitmask(Vector128<UIntPtr> value);
+        public static Vector128<byte> CompareEqual(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> CompareEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> CompareEqual(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> CompareEqual(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> CompareEqual(Vector128<long> left, Vector128<long> right);
+        public static Vector128<IntPtr> CompareEqual(Vector128<IntPtr> left, Vector128<IntPtr> right);
+        public static Vector128<sbyte> CompareEqual(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<float> CompareEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<ushort> CompareEqual(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> CompareEqual(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> CompareEqual(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<UIntPtr> CompareEqual(Vector128<UIntPtr> left, Vector128<UIntPtr> right);
+        public static Vector128<byte> CompareNotEqual(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> CompareNotEqual(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> CompareNotEqual(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> CompareNotEqual(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> CompareNotEqual(Vector128<long> left, Vector128<long> right);
+        public static Vector128<IntPtr> CompareNotEqual(Vector128<IntPtr> left, Vector128<IntPtr> right);
+        public static Vector128<sbyte> CompareNotEqual(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<float> CompareNotEqual(Vector128<float> left, Vector128<float> right);
+        public static Vector128<ushort> CompareNotEqual(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> CompareNotEqual(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> CompareNotEqual(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<UIntPtr> CompareNotEqual(Vector128<UIntPtr> left, Vector128<UIntPtr> right);
+        public static Vector128<int> Dot(Vector128<short> left, Vector128<short> right);
+        public static uint ExtractLane(Vector128<byte> value, [ConstantExpectedAttribute(Max=(byte)15)] byte index);
+        public static double ExtractLane(Vector128<double> value, [ConstantExpectedAttribute(Max=(byte)1)] byte index);
+        public static int ExtractLane(Vector128<short> value, [ConstantExpectedAttribute(Max=(byte)7)] byte index);
+        public static int ExtractLane(Vector128<int> value, [ConstantExpectedAttribute(Max=(byte)3)] byte index);
+        public static long ExtractLane(Vector128<long> value, [ConstantExpectedAttribute(Max=(byte)1)] byte index);
+        public static IntPtr ExtractLane(Vector128<IntPtr> value, [ConstantExpectedAttribute(Max=(byte)3)] byte index);
+        public static int ExtractLane(Vector128<sbyte> value, [ConstantExpectedAttribute(Max=(byte)15)] byte index);
+        public static float ExtractLane(Vector128<float> value, [ConstantExpectedAttribute(Max=(byte)3)] byte index);
+        public static uint ExtractLane(Vector128<ushort> value, [ConstantExpectedAttribute(Max=(byte)7)] byte index);
+        public static uint ExtractLane(Vector128<uint> value, [ConstantExpectedAttribute(Max=(byte)3)] byte index);
+        public static ulong ExtractLane(Vector128<ulong> value, [ConstantExpectedAttribute(Max=(byte)1)] byte index);
+        public static UIntPtr ExtractLane(Vector128<UIntPtr> value, [ConstantExpectedAttribute(Max=(byte)3)] byte index);
+        public static Vector128<short> Multiply(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> Multiply(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> Multiply(Vector128<long> left, Vector128<long> right);
+        public static Vector128<IntPtr> Multiply(Vector128<IntPtr> left, Vector128<IntPtr> right);
+        public static Vector128<ushort> Multiply(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Multiply(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> Multiply(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<UIntPtr> Multiply(Vector128<UIntPtr> left, Vector128<UIntPtr> right);
+        public static Vector128<byte> Negate(Vector128<byte> value);
+        public static Vector128<short> Negate(Vector128<short> value);
+        public static Vector128<int> Negate(Vector128<int> value);
+        public static Vector128<long> Negate(Vector128<long> value);
+        public static Vector128<IntPtr> Negate(Vector128<IntPtr> value);
+        public static Vector128<sbyte> Negate(Vector128<sbyte> value);
+        public static Vector128<ushort> Negate(Vector128<ushort> value);
+        public static Vector128<uint> Negate(Vector128<uint> value);
+        public static Vector128<ulong> Negate(Vector128<ulong> value);
+        public static Vector128<UIntPtr> Negate(Vector128<UIntPtr> value);
+        public static Vector128<byte> ReplaceLane(Vector128<byte> vector, [ConstantExpectedAttribute(Max=(byte)15)] byte imm, uint value);
+        public static Vector128<double> ReplaceLane(Vector128<double> vector, [ConstantExpectedAttribute(Max=(byte)1)] byte imm, double value);
+        public static Vector128<short> ReplaceLane(Vector128<short> vector, [ConstantExpectedAttribute(Max=(byte)7)] byte imm, int value);
+        public static Vector128<int> ReplaceLane(Vector128<int> vector, [ConstantExpectedAttribute(Max=(byte)3)] byte imm, int value);
+        public static Vector128<long> ReplaceLane(Vector128<long> vector, [ConstantExpectedAttribute(Max=(byte)1)] byte imm, long value);
+        public static Vector128<IntPtr> ReplaceLane(Vector128<IntPtr> vector, [ConstantExpectedAttribute(Max=(byte)3)] byte imm, IntPtr value);
+        public static Vector128<sbyte> ReplaceLane(Vector128<sbyte> vector, [ConstantExpectedAttribute(Max=(byte)15)] byte imm, int value);
+        public static Vector128<float> ReplaceLane(Vector128<float> vector, [ConstantExpectedAttribute(Max=(byte)3)] byte imm, float value);
+        public static Vector128<ushort> ReplaceLane(Vector128<ushort> vector, [ConstantExpectedAttribute(Max=(byte)7)] byte imm, uint value);
+        public static Vector128<int> ReplaceLane(Vector128<uint> vector, [ConstantExpectedAttribute(Max=(byte)3)] byte imm, uint value);
+        public static Vector128<ulong> ReplaceLane(Vector128<ulong> vector, [ConstantExpectedAttribute(Max=(byte)1)] byte imm, ulong value);
+        public static Vector128<UIntPtr> ReplaceLane(Vector128<UIntPtr> vector, [ConstantExpectedAttribute(Max=(byte)3)] byte imm, UIntPtr value);
+        public static Vector128<byte> Shuffle(Vector128<byte> lower, Vector128<byte> upper, Vector128<byte> indices);
+        public static Vector128<sbyte> Shuffle(Vector128<sbyte> lower, Vector128<sbyte> upper, Vector128<sbyte> indices);
+        public static Vector128<byte> Splat(byte value);
+        public static Vector128<double> Splat(double value);
+        public static Vector128<short> Splat(short value);
+        public static Vector128<int> Splat(int value);
+        public static Vector128<long> Splat(long value);
+        public static Vector128<IntPtr> Splat(IntPtr value);
+        public static Vector128<sbyte> Splat(sbyte value);
+        public static Vector128<float> Splat(float value);
+        public static Vector128<ushort> Splat(ushort value);
+        public static Vector128<uint> Splat(uint value);
+        public static Vector128<ulong> Splat(ulong value);
+        public static Vector128<UIntPtr> Splat(UIntPtr value);
+        public static Vector128<byte> Subtract(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<short> Subtract(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> Subtract(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> Subtract(Vector128<long> left, Vector128<long> right);
+        public static Vector128<IntPtr> Subtract(Vector128<IntPtr> left, Vector128<IntPtr> right);
+        public static Vector128<sbyte> Subtract(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> Subtract(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Subtract(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> Subtract(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<UIntPtr> Subtract(Vector128<UIntPtr> left, Vector128<UIntPtr> right);
+        public static Vector128<byte> Swizzle(Vector128<byte> vector, Vector128<byte> indices);
+        public static Vector128<sbyte> Swizzle(Vector128<sbyte> vector, Vector128<sbyte> indices);
+    }
+}
```

