# System.Runtime.Intrinsics.X86

``` diff
 namespace System.Runtime.Intrinsics.X86 {
     [CLSCompliantAttribute(false)]
     public abstract class Aes : Sse2 {
-        public static Vector128<byte> KeygenAssist(Vector128<byte> value, byte control);
+        public static Vector128<byte> KeygenAssist(Vector128<byte> value, [ConstantExpectedAttribute] byte control);
     }
     [CLSCompliantAttribute(false)]
     public abstract class Avx : Sse42 {
-        public static Vector256<double> Blend(Vector256<double> left, Vector256<double> right, byte control);
+        public static Vector256<double> Blend(Vector256<double> left, Vector256<double> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<float> Blend(Vector256<float> left, Vector256<float> right, byte control);
+        public static Vector256<float> Blend(Vector256<float> left, Vector256<float> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<double> Compare(Vector128<double> left, Vector128<double> right, FloatComparisonMode mode);
+        public static Vector128<double> Compare(Vector128<double> left, Vector128<double> right, [ConstantExpectedAttribute(Max=FloatComparisonMode.UnorderedTrueSignaling)] FloatComparisonMode mode);
-        public static Vector128<float> Compare(Vector128<float> left, Vector128<float> right, FloatComparisonMode mode);
+        public static Vector128<float> Compare(Vector128<float> left, Vector128<float> right, [ConstantExpectedAttribute(Max=FloatComparisonMode.UnorderedTrueSignaling)] FloatComparisonMode mode);
-        public static Vector256<double> Compare(Vector256<double> left, Vector256<double> right, FloatComparisonMode mode);
+        public static Vector256<double> Compare(Vector256<double> left, Vector256<double> right, [ConstantExpectedAttribute(Max=FloatComparisonMode.UnorderedTrueSignaling)] FloatComparisonMode mode);
-        public static Vector256<float> Compare(Vector256<float> left, Vector256<float> right, FloatComparisonMode mode);
+        public static Vector256<float> Compare(Vector256<float> left, Vector256<float> right, [ConstantExpectedAttribute(Max=FloatComparisonMode.UnorderedTrueSignaling)] FloatComparisonMode mode);
-        public static Vector128<double> CompareScalar(Vector128<double> left, Vector128<double> right, FloatComparisonMode mode);
+        public static Vector128<double> CompareScalar(Vector128<double> left, Vector128<double> right, [ConstantExpectedAttribute(Max=FloatComparisonMode.UnorderedTrueSignaling)] FloatComparisonMode mode);
-        public static Vector128<float> CompareScalar(Vector128<float> left, Vector128<float> right, FloatComparisonMode mode);
+        public static Vector128<float> CompareScalar(Vector128<float> left, Vector128<float> right, [ConstantExpectedAttribute(Max=FloatComparisonMode.UnorderedTrueSignaling)] FloatComparisonMode mode);
-        public static Vector256<float> DotProduct(Vector256<float> left, Vector256<float> right, byte control);
+        public static Vector256<float> DotProduct(Vector256<float> left, Vector256<float> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<byte> ExtractVector128(Vector256<byte> value, byte index);
+        public static Vector128<byte> ExtractVector128(Vector256<byte> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<double> ExtractVector128(Vector256<double> value, byte index);
+        public static Vector128<double> ExtractVector128(Vector256<double> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<short> ExtractVector128(Vector256<short> value, byte index);
+        public static Vector128<short> ExtractVector128(Vector256<short> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<int> ExtractVector128(Vector256<int> value, byte index);
+        public static Vector128<int> ExtractVector128(Vector256<int> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<long> ExtractVector128(Vector256<long> value, byte index);
+        public static Vector128<long> ExtractVector128(Vector256<long> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<sbyte> ExtractVector128(Vector256<sbyte> value, byte index);
+        public static Vector128<sbyte> ExtractVector128(Vector256<sbyte> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<float> ExtractVector128(Vector256<float> value, byte index);
+        public static Vector128<float> ExtractVector128(Vector256<float> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<ushort> ExtractVector128(Vector256<ushort> value, byte index);
+        public static Vector128<ushort> ExtractVector128(Vector256<ushort> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<uint> ExtractVector128(Vector256<uint> value, byte index);
+        public static Vector128<uint> ExtractVector128(Vector256<uint> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<ulong> ExtractVector128(Vector256<ulong> value, byte index);
+        public static Vector128<ulong> ExtractVector128(Vector256<ulong> value, [ConstantExpectedAttribute] byte index);
-        public static Vector256<byte> InsertVector128(Vector256<byte> value, Vector128<byte> data, byte index);
+        public static Vector256<byte> InsertVector128(Vector256<byte> value, Vector128<byte> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<double> InsertVector128(Vector256<double> value, Vector128<double> data, byte index);
+        public static Vector256<double> InsertVector128(Vector256<double> value, Vector128<double> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<short> InsertVector128(Vector256<short> value, Vector128<short> data, byte index);
+        public static Vector256<short> InsertVector128(Vector256<short> value, Vector128<short> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<int> InsertVector128(Vector256<int> value, Vector128<int> data, byte index);
+        public static Vector256<int> InsertVector128(Vector256<int> value, Vector128<int> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<long> InsertVector128(Vector256<long> value, Vector128<long> data, byte index);
+        public static Vector256<long> InsertVector128(Vector256<long> value, Vector128<long> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<sbyte> InsertVector128(Vector256<sbyte> value, Vector128<sbyte> data, byte index);
+        public static Vector256<sbyte> InsertVector128(Vector256<sbyte> value, Vector128<sbyte> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<float> InsertVector128(Vector256<float> value, Vector128<float> data, byte index);
+        public static Vector256<float> InsertVector128(Vector256<float> value, Vector128<float> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<ushort> InsertVector128(Vector256<ushort> value, Vector128<ushort> data, byte index);
+        public static Vector256<ushort> InsertVector128(Vector256<ushort> value, Vector128<ushort> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<uint> InsertVector128(Vector256<uint> value, Vector128<uint> data, byte index);
+        public static Vector256<uint> InsertVector128(Vector256<uint> value, Vector128<uint> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<ulong> InsertVector128(Vector256<ulong> value, Vector128<ulong> data, byte index);
+        public static Vector256<ulong> InsertVector128(Vector256<ulong> value, Vector128<ulong> data, [ConstantExpectedAttribute] byte index);
-        public static Vector128<double> Permute(Vector128<double> value, byte control);
+        public static Vector128<double> Permute(Vector128<double> value, [ConstantExpectedAttribute] byte control);
-        public static Vector128<float> Permute(Vector128<float> value, byte control);
+        public static Vector128<float> Permute(Vector128<float> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<double> Permute(Vector256<double> value, byte control);
+        public static Vector256<double> Permute(Vector256<double> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<float> Permute(Vector256<float> value, byte control);
+        public static Vector256<float> Permute(Vector256<float> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<byte> Permute2x128(Vector256<byte> left, Vector256<byte> right, byte control);
+        public static Vector256<byte> Permute2x128(Vector256<byte> left, Vector256<byte> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<double> Permute2x128(Vector256<double> left, Vector256<double> right, byte control);
+        public static Vector256<double> Permute2x128(Vector256<double> left, Vector256<double> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<short> Permute2x128(Vector256<short> left, Vector256<short> right, byte control);
+        public static Vector256<short> Permute2x128(Vector256<short> left, Vector256<short> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<int> Permute2x128(Vector256<int> left, Vector256<int> right, byte control);
+        public static Vector256<int> Permute2x128(Vector256<int> left, Vector256<int> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<long> Permute2x128(Vector256<long> left, Vector256<long> right, byte control);
+        public static Vector256<long> Permute2x128(Vector256<long> left, Vector256<long> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<sbyte> Permute2x128(Vector256<sbyte> left, Vector256<sbyte> right, byte control);
+        public static Vector256<sbyte> Permute2x128(Vector256<sbyte> left, Vector256<sbyte> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<float> Permute2x128(Vector256<float> left, Vector256<float> right, byte control);
+        public static Vector256<float> Permute2x128(Vector256<float> left, Vector256<float> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<ushort> Permute2x128(Vector256<ushort> left, Vector256<ushort> right, byte control);
+        public static Vector256<ushort> Permute2x128(Vector256<ushort> left, Vector256<ushort> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<uint> Permute2x128(Vector256<uint> left, Vector256<uint> right, byte control);
+        public static Vector256<uint> Permute2x128(Vector256<uint> left, Vector256<uint> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<ulong> Permute2x128(Vector256<ulong> left, Vector256<ulong> right, byte control);
+        public static Vector256<ulong> Permute2x128(Vector256<ulong> left, Vector256<ulong> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<double> Shuffle(Vector256<double> value, Vector256<double> right, byte control);
+        public static Vector256<double> Shuffle(Vector256<double> value, Vector256<double> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<float> Shuffle(Vector256<float> value, Vector256<float> right, byte control);
+        public static Vector256<float> Shuffle(Vector256<float> value, Vector256<float> right, [ConstantExpectedAttribute] byte control);
     }
     [CLSCompliantAttribute(false)]
     public abstract class Avx2 : Avx {
-        public static Vector256<byte> AlignRight(Vector256<byte> left, Vector256<byte> right, byte mask);
+        public static Vector256<byte> AlignRight(Vector256<byte> left, Vector256<byte> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector256<short> AlignRight(Vector256<short> left, Vector256<short> right, byte mask);
+        public static Vector256<short> AlignRight(Vector256<short> left, Vector256<short> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector256<int> AlignRight(Vector256<int> left, Vector256<int> right, byte mask);
+        public static Vector256<int> AlignRight(Vector256<int> left, Vector256<int> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector256<long> AlignRight(Vector256<long> left, Vector256<long> right, byte mask);
+        public static Vector256<long> AlignRight(Vector256<long> left, Vector256<long> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector256<sbyte> AlignRight(Vector256<sbyte> left, Vector256<sbyte> right, byte mask);
+        public static Vector256<sbyte> AlignRight(Vector256<sbyte> left, Vector256<sbyte> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector256<ushort> AlignRight(Vector256<ushort> left, Vector256<ushort> right, byte mask);
+        public static Vector256<ushort> AlignRight(Vector256<ushort> left, Vector256<ushort> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector256<uint> AlignRight(Vector256<uint> left, Vector256<uint> right, byte mask);
+        public static Vector256<uint> AlignRight(Vector256<uint> left, Vector256<uint> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector256<ulong> AlignRight(Vector256<ulong> left, Vector256<ulong> right, byte mask);
+        public static Vector256<ulong> AlignRight(Vector256<ulong> left, Vector256<ulong> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector128<int> Blend(Vector128<int> left, Vector128<int> right, byte control);
+        public static Vector128<int> Blend(Vector128<int> left, Vector128<int> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<uint> Blend(Vector128<uint> left, Vector128<uint> right, byte control);
+        public static Vector128<uint> Blend(Vector128<uint> left, Vector128<uint> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<short> Blend(Vector256<short> left, Vector256<short> right, byte control);
+        public static Vector256<short> Blend(Vector256<short> left, Vector256<short> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<int> Blend(Vector256<int> left, Vector256<int> right, byte control);
+        public static Vector256<int> Blend(Vector256<int> left, Vector256<int> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<ushort> Blend(Vector256<ushort> left, Vector256<ushort> right, byte control);
+        public static Vector256<ushort> Blend(Vector256<ushort> left, Vector256<ushort> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<uint> Blend(Vector256<uint> left, Vector256<uint> right, byte control);
+        public static Vector256<uint> Blend(Vector256<uint> left, Vector256<uint> right, [ConstantExpectedAttribute] byte control);
-        public static new Vector128<byte> ExtractVector128(Vector256<byte> value, byte index);
+        public static new Vector128<byte> ExtractVector128(Vector256<byte> value, [ConstantExpectedAttribute] byte index);
-        public static new Vector128<short> ExtractVector128(Vector256<short> value, byte index);
+        public static new Vector128<short> ExtractVector128(Vector256<short> value, [ConstantExpectedAttribute] byte index);
-        public static new Vector128<int> ExtractVector128(Vector256<int> value, byte index);
+        public static new Vector128<int> ExtractVector128(Vector256<int> value, [ConstantExpectedAttribute] byte index);
-        public static new Vector128<long> ExtractVector128(Vector256<long> value, byte index);
+        public static new Vector128<long> ExtractVector128(Vector256<long> value, [ConstantExpectedAttribute] byte index);
-        public static new Vector128<sbyte> ExtractVector128(Vector256<sbyte> value, byte index);
+        public static new Vector128<sbyte> ExtractVector128(Vector256<sbyte> value, [ConstantExpectedAttribute] byte index);
-        public static new Vector128<ushort> ExtractVector128(Vector256<ushort> value, byte index);
+        public static new Vector128<ushort> ExtractVector128(Vector256<ushort> value, [ConstantExpectedAttribute] byte index);
-        public static new Vector128<uint> ExtractVector128(Vector256<uint> value, byte index);
+        public static new Vector128<uint> ExtractVector128(Vector256<uint> value, [ConstantExpectedAttribute] byte index);
-        public static new Vector128<ulong> ExtractVector128(Vector256<ulong> value, byte index);
+        public static new Vector128<ulong> ExtractVector128(Vector256<ulong> value, [ConstantExpectedAttribute] byte index);
-        public unsafe static Vector128<double> GatherMaskVector128(Vector128<double> source, double* baseAddress, Vector128<int> index, Vector128<double> mask, byte scale);
+        public unsafe static Vector128<double> GatherMaskVector128(Vector128<double> source, double* baseAddress, Vector128<int> index, Vector128<double> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<double> GatherMaskVector128(Vector128<double> source, double* baseAddress, Vector128<long> index, Vector128<double> mask, byte scale);
+        public unsafe static Vector128<double> GatherMaskVector128(Vector128<double> source, double* baseAddress, Vector128<long> index, Vector128<double> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector128<int> index, Vector128<int> mask, byte scale);
+        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector128<int> index, Vector128<int> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector128<long> index, Vector128<int> mask, byte scale);
+        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector128<long> index, Vector128<int> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector256<long> index, Vector128<int> mask, byte scale);
+        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector256<long> index, Vector128<int> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<long> GatherMaskVector128(Vector128<long> source, long* baseAddress, Vector128<int> index, Vector128<long> mask, byte scale);
+        public unsafe static Vector128<long> GatherMaskVector128(Vector128<long> source, long* baseAddress, Vector128<int> index, Vector128<long> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<long> GatherMaskVector128(Vector128<long> source, long* baseAddress, Vector128<long> index, Vector128<long> mask, byte scale);
+        public unsafe static Vector128<long> GatherMaskVector128(Vector128<long> source, long* baseAddress, Vector128<long> index, Vector128<long> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector128<int> index, Vector128<float> mask, byte scale);
+        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector128<int> index, Vector128<float> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector128<long> index, Vector128<float> mask, byte scale);
+        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector128<long> index, Vector128<float> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector256<long> index, Vector128<float> mask, byte scale);
+        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector256<long> index, Vector128<float> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector128<int> index, Vector128<uint> mask, byte scale);
+        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector128<int> index, Vector128<uint> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector128<long> index, Vector128<uint> mask, byte scale);
+        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector128<long> index, Vector128<uint> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector256<long> index, Vector128<uint> mask, byte scale);
+        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector256<long> index, Vector128<uint> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<ulong> GatherMaskVector128(Vector128<ulong> source, ulong* baseAddress, Vector128<int> index, Vector128<ulong> mask, byte scale);
+        public unsafe static Vector128<ulong> GatherMaskVector128(Vector128<ulong> source, ulong* baseAddress, Vector128<int> index, Vector128<ulong> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<ulong> GatherMaskVector128(Vector128<ulong> source, ulong* baseAddress, Vector128<long> index, Vector128<ulong> mask, byte scale);
+        public unsafe static Vector128<ulong> GatherMaskVector128(Vector128<ulong> source, ulong* baseAddress, Vector128<long> index, Vector128<ulong> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<double> GatherMaskVector256(Vector256<double> source, double* baseAddress, Vector128<int> index, Vector256<double> mask, byte scale);
+        public unsafe static Vector256<double> GatherMaskVector256(Vector256<double> source, double* baseAddress, Vector128<int> index, Vector256<double> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<double> GatherMaskVector256(Vector256<double> source, double* baseAddress, Vector256<long> index, Vector256<double> mask, byte scale);
+        public unsafe static Vector256<double> GatherMaskVector256(Vector256<double> source, double* baseAddress, Vector256<long> index, Vector256<double> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<int> GatherMaskVector256(Vector256<int> source, int* baseAddress, Vector256<int> index, Vector256<int> mask, byte scale);
+        public unsafe static Vector256<int> GatherMaskVector256(Vector256<int> source, int* baseAddress, Vector256<int> index, Vector256<int> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<long> GatherMaskVector256(Vector256<long> source, long* baseAddress, Vector128<int> index, Vector256<long> mask, byte scale);
+        public unsafe static Vector256<long> GatherMaskVector256(Vector256<long> source, long* baseAddress, Vector128<int> index, Vector256<long> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<long> GatherMaskVector256(Vector256<long> source, long* baseAddress, Vector256<long> index, Vector256<long> mask, byte scale);
+        public unsafe static Vector256<long> GatherMaskVector256(Vector256<long> source, long* baseAddress, Vector256<long> index, Vector256<long> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<float> GatherMaskVector256(Vector256<float> source, float* baseAddress, Vector256<int> index, Vector256<float> mask, byte scale);
+        public unsafe static Vector256<float> GatherMaskVector256(Vector256<float> source, float* baseAddress, Vector256<int> index, Vector256<float> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<uint> GatherMaskVector256(Vector256<uint> source, uint* baseAddress, Vector256<int> index, Vector256<uint> mask, byte scale);
+        public unsafe static Vector256<uint> GatherMaskVector256(Vector256<uint> source, uint* baseAddress, Vector256<int> index, Vector256<uint> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<ulong> GatherMaskVector256(Vector256<ulong> source, ulong* baseAddress, Vector128<int> index, Vector256<ulong> mask, byte scale);
+        public unsafe static Vector256<ulong> GatherMaskVector256(Vector256<ulong> source, ulong* baseAddress, Vector128<int> index, Vector256<ulong> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<ulong> GatherMaskVector256(Vector256<ulong> source, ulong* baseAddress, Vector256<long> index, Vector256<ulong> mask, byte scale);
+        public unsafe static Vector256<ulong> GatherMaskVector256(Vector256<ulong> source, ulong* baseAddress, Vector256<long> index, Vector256<ulong> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<double> GatherVector128(double* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<double> GatherVector128(double* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<double> GatherVector128(double* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<double> GatherVector128(double* baseAddress, Vector128<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector128<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector256<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<long> GatherVector128(long* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<long> GatherVector128(long* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<long> GatherVector128(long* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<long> GatherVector128(long* baseAddress, Vector128<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector128<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector256<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector128<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector256<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<ulong> GatherVector128(ulong* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<ulong> GatherVector128(ulong* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<ulong> GatherVector128(ulong* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<ulong> GatherVector128(ulong* baseAddress, Vector128<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<double> GatherVector256(double* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector256<double> GatherVector256(double* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<double> GatherVector256(double* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector256<double> GatherVector256(double* baseAddress, Vector256<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<int> GatherVector256(int* baseAddress, Vector256<int> index, byte scale);
+        public unsafe static Vector256<int> GatherVector256(int* baseAddress, Vector256<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<long> GatherVector256(long* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector256<long> GatherVector256(long* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<long> GatherVector256(long* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector256<long> GatherVector256(long* baseAddress, Vector256<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<float> GatherVector256(float* baseAddress, Vector256<int> index, byte scale);
+        public unsafe static Vector256<float> GatherVector256(float* baseAddress, Vector256<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<uint> GatherVector256(uint* baseAddress, Vector256<int> index, byte scale);
+        public unsafe static Vector256<uint> GatherVector256(uint* baseAddress, Vector256<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<ulong> GatherVector256(ulong* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector256<ulong> GatherVector256(ulong* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<ulong> GatherVector256(ulong* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector256<ulong> GatherVector256(ulong* baseAddress, Vector256<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public static new Vector256<byte> InsertVector128(Vector256<byte> value, Vector128<byte> data, byte index);
+        public static new Vector256<byte> InsertVector128(Vector256<byte> value, Vector128<byte> data, [ConstantExpectedAttribute] byte index);
-        public static new Vector256<short> InsertVector128(Vector256<short> value, Vector128<short> data, byte index);
+        public static new Vector256<short> InsertVector128(Vector256<short> value, Vector128<short> data, [ConstantExpectedAttribute] byte index);
-        public static new Vector256<int> InsertVector128(Vector256<int> value, Vector128<int> data, byte index);
+        public static new Vector256<int> InsertVector128(Vector256<int> value, Vector128<int> data, [ConstantExpectedAttribute] byte index);
-        public static new Vector256<long> InsertVector128(Vector256<long> value, Vector128<long> data, byte index);
+        public static new Vector256<long> InsertVector128(Vector256<long> value, Vector128<long> data, [ConstantExpectedAttribute] byte index);
-        public static new Vector256<sbyte> InsertVector128(Vector256<sbyte> value, Vector128<sbyte> data, byte index);
+        public static new Vector256<sbyte> InsertVector128(Vector256<sbyte> value, Vector128<sbyte> data, [ConstantExpectedAttribute] byte index);
-        public static new Vector256<ushort> InsertVector128(Vector256<ushort> value, Vector128<ushort> data, byte index);
+        public static new Vector256<ushort> InsertVector128(Vector256<ushort> value, Vector128<ushort> data, [ConstantExpectedAttribute] byte index);
-        public static new Vector256<uint> InsertVector128(Vector256<uint> value, Vector128<uint> data, byte index);
+        public static new Vector256<uint> InsertVector128(Vector256<uint> value, Vector128<uint> data, [ConstantExpectedAttribute] byte index);
-        public static new Vector256<ulong> InsertVector128(Vector256<ulong> value, Vector128<ulong> data, byte index);
+        public static new Vector256<ulong> InsertVector128(Vector256<ulong> value, Vector128<ulong> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<ushort> MultipleSumAbsoluteDifferences(Vector256<byte> left, Vector256<byte> right, byte mask);
+        public static Vector256<ushort> MultipleSumAbsoluteDifferences(Vector256<byte> left, Vector256<byte> right, [ConstantExpectedAttribute] byte mask);
-        public static new Vector256<byte> Permute2x128(Vector256<byte> left, Vector256<byte> right, byte control);
+        public static new Vector256<byte> Permute2x128(Vector256<byte> left, Vector256<byte> right, [ConstantExpectedAttribute] byte control);
-        public static new Vector256<short> Permute2x128(Vector256<short> left, Vector256<short> right, byte control);
+        public static new Vector256<short> Permute2x128(Vector256<short> left, Vector256<short> right, [ConstantExpectedAttribute] byte control);
-        public static new Vector256<int> Permute2x128(Vector256<int> left, Vector256<int> right, byte control);
+        public static new Vector256<int> Permute2x128(Vector256<int> left, Vector256<int> right, [ConstantExpectedAttribute] byte control);
-        public static new Vector256<long> Permute2x128(Vector256<long> left, Vector256<long> right, byte control);
+        public static new Vector256<long> Permute2x128(Vector256<long> left, Vector256<long> right, [ConstantExpectedAttribute] byte control);
-        public static new Vector256<sbyte> Permute2x128(Vector256<sbyte> left, Vector256<sbyte> right, byte control);
+        public static new Vector256<sbyte> Permute2x128(Vector256<sbyte> left, Vector256<sbyte> right, [ConstantExpectedAttribute] byte control);
-        public static new Vector256<ushort> Permute2x128(Vector256<ushort> left, Vector256<ushort> right, byte control);
+        public static new Vector256<ushort> Permute2x128(Vector256<ushort> left, Vector256<ushort> right, [ConstantExpectedAttribute] byte control);
-        public static new Vector256<uint> Permute2x128(Vector256<uint> left, Vector256<uint> right, byte control);
+        public static new Vector256<uint> Permute2x128(Vector256<uint> left, Vector256<uint> right, [ConstantExpectedAttribute] byte control);
-        public static new Vector256<ulong> Permute2x128(Vector256<ulong> left, Vector256<ulong> right, byte control);
+        public static new Vector256<ulong> Permute2x128(Vector256<ulong> left, Vector256<ulong> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<double> Permute4x64(Vector256<double> value, byte control);
+        public static Vector256<double> Permute4x64(Vector256<double> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<long> Permute4x64(Vector256<long> value, byte control);
+        public static Vector256<long> Permute4x64(Vector256<long> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<ulong> Permute4x64(Vector256<ulong> value, byte control);
+        public static Vector256<ulong> Permute4x64(Vector256<ulong> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<short> ShiftLeftLogical(Vector256<short> value, byte count);
+        public static Vector256<short> ShiftLeftLogical(Vector256<short> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<int> ShiftLeftLogical(Vector256<int> value, byte count);
+        public static Vector256<int> ShiftLeftLogical(Vector256<int> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<long> ShiftLeftLogical(Vector256<long> value, byte count);
+        public static Vector256<long> ShiftLeftLogical(Vector256<long> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<ushort> ShiftLeftLogical(Vector256<ushort> value, byte count);
+        public static Vector256<ushort> ShiftLeftLogical(Vector256<ushort> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<uint> ShiftLeftLogical(Vector256<uint> value, byte count);
+        public static Vector256<uint> ShiftLeftLogical(Vector256<uint> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<ulong> ShiftLeftLogical(Vector256<ulong> value, byte count);
+        public static Vector256<ulong> ShiftLeftLogical(Vector256<ulong> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<byte> ShiftLeftLogical128BitLane(Vector256<byte> value, byte numBytes);
+        public static Vector256<byte> ShiftLeftLogical128BitLane(Vector256<byte> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<short> ShiftLeftLogical128BitLane(Vector256<short> value, byte numBytes);
+        public static Vector256<short> ShiftLeftLogical128BitLane(Vector256<short> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<int> ShiftLeftLogical128BitLane(Vector256<int> value, byte numBytes);
+        public static Vector256<int> ShiftLeftLogical128BitLane(Vector256<int> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<long> ShiftLeftLogical128BitLane(Vector256<long> value, byte numBytes);
+        public static Vector256<long> ShiftLeftLogical128BitLane(Vector256<long> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<sbyte> ShiftLeftLogical128BitLane(Vector256<sbyte> value, byte numBytes);
+        public static Vector256<sbyte> ShiftLeftLogical128BitLane(Vector256<sbyte> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<ushort> ShiftLeftLogical128BitLane(Vector256<ushort> value, byte numBytes);
+        public static Vector256<ushort> ShiftLeftLogical128BitLane(Vector256<ushort> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<uint> ShiftLeftLogical128BitLane(Vector256<uint> value, byte numBytes);
+        public static Vector256<uint> ShiftLeftLogical128BitLane(Vector256<uint> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<ulong> ShiftLeftLogical128BitLane(Vector256<ulong> value, byte numBytes);
+        public static Vector256<ulong> ShiftLeftLogical128BitLane(Vector256<ulong> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<short> ShiftRightArithmetic(Vector256<short> value, byte count);
+        public static Vector256<short> ShiftRightArithmetic(Vector256<short> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<int> ShiftRightArithmetic(Vector256<int> value, byte count);
+        public static Vector256<int> ShiftRightArithmetic(Vector256<int> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<short> ShiftRightLogical(Vector256<short> value, byte count);
+        public static Vector256<short> ShiftRightLogical(Vector256<short> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<int> ShiftRightLogical(Vector256<int> value, byte count);
+        public static Vector256<int> ShiftRightLogical(Vector256<int> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<long> ShiftRightLogical(Vector256<long> value, byte count);
+        public static Vector256<long> ShiftRightLogical(Vector256<long> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<ushort> ShiftRightLogical(Vector256<ushort> value, byte count);
+        public static Vector256<ushort> ShiftRightLogical(Vector256<ushort> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<uint> ShiftRightLogical(Vector256<uint> value, byte count);
+        public static Vector256<uint> ShiftRightLogical(Vector256<uint> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<ulong> ShiftRightLogical(Vector256<ulong> value, byte count);
+        public static Vector256<ulong> ShiftRightLogical(Vector256<ulong> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<byte> ShiftRightLogical128BitLane(Vector256<byte> value, byte numBytes);
+        public static Vector256<byte> ShiftRightLogical128BitLane(Vector256<byte> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<short> ShiftRightLogical128BitLane(Vector256<short> value, byte numBytes);
+        public static Vector256<short> ShiftRightLogical128BitLane(Vector256<short> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<int> ShiftRightLogical128BitLane(Vector256<int> value, byte numBytes);
+        public static Vector256<int> ShiftRightLogical128BitLane(Vector256<int> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<long> ShiftRightLogical128BitLane(Vector256<long> value, byte numBytes);
+        public static Vector256<long> ShiftRightLogical128BitLane(Vector256<long> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<sbyte> ShiftRightLogical128BitLane(Vector256<sbyte> value, byte numBytes);
+        public static Vector256<sbyte> ShiftRightLogical128BitLane(Vector256<sbyte> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<ushort> ShiftRightLogical128BitLane(Vector256<ushort> value, byte numBytes);
+        public static Vector256<ushort> ShiftRightLogical128BitLane(Vector256<ushort> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<uint> ShiftRightLogical128BitLane(Vector256<uint> value, byte numBytes);
+        public static Vector256<uint> ShiftRightLogical128BitLane(Vector256<uint> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<ulong> ShiftRightLogical128BitLane(Vector256<ulong> value, byte numBytes);
+        public static Vector256<ulong> ShiftRightLogical128BitLane(Vector256<ulong> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<int> Shuffle(Vector256<int> value, byte control);
+        public static Vector256<int> Shuffle(Vector256<int> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<uint> Shuffle(Vector256<uint> value, byte control);
+        public static Vector256<uint> Shuffle(Vector256<uint> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<short> ShuffleHigh(Vector256<short> value, byte control);
+        public static Vector256<short> ShuffleHigh(Vector256<short> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<ushort> ShuffleHigh(Vector256<ushort> value, byte control);
+        public static Vector256<ushort> ShuffleHigh(Vector256<ushort> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<short> ShuffleLow(Vector256<short> value, byte control);
+        public static Vector256<short> ShuffleLow(Vector256<short> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<ushort> ShuffleLow(Vector256<ushort> value, byte control);
+        public static Vector256<ushort> ShuffleLow(Vector256<ushort> value, [ConstantExpectedAttribute] byte control);
     }
     [CLSCompliantAttribute(false)]
     public abstract class Pclmulqdq : Sse2 {
-        public static Vector128<long> CarrylessMultiply(Vector128<long> left, Vector128<long> right, byte control);
+        public static Vector128<long> CarrylessMultiply(Vector128<long> left, Vector128<long> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<ulong> CarrylessMultiply(Vector128<ulong> left, Vector128<ulong> right, byte control);
+        public static Vector128<ulong> CarrylessMultiply(Vector128<ulong> left, Vector128<ulong> right, [ConstantExpectedAttribute] byte control);
     }
     [CLSCompliantAttribute(false)]
     public abstract class Sse : X86Base {
-        public static Vector128<float> Shuffle(Vector128<float> left, Vector128<float> right, byte control);
+        public static Vector128<float> Shuffle(Vector128<float> left, Vector128<float> right, [ConstantExpectedAttribute] byte control);
     }
     [CLSCompliantAttribute(false)]
     public abstract class Sse2 : Sse {
-        public static ushort Extract(Vector128<ushort> value, byte index);
+        public static ushort Extract(Vector128<ushort> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<short> Insert(Vector128<short> value, short data, byte index);
+        public static Vector128<short> Insert(Vector128<short> value, short data, [ConstantExpectedAttribute] byte index);
-        public static Vector128<ushort> Insert(Vector128<ushort> value, ushort data, byte index);
+        public static Vector128<ushort> Insert(Vector128<ushort> value, ushort data, [ConstantExpectedAttribute] byte index);
-        public static Vector128<short> ShiftLeftLogical(Vector128<short> value, byte count);
+        public static Vector128<short> ShiftLeftLogical(Vector128<short> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<int> ShiftLeftLogical(Vector128<int> value, byte count);
+        public static Vector128<int> ShiftLeftLogical(Vector128<int> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<long> ShiftLeftLogical(Vector128<long> value, byte count);
+        public static Vector128<long> ShiftLeftLogical(Vector128<long> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<ushort> ShiftLeftLogical(Vector128<ushort> value, byte count);
+        public static Vector128<ushort> ShiftLeftLogical(Vector128<ushort> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<uint> ShiftLeftLogical(Vector128<uint> value, byte count);
+        public static Vector128<uint> ShiftLeftLogical(Vector128<uint> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<ulong> ShiftLeftLogical(Vector128<ulong> value, byte count);
+        public static Vector128<ulong> ShiftLeftLogical(Vector128<ulong> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<byte> ShiftLeftLogical128BitLane(Vector128<byte> value, byte numBytes);
+        public static Vector128<byte> ShiftLeftLogical128BitLane(Vector128<byte> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<short> ShiftLeftLogical128BitLane(Vector128<short> value, byte numBytes);
+        public static Vector128<short> ShiftLeftLogical128BitLane(Vector128<short> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<int> ShiftLeftLogical128BitLane(Vector128<int> value, byte numBytes);
+        public static Vector128<int> ShiftLeftLogical128BitLane(Vector128<int> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<long> ShiftLeftLogical128BitLane(Vector128<long> value, byte numBytes);
+        public static Vector128<long> ShiftLeftLogical128BitLane(Vector128<long> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<sbyte> ShiftLeftLogical128BitLane(Vector128<sbyte> value, byte numBytes);
+        public static Vector128<sbyte> ShiftLeftLogical128BitLane(Vector128<sbyte> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<ushort> ShiftLeftLogical128BitLane(Vector128<ushort> value, byte numBytes);
+        public static Vector128<ushort> ShiftLeftLogical128BitLane(Vector128<ushort> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<uint> ShiftLeftLogical128BitLane(Vector128<uint> value, byte numBytes);
+        public static Vector128<uint> ShiftLeftLogical128BitLane(Vector128<uint> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<ulong> ShiftLeftLogical128BitLane(Vector128<ulong> value, byte numBytes);
+        public static Vector128<ulong> ShiftLeftLogical128BitLane(Vector128<ulong> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<short> ShiftRightArithmetic(Vector128<short> value, byte count);
+        public static Vector128<short> ShiftRightArithmetic(Vector128<short> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<int> ShiftRightArithmetic(Vector128<int> value, byte count);
+        public static Vector128<int> ShiftRightArithmetic(Vector128<int> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<short> ShiftRightLogical(Vector128<short> value, byte count);
+        public static Vector128<short> ShiftRightLogical(Vector128<short> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<int> ShiftRightLogical(Vector128<int> value, byte count);
+        public static Vector128<int> ShiftRightLogical(Vector128<int> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<long> ShiftRightLogical(Vector128<long> value, byte count);
+        public static Vector128<long> ShiftRightLogical(Vector128<long> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<ushort> ShiftRightLogical(Vector128<ushort> value, byte count);
+        public static Vector128<ushort> ShiftRightLogical(Vector128<ushort> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<uint> ShiftRightLogical(Vector128<uint> value, byte count);
+        public static Vector128<uint> ShiftRightLogical(Vector128<uint> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<ulong> ShiftRightLogical(Vector128<ulong> value, byte count);
+        public static Vector128<ulong> ShiftRightLogical(Vector128<ulong> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<byte> ShiftRightLogical128BitLane(Vector128<byte> value, byte numBytes);
+        public static Vector128<byte> ShiftRightLogical128BitLane(Vector128<byte> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<short> ShiftRightLogical128BitLane(Vector128<short> value, byte numBytes);
+        public static Vector128<short> ShiftRightLogical128BitLane(Vector128<short> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<int> ShiftRightLogical128BitLane(Vector128<int> value, byte numBytes);
+        public static Vector128<int> ShiftRightLogical128BitLane(Vector128<int> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<long> ShiftRightLogical128BitLane(Vector128<long> value, byte numBytes);
+        public static Vector128<long> ShiftRightLogical128BitLane(Vector128<long> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<sbyte> ShiftRightLogical128BitLane(Vector128<sbyte> value, byte numBytes);
+        public static Vector128<sbyte> ShiftRightLogical128BitLane(Vector128<sbyte> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<ushort> ShiftRightLogical128BitLane(Vector128<ushort> value, byte numBytes);
+        public static Vector128<ushort> ShiftRightLogical128BitLane(Vector128<ushort> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<uint> ShiftRightLogical128BitLane(Vector128<uint> value, byte numBytes);
+        public static Vector128<uint> ShiftRightLogical128BitLane(Vector128<uint> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<ulong> ShiftRightLogical128BitLane(Vector128<ulong> value, byte numBytes);
+        public static Vector128<ulong> ShiftRightLogical128BitLane(Vector128<ulong> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<double> Shuffle(Vector128<double> left, Vector128<double> right, byte control);
+        public static Vector128<double> Shuffle(Vector128<double> left, Vector128<double> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<int> Shuffle(Vector128<int> value, byte control);
+        public static Vector128<int> Shuffle(Vector128<int> value, [ConstantExpectedAttribute] byte control);
-        public static Vector128<uint> Shuffle(Vector128<uint> value, byte control);
+        public static Vector128<uint> Shuffle(Vector128<uint> value, [ConstantExpectedAttribute] byte control);
-        public static Vector128<short> ShuffleHigh(Vector128<short> value, byte control);
+        public static Vector128<short> ShuffleHigh(Vector128<short> value, [ConstantExpectedAttribute] byte control);
-        public static Vector128<ushort> ShuffleHigh(Vector128<ushort> value, byte control);
+        public static Vector128<ushort> ShuffleHigh(Vector128<ushort> value, [ConstantExpectedAttribute] byte control);
-        public static Vector128<short> ShuffleLow(Vector128<short> value, byte control);
+        public static Vector128<short> ShuffleLow(Vector128<short> value, [ConstantExpectedAttribute] byte control);
-        public static Vector128<ushort> ShuffleLow(Vector128<ushort> value, byte control);
+        public static Vector128<ushort> ShuffleLow(Vector128<ushort> value, [ConstantExpectedAttribute] byte control);
     }
     [CLSCompliantAttribute(false)]
     public abstract class Sse41 : Ssse3 {
-        public static Vector128<double> Blend(Vector128<double> left, Vector128<double> right, byte control);
+        public static Vector128<double> Blend(Vector128<double> left, Vector128<double> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<short> Blend(Vector128<short> left, Vector128<short> right, byte control);
+        public static Vector128<short> Blend(Vector128<short> left, Vector128<short> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<float> Blend(Vector128<float> left, Vector128<float> right, byte control);
+        public static Vector128<float> Blend(Vector128<float> left, Vector128<float> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<ushort> Blend(Vector128<ushort> left, Vector128<ushort> right, byte control);
+        public static Vector128<ushort> Blend(Vector128<ushort> left, Vector128<ushort> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<double> DotProduct(Vector128<double> left, Vector128<double> right, byte control);
+        public static Vector128<double> DotProduct(Vector128<double> left, Vector128<double> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<float> DotProduct(Vector128<float> left, Vector128<float> right, byte control);
+        public static Vector128<float> DotProduct(Vector128<float> left, Vector128<float> right, [ConstantExpectedAttribute] byte control);
-        public static byte Extract(Vector128<byte> value, byte index);
+        public static byte Extract(Vector128<byte> value, [ConstantExpectedAttribute] byte index);
-        public static int Extract(Vector128<int> value, byte index);
+        public static int Extract(Vector128<int> value, [ConstantExpectedAttribute] byte index);
-        public static float Extract(Vector128<float> value, byte index);
+        public static float Extract(Vector128<float> value, [ConstantExpectedAttribute] byte index);
-        public static uint Extract(Vector128<uint> value, byte index);
+        public static uint Extract(Vector128<uint> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<byte> Insert(Vector128<byte> value, byte data, byte index);
+        public static Vector128<byte> Insert(Vector128<byte> value, byte data, [ConstantExpectedAttribute] byte index);
-        public static Vector128<int> Insert(Vector128<int> value, int data, byte index);
+        public static Vector128<int> Insert(Vector128<int> value, int data, [ConstantExpectedAttribute] byte index);
-        public static Vector128<sbyte> Insert(Vector128<sbyte> value, sbyte data, byte index);
+        public static Vector128<sbyte> Insert(Vector128<sbyte> value, sbyte data, [ConstantExpectedAttribute] byte index);
-        public static Vector128<float> Insert(Vector128<float> value, Vector128<float> data, byte index);
+        public static Vector128<float> Insert(Vector128<float> value, Vector128<float> data, [ConstantExpectedAttribute] byte index);
-        public static Vector128<uint> Insert(Vector128<uint> value, uint data, byte index);
+        public static Vector128<uint> Insert(Vector128<uint> value, uint data, [ConstantExpectedAttribute] byte index);
-        public static Vector128<ushort> MultipleSumAbsoluteDifferences(Vector128<byte> left, Vector128<byte> right, byte mask);
+        public static Vector128<ushort> MultipleSumAbsoluteDifferences(Vector128<byte> left, Vector128<byte> right, [ConstantExpectedAttribute] byte mask);
         public new abstract class X64 : Ssse3.X64 {
-            public static long Extract(Vector128<long> value, byte index);
+            public static long Extract(Vector128<long> value, [ConstantExpectedAttribute] byte index);
-            public static ulong Extract(Vector128<ulong> value, byte index);
+            public static ulong Extract(Vector128<ulong> value, [ConstantExpectedAttribute] byte index);
-            public static Vector128<long> Insert(Vector128<long> value, long data, byte index);
+            public static Vector128<long> Insert(Vector128<long> value, long data, [ConstantExpectedAttribute] byte index);
-            public static Vector128<ulong> Insert(Vector128<ulong> value, ulong data, byte index);
+            public static Vector128<ulong> Insert(Vector128<ulong> value, ulong data, [ConstantExpectedAttribute] byte index);
         }
     }
     [CLSCompliantAttribute(false)]
     public abstract class Ssse3 : Sse3 {
-        public static Vector128<byte> AlignRight(Vector128<byte> left, Vector128<byte> right, byte mask);
+        public static Vector128<byte> AlignRight(Vector128<byte> left, Vector128<byte> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector128<short> AlignRight(Vector128<short> left, Vector128<short> right, byte mask);
+        public static Vector128<short> AlignRight(Vector128<short> left, Vector128<short> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector128<int> AlignRight(Vector128<int> left, Vector128<int> right, byte mask);
+        public static Vector128<int> AlignRight(Vector128<int> left, Vector128<int> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector128<long> AlignRight(Vector128<long> left, Vector128<long> right, byte mask);
+        public static Vector128<long> AlignRight(Vector128<long> left, Vector128<long> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector128<sbyte> AlignRight(Vector128<sbyte> left, Vector128<sbyte> right, byte mask);
+        public static Vector128<sbyte> AlignRight(Vector128<sbyte> left, Vector128<sbyte> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector128<ushort> AlignRight(Vector128<ushort> left, Vector128<ushort> right, byte mask);
+        public static Vector128<ushort> AlignRight(Vector128<ushort> left, Vector128<ushort> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector128<uint> AlignRight(Vector128<uint> left, Vector128<uint> right, byte mask);
+        public static Vector128<uint> AlignRight(Vector128<uint> left, Vector128<uint> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector128<ulong> AlignRight(Vector128<ulong> left, Vector128<ulong> right, byte mask);
+        public static Vector128<ulong> AlignRight(Vector128<ulong> left, Vector128<ulong> right, [ConstantExpectedAttribute] byte mask);
     }
 }
```

