# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
     public abstract class AsymmetricAlgorithm : IDisposable {
+        public string ExportEncryptedPkcs8PrivateKeyPem(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters);
+        public bool TryExportEncryptedPkcs8PrivateKeyPem(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<char> destination, out int charsWritten);
     }
+    public sealed class AuthenticationTagMismatchException : CryptographicException {
+        public AuthenticationTagMismatchException();
+        public AuthenticationTagMismatchException(string message);
+        public AuthenticationTagMismatchException(string message, Exception inner);
+    }
     public abstract class RandomNumberGenerator : IDisposable {
+        public static string GetHexString(int stringLength, bool lowercase = false);
+        public static void GetHexString(Span<char> destination, bool lowercase = false);
+        public static T[] GetItems<T>(ReadOnlySpan<T> choices, int length);
+        public static void GetItems<T>(ReadOnlySpan<T> choices, Span<T> destination);
+        public static string GetString(ReadOnlySpan<char> choices, int length);
+        public static void Shuffle<T>(Span<T> values);
     }
     public abstract class RSA : AsymmetricAlgorithm {
-        public virtual byte[] DecryptValue(byte[] rgb);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("RSA.EncryptValue and DecryptValue are not supported and throw NotSupportedException. Use RSA.Encrypt and RSA.Decrypt instead.", DiagnosticId="SYSLIB0048", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public virtual byte[] DecryptValue(byte[] rgb);
-        public virtual byte[] EncryptValue(byte[] rgb);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("RSA.EncryptValue and DecryptValue are not supported and throw NotSupportedException. Use RSA.Encrypt and RSA.Decrypt instead.", DiagnosticId="SYSLIB0048", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public virtual byte[] EncryptValue(byte[] rgb);
     }
     public sealed class RSACryptoServiceProvider : RSA, ICspAsymmetricAlgorithm {
-        public override byte[] DecryptValue(byte[] rgb);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("RSA.EncryptValue and DecryptValue are not supported and throw NotSupportedException. Use RSA.Encrypt and RSA.Decrypt instead.", DiagnosticId="SYSLIB0048", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override byte[] DecryptValue(byte[] rgb);
-        public override byte[] EncryptValue(byte[] rgb);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("RSA.EncryptValue and DecryptValue are not supported and throw NotSupportedException. Use RSA.Encrypt and RSA.Decrypt instead.", DiagnosticId="SYSLIB0048", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override byte[] EncryptValue(byte[] rgb);
     }
 }
```

