# System.Text.Json

``` diff
 namespace System.Text.Json {
     public readonly struct JsonEncodedText : IEquatable<JsonEncodedText> {
+        public string Value { get; }
     }
     public abstract class JsonNamingPolicy {
+        public static JsonNamingPolicy KebabCaseLower { get; }
+        public static JsonNamingPolicy KebabCaseUpper { get; }
+        public static JsonNamingPolicy SnakeCaseLower { get; }
+        public static JsonNamingPolicy SnakeCaseUpper { get; }
     }
     public static class JsonSerializer {
+        public static object? Deserialize(Stream utf8Json, JsonTypeInfo jsonTypeInfo);
+        public static object? Deserialize(ReadOnlySpan<byte> utf8Json, JsonTypeInfo jsonTypeInfo);
+        public static object? Deserialize([StringSyntaxAttribute("Json")] ReadOnlySpan<char> json, JsonTypeInfo jsonTypeInfo);
+        public static object? Deserialize([StringSyntaxAttribute("Json")] string json, JsonTypeInfo jsonTypeInfo);
+        public static object? Deserialize(this JsonDocument document, JsonTypeInfo jsonTypeInfo);
+        public static object? Deserialize(this JsonElement element, JsonTypeInfo jsonTypeInfo);
+        public static object? Deserialize(this JsonNode? node, JsonTypeInfo jsonTypeInfo);
+        public static object? Deserialize(ref Utf8JsonReader reader, JsonTypeInfo jsonTypeInfo);
+        public static ValueTask<object?> DeserializeAsync(Stream utf8Json, JsonTypeInfo jsonTypeInfo, CancellationToken cancellationToken = default(CancellationToken));
+        public static IAsyncEnumerable<object?> DeserializeAsyncEnumerable(Stream utf8Json, JsonTypeInfo jsonTypeInfo, CancellationToken cancellationToken = default(CancellationToken));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static IAsyncEnumerable<object?> DeserializeAsyncEnumerable(Stream utf8Json, Type returnType, JsonSerializerOptions? options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static void Serialize(Stream utf8Json, object? value, JsonTypeInfo jsonTypeInfo);
+        public static string Serialize(object? value, JsonTypeInfo jsonTypeInfo);
+        public static void Serialize(Utf8JsonWriter writer, object? value, JsonTypeInfo jsonTypeInfo);
+        public static Task SerializeAsync(Stream utf8Json, object? value, JsonTypeInfo jsonTypeInfo, CancellationToken cancellationToken = default(CancellationToken));
+        public static JsonDocument SerializeToDocument(object? value, JsonTypeInfo jsonTypeInfo);
+        public static JsonElement SerializeToElement(object? value, JsonTypeInfo jsonTypeInfo);
+        public static JsonNode? SerializeToNode(object? value, JsonTypeInfo jsonTypeInfo);
+        public static byte[] SerializeToUtf8Bytes(object? value, JsonTypeInfo jsonTypeInfo);
     }
     public sealed class JsonSerializerOptions {
+        public bool IsReadOnly { get; }
+        public JsonUnmappedMemberHandling UnmappedMemberHandling { get; set; }
+        public void MakeReadOnly();
     }
     public sealed class Utf8JsonWriter : IAsyncDisposable, IDisposable {
+        public void WriteRawValue(ReadOnlySequence<byte> utf8Json, bool skipInputValidation = false);
     }
 }
```

