# System

``` diff
 namespace System {
     public class ArgumentOutOfRangeException : ArgumentException {
-        public ArgumentOutOfRangeException(string paramName);
+        public ArgumentOutOfRangeException(string? paramName);
-        public ArgumentOutOfRangeException(string message, Exception innerException);
+        public ArgumentOutOfRangeException(string? message, Exception? innerException);
-        public ArgumentOutOfRangeException(string paramName, object actualValue, string message);
+        public ArgumentOutOfRangeException(string? paramName, object? actualValue, string? message);
-        public ArgumentOutOfRangeException(string paramName, string message);
+        public ArgumentOutOfRangeException(string? paramName, string? message);
-        public virtual object ActualValue { get; }
+        public virtual object? ActualValue { get; }
+        public static void ThrowIfGreaterThan<T>(T value, T other, [CallerArgumentExpressionAttribute("value")] string? paramName = null) where T : IComparable<T>;
+        public static void ThrowIfGreaterThanOrEqual<T>(T value, T other, [CallerArgumentExpressionAttribute("value")] string? paramName = null) where T : IComparable<T>;
+        public static void ThrowIfLessThan<T>(T value, T other, [CallerArgumentExpressionAttribute("value")] string? paramName = null) where T : IComparable<T>;
+        public static void ThrowIfLessThanOrEqual<T>(T value, T other, [CallerArgumentExpressionAttribute("value")] string? paramName = null) where T : IComparable<T>;
+        public static void ThrowIfNegative<T>(T value, [CallerArgumentExpressionAttribute("value")] string? paramName = null) where T : INumberBase<T>;
+        public static void ThrowIfNegativeOrZero<T>(T value, [CallerArgumentExpressionAttribute("value")] string? paramName = null) where T : INumberBase<T>;
+        public static void ThrowIfZero<T>(T value, [CallerArgumentExpressionAttribute("value")] string? paramName = null) where T : INumberBase<T>;
     }
     public static class Console {
-        public static int WindowHeight { [UnsupportedOSPlatformAttribute("android"), UnsupportedOSPlatformAttribute("browser"), UnsupportedOSPlatformAttribute("ios"), UnsupportedOSPlatformAttribute("tvos")] get; [SupportedOSPlatformAttribute("windows")] set; }
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public static int WindowHeight { get; set; }
-        public static int WindowWidth { [UnsupportedOSPlatformAttribute("android"), UnsupportedOSPlatformAttribute("browser"), UnsupportedOSPlatformAttribute("ios"), UnsupportedOSPlatformAttribute("tvos")] get; [SupportedOSPlatformAttribute("windows")] set; }
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public static int WindowWidth { get; set; }
-        [SupportedOSPlatformAttribute("windows")]
-        public static void SetWindowSize(int width, int height);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        public static void SetWindowSize(int width, int height);
     }
     public readonly struct DateOnly : IComparable, IComparable<DateOnly>, IEquatable<DateOnly>, IFormattable, IParsable<DateOnly>, ISpanFormattable, ISpanParsable<DateOnly> {
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        public void Deconstruct(out int year, out int month, out int day);
     }
     public readonly struct DateTime : IComparable, IComparable<DateTime>, IConvertible, IEquatable<DateTime>, IFormattable, IParsable<DateTime>, ISerializable, ISpanFormattable, ISpanParsable<DateTime> {
+        public DateTime(DateOnly date, TimeOnly time);
+        public DateTime(DateOnly date, TimeOnly time, DateTimeKind kind);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        public void Deconstruct(out DateOnly date, out TimeOnly time);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        public void Deconstruct(out int year, out int month, out int day);
     }
     public readonly struct DateTimeOffset : IComparable, IComparable<DateTimeOffset>, IDeserializationCallback, IEquatable<DateTimeOffset>, IFormattable, IParsable<DateTimeOffset>, ISerializable, ISpanFormattable, ISpanParsable<DateTimeOffset> {
+        public DateTimeOffset(DateOnly date, TimeOnly time, TimeSpan offset);
+        public int TotalOffsetMinutes { get; }
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        public void Deconstruct(out DateOnly date, out TimeOnly time, out TimeSpan offset);
     }
     public readonly struct Double : IAdditionOperators<double, double, double>, IAdditiveIdentity<double, double>, IBinaryFloatingPointIeee754<double>, IBinaryNumber<double>, IBitwiseOperators<double, double, double>, IComparable, IComparable<double>, IComparisonOperators<double, double, bool>, IConvertible, IDecrementOperators<double>, IDivisionOperators<double, double, double>, IEqualityOperators<double, double, bool>, IEquatable<double>, IExponentialFunctions<double>, IFloatingPoint<double>, IFloatingPointConstants<double>, IFloatingPointIeee754<double>, IFormattable, IHyperbolicFunctions<double>, IIncrementOperators<double>, ILogarithmicFunctions<double>, IMinMaxValue<double>, IModulusOperators<double, double, double>, IMultiplicativeIdentity<double, double>, IMultiplyOperators<double, double, double>, INumber<double>, INumberBase<double>, IParsable<double>, IPowerFunctions<double>, IRootFunctions<double>, ISignedNumber<double>, ISpanFormattable, ISpanParsable<double>, ISubtractionOperators<double, double, double>, ITrigonometricFunctions<double>, IUnaryNegationOperators<double, double>, IUnaryPlusOperators<double, double> {
+        public static double Lerp(double value1, double value2, double amount);
     }
-    public abstract class Enum : ValueType, IComparable, IConvertible, IFormattable {
+    public abstract class Enum : ValueType, IComparable, IConvertible, IFormattable, ISpanFormattable {
+        bool ISpanFormattable.TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format, IFormatProvider provider);
+        public static bool TryFormat<TEnum>(TEnum value, Span<char> destination, out int charsWritten, [StringSyntaxAttribute("EnumFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>)) where TEnum : struct;
     }
     public static class Environment {
+        public static bool IsPrivilegedProcess { get; }
     }
     public readonly struct Half : IAdditionOperators<Half, Half, Half>, IAdditiveIdentity<Half, Half>, IBinaryFloatingPointIeee754<Half>, IBinaryNumber<Half>, IBitwiseOperators<Half, Half, Half>, IComparable, IComparable<Half>, IComparisonOperators<Half, Half, bool>, IDecrementOperators<Half>, IDivisionOperators<Half, Half, Half>, IEqualityOperators<Half, Half, bool>, IEquatable<Half>, IExponentialFunctions<Half>, IFloatingPoint<Half>, IFloatingPointConstants<Half>, IFloatingPointIeee754<Half>, IFormattable, IHyperbolicFunctions<Half>, IIncrementOperators<Half>, ILogarithmicFunctions<Half>, IMinMaxValue<Half>, IModulusOperators<Half, Half, Half>, IMultiplicativeIdentity<Half, Half>, IMultiplyOperators<Half, Half, Half>, INumber<Half>, INumberBase<Half>, IParsable<Half>, IPowerFunctions<Half>, IRootFunctions<Half>, ISignedNumber<Half>, ISpanFormattable, ISpanParsable<Half>, ISubtractionOperators<Half, Half, Half>, ITrigonometricFunctions<Half>, IUnaryNegationOperators<Half, Half>, IUnaryPlusOperators<Half, Half> {
+        public static Half Lerp(Half value1, Half value2, Half amount);
     }
     public static class MemoryExtensions {
+        public static int Count<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>?;
+        public static int Count<T>(this ReadOnlySpan<T> span, T value) where T : IEquatable<T>?;
+        public static int Count<T>(this Span<T> span, ReadOnlySpan<T> value) where T : IEquatable<T>?;
+        public static int Count<T>(this Span<T> span, T value) where T : IEquatable<T>?;
+        public static int IndexOfAny<T>(this ReadOnlySpan<T> span, IndexOfAnyValues<T> values) where T : IEquatable<T>?;
+        public static int IndexOfAny<T>(this Span<T> span, IndexOfAnyValues<T> values) where T : IEquatable<T>?;
+        public static int IndexOfAnyExcept<T>(this ReadOnlySpan<T> span, IndexOfAnyValues<T> values) where T : IEquatable<T>?;
+        public static int IndexOfAnyExcept<T>(this Span<T> span, IndexOfAnyValues<T> values) where T : IEquatable<T>?;
+        public static int IndexOfAnyExceptInRange<T>(this ReadOnlySpan<T> span, T lowInclusive, T highInclusive) where T : IComparable<T>;
+        public static int IndexOfAnyExceptInRange<T>(this Span<T> span, T lowInclusive, T highInclusive) where T : IComparable<T>;
+        public static int IndexOfAnyInRange<T>(this ReadOnlySpan<T> span, T lowInclusive, T highInclusive) where T : IComparable<T>;
+        public static int IndexOfAnyInRange<T>(this Span<T> span, T lowInclusive, T highInclusive) where T : IComparable<T>;
+        public static int LastIndexOfAny<T>(this ReadOnlySpan<T> span, IndexOfAnyValues<T> values) where T : IEquatable<T>?;
+        public static int LastIndexOfAny<T>(this Span<T> span, IndexOfAnyValues<T> values) where T : IEquatable<T>?;
+        public static int LastIndexOfAnyExcept<T>(this ReadOnlySpan<T> span, IndexOfAnyValues<T> values) where T : IEquatable<T>?;
+        public static int LastIndexOfAnyExcept<T>(this Span<T> span, IndexOfAnyValues<T> values) where T : IEquatable<T>?;
+        public static int LastIndexOfAnyExceptInRange<T>(this ReadOnlySpan<T> span, T lowInclusive, T highInclusive) where T : IComparable<T>;
+        public static int LastIndexOfAnyExceptInRange<T>(this Span<T> span, T lowInclusive, T highInclusive) where T : IComparable<T>;
+        public static int LastIndexOfAnyInRange<T>(this ReadOnlySpan<T> span, T lowInclusive, T highInclusive) where T : IComparable<T>;
+        public static int LastIndexOfAnyInRange<T>(this Span<T> span, T lowInclusive, T highInclusive) where T : IComparable<T>;
+        public static void Replace<T>(this Span<T> span, T oldValue, T newValue) where T : IEquatable<T>?;
+        public static int Split(this ReadOnlySpan<char> source, Span<Range> destination, char separator, StringSplitOptions options = StringSplitOptions.None);
+        public static int Split(this ReadOnlySpan<char> source, Span<Range> destination, ReadOnlySpan<char> separator, StringSplitOptions options = StringSplitOptions.None);
+        public static int SplitAny(this ReadOnlySpan<char> source, Span<Range> destination, ReadOnlySpan<char> separators, StringSplitOptions options = StringSplitOptions.None);
+        public static int SplitAny(this ReadOnlySpan<char> source, Span<Range> destination, ReadOnlySpan<string> separators, StringSplitOptions options = StringSplitOptions.None);
+        public static bool TryWrite(this Span<char> destination, IFormatProvider? provider, CompositeFormat format, out int charsWritten, params object?[] args);
+        public static bool TryWrite(this Span<char> destination, IFormatProvider? provider, CompositeFormat format, out int charsWritten, ReadOnlySpan<object?> args);
+        public static bool TryWrite<TArg0, TArg1, TArg2>(this Span<char> destination, IFormatProvider? provider, CompositeFormat format, out int charsWritten, TArg0 arg0, TArg1 arg1, TArg2 arg2);
+        public static bool TryWrite<TArg0, TArg1>(this Span<char> destination, IFormatProvider? provider, CompositeFormat format, out int charsWritten, TArg0 arg0, TArg1 arg1);
+        public static bool TryWrite<TArg0>(this Span<char> destination, IFormatProvider? provider, CompositeFormat format, out int charsWritten, TArg0 arg0);
     }
     public class Random {
+        public T[] GetItems<T>(ReadOnlySpan<T> choices, int length);
+        public void GetItems<T>(ReadOnlySpan<T> choices, Span<T> destination);
+        public T[] GetItems<T>(T[] choices, int length);
+        public void Shuffle<T>(Span<T> values);
+        public void Shuffle<T>(T[] values);
     }
     public readonly struct Single : IAdditionOperators<float, float, float>, IAdditiveIdentity<float, float>, IBinaryFloatingPointIeee754<float>, IBinaryNumber<float>, IBitwiseOperators<float, float, float>, IComparable, IComparable<float>, IComparisonOperators<float, float, bool>, IConvertible, IDecrementOperators<float>, IDivisionOperators<float, float, float>, IEqualityOperators<float, float, bool>, IEquatable<float>, IExponentialFunctions<float>, IFloatingPoint<float>, IFloatingPointConstants<float>, IFloatingPointIeee754<float>, IFormattable, IHyperbolicFunctions<float>, IIncrementOperators<float>, ILogarithmicFunctions<float>, IMinMaxValue<float>, IModulusOperators<float, float, float>, IMultiplicativeIdentity<float, float>, IMultiplyOperators<float, float, float>, INumber<float>, INumberBase<float>, IParsable<float>, IPowerFunctions<float>, IRootFunctions<float>, ISignedNumber<float>, ISpanFormattable, ISpanParsable<float>, ISubtractionOperators<float, float, float>, ITrigonometricFunctions<float>, IUnaryNegationOperators<float, float>, IUnaryPlusOperators<float, float> {
+        public static float Lerp(float value1, float value2, float amount);
     }
     public sealed class String : ICloneable, IComparable, IComparable<string?>, IConvertible, IEnumerable, IEnumerable<char>, IEquatable<string?> {
+        public static string Format(IFormatProvider? provider, CompositeFormat format, params object?[] args);
+        public static string Format(IFormatProvider? provider, CompositeFormat format, ReadOnlySpan<object?> args);
+        public static string Format<TArg0, TArg1, TArg2>(IFormatProvider? provider, CompositeFormat format, TArg0 arg0, TArg1 arg1, TArg2 arg2);
+        public static string Format<TArg0, TArg1>(IFormatProvider? provider, CompositeFormat format, TArg0 arg0, TArg1 arg1);
+        public static string Format<TArg0>(IFormatProvider? provider, CompositeFormat format, TArg0 arg0);
     }
     public readonly struct TimeOnly : IComparable, IComparable<TimeOnly>, IEquatable<TimeOnly>, IFormattable, IParsable<TimeOnly>, ISpanFormattable, ISpanParsable<TimeOnly> {
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        public void Deconstruct(out int hour, out int minute);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        public void Deconstruct(out int hour, out int minute, out int second);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        public void Deconstruct(out int hour, out int minute, out int second, out int millisecond);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        public void Deconstruct(out int hour, out int minute, out int second, out int millisecond, out int microsecond);
     }
 }
```

