# System.Resources

``` diff
 namespace System.Resources {
     public sealed class ResXDataNode : ISerializable {
-        public ResXDataNode(string name, object value);
+        public ResXDataNode(string name, object? value);
-        public ResXDataNode(string name, object value, Func<Type, string> typeNameConverter);
+        public ResXDataNode(string name, object? value, Func<Type?, string>? typeNameConverter);
-        public ResXDataNode(string name, ResXFileRef fileRef, Func<Type, string> typeNameConverter);
+        public ResXDataNode(string name, ResXFileRef fileRef, Func<Type?, string>? typeNameConverter);
-        public string Comment { get; set; }
+        [AllowNullAttribute]
+        public string Comment { get; set; }
-        public object GetValue(AssemblyName[] names);
+        public object? GetValue(AssemblyName[] names);
-        public string GetValueTypeName(AssemblyName[] names);
+        public string? GetValueTypeName(AssemblyName[] names);
     }
     [TypeConverterAttribute(typeof(ResXFileRef.Converter))]
     public class ResXFileRef {
-        public Encoding TextFileEncoding { get; }
+        public Encoding? TextFileEncoding { get; }
         public class Converter : TypeConverter {
-            public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+            public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
         }
     }
     public class ResXResourceReader : IDisposable, IEnumerable, IResourceReader {
-        public ResXResourceReader(string fileName, ITypeResolutionService typeResolver);
+        public ResXResourceReader(string fileName, ITypeResolutionService? typeResolver);
-        public string BasePath { get; set; }
+        public string? BasePath { get; set; }
-        public static ResXResourceReader FromFileContents(string fileContents, ITypeResolutionService typeResolver);
+        public static ResXResourceReader FromFileContents(string fileContents, ITypeResolutionService? typeResolver);
     }
     public class ResXResourceWriter : IDisposable, IResourceWriter {
-        public ResXResourceWriter(Stream stream, Func<Type, string> typeNameConverter);
+        public ResXResourceWriter(Stream stream, Func<Type?, string> typeNameConverter);
-        public ResXResourceWriter(TextWriter textWriter, Func<Type, string> typeNameConverter);
+        public ResXResourceWriter(TextWriter textWriter, Func<Type?, string> typeNameConverter);
-        public ResXResourceWriter(string fileName, Func<Type, string> typeNameConverter);
+        public ResXResourceWriter(string fileName, Func<Type?, string> typeNameConverter);
-        public string BasePath { get; set; }
+        public string? BasePath { get; set; }
-        public virtual void AddAlias(string aliasName, AssemblyName assemblyName);
+        public virtual void AddAlias(string? aliasName, AssemblyName assemblyName);
-        public void AddMetadata(string name, object value);
+        public void AddMetadata(string name, object? value);
-        public void AddMetadata(string name, string value);
+        public void AddMetadata(string name, string? value);
-        public void AddResource(string name, byte[] value);
+        public void AddResource(string name, byte[]? value);
-        public void AddResource(string name, object value);
+        public void AddResource(string name, object? value);
-        public void AddResource(string name, string value);
+        public void AddResource(string name, string? value);
     }
 }
```

