# System.Security.Cryptography.Xml

``` diff
 namespace System.Security.Cryptography.Xml {
     public sealed class CipherData {
-        public CipherReference CipherReference { get; set; }
+        [DisallowNullAttribute]
+        public CipherReference CipherReference { get; set; }
-        public byte[] CipherValue { get; set; }
+        [DisallowNullAttribute]
+        public byte[] CipherValue { get; set; }
     }
     public sealed class EncryptedKey : EncryptedType {
-        public string CarriedKeyName { get; set; }
+        public string? CarriedKeyName { get; set; }
-        public string Recipient { get; set; }
+        [AllowNullAttribute]
+        public string Recipient { get; set; }
     }
     public abstract class EncryptedReference {
-        protected string ReferenceType { get; set; }
+        protected string? ReferenceType { get; set; }
     }
     public abstract class EncryptedType {
-        public KeyInfo KeyInfo { get; set; }
+        [AllowNullAttribute]
+        public KeyInfo KeyInfo { get; set; }
     }
     public class EncryptedXml {
-        public EncryptedXml(XmlDocument document, Evidence evidence);
+        public EncryptedXml(XmlDocument document, Evidence? evidence);
-        public Evidence DocumentEvidence { get; set; }
+        public Evidence? DocumentEvidence { get; set; }
-        public string Recipient { get; set; }
+        [AllowNullAttribute]
+        public string Recipient { get; set; }
-        public XmlResolver Resolver { get; set; }
+        public XmlResolver? Resolver { get; set; }
-        public virtual byte[] DecryptEncryptedKey(EncryptedKey encryptedKey);
+        public virtual byte[]? DecryptEncryptedKey(EncryptedKey encryptedKey);
-        public virtual byte[] GetDecryptionIV(EncryptedData encryptedData, string symmetricAlgorithmUri);
+        public virtual byte[] GetDecryptionIV(EncryptedData encryptedData, string? symmetricAlgorithmUri);
-        public virtual SymmetricAlgorithm GetDecryptionKey(EncryptedData encryptedData, string symmetricAlgorithmUri);
+        public virtual SymmetricAlgorithm? GetDecryptionKey(EncryptedData encryptedData, string? symmetricAlgorithmUri);
-        public virtual XmlElement GetIdElement(XmlDocument document, string idValue);
+        public virtual XmlElement? GetIdElement(XmlDocument document, string idValue);
     }
     public sealed class EncryptionProperty {
-        public XmlElement PropertyElement { get; set; }
+        [DisallowNullAttribute]
+        public XmlElement PropertyElement { get; set; }
     }
     public sealed class EncryptionPropertyCollection : ICollection, IEnumerable, IList {
-        object System.Collections.IList.this[int index] { get; set; }
+        object? IList.this[int index] { get; set; }
     }
     public class KeyInfo : IEnumerable {
-        public string Id { get; set; }
+        public string? Id { get; set; }
     }
     public class KeyInfoEncryptedKey : KeyInfoClause {
-        public EncryptedKey EncryptedKey { get; set; }
+        public EncryptedKey? EncryptedKey { get; set; }
     }
     public class KeyInfoNode : KeyInfoClause {
-        public XmlElement Value { get; set; }
+        public XmlElement? Value { get; set; }
     }
     public sealed class ReferenceList : ICollection, IEnumerable, IList {
-        bool System.Collections.IList.IsFixedSize { get; }
+        bool IList.IsFixedSize { get; }
-        bool System.Collections.IList.IsReadOnly { get; }
+        bool IList.IsReadOnly { get; }
-        object System.Collections.IList.this[int index] { get; set; }
+        object? IList.this[int index] { get; set; }
-        public int Add(object value);
+        public int Add(object? value);
-        public bool Contains(object value);
+        public bool Contains(object? value);
-        public int IndexOf(object value);
+        public int IndexOf(object? value);
-        public void Insert(int index, object value);
+        public void Insert(int index, object? value);
-        public EncryptedReference Item(int index);
+        public EncryptedReference? Item(int index);
-        public void Remove(object value);
+        public void Remove(object? value);
     }
     public class Signature {
-        public string Id { get; set; }
+        public string? Id { get; set; }
-        public byte[] SignatureValue { get; set; }
+        public byte[]? SignatureValue { get; set; }
-        public SignedInfo SignedInfo { get; set; }
+        public SignedInfo? SignedInfo { get; set; }
     }
     public class SignedInfo : ICollection, IEnumerable {
-        public string CanonicalizationMethod { get; set; }
+        [AllowNullAttribute]
+        public string CanonicalizationMethod { get; set; }
-        public string Id { get; set; }
+        public string? Id { get; set; }
-        public string SignatureLength { get; set; }
+        public string? SignatureLength { get; set; }
-        public string SignatureMethod { get; set; }
+        public string? SignatureMethod { get; set; }
     }
     public class SignedXml {
-        protected string m_strSigningKeyName;
+        protected string? m_strSigningKeyName;
-        public EncryptedXml EncryptedXml { get; set; }
+        [AllowNullAttribute]
+        public EncryptedXml EncryptedXml { get; set; }
-        public string SignatureLength { get; }
+        public string? SignatureLength { get; }
-        public string SignatureMethod { get; }
+        public string? SignatureMethod { get; }
-        public byte[] SignatureValue { get; }
+        public byte[]? SignatureValue { get; }
-        public SignedInfo SignedInfo { get; }
+        public SignedInfo? SignedInfo { get; }
-        public AsymmetricAlgorithm SigningKey { get; set; }
+        public AsymmetricAlgorithm? SigningKey { get; set; }
-        public string SigningKeyName { get; set; }
+        public string? SigningKeyName { get; set; }
-        public bool CheckSignatureReturningKey(out AsymmetricAlgorithm signingKey);
+        public bool CheckSignatureReturningKey(out AsymmetricAlgorithm? signingKey);
-        public virtual XmlElement GetIdElement(XmlDocument document, string idValue);
+        public virtual XmlElement? GetIdElement(XmlDocument? document, string idValue);
-        protected virtual AsymmetricAlgorithm GetPublicKey();
+        protected virtual AsymmetricAlgorithm? GetPublicKey();
     }
     public abstract class Transform {
-        public string Algorithm { get; set; }
+        public string? Algorithm { get; set; }
-        public XmlElement Context { get; set; }
+        public XmlElement? Context { get; set; }
-        public XmlResolver Resolver { set; }
+        public XmlResolver? Resolver { set; }
-        protected abstract XmlNodeList GetInnerXml();
+        protected abstract XmlNodeList? GetInnerXml();
     }
     public class XmlDecryptionTransform : Transform {
-        protected override XmlNodeList GetInnerXml();
+        protected override XmlNodeList? GetInnerXml();
-        protected virtual bool IsTargetElement(XmlElement inputElement, string idValue);
+        protected virtual bool IsTargetElement(XmlElement? inputElement, string idValue);
     }
     public class XmlDsigBase64Transform : Transform {
-        protected override XmlNodeList GetInnerXml();
+        protected override XmlNodeList? GetInnerXml();
     }
     public class XmlDsigC14NTransform : Transform {
-        protected override XmlNodeList GetInnerXml();
+        protected override XmlNodeList? GetInnerXml();
     }
     public class XmlDsigEnvelopedSignatureTransform : Transform {
-        protected override XmlNodeList GetInnerXml();
+        protected override XmlNodeList? GetInnerXml();
     }
     public class XmlDsigExcC14NTransform : Transform {
-        public XmlDsigExcC14NTransform(bool includeComments, string inclusiveNamespacesPrefixList);
+        public XmlDsigExcC14NTransform(bool includeComments, string? inclusiveNamespacesPrefixList);
-        public string InclusiveNamespacesPrefixList { get; set; }
+        public string? InclusiveNamespacesPrefixList { get; set; }
-        protected override XmlNodeList GetInnerXml();
+        protected override XmlNodeList? GetInnerXml();
     }
     public class XmlDsigXPathTransform : Transform {
-        protected override XmlNodeList GetInnerXml();
+        protected override XmlNodeList? GetInnerXml();
     }
     public class XmlDsigXsltTransform : Transform {
-        protected override XmlNodeList GetInnerXml();
+        protected override XmlNodeList? GetInnerXml();
     }
     public class XmlLicenseTransform : Transform {
-        public IRelDecryptor Decryptor { get; set; }
+        public IRelDecryptor? Decryptor { get; set; }
-        protected override XmlNodeList GetInnerXml();
+        protected override XmlNodeList? GetInnerXml();
     }
 }
```

