# System.Windows.Forms

``` diff
 namespace System.Windows.Forms {
-    public class AccessibleObject : StandardOleMarshalObject, IAccessible, Interop.Ole32.IOleWindow, Interop.Ole32.IServiceProvider, Interop.Oleaut32.IEnumVariant, Interop.UiaCore.IAccessibleEx, Interop.UiaCore.IExpandCollapseProvider, Interop.UiaCore.IGridItemProvider, Interop.UiaCore.IGridProvider, Interop.UiaCore.IInvokeProvider, Interop.UiaCore.ILegacyIAccessibleProvider, Interop.UiaCore.IMultipleViewProvider, Interop.UiaCore.IRangeValueProvider, Interop.UiaCore.IRawElementProviderFragment, Interop.UiaCore.IRawElementProviderFragmentRoot, Interop.UiaCore.IRawElementProviderHwndOverride, Interop.UiaCore.IRawElementProviderSimple, Interop.UiaCore.IScrollItemProvider, Interop.UiaCore.ISelectionItemProvider, Interop.UiaCore.ISelectionProvider, Interop.UiaCore.ITableItemProvider, Interop.UiaCore.ITableProvider, Interop.UiaCore.ITextProvider, Interop.UiaCore.ITextProvider2, Interop.UiaCore.IToggleProvider, Interop.UiaCore.IValueProvider, IReflect
+    public class AccessibleObject : StandardOleMarshalObject, IAccessible, Interop.Oleaut32.IEnumVariant, Interop.UiaCore.IAccessibleEx, Interop.UiaCore.IExpandCollapseProvider, Interop.UiaCore.IGridItemProvider, Interop.UiaCore.IGridProvider, Interop.UiaCore.IInvokeProvider, Interop.UiaCore.ILegacyIAccessibleProvider, Interop.UiaCore.IMultipleViewProvider, Interop.UiaCore.IRangeValueProvider, Interop.UiaCore.IRawElementProviderFragment, Interop.UiaCore.IRawElementProviderFragmentRoot, Interop.UiaCore.IRawElementProviderHwndOverride, Interop.UiaCore.IRawElementProviderSimple, Interop.UiaCore.IScrollItemProvider, Interop.UiaCore.ISelectionItemProvider, Interop.UiaCore.ISelectionProvider, Interop.UiaCore.ITableItemProvider, Interop.UiaCore.ITableProvider, Interop.UiaCore.ITextProvider, Interop.UiaCore.ITextProvider2, Interop.UiaCore.IToggleProvider, Interop.UiaCore.IValueProvider, IOleWindow.Interface, IReflect, IServiceProvider.Interface
     public sealed class Application {
-        public static string CompanyName { get; }
+        public static string? CompanyName { get; }
-        public static string ProductName { get; }
+        public static string? ProductName { get; }
-        public static event EventHandler ApplicationExit;
+        public static event EventHandler? ApplicationExit;
-        [EditorBrowsableAttribute(2)]
-        public static event EventHandler EnterThreadModal;
+        [EditorBrowsableAttribute(2)]
+        public static event EventHandler? EnterThreadModal;
-        public static event EventHandler Idle;
+        public static event EventHandler? Idle;
-        [EditorBrowsableAttribute(2)]
-        public static event EventHandler LeaveThreadModal;
+        [EditorBrowsableAttribute(2)]
+        public static event EventHandler? LeaveThreadModal;
-        public static event ThreadExceptionEventHandler ThreadException;
+        public static event ThreadExceptionEventHandler? ThreadException;
-        public static event EventHandler ThreadExit;
+        public static event EventHandler? ThreadExit;
-        public static void AddMessageFilter(IMessageFilter value);
+        public static void AddMessageFilter(IMessageFilter? value);
-        [EditorBrowsableAttribute(2)]
-        public static void Exit(CancelEventArgs e);
+        [EditorBrowsableAttribute(2)]
+        public static void Exit(CancelEventArgs? e);
-        [EditorBrowsableAttribute(2)]
-        public static void RegisterMessageLoop(Application.MessageLoopCallback callback);
+        [EditorBrowsableAttribute(2)]
+        public static void RegisterMessageLoop(Application.MessageLoopCallback? callback);
     }
     [DefaultEventAttribute("Enter")]
     [DesignTimeVisibleAttribute(false)]
     [DesignerAttribute("System.Windows.Forms.Design.AxHostDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [ToolboxItemAttribute(false)]
     public abstract class AxHost : Control, ICustomTypeDescriptor, ISupportInitialize {
-        [TypeConverterAttribute(typeof(TypeConverter))]
-        public class State : ISerializable {
+        [TypeConverterAttribute(typeof(TypeConverter))]
+        public class State : IDisposable, ISerializable {
+            public void Dispose();
+            protected virtual void Dispose(bool disposing);
-            void ISerializable.GetObjectData(SerializationInfo si, StreamingContext context);
+            void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
         }
     }
     [DefaultEventAttribute("CollectionChanged")]
     public class BindingContext : ICollection, IEnumerable {
-        int System.Collections.ICollection.Count { get; }
+        int ICollection.Count { get; }
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
-        public BindingManagerBase this[object dataSource, string dataMember] { get; }
+        public BindingManagerBase this[object dataSource, string? dataMember] { get; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        [SRDescriptionAttribute("collectionChangedEventDescr")]
-        public event CollectionChangeEventHandler CollectionChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [SRDescriptionAttribute("collectionChangedEventDescr")]
+        public event CollectionChangeEventHandler? CollectionChanged;
-        public bool Contains(object dataSource, string dataMember);
+        public bool Contains(object dataSource, string? dataMember);
-        public static void UpdateBinding(BindingContext newBindingContext, Binding binding);
+        public static void UpdateBinding(BindingContext? newBindingContext, Binding binding);
     }
     public struct BindingMemberInfo : IEquatable<BindingMemberInfo> {
-        public BindingMemberInfo(string dataMember);
+        public BindingMemberInfo(string? dataMember);
-        public override bool Equals(object otherObject);
+        public override bool Equals(object? otherObject);
     }
-    [DefaultEventAttribute("Click")]
-    [DefaultPropertyAttribute("Text")]
-    [DesignerAttribute("System.Windows.Forms.Design.ControlDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
-    [DesignerSerializerAttribute("System.Windows.Forms.Design.ControlCodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.ComponentModel.Design.Serialization.CodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
-    [ToolboxItemFilterAttribute("System.Windows.Forms")]
-    public class Control : Component, IArrangedElement, IBindableComponent, IComponent, IDisposable, IDropTarget, IHandle, IKeyboardToolTip, Interop.Ole32.IOleControl, Interop.Ole32.IOleInPlaceActiveObject, Interop.Ole32.IOleInPlaceObject, Interop.Ole32.IOleObject, Interop.Ole32.IOleWindow, Interop.Ole32.IPersist, Interop.Ole32.IPersistStorage, Interop.Ole32.IPersistStreamInit, Interop.Ole32.IQuickActivate, Interop.Ole32.IViewObject, Interop.Ole32.IViewObject2, Interop.Oleaut32.IPersistPropertyBag, ISupportOleDropSource, ISynchronizeInvoke, IWin32Window {
+    [DefaultEventAttribute("Click")]
+    [DefaultPropertyAttribute("Text")]
+    [DesignerAttribute("System.Windows.Forms.Design.ControlDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    [DesignerSerializerAttribute("System.Windows.Forms.Design.ControlCodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.ComponentModel.Design.Serialization.CodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    [ToolboxItemFilterAttribute("System.Windows.Forms")]
+    public class Control : Component, IArrangedElement, IBindableComponent, IComponent, IDisposable, IDropTarget, IHandle, IHandle<HWND>, IKeyboardToolTip, IOleControl.Interface, IOleInPlaceActiveObject.Interface, IOleInPlaceObject.Interface, IOleObject.Interface, IOleWindow.Interface, IPersist.Interface, IPersistPropertyBag.Interface, IPersistStorage.Interface, IPersistStreamInit.Interface, IQuickActivate.Interface, ISupportOleDropSource, ISynchronizeInvoke, IViewObject.Interface, IViewObject2.Interface, IWin32Window {
-        [EditorBrowsableAttribute(2)]
-        protected void InvokeGotFocus(Control toInvoke, EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected void InvokeGotFocus(Control? toInvoke, EventArgs e);
-        [EditorBrowsableAttribute(2)]
-        protected void InvokeLostFocus(Control toInvoke, EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected void InvokeLostFocus(Control? toInvoke, EventArgs e);
-        [EditorBrowsableAttribute(2)]
-        protected void InvokeOnClick(Control toInvoke, EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected void InvokeOnClick(Control? toInvoke, EventArgs e);
     }
     public class DataGridViewTextBoxEditingControl : TextBox, IDataGridViewEditingControl {
-        protected override void OnGotFocus(EventArgs e);
     }
     [DefaultBindingPropertyAttribute("SelectedItem")]
     [DefaultEventAttribute("SelectedItemChanged")]
     [DefaultPropertyAttribute("Items")]
     [SRDescriptionAttribute("DescriptionDomainUpDown")]
     public class DomainUpDown : UpDownBase {
-        protected override AccessibleObject CreateAccessibilityInstance();
-        [EditorBrowsableAttribute(1)]
-        [ObsoleteAttribute("DomainUpDownAccessibleObject is no longer used to provide accessible support for DomainUpDown controls.", false, DiagnosticId="WFDEV002", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
-        public class DomainUpDownAccessibleObject : Control.ControlAccessibleObject
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("DomainUpDownAccessibleObject is no longer used to provide accessible support for DomainUpDown controls. Use ControlAccessibleObject instead.", true, DiagnosticId="WFDEV002", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        public class DomainUpDownAccessibleObject : Control.ControlAccessibleObject
     }
     public class DragEventArgs : EventArgs {
-        public DragEventArgs(IDataObject? data, int keyState, int x, int y, DragDropEffects allowedEffect, DragDropEffects effect, DropImageType dropImageType, string message, string messageReplacementToken);
+        public DragEventArgs(IDataObject data, int keyState, int x, int y, DragDropEffects allowedEffect, DragDropEffects effect, DropImageType dropImageType, string message, string messageReplacementToken);
     }
     [ComplexBindingPropertiesAttribute("DataSource", "DataMember")]
     [ProvidePropertyAttribute("Error", typeof(Control))]
     [ProvidePropertyAttribute("IconAlignment", typeof(Control))]
     [ProvidePropertyAttribute("IconPadding", typeof(Control))]
     [SRDescriptionAttribute("DescriptionErrorProvider")]
     [ToolboxItemFilterAttribute("System.Windows.Forms")]
     public class ErrorProvider : Component, IExtenderProvider, ISupportInitialize {
-        [DefaultValueAttribute(null)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ErrorProviderContainerControlDescr")]
-        public ContainerControl ContainerControl { get; set; }
+        [DefaultValueAttribute(null)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ErrorProviderContainerControlDescr")]
+        public ContainerControl? ContainerControl { get; set; }
-        [DefaultValueAttribute(null)]
-        [EditorAttribute("System.Windows.Forms.Design.DataMemberListEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ErrorProviderDataMemberDescr")]
-        public string DataMember { get; set; }
+        [DefaultValueAttribute(null)]
+        [EditorAttribute("System.Windows.Forms.Design.DataMemberListEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ErrorProviderDataMemberDescr")]
+        public string? DataMember { get; set; }
-        [AttributeProviderAttribute(typeof(IListSource))]
-        [DefaultValueAttribute(null)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ErrorProviderDataSourceDescr")]
-        public object DataSource { get; set; }
+        [AttributeProviderAttribute(typeof(IListSource))]
+        [DefaultValueAttribute(null)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ErrorProviderDataSourceDescr")]
+        public object? DataSource { get; set; }
-        public override ISite Site { set; }
+        public override ISite? Site { set; }
-        [BindableAttribute(true)]
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(false)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ControlTagDescr")]
-        [TypeConverterAttribute(typeof(StringConverter))]
-        public object Tag { get; set; }
+        [BindableAttribute(true)]
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(false)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ControlTagDescr")]
+        [TypeConverterAttribute(typeof(StringConverter))]
+        public object? Tag { get; set; }
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("ControlOnRightToLeftChangedDescr")]
-        public event EventHandler RightToLeftChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("ControlOnRightToLeftChangedDescr")]
+        public event EventHandler? RightToLeftChanged;
-        public void BindToDataAndErrors(object newDataSource, string newDataMember);
+        public void BindToDataAndErrors(object? newDataSource, string? newDataMember);
-        public bool CanExtend(object extendee);
+        public bool CanExtend(object? extendee);
-        public void SetError(Control control, string value);
+        public void SetError(Control control, string? value);
     }
     [DefaultEventAttribute("HelpRequest")]
     [DefaultPropertyAttribute("SelectedPath")]
     [DesignerAttribute("System.Windows.Forms.Design.FolderBrowserDialogDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionFolderBrowserDialog")]
     public sealed class FolderBrowserDialog : CommonDialog {
         protected override bool RunDialog(IntPtr hWndOwner);
     }
     public static class Help {
-        public static void ShowPopup(Control parent, string caption, Point location);
+        public static void ShowPopup(Control? parent, string caption, Point location);
     }
     [ProvidePropertyAttribute("HelpKeyword", typeof(Control))]
     [ProvidePropertyAttribute("HelpNavigator", typeof(Control))]
     [ProvidePropertyAttribute("HelpString", typeof(Control))]
     [ProvidePropertyAttribute("ShowHelp", typeof(Control))]
     [SRDescriptionAttribute("DescriptionHelpProvider")]
     [ToolboxItemFilterAttribute("System.Windows.Forms")]
     public class HelpProvider : Component, IExtenderProvider {
-        [DefaultValueAttribute(null)]
-        [EditorAttribute("System.Windows.Forms.Design.HelpNamespaceEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [LocalizableAttribute(true)]
-        [SRDescriptionAttribute("HelpProviderHelpNamespaceDescr")]
-        public virtual string HelpNamespace { get; set; }
+        [DefaultValueAttribute(null)]
+        [EditorAttribute("System.Windows.Forms.Design.HelpNamespaceEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [LocalizableAttribute(true)]
+        [SRDescriptionAttribute("HelpProviderHelpNamespaceDescr")]
+        public virtual string? HelpNamespace { get; set; }
-        [BindableAttribute(true)]
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(false)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ControlTagDescr")]
-        [TypeConverterAttribute(typeof(StringConverter))]
-        public object Tag { get; set; }
+        [BindableAttribute(true)]
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(false)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ControlTagDescr")]
+        [TypeConverterAttribute(typeof(StringConverter))]
+        public object? Tag { get; set; }
-        public virtual bool CanExtend(object target);
+        public virtual bool CanExtend(object? target);
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(true)]
-        [SRDescriptionAttribute("HelpProviderHelpKeywordDescr")]
-        public virtual string GetHelpKeyword(Control ctl);
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(true)]
+        [SRDescriptionAttribute("HelpProviderHelpKeywordDescr")]
+        public virtual string? GetHelpKeyword(Control ctl);
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(true)]
-        [SRDescriptionAttribute("HelpProviderHelpStringDescr")]
-        public virtual string GetHelpString(Control ctl);
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(true)]
+        [SRDescriptionAttribute("HelpProviderHelpStringDescr")]
+        public virtual string? GetHelpString(Control ctl);
-        public virtual void SetHelpKeyword(Control ctl, string keyword);
+        public virtual void SetHelpKeyword(Control ctl, string? keyword);
-        public virtual void SetHelpString(Control ctl, string helpString);
+        public virtual void SetHelpString(Control ctl, string? helpString);
     }
     [DefaultEventAttribute("LinkClicked")]
     [SRDescriptionAttribute("DescriptionLinkLabel")]
     [ToolboxItemAttribute("System.Windows.Forms.Design.AutoSizeToolboxItem,System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public class LinkLabel : Label, IButtonControl {
-        protected Cursor OverrideCursor { get; set; }
+        protected Cursor? OverrideCursor { get; set; }
-        DialogResult System.Windows.Forms.IButtonControl.DialogResult { get; set; }
+        DialogResult IButtonControl.DialogResult { get; set; }
-        [RefreshPropertiesAttribute(2)]
-        public override string Text { get; set; }
+        [RefreshPropertiesAttribute(2)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [SRDescriptionAttribute("LinkLabelLinkClickedDescr")]
-        [WinCategoryAttribute("Action")]
-        public event LinkLabelLinkClickedEventHandler LinkClicked;
+        [SRDescriptionAttribute("LinkLabelLinkClickedDescr")]
+        [WinCategoryAttribute("Action")]
+        public event LinkLabelLinkClickedEventHandler? LinkClicked;
-        [BrowsableAttribute(true)]
-        [EditorBrowsableAttribute(0)]
-        public new event EventHandler TabStopChanged;
+        [BrowsableAttribute(true)]
+        [EditorBrowsableAttribute(0)]
+        public new event EventHandler? TabStopChanged;
-        protected LinkLabel.Link PointInLink(int x, int y);
+        protected LinkLabel.Link? PointInLink(int x, int y);
         [TypeConverterAttribute(typeof(LinkConverter))]
         public class Link {
-            [DefaultValueAttribute("")]
-            [SRCategoryAttribute("CatAppearance")]
-            [SRDescriptionAttribute("TreeNodeNodeNameDescr")]
-            public string Name { get; set; }
+            [DefaultValueAttribute("")]
+            [SRCategoryAttribute("CatAppearance")]
+            [SRDescriptionAttribute("TreeNodeNodeNameDescr")]
+            [AllowNullAttribute]
+            public string Name { get; set; }
         }
         public class LinkCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object? IList.this[int index] { get; set; }
-            public virtual LinkLabel.Link this[string key] { get; }
+            public virtual LinkLabel.Link? this[string key] { get; }
-            public LinkLabel.Link Add(int start, int length, object linkData);
+            public LinkLabel.Link Add(int start, int length, object? linkData);
-            public virtual bool ContainsKey(string key);
+            public virtual bool ContainsKey(string? key);
-            public virtual int IndexOfKey(string key);
+            public virtual int IndexOfKey(string? key);
-            public virtual void RemoveByKey(string key);
+            public virtual void RemoveByKey(string? key);
-            int IList.Add(object value);
+            int IList.Add(object? value);
-            bool IList.Contains(object link);
+            bool IList.Contains(object? value);
-            int IList.IndexOf(object link);
+            int IList.IndexOf(object? value);
-            void IList.Insert(int index, object value);
+            void IList.Insert(int index, object? value);
-            void IList.Remove(object value);
+            void IList.Remove(object? value);
         }
     }
     [DefaultBindingPropertyAttribute("Text")]
     [DefaultEventAttribute("MaskInputRejected")]
     [DefaultPropertyAttribute("Mask")]
     [DesignerAttribute("System.Windows.Forms.Design.MaskedTextBoxDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionMaskedTextBox")]
     public class MaskedTextBox : TextBoxBase {
+        protected override AccessibleObject CreateAccessibilityInstance();
+        protected override void OnGotFocus(EventArgs e);
+        protected override void OnMouseDown(MouseEventArgs e);
     }
     public class MessageBox {
-        public static DialogResult Show(string text, string caption, MessageBoxButtons buttons, MessageBoxIcon icon, MessageBoxDefaultButton defaultButton, MessageBoxOptions options, string helpFilePath, string keyword);
+        public static DialogResult Show(string? text, string? caption, MessageBoxButtons buttons, MessageBoxIcon icon, MessageBoxDefaultButton defaultButton, MessageBoxOptions options, string helpFilePath, string keyword);
     }
     [DefaultBindingPropertyAttribute("SelectionRange")]
     [DefaultEventAttribute("DateChanged")]
     [DefaultPropertyAttribute("SelectionRange")]
     [DesignerAttribute("System.Windows.Forms.Design.MonthCalendarDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionMonthCalendar")]
     public class MonthCalendar : Control {
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override Image BackgroundImage { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public override Image? BackgroundImage { get; set; }
-        [BindableAttribute(false)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BindableAttribute(false)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackgroundImageChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackgroundImageChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackgroundImageLayoutChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackgroundImageLayoutChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler Click;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? Click;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("MonthCalendarOnDateChangedDescr")]
-        public event DateRangeEventHandler DateChanged;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("MonthCalendarOnDateChangedDescr")]
+        public event DateRangeEventHandler? DateChanged;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("MonthCalendarOnDateSelectedDescr")]
-        public event DateRangeEventHandler DateSelected;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("MonthCalendarOnDateSelectedDescr")]
+        public event DateRangeEventHandler? DateSelected;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler DoubleClick;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? DoubleClick;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler ImeModeChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? ImeModeChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event MouseEventHandler MouseClick;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event MouseEventHandler? MouseClick;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event MouseEventHandler MouseDoubleClick;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event MouseEventHandler? MouseDoubleClick;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler PaddingChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? PaddingChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event PaintEventHandler Paint;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event PaintEventHandler? Paint;
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("ControlOnRightToLeftLayoutChangedDescr")]
-        public event EventHandler RightToLeftLayoutChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("ControlOnRightToLeftLayoutChangedDescr")]
+        public event EventHandler? RightToLeftLayoutChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler TextChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? TextChanged;
     }
     public class NativeWindow : MarshalByRefObject, IHandle, IWin32Window {
+        protected virtual void WmDpiChangedAfterParent(ref Message m);
+        protected virtual void WmDpiChangedBeforeParent(ref Message m);
     }
     [DefaultPropertyAttribute("Document")]
     [SRDescriptionAttribute("DescriptionPrintPreviewControl")]
     public class PrintPreviewControl : Control {
-        [DefaultValueAttribute(null)]
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("PrintPreviewDocumentDescr")]
-        public PrintDocument? Document { get; set; }
+        [DefaultValueAttribute(null)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("PrintPreviewDocumentDescr")]
+        public PrintDocument Document { get; set; }
+        [BrowsableAttribute(false)]
+        [DefaultValueAttribute(false)]
+        [DispIdAttribute(-516)]
+        [EditorBrowsableAttribute(1)]
+        public new bool TabStop { get; set; }
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("RadioButtonOnStartPageChangedDescr")]
-        public event EventHandler? StartPageChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("RadioButtonOnStartPageChangedDescr")]
+        public event EventHandler StartPageChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler TabStopChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler? TextChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler TextChanged;
     }
-    [DesignerAttribute("System.Windows.Forms.Design.PropertyGridDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
-    [SRDescriptionAttribute("DescriptionPropertyGrid")]
-    public class PropertyGrid : ContainerControl, IComPropertyBrowser, Interop.Ole32.IPropertyNotifySink
+    [DesignerAttribute("System.Windows.Forms.Design.PropertyGridDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    [SRDescriptionAttribute("DescriptionPropertyGrid")]
+    public class PropertyGrid : ContainerControl, IComPropertyBrowser, IPropertyNotifySink.Interface
     [DefaultEventAttribute("Scroll")]
     [DefaultPropertyAttribute("Value")]
     public abstract class ScrollBar : Control {
-        protected override void RescaleConstantsForDpi(int deviceDpiOld, int deviceDpiNew);
+        protected override void ScaleControl(SizeF factor, BoundsSpecified specified);
     }
     [SRDescriptionAttribute("DescriptionStatusStrip")]
     public class StatusStrip : ToolStrip {
-        [BrowsableAttribute(false)]
-        public new event EventHandler PaddingChanged;
+        [BrowsableAttribute(false)]
+        public new event EventHandler? PaddingChanged;
-        protected internal override ToolStripItem CreateDefaultItem(string text, Image image, EventHandler onClick);
+        protected internal override ToolStripItem CreateDefaultItem(string? text, Image? image, EventHandler? onClick);
     }
     [EditorAttribute("System.Windows.Forms.Design.StyleCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
     public abstract class TableLayoutStyleCollection : ICollection, IEnumerable, IList {
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
-        bool System.Collections.IList.IsFixedSize { get; }
+        bool IList.IsFixedSize { get; }
-        bool System.Collections.IList.IsReadOnly { get; }
+        bool IList.IsReadOnly { get; }
-        object System.Collections.IList.this[int index] { get; set; }
+        object? IList.this[int index] { get; set; }
-        int IList.Add(object style);
+        int IList.Add(object? style);
-        bool IList.Contains(object style);
+        bool IList.Contains(object? style);
-        int IList.IndexOf(object style);
+        int IList.IndexOf(object? style);
-        void IList.Insert(int index, object style);
+        void IList.Insert(int index, object? style);
-        void IList.Remove(object style);
+        void IList.Remove(object? style);
     }
     [DesignerAttribute("System.Windows.Forms.Design.TextBoxDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionTextBox")]
     public class TextBox : TextBoxBase {
+        protected override AccessibleObject CreateAccessibilityInstance();
     }
     [DefaultBindingPropertyAttribute("Text")]
     [DefaultEventAttribute("TextChanged")]
     [DesignerAttribute("System.Windows.Forms.Design.TextBoxBaseDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public abstract class TextBoxBase : Control {
+        protected bool ContainsNavigationKeyCode(Keys keyCode);
     }
     [DefaultEventAttribute("ItemClicked")]
     [DefaultPropertyAttribute("Items")]
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DesignerSerializerAttribute("System.Windows.Forms.Design.ToolStripCodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.ComponentModel.Design.Serialization.CodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionToolStrip")]
     public class ToolStrip : ScrollableControl, IArrangedElement, IComponent, IDisposable, ISupportToolStripPanel {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        public override Cursor Cursor { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [AllowNullAttribute]
+        public override Cursor Cursor { get; set; }
-        public override Font Font { get; set; }
+        [AllowNullAttribute]
+        public override Font Font { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        public ToolStripRenderer Renderer { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [AllowNullAttribute]
+        public ToolStripRenderer Renderer { get; set; }
     }
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.ToolStrip)]
     public class ToolStripButton : ToolStripItem {
-        public override bool CanSelect { get; }
     }
     [DefaultPropertyAttribute("Items")]
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.ContextMenuStrip | ToolStripItemDesignerAvailability.MenuStrip | ToolStripItemDesignerAvailability.ToolStrip)]
     public class ToolStripComboBox : ToolStripControlHost {
-        public ToolStripComboBox(string name);
+        public ToolStripComboBox(string? name);
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override Image BackgroundImage { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        public override Image? BackgroundImage { get; set; }
-        [BindableAttribute(true)]
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRDescriptionAttribute("ComboBoxSelectedItemDescr")]
-        public object SelectedItem { get; set; }
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRDescriptionAttribute("ComboBoxSelectedItemDescr")]
+        public object? SelectedItem { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler DoubleClick;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? DoubleClick;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ComboBoxOnDropDownDescr")]
-        public event EventHandler DropDown;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ComboBoxOnDropDownDescr")]
+        public event EventHandler? DropDown;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ComboBoxOnDropDownClosedDescr")]
-        public event EventHandler DropDownClosed;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ComboBoxOnDropDownClosedDescr")]
+        public event EventHandler? DropDownClosed;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ComboBoxDropDownStyleChangedDescr")]
-        public event EventHandler DropDownStyleChanged;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ComboBoxDropDownStyleChangedDescr")]
+        public event EventHandler? DropDownStyleChanged;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("selectedIndexChangedEventDescr")]
-        public event EventHandler SelectedIndexChanged;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("selectedIndexChangedEventDescr")]
+        public event EventHandler? SelectedIndexChanged;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ComboBoxOnTextUpdateDescr")]
-        public event EventHandler TextUpdate;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ComboBoxOnTextUpdateDescr")]
+        public event EventHandler? TextUpdate;
-        public int FindString(string s);
+        public int FindString(string? s);
-        public int FindString(string s, int startIndex);
+        public int FindString(string? s, int startIndex);
-        public int FindStringExact(string s);
+        public int FindStringExact(string? s);
-        public int FindStringExact(string s, int startIndex);
+        public int FindStringExact(string? s, int startIndex);
-        protected override void OnSubscribeControlEvents(Control control);
+        protected override void OnSubscribeControlEvents(Control? control);
-        protected override void OnUnsubscribeControlEvents(Control control);
+        protected override void OnUnsubscribeControlEvents(Control? control);
     }
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripDropDownDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public class ToolStripDropDown : ToolStrip {
-        public override Font Font { get; set; }
+        [AllowNullAttribute]
+        public override Font Font { get; set; }
     }
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.StatusStrip | ToolStripItemDesignerAvailability.ToolStrip)]
     public class ToolStripDropDownButton : ToolStripDropDownItem {
-        public ToolStripDropDownButton(Image image);
+        public ToolStripDropDownButton(Image? image);
-        public ToolStripDropDownButton(string text);
+        public ToolStripDropDownButton(string? text);
-        public ToolStripDropDownButton(string text, Image image);
+        public ToolStripDropDownButton(string? text, Image? image);
-        public ToolStripDropDownButton(string text, Image image, EventHandler onClick);
+        public ToolStripDropDownButton(string? text, Image? image, EventHandler? onClick);
-        public ToolStripDropDownButton(string text, Image image, EventHandler onClick, string name);
+        public ToolStripDropDownButton(string? text, Image? image, EventHandler? onClick, string? name);
-        public ToolStripDropDownButton(string text, Image image, params ToolStripItem[] dropDownItems);
+        public ToolStripDropDownButton(string? text, Image? image, params ToolStripItem[]? dropDownItems);
     }
     [DefaultPropertyAttribute("DropDownItems")]
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripMenuItemDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public abstract class ToolStripDropDownItem : ToolStripItem {
-        protected ToolStripDropDownItem(string text, Image image, EventHandler onClick);
+        protected ToolStripDropDownItem(string? text, Image? image, EventHandler? onClick);
-        protected ToolStripDropDownItem(string text, Image image, EventHandler onClick, string name);
+        protected ToolStripDropDownItem(string? text, Image? image, EventHandler? onClick, string? name);
-        protected ToolStripDropDownItem(string text, Image image, params ToolStripItem[] dropDownItems);
+        protected ToolStripDropDownItem(string? text, Image? image, params ToolStripItem[]? dropDownItems);
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ToolStripDropDownDescr")]
-        [TypeConverterAttribute(typeof(ReferenceConverter))]
-        public ToolStripDropDown DropDown { get; set; }
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ToolStripDropDownDescr")]
+        [TypeConverterAttribute(typeof(ReferenceConverter))]
+        [AllowNullAttribute]
+        public ToolStripDropDown DropDown { get; set; }
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("ToolStripDropDownClosedDecr")]
-        public event EventHandler DropDownClosed;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("ToolStripDropDownClosedDecr")]
+        public event EventHandler? DropDownClosed;
-        [SRCategoryAttribute("CatAction")]
-        public event ToolStripItemClickedEventHandler DropDownItemClicked;
+        [SRCategoryAttribute("CatAction")]
+        public event ToolStripItemClickedEventHandler? DropDownItemClicked;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("ToolStripDropDownOpenedDescr")]
-        public event EventHandler DropDownOpened;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("ToolStripDropDownOpenedDescr")]
+        public event EventHandler? DropDownOpened;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("ToolStripDropDownOpeningDescr")]
-        public event EventHandler DropDownOpening;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("ToolStripDropDownOpeningDescr")]
+        public event EventHandler? DropDownOpening;
     }
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripDropDownDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public class ToolStripDropDownMenu : ToolStripDropDown {
-        protected internal override ToolStripItem CreateDefaultItem(string text, Image image, EventHandler onClick);
+        protected internal override ToolStripItem CreateDefaultItem(string? text, Image? image, EventHandler? onClick);
     }
     [DefaultEventAttribute("Click")]
     [DefaultPropertyAttribute("Text")]
     [DesignTimeVisibleAttribute(false)]
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripItemDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [ToolboxItemAttribute(false)]
     public abstract class ToolStripItem : BindableComponent, IArrangedElement, ICommandBindingTargetProvider, IComponent, IDisposable, IDropTarget, IKeyboardToolTip, ISupportOleDropSource {
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripItemFontDescr")]
-        public virtual Font Font { get; set; }
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripItemFontDescr")]
+        [AllowNullAttribute]
+        public virtual Font Font { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorAttribute("System.Windows.Forms.Design.ToolStripImageIndexEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [LocalizableAttribute(true)]
-        [RefreshPropertiesAttribute(2)]
-        [RelatedImageListAttribute("Owner.ImageList")]
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ToolStripItemImageKeyDescr")]
-        [TypeConverterAttribute(typeof(ImageKeyConverter))]
-        public string ImageKey { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorAttribute("System.Windows.Forms.Design.ToolStripImageIndexEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [LocalizableAttribute(true)]
+        [RefreshPropertiesAttribute(2)]
+        [RelatedImageListAttribute("Owner.ImageList")]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ToolStripItemImageKeyDescr")]
+        [TypeConverterAttribute(typeof(ImageKeyConverter))]
+        [AllowNullAttribute]
+        public string ImageKey { get; set; }
-        [EditorBrowsableAttribute(2)]
-        public DragDropEffects DoDragDrop(object data, DragDropEffects allowedEffects, Bitmap dragImage, Point cursorOffset, bool useDefaultDragImage);
+        [EditorBrowsableAttribute(2)]
+        public DragDropEffects DoDragDrop(object data, DragDropEffects allowedEffects, Bitmap? dragImage, Point cursorOffset, bool useDefaultDragImage);
     }
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.ToolStrip)]
     public class ToolStripLabel : ToolStripItem {
-        public ToolStripLabel(Image image);
+        public ToolStripLabel(Image? image);
-        public ToolStripLabel(string text);
+        public ToolStripLabel(string? text);
-        public ToolStripLabel(string text, Image image);
+        public ToolStripLabel(string? text, Image? image);
-        public ToolStripLabel(string text, Image image, bool isLink);
+        public ToolStripLabel(string? text, Image? image, bool isLink);
-        public ToolStripLabel(string text, Image image, bool isLink, EventHandler onClick);
+        public ToolStripLabel(string? text, Image? image, bool isLink, EventHandler? onClick);
-        public ToolStripLabel(string text, Image image, bool isLink, EventHandler onClick, string name);
+        public ToolStripLabel(string? text, Image? image, bool isLink, EventHandler? onClick, string? name);
     }
     [DesignerSerializerAttribute("System.Windows.Forms.Design.ToolStripMenuItemCodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.ComponentModel.Design.Serialization.CodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.ContextMenuStrip | ToolStripItemDesignerAvailability.MenuStrip)]
     public class ToolStripMenuItem : ToolStripDropDownItem {
-        public ToolStripMenuItem(Image image);
+        public ToolStripMenuItem(Image? image);
-        public ToolStripMenuItem(string text);
+        public ToolStripMenuItem(string? text);
-        public ToolStripMenuItem(string text, Image image);
+        public ToolStripMenuItem(string? text, Image? image);
-        public ToolStripMenuItem(string text, Image image, EventHandler onClick);
+        public ToolStripMenuItem(string? text, Image? image, EventHandler? onClick);
-        public ToolStripMenuItem(string text, Image image, EventHandler onClick, string name);
+        public ToolStripMenuItem(string? text, Image? image, EventHandler? onClick, string? name);
-        public ToolStripMenuItem(string text, Image image, EventHandler onClick, Keys shortcutKeys);
+        public ToolStripMenuItem(string? text, Image? image, EventHandler? onClick, Keys shortcutKeys);
-        public ToolStripMenuItem(string text, Image image, params ToolStripItem[] dropDownItems);
+        public ToolStripMenuItem(string? text, Image? image, params ToolStripItem[]? dropDownItems);
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripMenuItemShortcutKeyDisplayStringDescr")]
-        public string ShortcutKeyDisplayString { get; set; }
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripMenuItemShortcutKeyDisplayStringDescr")]
+        public string? ShortcutKeyDisplayString { get; set; }
-        [SRDescriptionAttribute("CheckBoxOnCheckedChangedDescr")]
-        public event EventHandler CheckedChanged;
+        [SRDescriptionAttribute("CheckBoxOnCheckedChangedDescr")]
+        public event EventHandler? CheckedChanged;
-        [SRDescriptionAttribute("CheckBoxOnCheckStateChangedDescr")]
-        public event EventHandler CheckStateChanged;
+        [SRDescriptionAttribute("CheckBoxOnCheckStateChangedDescr")]
+        public event EventHandler? CheckStateChanged;
     }
     [DefaultPropertyAttribute("Value")]
     public class ToolStripProgressBar : ToolStripControlHost {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
     }
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.ContextMenuStrip | ToolStripItemDesignerAvailability.ToolStrip)]
     public class ToolStripSeparator : ToolStripItem {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override Font Font { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override Font Font { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public new string ImageKey { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public new string ImageKey { get; set; }
     }
     [DefaultEventAttribute("ButtonClick")]
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.StatusStrip | ToolStripItemDesignerAvailability.ToolStrip)]
     public class ToolStripSplitButton : ToolStripDropDownItem {
-        public ToolStripSplitButton(Image image);
+        public ToolStripSplitButton(Image? image);
-        public ToolStripSplitButton(string text);
+        public ToolStripSplitButton(string? text);
-        public ToolStripSplitButton(string text, Image image);
+        public ToolStripSplitButton(string? text, Image? image);
-        public ToolStripSplitButton(string text, Image image, EventHandler onClick);
+        public ToolStripSplitButton(string? text, Image? image, EventHandler? onClick);
-        public ToolStripSplitButton(string text, Image image, EventHandler onClick, string name);
+        public ToolStripSplitButton(string? text, Image? image, EventHandler? onClick, string? name);
-        public ToolStripSplitButton(string text, Image image, params ToolStripItem[] dropDownItems);
+        public ToolStripSplitButton(string? text, Image? image, params ToolStripItem[]? dropDownItems);
-        [BrowsableAttribute(false)]
-        [DefaultValueAttribute(null)]
-        public ToolStripItem DefaultItem { get; set; }
+        [BrowsableAttribute(false)]
+        [DefaultValueAttribute(null)]
+        public ToolStripItem? DefaultItem { get; set; }
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("ToolStripSplitButtonOnButtonClickDescr")]
-        public event EventHandler ButtonClick;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("ToolStripSplitButtonOnButtonClickDescr")]
+        public event EventHandler? ButtonClick;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("ToolStripSplitButtonOnButtonDoubleClickDescr")]
-        public event EventHandler ButtonDoubleClick;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("ToolStripSplitButtonOnButtonDoubleClickDescr")]
+        public event EventHandler? ButtonDoubleClick;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("ToolStripSplitButtonOnDefaultItemChangedDescr")]
-        public event EventHandler DefaultItemChanged;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("ToolStripSplitButtonOnDefaultItemChangedDescr")]
+        public event EventHandler? DefaultItemChanged;
     }
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.StatusStrip)]
     public class ToolStripStatusLabel : ToolStripLabel, IAutomationLiveRegion {
-        public ToolStripStatusLabel(Image image);
+        public ToolStripStatusLabel(Image? image);
-        public ToolStripStatusLabel(string text);
+        public ToolStripStatusLabel(string? text);
-        public ToolStripStatusLabel(string text, Image image);
+        public ToolStripStatusLabel(string? text, Image? image);
-        public ToolStripStatusLabel(string text, Image image, EventHandler onClick);
+        public ToolStripStatusLabel(string? text, Image? image, EventHandler? onClick);
-        public ToolStripStatusLabel(string text, Image image, EventHandler onClick, string name);
+        public ToolStripStatusLabel(string? text, Image? image, EventHandler? onClick, string? name);
     }
     [ToolStripItemDesignerAvailabilityAttribute(ToolStripItemDesignerAvailability.ContextMenuStrip | ToolStripItemDesignerAvailability.MenuStrip | ToolStripItemDesignerAvailability.ToolStrip)]
     public class ToolStripTextBox : ToolStripControlHost {
-        public ToolStripTextBox(string name);
+        public ToolStripTextBox(string? name);
-        [BrowsableAttribute(true)]
-        [DesignerSerializationVisibilityAttribute(2)]
-        [EditorAttribute("System.Windows.Forms.Design.ListControlStringCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [EditorBrowsableAttribute(0)]
-        [LocalizableAttribute(true)]
-        [SRDescriptionAttribute("TextBoxAutoCompleteCustomSourceDescr")]
-        public AutoCompleteStringCollection AutoCompleteCustomSource { get; set; }
+        [BrowsableAttribute(true)]
+        [DesignerSerializationVisibilityAttribute(2)]
+        [EditorAttribute("System.Windows.Forms.Design.ListControlStringCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [EditorBrowsableAttribute(0)]
+        [LocalizableAttribute(true)]
+        [SRDescriptionAttribute("TextBoxAutoCompleteCustomSourceDescr")]
+        [AllowNullAttribute]
+        public AutoCompleteStringCollection AutoCompleteCustomSource { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override Image BackgroundImage { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        public override Image? BackgroundImage { get; set; }
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorAttribute("System.Windows.Forms.Design.StringArrayEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("TextBoxLinesDescr")]
-        public string[] Lines { get; set; }
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorAttribute("System.Windows.Forms.Design.StringArrayEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("TextBoxLinesDescr")]
+        [AllowNullAttribute]
+        public string[] Lines { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("TextBoxSelectedTextDescr")]
-        public string SelectedText { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("TextBoxSelectedTextDescr")]
+        [AllowNullAttribute]
+        public string SelectedText { get; set; }
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("TextBoxBaseOnAcceptsTabChangedDescr")]
-        public event EventHandler AcceptsTabChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("TextBoxBaseOnAcceptsTabChangedDescr")]
+        public event EventHandler? AcceptsTabChanged;
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("TextBoxBaseOnBorderStyleChangedDescr")]
-        public event EventHandler BorderStyleChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("TextBoxBaseOnBorderStyleChangedDescr")]
+        public event EventHandler? BorderStyleChanged;
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("TextBoxBaseOnHideSelectionChangedDescr")]
-        public event EventHandler HideSelectionChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("TextBoxBaseOnHideSelectionChangedDescr")]
+        public event EventHandler? HideSelectionChanged;
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("TextBoxBaseOnModifiedChangedDescr")]
-        public event EventHandler ModifiedChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("TextBoxBaseOnModifiedChangedDescr")]
+        public event EventHandler? ModifiedChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("TextBoxBaseOnMultilineChangedDescr")]
-        public event EventHandler MultilineChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("TextBoxBaseOnMultilineChangedDescr")]
+        public event EventHandler? MultilineChanged;
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("TextBoxBaseOnReadOnlyChangedDescr")]
-        public event EventHandler ReadOnlyChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("TextBoxBaseOnReadOnlyChangedDescr")]
+        public event EventHandler? ReadOnlyChanged;
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("ToolStripTextBoxTextBoxTextAlignChangedDescr")]
-        public event EventHandler TextBoxTextAlignChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("ToolStripTextBoxTextBoxTextAlignChangedDescr")]
+        public event EventHandler? TextBoxTextAlignChanged;
-        public void AppendText(string text);
+        public void AppendText(string? text);
-        protected override void OnSubscribeControlEvents(Control control);
+        protected override void OnSubscribeControlEvents(Control? control);
-        protected override void OnUnsubscribeControlEvents(Control control);
+        protected override void OnUnsubscribeControlEvents(Control? control);
     }
-    public class WebBrowserSiteBase : IDisposable, Interop.Ole32.IOleClientSite, Interop.Ole32.IOleControlSite, Interop.Ole32.IOleInPlaceSite, Interop.Ole32.IPropertyNotifySink, Interop.Ole32.ISimpleFrameSite
+    public class WebBrowserSiteBase : IDisposable, IOleClientSite.Interface, IOleControlSite.Interface, IOleInPlaceSite.Interface, IOleWindow.Interface, IPropertyNotifySink.Interface, ISimpleFrameSite.Interface
 }
```

