# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
     public sealed class DefaultEndpointFilterInvocationContext : EndpointFilterInvocationContext {
-        public DefaultEndpointFilterInvocationContext(HttpContext httpContext, params object[] arguments);
+        public DefaultEndpointFilterInvocationContext(HttpContext httpContext, params object?[] arguments);
     }
-    [JsonConverterAttribute(typeof(HttpValidationProblemDetailsJsonConverter))]
-    public class HttpValidationProblemDetails : ProblemDetails {
+    public class HttpValidationProblemDetails : ProblemDetails {
-        public IDictionary<string, string[]> Errors { get; }
+        public IDictionary<string, string[]> Errors { get; set; }
     }
     public interface IProblemDetailsService {
+        ValueTask<bool> TryWriteAsync(ProblemDetailsContext context);
     }
     public static class Results {
+        public static IResult AcceptedAtRoute(string routeName, RouteValueDictionary routeValues, object value = null);
+        public static IResult AcceptedAtRoute<TValue>(string routeName, RouteValueDictionary routeValues, TValue value = null);
+        public static IResult CreatedAtRoute(string routeName, RouteValueDictionary routeValues, object value = null);
+        public static IResult CreatedAtRoute<TValue>(string routeName, RouteValueDictionary routeValues, TValue value = null);
-        public static IResult Json(object data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext.")]
+        public static IResult Json(object data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        public static IResult Json(object? data, JsonTypeInfo jsonTypeInfo, string? contentType = null, int? statusCode = default(int?));
+        public static IResult Json(object? data, Type type, JsonSerializerContext context, string? contentType = null, int? statusCode = default(int?));
-        public static IResult Json<TValue>(TValue data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext.")]
+        public static IResult Json<TValue>(TValue data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        public static IResult Json<TValue>(TValue data, JsonSerializerContext context, string contentType = null, int? statusCode = default(int?));
+        public static IResult Json<TValue>(TValue data, JsonTypeInfo<TValue> jsonTypeInfo, string contentType = null, int? statusCode = default(int?));
+        public static IResult RedirectToRoute(string routeName, RouteValueDictionary routeValues, bool permanent = false, bool preserveMethod = false, string fragment = null);
     }
     public static class StatusCodes {
+        public const int Status499ClientClosedRequest = 499;
     }
     public static class TypedResults {
+        public static AcceptedAtRoute AcceptedAtRoute(string routeName, RouteValueDictionary routeValues);
+        public static AcceptedAtRoute<TValue> AcceptedAtRoute<TValue>(TValue value, string routeName, RouteValueDictionary routeValues);
+        public static CreatedAtRoute CreatedAtRoute(string routeName, RouteValueDictionary routeValues);
+        public static CreatedAtRoute<TValue> CreatedAtRoute<TValue>(TValue value, string routeName, RouteValueDictionary routeValues);
-        public static JsonHttpResult<TValue> Json<TValue>(TValue data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext.")]
+        public static JsonHttpResult<TValue> Json<TValue>(TValue data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        public static JsonHttpResult<TValue> Json<TValue>(TValue data, JsonSerializerContext context, string contentType = null, int? statusCode = default(int?));
+        public static JsonHttpResult<TValue> Json<TValue>(TValue data, JsonTypeInfo<TValue> jsonTypeInfo, string contentType = null, int? statusCode = default(int?));
+        public static RedirectToRouteHttpResult RedirectToRoute(string routeName, RouteValueDictionary routeValues, bool permanent = false, bool preserveMethod = false, string fragment = null);
     }
 }
```

