# Microsoft.AspNetCore.Mvc

``` diff
 namespace Microsoft.AspNetCore.Mvc {
-    [JsonConverterAttribute(typeof(ProblemDetailsJsonConverter))]
-    public class ProblemDetails {
+    public class ProblemDetails {
-        [JsonPropertyNameAttribute("detail")]
-        public string Detail { get; set; }
+        [JsonIgnoreAttribute(Condition=3)]
+        [JsonPropertyOrderAttribute(-2)]
+        public string Detail { get; set; }
-        [JsonExtensionDataAttribute]
-        public IDictionary<string, object?> Extensions { get; }
+        [JsonExtensionDataAttribute]
+        public IDictionary<string, object?> Extensions { get; set; }
-        [JsonPropertyNameAttribute("instance")]
-        public string Instance { get; set; }
+        [JsonIgnoreAttribute(Condition=3)]
+        [JsonPropertyOrderAttribute(-1)]
+        public string Instance { get; set; }
-        [JsonPropertyNameAttribute("status")]
-        public int? Status { get; set; }
+        [JsonIgnoreAttribute(Condition=3)]
+        [JsonPropertyOrderAttribute(-3)]
+        public int? Status { get; set; }
-        [JsonPropertyNameAttribute("title")]
-        public string Title { get; set; }
+        [JsonIgnoreAttribute(Condition=3)]
+        [JsonPropertyOrderAttribute(-4)]
+        public string Title { get; set; }
-        [JsonPropertyNameAttribute("type")]
-        public string Type { get; set; }
+        [JsonIgnoreAttribute(Condition=3)]
+        [JsonPropertyOrderAttribute(-5)]
+        public string Type { get; set; }
     }
-    [JsonConverterAttribute(typeof(ValidationProblemDetailsJsonConverter))]
-    public class ValidationProblemDetails : HttpValidationProblemDetails {
+    public class ValidationProblemDetails : HttpValidationProblemDetails {
-        public new IDictionary<string, string[]> Errors { get; }
+        public new IDictionary<string, string[]> Errors { get; set; }
     }
 }
```

