# System.Buffers.Binary

``` diff
 namespace System.Buffers.Binary {
     public static class BinaryPrimitives {
+        public static Int128 ReadInt128BigEndian(ReadOnlySpan<byte> source);
+        public static Int128 ReadInt128LittleEndian(ReadOnlySpan<byte> source);
+        public static IntPtr ReadIntPtrBigEndian(ReadOnlySpan<byte> source);
+        public static IntPtr ReadIntPtrLittleEndian(ReadOnlySpan<byte> source);
+        [CLSCompliantAttribute(false)]
+        public static UInt128 ReadUInt128BigEndian(ReadOnlySpan<byte> source);
+        [CLSCompliantAttribute(false)]
+        public static UInt128 ReadUInt128LittleEndian(ReadOnlySpan<byte> source);
+        [CLSCompliantAttribute(false)]
+        public static UIntPtr ReadUIntPtrBigEndian(ReadOnlySpan<byte> source);
+        [CLSCompliantAttribute(false)]
+        public static UIntPtr ReadUIntPtrLittleEndian(ReadOnlySpan<byte> source);
+        public static bool TryReadInt128BigEndian(ReadOnlySpan<byte> source, out Int128 value);
+        public static bool TryReadInt128LittleEndian(ReadOnlySpan<byte> source, out Int128 value);
+        public static bool TryReadIntPtrBigEndian(ReadOnlySpan<byte> source, out IntPtr value);
+        public static bool TryReadIntPtrLittleEndian(ReadOnlySpan<byte> source, out IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static bool TryReadUInt128BigEndian(ReadOnlySpan<byte> source, out UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static bool TryReadUInt128LittleEndian(ReadOnlySpan<byte> source, out UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static bool TryReadUIntPtrBigEndian(ReadOnlySpan<byte> source, out UIntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static bool TryReadUIntPtrLittleEndian(ReadOnlySpan<byte> source, out UIntPtr value);
+        public static bool TryWriteInt128BigEndian(Span<byte> destination, Int128 value);
+        public static bool TryWriteInt128LittleEndian(Span<byte> destination, Int128 value);
+        public static bool TryWriteIntPtrBigEndian(Span<byte> destination, IntPtr value);
+        public static bool TryWriteIntPtrLittleEndian(Span<byte> destination, IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static bool TryWriteUInt128BigEndian(Span<byte> destination, UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static bool TryWriteUInt128LittleEndian(Span<byte> destination, UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static bool TryWriteUIntPtrBigEndian(Span<byte> destination, UIntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static bool TryWriteUIntPtrLittleEndian(Span<byte> destination, UIntPtr value);
+        public static void WriteInt128BigEndian(Span<byte> destination, Int128 value);
+        public static void WriteInt128LittleEndian(Span<byte> destination, Int128 value);
+        public static void WriteIntPtrBigEndian(Span<byte> destination, IntPtr value);
+        public static void WriteIntPtrLittleEndian(Span<byte> destination, IntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static void WriteUInt128BigEndian(Span<byte> destination, UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static void WriteUInt128LittleEndian(Span<byte> destination, UInt128 value);
+        [CLSCompliantAttribute(false)]
+        public static void WriteUIntPtrBigEndian(Span<byte> destination, UIntPtr value);
+        [CLSCompliantAttribute(false)]
+        public static void WriteUIntPtrLittleEndian(Span<byte> destination, UIntPtr value);
     }
 }
```

