# System.ComponentModel.DataAnnotations

``` diff
 namespace System.ComponentModel.DataAnnotations {
+    [AttributeUsageAttribute(AttributeTargets.Field | AttributeTargets.Parameter | AttributeTargets.Property, AllowMultiple=false)]
+    [CLSCompliantAttribute(false)]
+    public class AllowedValuesAttribute : ValidationAttribute {
+        public AllowedValuesAttribute(params object?[] values);
+        public object?[] Values { get; }
+        public override bool IsValid(object? value);
+    }
+    [AttributeUsageAttribute(AttributeTargets.Field | AttributeTargets.Parameter | AttributeTargets.Property, AllowMultiple=false)]
+    public class Base64StringAttribute : ValidationAttribute {
+        public Base64StringAttribute();
+        public override bool IsValid(object? value);
+    }
+    [AttributeUsageAttribute(AttributeTargets.Field | AttributeTargets.Parameter | AttributeTargets.Property, AllowMultiple=false)]
+    [CLSCompliantAttribute(false)]
+    public class DeniedValuesAttribute : ValidationAttribute {
+        public DeniedValuesAttribute(params object?[] values);
+        public object?[] Values { get; }
+        public override bool IsValid(object? value);
+    }
+    [AttributeUsageAttribute(AttributeTargets.Field | AttributeTargets.Parameter | AttributeTargets.Property, AllowMultiple=false)]
+    public class LengthAttribute : ValidationAttribute {
+        [RequiresUnreferencedCodeAttribute("Uses reflection to get the 'Count' property on types that don't implement ICollection. This 'Count' property may be trimmed. Ensure it is preserved.")]
+        public LengthAttribute(int minimumLength, int maximumLength);
+        public int MaximumLength { get; }
+        public int MinimumLength { get; }
+        public override string FormatErrorMessage(string name);
+        public override bool IsValid(object? value);
+    }
     [AttributeUsageAttribute(AttributeTargets.Field | AttributeTargets.Parameter | AttributeTargets.Property, AllowMultiple=false)]
     public class RangeAttribute : ValidationAttribute {
+        public bool MaximumIsExclusive { get; set; }
+        public bool MinimumIsExclusive { get; set; }
     }
     [AttributeUsageAttribute(AttributeTargets.Field | AttributeTargets.Parameter | AttributeTargets.Property, AllowMultiple=false)]
     public class RequiredAttribute : ValidationAttribute {
+        public bool DisallowAllDefaultValues { get; set; }
     }
 }
```

