# System.Windows.Forms

``` diff
 namespace System.Windows.Forms {
     public class BaseCollection : MarshalByRefObject, ICollection, IEnumerable {
-        protected virtual ArrayList List { get; }
+        protected virtual ArrayList? List { get; }
     }
     [DefaultEventAttribute("CollectionChanged")]
     public class BindingsCollection : BaseCollection {
-        [SRDescriptionAttribute("collectionChangedEventDescr")]
-        public event CollectionChangeEventHandler CollectionChanged;
+        [SRDescriptionAttribute("collectionChangedEventDescr")]
+        public event CollectionChangeEventHandler? CollectionChanged;
-        [SRDescriptionAttribute("collectionChangingEventDescr")]
-        public event CollectionChangeEventHandler CollectionChanging;
+        [SRDescriptionAttribute("collectionChangingEventDescr")]
+        public event CollectionChangeEventHandler? CollectionChanging;
     }
     [ComplexBindingPropertiesAttribute("DataSource", "DataMember")]
     [DefaultEventAttribute("CellContentClick")]
     [DesignerAttribute("System.Windows.Forms.Design.DataGridViewDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DockingAttribute(DockingBehavior.Ask)]
     [EditorAttribute("System.Windows.Forms.Design.DataGridViewComponentEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(ComponentEditor))]
     [SRDescriptionAttribute("DescriptionDataGridView")]
     public class DataGridView : Control, ISupportInitialize {
         public class DataGridViewControlCollection : Control.ControlCollection {
-            public override void Remove(Control value);
+            public override void Remove(Control? value);
         }
     }
     [AttributeUsageAttribute(4)]
     public sealed class DataGridViewColumnDesignTimeVisibleAttribute : Attribute {
-        public override bool Equals(object obj);
+        public override bool Equals(object? obj);
     }
     [TypeConverterAttribute(typeof(DataGridViewRowConverter))]
     public class DataGridViewRow : DataGridViewBand {
-        [DefaultValueAttribute(22)]
-        [NotifyParentPropertyAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("DataGridView_RowHeightDescr")]
-        public int Height { get; set; }
+        [NotifyParentPropertyAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("DataGridView_RowHeightDescr")]
+        public int Height { get; set; }
     }
     [ListBindableAttribute(false)]
     public class DataGridViewSelectedColumnCollection : BaseCollection, ICollection, IEnumerable, IList {
-        int System.Collections.ICollection.Count { get; }
+        int ICollection.Count { get; }
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
-        bool System.Collections.IList.IsFixedSize { get; }
+        bool IList.IsFixedSize { get; }
-        bool System.Collections.IList.IsReadOnly { get; }
+        bool IList.IsReadOnly { get; }
-        object System.Collections.IList.this[int index] { get; set; }
+        object? IList.this[int index] { get; set; }
-        int IList.Add(object value);
+        int IList.Add(object? value);
-        bool IList.Contains(object value);
+        bool IList.Contains(object? value);
-        int IList.IndexOf(object value);
+        int IList.IndexOf(object? value);
-        void IList.Insert(int index, object value);
+        void IList.Insert(int index, object? value);
-        void IList.Remove(object value);
+        void IList.Remove(object? value);
     }
     [ListBindableAttribute(false)]
     public class DataGridViewSelectedRowCollection : BaseCollection, ICollection, IEnumerable, IList {
-        int System.Collections.ICollection.Count { get; }
+        int ICollection.Count { get; }
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
-        bool System.Collections.IList.IsFixedSize { get; }
+        bool IList.IsFixedSize { get; }
-        bool System.Collections.IList.IsReadOnly { get; }
+        bool IList.IsReadOnly { get; }
-        object System.Collections.IList.this[int index] { get; set; }
+        object? IList.this[int index] { get; set; }
-        int IList.Add(object value);
+        int IList.Add(object? value);
-        bool IList.Contains(object value);
+        bool IList.Contains(object? value);
-        int IList.IndexOf(object value);
+        int IList.IndexOf(object? value);
-        void IList.Insert(int index, object value);
+        void IList.Insert(int index, object? value);
-        void IList.Remove(object value);
+        void IList.Remove(object? value);
     }
     [DefaultBindingPropertyAttribute("SelectedValue")]
     [DefaultEventAttribute("SelectedIndexChanged")]
     [DefaultPropertyAttribute("Items")]
     [DesignerAttribute("System.Windows.Forms.Design.ListBoxDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionListBox")]
     public class ListBox : ListControl {
-        [DefaultValueAttribute(13)]
-        [LocalizableAttribute(true)]
-        [RefreshPropertiesAttribute(2)]
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ListBoxItemHeightDescr")]
-        public virtual int ItemHeight { get; set; }
+        [LocalizableAttribute(true)]
+        [RefreshPropertiesAttribute(2)]
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ListBoxItemHeightDescr")]
+        public virtual int ItemHeight { get; set; }
     }
     [DesignTimeVisibleAttribute(false)]
     [ToolboxItemAttribute(false)]
     public sealed class MdiClient : Control {
         public new class ControlCollection : Control.ControlCollection {
-            public override void Add(Control value);
+            public override void Add(Control? value);
-            public override void Remove(Control value);
+            public override void Remove(Control? value);
         }
     }
     [DesignerAttribute("System.Windows.Forms.Design.PropertyGridDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionPropertyGrid")]
     public class PropertyGrid : ContainerControl, IComPropertyBrowser, IPropertyNotifySink.Interface {
         public class PropertyTabCollection : ICollection, IEnumerable {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
         }
     }
     [DefaultEventAttribute("SelectedIndexChanged")]
     [DefaultPropertyAttribute("TabPages")]
     [DesignerAttribute("System.Windows.Forms.Design.TabControlDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionTabControl")]
     public class TabControl : Control {
         public new class ControlCollection : Control.ControlCollection {
-            public override void Add(Control value);
+            public override void Add(Control? value);
-            public override void Remove(Control value);
+            public override void Remove(Control? value);
         }
     }
     [TypeConverterAttribute(typeof(TableLayoutPanelCellPositionTypeConverter))]
     public struct TableLayoutPanelCellPosition : IEquatable<TableLayoutPanelCellPosition> {
-        public override bool Equals(object other);
+        public override bool Equals(object? other);
     }
     [EditorAttribute("System.Windows.Forms.Design.StyleCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
     public abstract class TableLayoutStyleCollection : ICollection, IEnumerable, IList {
-        object? IList.this[int index] { get; set; }
+        object IList.this[int index] { get; set; }
-        int IList.Add(object? style);
+        int IList.Add(object style);
-        bool IList.Contains(object? style);
+        bool IList.Contains(object style);
-        int IList.IndexOf(object? style);
+        int IList.IndexOf(object style);
-        void IList.Insert(int index, object? style);
+        void IList.Insert(int index, object style);
-        void IList.Remove(object? style);
+        void IList.Remove(object style);
     }
     [DefaultEventAttribute("Popup")]
     [ProvidePropertyAttribute("ToolTip", typeof(Control))]
     [SRDescriptionAttribute("DescriptionToolTip")]
     [ToolboxItemFilterAttribute("System.Windows.Forms")]
     public class ToolTip : Component, IExtenderProvider, IHandle, IHandle<HWND> {
-        [BindableAttribute(true)]
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(false)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ControlTagDescr")]
-        [TypeConverterAttribute(typeof(StringConverter))]
-        public object Tag { get; set; }
+        [BindableAttribute(true)]
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(false)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ControlTagDescr")]
+        [TypeConverterAttribute(typeof(StringConverter))]
+        public object? Tag { get; set; }
-        [DefaultValueAttribute("")]
-        [SRDescriptionAttribute("ToolTipTitleDescr")]
-        public string ToolTipTitle { get; set; }
+        [DefaultValueAttribute("")]
+        [SRDescriptionAttribute("ToolTipTitleDescr")]
+        [AllowNullAttribute]
+        public string ToolTipTitle { get; set; }
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ToolTipDrawEventDescr")]
-        public event DrawToolTipEventHandler Draw;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ToolTipDrawEventDescr")]
+        public event DrawToolTipEventHandler? Draw;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ToolTipPopupEventDescr")]
-        public event PopupEventHandler Popup;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ToolTipPopupEventDescr")]
+        public event PopupEventHandler? Popup;
     }
     public sealed class WindowsFormsSynchronizationContext : SynchronizationContext, IDisposable {
-        public override void Post(SendOrPostCallback d, object state);
+        public override void Post(SendOrPostCallback d, object? state);
-        public override void Send(SendOrPostCallback d, object state);
+        public override void Send(SendOrPostCallback d, object? state);
     }
 }
```

