# Microsoft.AspNetCore.Builder

``` diff
 namespace Microsoft.AspNetCore.Builder {
+    public class ComponentTypeMetadata {
+        public ComponentTypeMetadata(Type componentType);
+        public Type Type { get; }
+    }
     public static class CorsEndpointConventionBuilderExtensions {
+        public static TBuilder RequireCors<TBuilder>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder;
     }
+    public class RazorComponentEndpointConventionBuilder : IEndpointConventionBuilder {
+        public void Add(Action<EndpointBuilder> convention);
+        public void Finally(Action<EndpointBuilder> finallyConvention);
+    }
+    public static class RazorComponentsEndpointRouteBuilderExtensions {
+        public static RazorComponentEndpointConventionBuilder MapRazorComponents<TRootComponent>(this IEndpointRouteBuilder endpoints) where TRootComponent : IRazorComponentApplication<TRootComponent>;
+    }
+    public static class RequestTimeoutsIApplicationBuilderExtensions {
+        public static IApplicationBuilder UseRequestTimeouts(this IApplicationBuilder builder);
+    }
+    public static class RequestTimeoutsIEndpointConventionBuilderExtensions {
+        public static IEndpointConventionBuilder DisableRequestTimeout(this IEndpointConventionBuilder builder);
+        public static IEndpointConventionBuilder WithRequestTimeout(this IEndpointConventionBuilder builder, RequestTimeoutPolicy policy);
+        public static IEndpointConventionBuilder WithRequestTimeout(this IEndpointConventionBuilder builder, string policyName);
+        public static IEndpointConventionBuilder WithRequestTimeout(this IEndpointConventionBuilder builder, TimeSpan timeout);
+    }
+    public static class RouteShortCircuitEndpointConventionBuilderExtensions {
+        public static IEndpointConventionBuilder ShortCircuit(this IEndpointConventionBuilder builder, int? statusCode = default(int?));
+    }
 }
```

