# Microsoft.AspNetCore.Components.Endpoints

``` diff
+namespace Microsoft.AspNetCore.Components.Endpoints {
+    public interface IComponentPrerenderer {
+        Dispatcher Dispatcher { get; }
+        ValueTask<IHtmlAsyncContent> PrerenderComponentAsync(HttpContext httpContext, Type componentType, RenderMode renderMode, ParameterView parameters);
+        ValueTask<IHtmlContent> PrerenderPersistedStateAsync(HttpContext httpContext, PersistedStateSerializationMode serializationMode);
+    }
+    public interface IRazorComponentsBuilder {
+        IServiceCollection Services { get; }
+    }
+    public class RazorComponentResult : IResult {
+        public RazorComponentResult(Type componentType);
+        public RazorComponentResult(Type componentType, IReadOnlyDictionary<string, object?>? parameters);
+        public RazorComponentResult(Type componentType, object? parameters);
+        public Type ComponentType { get; }
+        public string? ContentType { get; set; }
+        public IReadOnlyDictionary<string, object?> Parameters { get; }
+        public RenderMode RenderMode { get; set; }
+        public int? StatusCode { get; set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public class RazorComponentResult<TComponent> : RazorComponentResult where TComponent : IComponent {
+        public RazorComponentResult();
+        public RazorComponentResult(IReadOnlyDictionary<string, object?> parameters);
+        public RazorComponentResult(object parameters);
+    }
+    public class RazorComponentResultExecutor {
+        public static readonly string DefaultContentType;
+        public RazorComponentResultExecutor();
+        public virtual Task ExecuteAsync(HttpContext httpContext, RazorComponentResult result);
+    }
+}
```

