# Microsoft.AspNetCore.Components.Web

``` diff
 namespace Microsoft.AspNetCore.Components.Web {
+    public sealed class HtmlComponent {
+        public static HtmlComponent Empty { get; }
+        public string ToHtmlString();
+        public Task WaitForQuiescenceAsync();
+        public void WriteHtmlTo(TextWriter output);
+    }
+    public sealed class HtmlRenderer : IAsyncDisposable, IDisposable {
+        public HtmlRenderer(IServiceProvider services, ILoggerFactory loggerFactory);
+        public Dispatcher Dispatcher { get; }
+        public HtmlComponent BeginRenderingComponent(Type componentType);
+        public HtmlComponent BeginRenderingComponent(Type componentType, ParameterView parameters);
+        public HtmlComponent BeginRenderingComponent<TComponent>() where TComponent : IComponent;
+        public HtmlComponent BeginRenderingComponent<TComponent>(ParameterView parameters) where TComponent : IComponent;
+        public void Dispose();
+        public ValueTask DisposeAsync();
+        public Task<HtmlComponent> RenderComponentAsync(Type componentType);
+        public Task<HtmlComponent> RenderComponentAsync(Type componentType, ParameterView parameters);
+        public Task<HtmlComponent> RenderComponentAsync<TComponent>() where TComponent : IComponent;
+        public Task<HtmlComponent> RenderComponentAsync<TComponent>(ParameterView parameters) where TComponent : IComponent;
+    }
 }
```

