# Microsoft.AspNetCore.Components

``` diff
 namespace Microsoft.AspNetCore.Components {
+    public class ComponentApplicationBuilder {
+        public ComponentApplicationBuilder();
+        public RazorComponentApplication Build();
+    }
     public readonly struct EventCallback : IEventCallback {
-        public EventCallback(IHandleEvent? receiver, MulticastDelegate? @delegate);
+        public EventCallback(IHandleEvent receiver, MulticastDelegate @delegate);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
     }
     public readonly struct EventCallback<TValue> : IEventCallback {
+        public override bool Equals(object obj);
+        public override int GetHashCode();
     }
+    public interface IRazorComponentApplication<TComponent> where TComponent : IRazorComponentApplication<TComponent> {
+        static ComponentApplicationBuilder GetBuilder();
+    }
+    public class PageDefinition {
+        public string DisplayName { get; }
+        public IReadOnlyList<object> Metadata { get; }
+        public string Route { get; }
+        public Type Type { get; }
+    }
+    public enum PersistedStateSerializationMode {
+        Infer = 1,
+        Server = 2,
+        WebAssembly = 3,
+    }
+    public class RazorComponentApplication {
+        public IEnumerable<PageDefinition> Pages { get; }
+    }
+    public enum RenderMode {
+        Server = 2,
+        ServerPrerendered = 3,
+        Static = 1,
+        WebAssembly = 4,
+        WebAssemblyPrerendered = 5,
+    }
 }
```

